

#define BBSTYPE             1
#define BBSVERSION          2
#define SYSOPNAME           3
#define SYSOPHANDLE         4
#define BBSPATH             5
#define DTERATE             6
#define BPSRATE             7
#define PORTNAME            8
#define PORTHANDLE          9
#define PARITY              10
#define DATABITS            11
#define STOPBITS            12
#define LINENUMBER          13
#define USERNUMBER          14
#define NAME                15
#define HANDLE              16
#define ADDRESS             17
#define CITY                18
#define STATE               19
#define ZIPCODE             20
#define COUNTRY             21
#define HOMEPHONE           22
#define DATAPHONE           23
#define FAXPHONE            24
#define BUSPHONE            25
#define PASSWORD            26
#define PASSNUMBER          27
#define SECNUM              28
#define SECNAME             29
#define TIMESON             30
#define DATELASTON          31
#define TIMELASTON          32
#define TIMEON              33  //  not to be confused with TIMESON
#define SECSLEFT            34
#define MINSLEFT            35
#define EXPIREDATE          36
#define SCREENLENGTH        37
#define SCREENWIDTH         38
#define BIRTHDAY            39
#define CONFERENCE          40
#define PROTOCOL            41
#define UPLOADS             42
#define DOWNLOADS           43
#define DLTODAY             44
#define MAXDLTODAY          45
#define DLKTODAY            46
#define MAXDLKTODAY         47
#define ULTODAY             48
#define MAXULTODAY          49
#define ULKTODAY            50
#define MAXULKTODAY         51
#define ULBYTES             52
#define DLBYTES             53
#define ULKBYTES            54
#define DLKBYTES            55
#define EVENTTIME           56
#define LASTNEWFILESCAN     57
#define TIMECREDIT          58
#define TIMESPOSTED         59
#define COMMENT             60
#define LOCAL               61
#define LOCKING             62
#define DISPLAY             63
#define PRINTER             64
#define SYSOPPAGE           65
#define EXPERT              66
#define NOVICE              67
#define ARQCONNECT          68
#define ANSICOLOR           69
#define ANSIMONO            70
#define HIGHASCII           71
#define MSGAREA             72
#define FILEAREA            73
#define FOSSIL              74
#define BBSNAME             75
#define SYSOP               76
#define BANKTIME            77

typedef struct _KEYWORD
{
    char *Name;
    int   Number;
} KEYWORD, *PKEYWORD;

KEYWORD KeyWord[] =
{
    "SessionInfoKeywords",  0,
    "BBSTYPE",              BBSTYPE,
    "BBSVERSION",           BBSVERSION,
    "SYSOPNAME",            SYSOPNAME,
    "SYSOPHANDLE",          SYSOPHANDLE,
    "BBSPATH",              BBSPATH,
    "DTERATE",              DTERATE,
    "BPSRATE",              BPSRATE,
    "PORTNAME",             PORTNAME,
    "PORTHANDLE",           PORTHANDLE,
    "PARITY",               PARITY,
    "DATABITS",             DATABITS,
    "STOPBITS",             STOPBITS,
    "LINENUMBER",           LINENUMBER,
    "USERNUMBER",           USERNUMBER,
    "NAME",                 NAME,
    "HANDLE",               HANDLE,
    "ADDRESS",              ADDRESS,
    "CITY",                 CITY,
    "STATE",                STATE,
    "ZIPCODE",              ZIPCODE,
    "COUNTRY",              COUNTRY,
    "HOMEPHONE",            HOMEPHONE,
    "DATAPHONE",            DATAPHONE,
    "FAXPHONE",             FAXPHONE,
    "BUSPHONE",             BUSPHONE,
    "PASSWORD",             PASSWORD,
    "PASSNUMBER",           PASSNUMBER,
    "SECNUM",               SECNUM,
    "SECNAME",              SECNAME,
    "TIMESON",              TIMESON,
    "DATELASTON",           DATELASTON,
    "TIMELASTON",           TIMELASTON,
    "TIMEON",               TIMEON,
    "SECSLEFT",             SECSLEFT,
    "MINSLEFT",             MINSLEFT,
    "EXPIREDATE",           EXPIREDATE,
    "SCREENLENGTH",         SCREENLENGTH,
    "SCREENWIDTH",          SCREENWIDTH,
    "BIRTHDAY",             BIRTHDAY,
    "CONFERENCE",           CONFERENCE,
    "PROTOCOL",             PROTOCOL,
    "UPLOADS",              UPLOADS,
    "DOWNLOADS",            DOWNLOADS,
    "DLTODAY",              DLTODAY,
    "MAXDLTODAY",           MAXDLTODAY,
    "DLKTODAY",             DLKTODAY,
    "MAXDLKTODAY",          MAXDLKTODAY,
    "ULTODAY",              ULTODAY,
    "MAXULTODAY",           MAXULTODAY,
    "ULKTODAY",             ULKTODAY,
    "MAXULKTODAY",          MAXULKTODAY,
    "ULBYTES",              ULBYTES,
    "DLBYTES",              DLBYTES,
    "ULKBYTES",             ULKBYTES,
    "DLKBYTES",             DLKBYTES,
    "EVENTTIME",            EVENTTIME,
    "LASTNEWFILESCAN",      LASTNEWFILESCAN,
    "TIMECREDIT",           TIMECREDIT,
    "TIMESPOSTED",          TIMESPOSTED,
    "COMMENT",              COMMENT,
    "LOCAL",                LOCAL,
    "LOCKING",              LOCKING,
    "DISPLAY",              DISPLAY,
    "PRINTER",              PRINTER,
    "SYSOPPAGE",            SYSOPPAGE,
    "EXPERT",               EXPERT,
    "NOVICE",               NOVICE,
    "ARQCONNECT",           ARQCONNECT,
    "ANSICOLOR",            ANSICOLOR,
    "ANSIMONO",             ANSIMONO,
    "HIGHASCII",            HIGHASCII,
    "MSGAREA",              MSGAREA,
    "FILEAREA",             FILEAREA,
    "FOSSIL",               FOSSIL,
    "BBSNAME",              BBSNAME,
    "SYSOP",                SYSOP,
    "BANKTIME",             BANKTIME,
    NULL,                   0
};

#define NUMKEYWORDS  (sizeof(KeyWord)/sizeof(KEYWORD))

char *SkipWhiteSpace(char *String);
char *SkipNonWhiteSpace(char *String);


// goes thru keyword table looking for the keyword 'Lookfor'
// returns number of keyword, or 0 if keyword is not found.

int LookupKeyword(char *Lookfor)
{
    int KeywordIndex = 1;

    while (KeyWord[KeywordIndex].Name)
    {
        if (! stricmp(KeyWord[KeywordIndex].Name, Lookfor))
            return (KeyWord[KeywordIndex].Number);

        KeywordIndex++;
    }

    return (0);
}


// given the filename 'SessionInfoName'
// this function reads in the file and
// assigns variables of your choice with
// the info.   Since this is an example
//  the actual variables are not shown.
int ReadSessionInfo(char *SessionInfoName)
{
    FILE *SessionInfoHandle;
    char  Input[301];
    int   Key;
    char *Keyword;
    char *Data;
    char *NewLine;

    SessionInfoHandle = _fsopen(SessionInfoName, "rt", SH_DENYNO);

    if (SessionInfoHandle == NULL)
    {
        printf("SessionInfo file '%s' not found!\n", SessionInfoName);

        return (-1);
    }

    while (! eof(SessionInfoHandle))
    {
        if (! fgets(Input, 301, SessionInfoHandle))
            break;

        if (*Input == ';')
        {
            // comment line
            continue;
        }

        NewLine = strchr(Input, '\n');

        if (NewLine)
            *NewLine = '\0';

        /**************************************************

        on a return from a door, a BBS program
        will want to check for a '!' which neans
        the data has changed. It may also skip any data
        that has not changed

        (this code probably not needed for a door program)

        if (*Input == '!')
        {
            // keyword starts on second char
            Keyword = Input + 1;
        }
        else
        {
            // this line has not changed
            continue;
        }

        ***************************************************/

        Keyword = Input;

        Data = SkipNonWhiteSpace(Keyword);

        if (*Data)
        {
            *Data++ = '\0';

            Data = SkipWhiteSpace(Data);

            // Data now points to data!
        }

        Key = LookupKeyword(Keyword);

        switch (Key)
        {
            case BBSTYPE:
                // assign BBS type
                break;

            case BBSVERSION:
                // assign BBS version
                break;

            case BBSNAME:
                // assign BBS name
                break;

            case SYSOPNAME:
                // assign SysOp name
                break;

                //
                //

                //
                //  ETC. you need only look for and accept the data you want.
                //

                //
                //

            case FOSSIL
                // assign FOSSIL boolean
                break;

            default:
                printf("Key '%s' not used\n", Keyword);
                break;
        }
    }

    fclose(SessionInfoHandle);

    return (0);
}

char *SkipWhiteSpace(char *String)
{
    char *p = String;

    while (*p == ' ' || *p == '\t')
        p++;

    return (p);
}

char *SkipNonWhiteSpace(char *String)
{
    char *p = String;

    while (*p && *p != ' ' && *p != '\t')
        p++;

    return (p);
}

