/****************************************************
 * REXX Script to renumber message and file areas.  *
 * Modify the three below and the last SELECT       *
 * command for your address, hubs, and downlinks.   *
 * WARNING: I use the echo TAG as the name of my    *
 * message areas.  If you don't do this, you will   *
 * have to modify your area.control file or         *
 * gatekpr.ctl file by hand.  Also, any echo tag    *
 * that has /, \, or & cannot be used as area names *
 * and must be modified by hand.  This utility      *
 * works on my system.  Use it only as a template   *
 * for writing your own.                            *
 * WARNING!!! Renumbering the file areas will SCREW *
 * UP your file.descriptions listing.  You SHOULD   *
 * re-run BFSMAKE.EXE after renumbering your file   *
 * areas!!
 ****************************************************/

arg FILE

/* Be sure to replace these with your own nets. Look below at the
   section where it writes the them and switch that too. */

Fidonet = '1:142/91.0@Fidonet'                  /* My fido hub */
Ravenet = '22:22/1.0@Ravenet'                   /* My Ravenet hub */
SCInet = '2001:200/0.0@SCInet 2001:201/4.0@SCInet 2001:201/5.0@SCInet 2001:201/6.0@SCInet 2001:201/1778.0@SCInet'   /* My scinet gateway and downlinks */
OS2net = '81:10/0.0@OS2net'  /* My OS2net gateway */

select
        when FILE = 1
          then do
                 infile = 'message_areas'
                 outfile1 = 'message.renumbered'
                 outfile2 = 'area.control'
               end

        when FILE = 2
          then do
                 infile = 'file_areas'
                 outfile = 'file.renumbered'
               end

        otherwise
          say "That is not a valid option.  Enter 1 for message_areas or 2 for file_areas"
          exit

end /* select */


lineread = linein(infile,1,0)  /* Set to first line */

i = 1

do forever

        lineread = linein(infile,,1)

        if lineread = ''
          then call EOF

        say lineread

        arealabel = word(lineread,1)
        address = '1'

        select
              when (arealabel = 'NAME') & (FILE = 1)
                then do
                       b = lineout(outfile1,lineread)
                       areatag = word(lineread,2)
                     end

              when arealabel = 'NUMBER'
                then do
                       areanumber = word(lineread,2)
                       a = lineout(outfile1,'  NUMBER   'i)
                       i = i + 1
                     end

              when arealabel = 'ADDRESS'
                then do
                       b = lineout(outfile1,lineread)
                       address = word(lineread,2)
                     end

              when lineread = ''
                then call EOF

              otherwise
                b = lineout(outfile1,lineread)

        end /* select */

        outline = ''

        select
                when address = '1:142/113.0@Fidonet'
                  then do
                         c1 = insert('ECHO','',,8)
                         c2 = insert(areatag,c1,8,32)
                         c3 = insert(areanumber,c2,32,45)
                         c4 = insert(Fidonet,c3,45)
                         c5 = lineout(outfile2,c4)
                       end

                 when (address = '1:142/113.0@Fidonet') & ((areatag = 'ADEPT_BETA') | (areatag = 'ADEPT_SOFTWARE'))
                  then do
                         c1 = insert('ECHO','',,8)
                         c2 = insert(areatag,c1,8,32)
                         c3 = insert(areanumber,c2,32,45)
                         c4 = insert('1:142/210.0@Fidonet',c3,45)
                         c5 = lineout(outfile2,c4)
                       end


                when address = '22:22/113.0@Ravenet'
                  then do
                         c1 = insert('ECHO','',,8)
                         c2 = insert(areatag,c1,8,32)
                         c3 = insert(areanumber,c2,32,45)
                         c4 = insert(Ravenet,c3,45)
                         c5 = lineout(outfile2,c4)
                       end

                when address = '2001:201/1.0@SCInet'
                  then do
                         c1 = insert('ECHO','',,8)
                         c2 = insert(areatag,c1,8,32)
                         c3 = insert(areanumber,c2,32,45)
                         c4 = insert(SCInet,c3,45)
                         c5 = lineout(outfile2,c4)
                       end

                when address = '81:10/5.0@OS2net'
                  then do
                         c1 = insert('ECHO','',,8)
                         c2 = insert(areatag,c1,8,32)
                         c3 = insert(areanumber,c2,32,45)
                         c4 = insert(OS2net,c3,45)
                         c5 = lineout(outfile2,c4)
                       end

                otherwise NOP

        end /* select */

end /* do loop */

EOF:

/* Closes the files */
x = lineout(infile)
y = lineout(outfile1)
z = lineout(outfile2)
exit
