#include <dos.h>
#define sqr(x) (x*x)

const int maxcol = 639;
const int maxrow = 349;
const int max_colors = 16;

int max_iterations;
int max_size = 4;
float Q[350];

void cls(char colors);
void plot(int x,int y,int color);
void setmode(int mode);

main()
{
	float Pmax, Pmin, Qmax, Qmin, P, deltaP, deltaQ,
		Xlast, Ylast, Xsquare, Ysquare;
	int coarse, color, row, col, ref_row, old_color=0;

	printf("\nCoarse (0) or Fine (1)? ");
	scanf("%d",&coarse);
	if (coarse == 0)
		max_iterations = 16;
	else
		max_iterations = 512;
	printf("\nMinimum X: ");
	scanf("%f",&Pmin);
	printf("\nMaximum X: ");
	scanf("%f",&Pmax);
	printf("\nMinimum Y: ");
	scanf("%f",&Qmin);
	printf("\nMaximum Y: ");
	scanf("%f",&Qmax);
	setmode(16);
	cls(7);
	deltaP = (Pmax - Pmin)/(maxcol - 1);
	deltaQ = (Qmax - Qmin)/(maxrow - 1);
	for (row=0; row<=maxrow; row++)
		Q[row] = Qmin + row*deltaQ;
	for (col=0; col<=maxcol; col++)
	{
		P = Pmin + col*deltaP;

		for (row=0; row<=maxrow; row++)
		{
			Xlast = Ylast = 0.0;
			color = 0;
			if (abs(P) + abs(Q[row]) < .5)
			{
				for (color=0; color<max_iterations; color++)
				{
					Xsquare = Xlast*Xlast;
					Ysquare = Ylast*Ylast;
					if ((Xsquare + Ysquare) > max_size) break;
					Ylast = 2*Xlast*Ylast + Q[row];
					Xlast = Xsquare - Ysquare + P;
				}
			}
			else
				color = 0;
			plot(col, row, (color % max_colors));
		}
	}
	getch();
}

void setmode(int mode)        	/* set video mode */
{
	union REGS inreg,outreg;

	inreg.h.al = mode;
	inreg.h.ah = 0x00;
	int86 (0x10, &inreg,&outreg);
}	/* -----------------------*/
void plot(int x,int y,int color)
{
	union REGS reg;

	reg.h.ah = 0x0C;
	reg.h.al = color;
	reg.x.dx = y;
	reg.x.cx = x;
	reg.h.bh = 0;
	int86(0x10,&reg,&reg);
}

               /*Ŀ
                                                                        
                                cls() = Clears the Screen               
                                                                        
                                                                        
                 */


void cls(char colors)
{

	union REGS reg;

	char ch;
	int columns,mode;

	mode = getMode(&columns);
	if (columns == 80)
	{
		if ((mode == 0x11) || (mode == 0x12))
			reg.x.dx = 0x1D4F;
		else
			reg.x.dx = 0x184F;
		reg.h.bh = colors;
	}
	else
	{
		reg.x.dx = 0x1828;
		switch (colors)
		{
			case 1:	reg.h.bh = 0x55;
				break;
			case 2:	reg.h.bh = 0xAA;
				break;
			case 3:	reg.h.bh = 0xFF;
				break;
			default:
				reg.h.bh = 0;
				break;
		}
	}
	reg.x.ax = 0x0600;
	reg.x.cx = 0;
	int86(0x10,&reg,&reg);
	gotoxy(0,0);
}
               /*Ŀ
                                                                        
                          getMode() = Returns Current  Video Mode       
                                                                        
                                                                        
                 */


int getMode(int *ncols)
{

	union REGS reg;

	reg.h.ah = 0x0F;
	int86 (0x10,&reg,&reg);
	*ncols = reg.h.ah;
	return reg.h.al;
}

