unit omaems;
interface
var error:byte; {0=everything ok.} {interrupts must save this}

function ems_installed:boolean;
procedure getstatus; {updates error}
function ems_addr:word;
function free_pages:word;
function total_pages:word;
function alloc_pages(how_many:word):word; {returns a handle}
procedure map_page(handle:word; phys_page:byte;{0-3}
                  log_page:word{0-(alloc-1)});
procedure free_ems(handle:word);
function ems_version:byte; {4 (upper) bits major, 4 bits minor}
procedure save_ems(handle:word); far; {use in interrupts}
procedure rest_ems(handle:word); far; {use in interrupts}
function active_handles:word;
function pages_allocated(handle:word):word;
function realloc_pages(handle:word; pages:word):word;
procedure prepare_ems_to_warm_boot;

implementation

function ems_installed:boolean;
var emmname,intname:string[8];
    _es,i:word;
begin
  intname:='';
  emmname:='EMMXXXX0';
  asm
   mov ah,$35;
   mov al,$67;
   int $21;
   mov [_es],es
  end;
  intname[0]:=char(8);
  for i:=0 to 7 do intname[i+1]:=char(mem[_es:i+$0A]);
  ems_installed:=(intname=emmname);
end;

procedure getstatus; assembler;
asm
 mov ah,$40;
 int $67;
 mov [error],ah
end;

function ems_addr:word; assembler;
asm
 mov ah,$41;
 int $67;
 mov [error],ah
 mov ax,bx
end;

function free_pages:word; assembler;
asm
 mov ah,$42;
 int $67;
 mov [error],ah
 mov ax,bx
end;

function total_pages:word; assembler;
asm
 mov ah,$42;
 int $67;
 mov [error],ah
 mov ax,dx
end;

function alloc_pages(how_many:word):word; assembler; {returns a handle}
asm
 mov ah,$43;
 mov bx,[how_many];
 int $67;
 mov [error],ah
 mov ax,dx
end;

procedure map_page(handle:word; phys_page:byte; log_page:word); assembler;
asm
 mov ah,$44;
 mov al,[phys_page];
 mov bx,[log_page];
 mov dx,[handle];
 int $67;
 mov [error],ah
end;

procedure free_ems(handle:word); assembler;
asm
 mov ah,$45;
 mov dx,[handle];
 int $67;
 mov [error],ah
end;

function ems_version:byte; assembler;
asm
 mov ah,$46;
 int $67;
 mov [error],ah;
end; {al=ver}

{$F+}
{$S-}
procedure save_ems(handle:word); assembler; {use in interrupts}
asm
 mov ah,$47;
 mov dx,[handle];
 int $67;
 mov [error],ah
end;
{$F-}

{$F+}
{$S-}
procedure rest_ems(handle:word); assembler; {use in interrupts}
asm
 mov ah,$48;
 mov dx,[handle];
 int $67;
 mov [error],ah
end;
{$F-}

function active_handles:word; assembler;
asm
 mov ah,$4B;
 int $67;
 mov [error],ah
 mov ax,bx
end;

function pages_allocated(handle:word):word; assembler;
asm
 mov ah,$4C;
 mov dx,[handle];
 int $67;
 mov [error],ah
 mov ax,bx;
end;

function realloc_pages(handle:word; pages:word):word; assembler;
asm {returns pages allocated}
 mov ah,$51;
 mov dx,[handle];
 mov bx,[pages];
 int $67;
 mov [error],ah
 mov ax,bx;
end;

procedure prepare_ems_to_warm_boot; assembler;
asm
 mov ah,$5C;
 int $67;
 mov [error],ah
end;

begin
end.