;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: srom.inc
; 
;  Purpose: data structure and const variable used in read/write eeprom
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
_SSromReg   struc
    abyPAR      db  6   DUP(?)          ; 0x00
    byMiiPhyId  db  ?                   ; 0x03
    byReserved0 db  ?

    wSUB_SID    dw  ?                   ; 0x04
    wSUB_VID    dw  ?
    wDeviceID   dw  ?
    wVendorID   dw  ?
    abyKey      db  6   DUP(?)          ; 0x08

    byMin_GNT   db  ?                   ; 0x0B
    byMax_LAT   db  ?
    byBCR0      db  ?                   ; 0x0C
    byBCR1      db  ? 
    byCFGA      db  ?                   ; 0x0D
    byCFGB      db  ?
    byCFGC      db  ?                   ; 0x0E
    byCFGD      db  ?
    bySignature db  ?                   ; 0x0F
    byCheckSum  db  ?
    abyReserved0    db  96  DUP(?)      ; 0x10
_SSromReg   ends


SROM_OFS_SIGNATURE      equ     000Fh

CRC32_VERIFY_OFFSET0    equ     0032h
CRC32_VERIFY_OFFSET1    equ     0033h

; EEPROM control instructions
CMD_ERASE       equ     00C0h    ; erase    1100,0000
CMD_READ        equ     0080h    ; read     1000,0000     
CMD_WRITE       equ     0040h    ; write    0100,0000
CMD_ERAL        equ     0020h    ; erase all    0010,0000
CMD_WRAL        equ     0010h    ; write all    0001,0000
CMD_EWEN        equ     0030h    ; erase/write enable   0011,0000
CMD_EWDS        equ     0000h    ; erase/write disable  0000,0000


; for NDIS2 driver 
; I will integrate the variable in ndis2 and packet dirver
