;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: srom.asm
; 
;  Purpose: read/write eeprom
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       VerifySromCRC32
;       SROMvReadAllContents
;       SROMwReadDirect
;       MACWriteEECSR
;       MACReadEECSR
;       DelayIO
;       MACRegBitOn
;       MACRegBitOff
; 
;  Revision History:
;       05-22-2003 GuardKuo: First relase
;       01-15-2003 GuardKuo: add this copyright message
;
; 

include srom.inc
include includes.mac
.386


        ; imported interface
        extrn       CALCPACKET_CRC:near
        extrn       MACminiDelay2:near
        extrn       MACmicroDelay2:near
        ; imported variable
        extrn       pciRevisionId:byte
        extrn       SSromReg:byte
        extrn       pbyRomRegs:byte
        extrn       pybWorkStream:byte
        extrn       Ioport:word
;        extrn       wCFGAddress:word
;        extrn       wEECSRAddress:word
; for packet
;Init    segment para public 'CODE'
BEGIN_INIT_CODE

;------------------------------------------------------------------
; VerifySromCRC32
;   input:
;       dx -> IoBase
;   output:
;       ZF set if successful
;       ZF clear on error
;   algo:
;
;------------------------------------------------------------------

public  VerifySromCRC32
VerifySromCRC32 proc    near
    ;----------------------
    ; reserved register
    ;----------------------
    
    push    bx
    push    cx
    push    dx
    
    push    di
    push    si
    push    bp

    ;-------------------------------
    ; put SROM contents into romRegs
    ;-------------------------------    

    call    SROMvReadAllContents

    
    or      eax,0FFFFFFFFh

    lea     si, SSromReg
    lea     di, pybWorkStream
    mov     cx, 0
    
GetSROMContextLoop:
    cmp     cx, 3
    jne     SaveToStream
    add     cx, 1
    add     si, 2

    
SaveToStream:    
    mov     bx, [si]
    mov     [di], bx
    add     di, 2
    inc     cx
    add     si, 2
    cmp     cx, 8
    jb      GetSROMContextLoop
    
GetSROMContextLoopEnd:    

    lea     si, SSromReg
    mov     bx, [si+30]
    mov     [di], bx
    
    ; cacluate CRC32
    lea     si, pybWorkStream
    mov     cx, 0Fh     ;15
    call    CalcPacket_CRC
    push    eax
    ; compare the result with the EEPROM CRC32

    push    CRC32_VERIFY_OFFSET1
    call    SROMwReadDirect
    shl     ebx,16
    push    CRC32_VERIFY_OFFSET0
    call    SROMwReadDirect
    pop     eax

    xor     eax, ebx
    
    pop     bp
    pop     si
    pop     di
    
    pop     dx
    pop     cx
    pop     bx

    ret

VerifySromCRC32 endp

;-------------------------------------------
; SROMvReadAllContents
;   input:
;   output:
;       si -> SROMRegister
;-------------------------------------------


SROMvReadAllContents    proc    near

    mov     cx, size  _SSromReg
    shr     cx, 1
    mov     ax, 0
    lea     si, SSromReg    

ReadAllDataLoop:    
    push    ax
    push    cx
    ;------------------------------------
    ; usage of SROMwReadDirect
    ; push [address of EEPROM want read]
    ; call SROMwReadDirect
    ;------------------------------------  
    push    ax  
    call    SROMwReadDirect
    mov     [si], bx

    pop     cx
    pop     ax
    add     si, 2
    inc     ax
    loop    ReadAllDataLoop
    ret
SROMvReadAllContents    endp

;-------------------------------------------
; SROMwReadDirect
;   input:
;       [bp+4] -> address of EEPROM
;   ouput:
;       bx -> the value of EEPROM
;   usage:
;       push    address
;       call    SROMvReadDirect
;-------------------------------------------

SROMwReadDirect     proc    near
    push    bp
    mov     bp, sp
    push    si
    mov     si, Ioport
    ; read operation :
    ; <idle><1><10><AAAAAA><xxxx xxxx xxxx xxxx><idle>
    ; enable embeded/direct programming
    ;push    wCfgAddress
    lea     dx, [si].SCsrRegStruc.CFGA
    mov     ah, CFGA_EELOAD
    call    MACRegBitOn
    
    ; turn on EECSR_DPM
    ;push    wEECSRAddress
    lea     dx, [si].SCsrRegStruc.EECSR
    mov     ah, EECSR_DPM
    call    MACRegBitOn
    
    ; Initialize
    ; deactive CS
    mov     al, EECSR_DPM
    call    MACWriteEECSR

    or      al, EECSR_CS
    call    MACWriteEECSR
    
    ; start bit <1>
    or      al, EECSR_DI
    call    MACWriteEECSR
    
    or      al, EECSR_SK
    call    MACWriteEECSR
    
    ; Issue command <10><AAAAAA>
    mov     dx, 80h
    mov     bx, [bp+4]
    or      bx, CMD_READ
IssueCommandLoop:
    ;push    dx
    test    dx, bx
    jz      NOT_THIS_BIT
    mov     al, EECSR_DPM or EECSR_CS or EECSR_DI
    call    MACWriteEECSR
    or      al, EECSR_SK
    call    MACWriteEECSR
    jmp     IsEND
NOT_THIS_BIT:
    mov     al, EECSR_DPM or EECSR_CS
    call    MACWriteEECSR
    or      al, EECSR_SK
    call    MACWriteEECSR
IsEND:        
    ;pop     dx
    shr     dx, 1
    or      dx, 0
    jnz     IssueCommandLoop
IssueCommandLoopEND:

    ; Read data <xxxx-xxxx-xxxx-xxxx>
    mov     dx, 8000h
    mov     bx, 0h
    and     ah, 0h
ReadDataLoop:
    push    dx
    mov     al, EECSR_DPM or EECSR_CS
    call    MACWriteEECSR
    or      al, EECSR_SK
    call    MACWriteEECSR
    shl     bx, 1
    ; read EECSR register
    ;call    MACReadEECSR
    mov     si, Ioport
    lea     dx, [si].SCsrRegStruc.EECSR
    in      al, dx
    and     al, EECSR_DO

    or      bx, ax
    pop     dx
    cmp     dx, 1
    jbe     ReadDataLoopEND
    shr     dx, 1
    jmp     ReadDataLoop
ReadDataLoopEND:

    ; deactive CS
    mov     al, EECSR_DPM
    call    MACWriteEECSR    
    
    mov     si, Ioport
    
    ; turn off EECSR_DPM
    ;push    wEECSRAddress
    lea     dx, [si].SCsrRegStruc.EECSR
    mov     ah, EECSR_DPM
    call    MACRegBitOff
    
    ;push    wCFGAddress
    lea     dx, [si].SCsrRegStruc.CFGA
    mov     ah, CFGA_EELOAD
    call    MACRegBitOff

    pop     si
    pop     bp
    ret     2
SROMwReadDirect     endp
;----------------------------------------
; MACWriteEECSR
;   description:
;   input:
;       al : mask
;       dx : eecsr
;   output:
;       no
;       cx,dx would be changed
;-----------------------------------------
;CB_DELAY_NM9346     equ     10      ;(10ms)

MACWriteEECSR      proc     near
    push    bx
    push    dx
    
    mov     bx, Ioport
    lea     dx, [bx].SCsrRegStruc.EECSR
    ;mov     dx, wEECSRAddress
    out     dx, al
    ; ----------------------------------
    ; modified by guard(2003/10/09)
    ; use HW delay instead of IO delay
    ; -----------------------------------
    push    ax
    cmp     pciRevisionId, RevisionID3106J
    jb      @VT3065
    mov     ax, 10
    call    MACmicroDelay2
    jmp     @WriteEECSROver
@VT3065:
    mov     ax, 1
    call    MACminiDelay2

@WriteEECSROver:
    pop     ax
    pop     dx
    pop     bx
    ret
    ; --------------------------------
    ; marked by guard(2003/10/09)
    ; use HW delay instead of SW delay
    ; ---------------------------------

    ;push    ax
    ;mov     cx, CB_DELAY_NM9346
    ;call    DelayIO
    ;pop     ax
    ;ret
MACWriteEECSR      endp
;----------------------------------------
; MACReadEECSR
;   description:
;   input:
;       no
;   output:
;       al -> value of EECSR
;       cx,dx would be changed
;-----------------------------------------
if 0
MACReadEECSR    proc        near
    mov     dx, wEECSRAddress
    in      al, dx

    ; -----------------------------------------
    ; marked by guard(2003/10/09)
    ; Delay is not necessary after read EECSR
    ; ---------------------------------------
    
    ;push    ax
    ;mov     cx, CB_DELAY_NM9346
    ;call    DelayIO
    ;pop     ax
    ret
MACReadEECSR    endp
endif
;-----------------------------------------------
;   DelayByIO
;   Description: Delay some ISA bus cycles (not very precisely)
;              this function is used to delay for a short time
;              the delay time == Unit * 1 / 8MHz
;                             == Unit * 125ns 
;                             == Unit * 0.125us 
;                             == Unit * 0.000125ms
;
;              Note: some machine's ISA bus clock rate is not precisely
;                    8MHz, the range may vary from 7MHz~14MHz
;
;   input:
;      cx -> how many ISA bus cycle
;       
;----------------------------------------------------

; it's safe to input data from delay port
A_IO_DELAY      equ     0061h
DelayIO     proc        near
CountDown:
        in      al, A_IO_DELAY
        loop    CountDown
        ret
DelayIO     endp
;-------------------------------------------
; MACRegBitOn
;   input:
;       dx : the offset of this Register
;       ah : mask
;   outout:
;       no
;       ax, dx would be changed
;   usage:
;       push    offset of Register
;       mov     ah, mask
;       call    MACRegBitOn
;-------------------------------------------
MACRegBitOn     proc    near
        ;push    bp
        ;mov     bp, sp
        ;mov     dx, [bp+4]
        in      al, dx
        
        or      al, ah
        out     dx, al
        ret
        ;pop     bp
        ;ret     2
MACRegBitOn     endp

;-------------------------------------------
; MACRegBitOff
;   input:
;       dx : the offset of this Register
;       ah : mask
;   outout:
;       no
;       ax, dx would be changed
;   usage:
;       push    offset of Register
;       ah      ah, mask
;       call    MACRegBitOff
;-------------------------------------------
MACRegBitOff     proc   near
        ;push    bp
        ;mov     bp, sp
        ;mov     dx, [bp+4]
        in      al, dx
        
        not     ah
        and     al, ah
        out     dx, al
        ret
        ;pop     bp
        ;ret     2
MACRegBitOff     endp

;Init        Ends   ; packet
END_INIT_CODE
    end