;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: crc.asm
; 
;  Purpose: CRC generator and check
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       CalcPacket_CRC
; 
;  Revision History:
;       05-22-2003 GuardKuo: first release
;       01-15-2003 GuardKuo: add this copyright message
; 

include includes.mac
.386


; exported interface
    public  CalcPacket_CRC

;Code    segment para public 'CODE'
extrn   Table256:byte
extrn   Table256End:byte

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; CalcPacket_CRC
;
; This routine calculates packet CRC.
; It returns the CRC value in EAX.
;
; Called by: o DriverSend
;
;               SI -> packet body (one contiguous buffer only)
;               CX -  packet lenght (without the CRC)
;               Interrupts enabled
;
;
; Outputs:      Calculated packet CRC is in packet buffer at offset [CX]
;               EAX-  Packet CRC
;               BX -  Preserved
;               CX -  Destroyed
;               SI -  Points right after end of packet
;               DI -  Destroyed
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BEGIN_CODE
	align   4
CalcPacket_CRC proc near

	push    ebx
	push    edi

	mov     eax, 0FFFFFFFFh         ; EAX = CRC accumulator
	lea     di, Table256            ; DI = pointer to table


	align 4
CT_GetNextByte:
	xor     bx, bx

	mov     bl, al                  ; BL = low CRC byte
	xor     bl, [si]                ; BX = index to table
	inc     si                      ; ESI = points to next byte

	shr     eax, 8

	shl     bx, 2                   ; BX = points into table (longwords)

	xor     eax, [bx][di]

	loop    CT_GetNextByte

	not     eax                     ; xor EAX with FFFFFFFFh

	pop     edi
	pop     ebx
	ret

CalcPacket_CRC endp
IF 0
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; VerifyCRCTable
;
; This routine verifies CRC table correctness.
;
; Called by: o DriverInit
;
;
; Outputs:
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
VerifyCRCTable  proc    near
	mov     cx, Table256End-Table256
	lea     si, Table256
	call    CalcPacket_CRC
	cmp     eax, 6FCF9E13h
	je      short FINE
	lea     dx, CGroup:szCRCTableError
FINE:
	ret
VerifyCRCTable  endp


szCRCTableError           db 111,0,'Err:some unexpected error occur in CRC code table',0Dh,0Ah,0
ENDIF
;Code    ends
END_CODE
end