;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: xmit.asm
; 
;  Purpose:
;     This file contains TransmitChain entry only. The process of transmiting
;     onto network media using an ethernet adapter is similar with ODI DRIVER, 
;     it has 3 following actions must be implemented.                          
;                                                                            
;     (1) Inspect buffer is idle for used. If not, return OUT_OF_RESOURCE.   
;                                                                            
;     (2) Disable interrupt to avoid sharing the same hardware resource.     
;                                                                            
;     (3) Move the tx descriptor buffer to adapter RAM buffer                
;         - useing FIFO stratgy for dual tx buffers                          
;                                                                            
;         (i)when there are two idle buffers, then copy tx descriptor to     
;            adapter's buffer and send it onto network media.                
;                                                                            
;         (ii)when there is only one idle buffer, then copy tx descriptor to 
;            adapter's buffer. This packet will be sent in interrupt handler 
;            later.                                                          
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       TransmitChain
;       List all the functions this module provides.
;       (This section is omitted in the header of "include" files)
; 
;  Revision History:
;       01-15-2003 GuardKuo: add this copyright message
;
;                 page    88,122
                title   XMIT - Transmit Functions (2.0.1 Spec)


.xlist
IFDEF OS2
include devhlp.inc
ENDIF
include includes.mac
.list
.lfcond
.sall

.386

;------ Exported Interfaces -------------------------------------------------;

                public  TransmitChain

;------ Imported Interfaces -------------------------------------------------;

                OS2XTRN devHelper:DWORD
                OS2XTRN segTX:WORD
                extrn   cs_ds:WORD
                extrn   state:BYTE
                extrn   status:BYTE
IFDEF SNAP
                DEXTRN  txsnaparea:BYTE
                DEXTRN  txsnapix:WORD
ENDIF

                extrn   Ioport:word
                extrn   ResetNIC: near
                extrn   pdescTxWrite:word
                extrn   wTxNumPosted:word
                extrn   wImrShadow:word

                extrn   pciRevisionId:byte
                extrn   TxEmmDescriptor:dword
            	extrn   VDSActiveFlag:byte
            	extrn   pdescTxLastPtr:word
            	extrn   pdescTxPreviousPtr:word
            	extrn   pdescTxBufferPhyAddr:dword
                BEGIN_CODE

NEWPAGE <TransmitChain - Transmit Packet Onto Network>
;------ TransmitChain -------------------------------------------------------;
;                                                                            ;
;       int far pascal TransmitChain(                                        ;
;                                       WORD ProtID,                         ;
;                                       WORD Handle,                         ;
;                                       DWORD Bufdesc,                       ;
;                                       WORD MACDS      );                   ;
;                                                                            ;
;       Transmits a packet onto the network.  The packet is described by     ;
;       some immediate data (which will be transmitted first if present)     ;
;       and a series of frame data blocks.  The buffer descriptor and the    ;
;       immediate data are assumed to have a lifetime only as long as the    ;
;       synchronous portion of the command, meaning that we must copy this   ;
;       information when we queue the request for asynchronous processing.   ;
;       Note that there is a limit of 64 bytes on the immediate data.        ;
;                                                                            ;
;       Note: Failure to align data buffers on (physical) word boundaries    ;
;       may have disastrous performance consequences.                        ;
;                                                                            ;
;       Copying the packet to the adapter's transmit buffer takes            ;
;       significantly longer than you might expect from abstract estimates   ;
;       based solely on cpu cycles.  See RECV.ASM for specific details.      ;
;                                                                            ;
;       Theoretically the Token Ring can carry very close to its 4Mbps       ;
;       rated capacity.  However, measurements with the actual copy to the   ;
;       adapter removed indicate that current IBM Token Ring Adapters for    ;
;       the PC top out around 3Mbps for transmit so 4Mbps is not achievable  ;
;       with a single transmitter.                                           ;
;                                                                            ;
;       Multiple (more than one) transmit buffer should theoretically        ;
;       help, by allowing for some overlap between copying the packet to     ;
;       the adapter and transmitting it on the network.  However, with       ;
;       current IBM Token Ring Adapters, the driver is never given more      ;
;       than one of the transmit buffers.  It appears that the adapter       ;
;       configures the second transmit buffer (the number of receive         ;
;       buffers that can be requested goes down), but no second buffer       ;
;       address is ever seen.  The driver still allows a second transmit     ;
;       buffer to be configured, and will default to two transmit buffers    ;
;       if there is sufficient memory, but this appears to make no           ;
;       performance difference with the current adapters.  As a              ;
;       consolation, IBM's LAN Support software does not seem to be able to  ;
;       get this to work either since measured performance doesn't change    ;
;       between 1 and 2 DHBs.                                                ;
;                                                                            ;
;----------------------------------------------------------------------------;

;------ Early-Out Errors ----------------------------------------------------;
;
; invalid state
;
                public  xmit_invalid
xmit_invalid:
        mov     ax,INVALID_FUNCTION
        jmp     xmit_exit

        ; no free queue entries.  return error.
        ;----------------------------------------------------------------------
        public  xmit_unable
xmit_unable:
        DINC    txcants

        mov     ax,OUT_OF_RESOURCES
        jmp     xmit_exit
        
        ; total tx byte count is to large
        ;-----------------------------------
xmit_bad1:
        pop     ds
xmit_bad:

        mov     ax,INVALID_PARAMETER
        jmp     xmit_exit

;------ TransmitChain -------------------------------------------------------;

        DLOCAL  txbuf,DWORD
        DLOCAL  tmpcnt
        DLOCAL  TxOddCount         ;mmmmm
        DLOCAL  TxOddValue,DWORD   ;mmmmm
        DLOCAL  oricnt
                align   4
TransmitChain   proc    far
        LOCALS
        PUSHR   esi,edi,ebp,ebx,ecx,edx,ds,es

        ; set up DS.
        ;-----------------------------------
        mov     ds,cs:cs_ds

        ; protect interupt flag
        ;-----------------------------------
        pushf
        push    eax

        ; ensure the adapter is openned
        ;-----------------------------------
        cmp     state,OPENNED
        jne     xmit_invalid

        ;VT3065A : W_DEFAULT_TX_PACKET_COUNT
        ;-----------------------------------\
        cmp     wTxNumPosted, W_DEFAULT_TX_PACKET_COUNT
        ;VT3065A : W_DEFAULT_TX_PACKET_COUNT
        ;-----------------------------------/
        
        jb      NotFull
        jmp     Out_Resource_Exit

NotFull:
        ; ensure the adapter has usable space for storing the tx descriptor
        ;----------------------------------------------------------------------

        ; disable interrupts for the remainder.  there are probably smaller critical
        ; sections here, but there seems no great reason to find them.
        ;----------------------------------------------------------------------
        ;cli

        ;xor     ax, ax
        ;mov     bx, Ioport
        ;lea     dx, [bx].SCsrRegStruc.IMR0
        ;out     dx, ax

        cld

        push    ds

        lds     si,[bp].tx_Bufdesc
        mov     bx,si
        mov     di,[si]                 ; get Bufdesc.TximmedLen

        mov     cx,[si].tx_data_count

        cmp     cx, MAX_CHAIN
        ja      xmit_bad1

        jcxz    @F                   
        add     si,0
GetBufferCnt:                           ; caculate the total bytes
        add     si,tx_chain             ; of Tx
        add     di,[si].cd_data_len
        loop    GetBufferCnt
@@:

        pop     ds

        ; the packets size must be limited
        ;-----------------------------------
        ;/** DrvCap
        
        or      di,di
        SJZ     xmit_bad

        cmp     di, 5EAh
        ja      xmit_bad

        mov     si,di
        mov     [bp].oricnt, di
        ; marked by Ben (02/01/2001), don'e need to evenize packet length. 
        ; Otherwise, the opposite NIC driver will drop this packet if it
        ; conforms with 802.3 spec.
        ; ------------------------------------------------------------------S
        
        cmp     di,60
        jae     @F
        mov     di,60
@@:
        mov     [bp].tmpcnt,di
        mov     bx, pdescTxWrite                ; BX Point at Tx curr desc.
                                                ; to be initialized.
        test    [bx].STxDescStruc.wTxOwn, W_TX_OWN_BIT
        jnz     Out_Resource_Exit

        cmp     di, 60
        jbe     CopyToOneDesc3065Chip

CopyToOneDesc3065Chip:
        ;VT3065A : Tx pciRevisionId
        ;------------------------------------------------------------/
        
        ; Update dwTdes1:
        ;-----------------
        mov     ax, W_TX_TCR_BUFF               ; 0E0h, STP+EDP+IC
        mov     [bx].STxDescStruc.wTCR, ax      ; Get total packet length (CX
        mov     ax, 8000H                       ; Chain bit
        add     ax, di
        mov     [bx].STxDescStruc.wTxBufferSize, ax  ; Get total packet length
                                                ; is the evenized and padded
                                                ; length calculated by the upper
                                                ; layer) and put in buffer size
                                                ; area.

        ;VT3065A : Update the TDES2
        ; Update the TDES2
        ;-----------------
        ; Restore the Tx buffer address, because 3065 can corrupt the field.
        ;------------------------------------------------------------------
        push	ebp
        mov     eax, [bx].STxDescStruc.pdescTxCurrPhy
        xor     ebp, ebp
        lea     ebp, [ebp].STxDescStruc.abyTxBuffer
        add     ebp, eax
        mov     [bx].STxDescStruc.dwTxPhyBufAddr, ebp
        pop     ebp
        
        ; Save TCB pointer for later return to upper layer when TX is done.
        ;------------------------------------------------------------------
        mov     [bx].STxDescStruc.pTCB_SI, si
        mov     [bx].STxDescStruc.pTCB_DS, ds	
        
        ;VT3065A : Update the TDES2
        ;-----------------------------------
        ; move the media header to the TX buffer:
        ;-----------------------------------------
        push    bx                              ; Save TX descriptor pointer
        push    ds                              ; Save original DS
        push    di                              ; Save packet size

        ;================================================================
        ; DS ==> data to be transferred
        ;
        ;================================================================
        push    ds
        pop     es                              ; ES = DS
        lea     di, [bx].STxDescStruc.abyTxBuffer
        
     IFDEF  TxDebug
        push    ax
                mov     ax,[bp].tmpcnt
                mov     cs:cxsave,ax
                mov     cs:disave,di
        pop     ax
     ENDIF
     
        lds     si,[bp].tx_Bufdesc
        movzx   ecx,[si].tx_immed_bytes

        jcxz    TxDataBlockStart

        ;=======================================================
        ; Here send immediate header to adapter begin
        ;=======================================================
        lds     si,[si].tx_immed_buff
AT16BitWr:

        mov     ah, cl                          ; AH saves number of residue
        and     ah, 03h                         ; bytes to move
        shr     cx, 2                           ; CX is double word move counter
   rep  movsd                                   ; move in doubles
        mov     cl, ah                          ; move the residue in bytes
   rep  movsb
        ;=======================================================
        ; Here send immediate header to adapter ended
        ;=======================================================

ImmDataDone:
        lds     si,[bp].tx_Bufdesc

TxDataBlockStart:
        movzx   ecx,[si].tx_data_count
IFDEF  TxDebug
        call  Dbgsave8
ENDIF
    
        cmp     cx, 0
        SJE     AllBlockDataDone

        mov     bx,cx
        add     si,tx_chain
        mov     [bp].txbuf.off,si
        mov     [bp].txbuf.segm,ds
        
        ;===============================================================\
        ; Transmit Loop Begin
        ; Within this loop, address with [bp]
        ;===============================================================/
SearchBlock:
        movzx   ecx,[si].cd_data_len
        or      ecx, ecx
        jnz     OS2_1
        jmp     BlockDataDone
OS2_1:

IFDEF OS2
        cmp     ds:[si].cd_ptr_type,CT_GDT
        jne     @F
        lds     si,ds:[si].cd_data_buff
        jmp     short xmit_go
@@:
    IFDEF FASTGDT
        mov     al,ds:[si].cd_data_buff.hiword.lobyte
        mov     bx,ds:[si].cd_data_buff.loword
        mov     ds,cs:cs_ds
        lds     si,dword ptr segTX
        mov     ds:[si].segd_base15_0,bx
        mov     ds:[si].segd_base23_16,al
        mov     ds:[si].segd_lim15_0,cx ; CX-1 really, but screw it
        mov     ds,si
        xor     si,si
    ELSE
        push    bp
        push    di
        push    dx
        push    cx
        push    bx
        push    ax
        mov     ax,ds:[si].cd_data_buff.hiword
        mov     bx,ds:[si].cd_data_buff.loword
        mov     ds,cs:cs_ds
        mov     si,segTX
        mov     dl,DevHlp_PhysToGDTSelector
        call    devHelper
        mov     ds,si
        xor     si,si
        pop     ax
        pop     bx
        pop     cx
        pop     dx
        pop     di
        pop     bp
ENDIF
xmit_go:
ELSE
        lds     si,ds:[si].cd_data_buff
ENDIF

        cld
        
     IFDEF   TxDebug
        call    dbgsave7  ;mmmmm
     ENDIF
     
OddByteToDo:
        mov     ah, cl                  ; AH saves number of residue
        and     ah, 03h                 ; bytes to move
        shr     cx, 2                   ; CX is double word move counter
   rep  movsd                           ; move in doubles
        mov     cl, ah                  ; move the residue in bytes
   rep  movsb
BlockDataDone:

        dec     bx
        jz      AllBlockDataDone

        add     [bp].txbuf.off,8
        lds     si,dword ptr [bp].txbuf
        jmp     SearchBlock
        
        ;===============================================================\
        ; Transmit Loop END
        ;===============================================================/
AllBlockDataDone:
        pop     cx
        pop     ds
        pop     bx
        mov     ds,cs:cs_ds
        
       IFDEF  TxDebug
        call   readtr
       ENDIF

        mov     cx, [bp].oricnt
        cmp     cx, 60
        jae     DMAFinished
        push    ax
        mov     ax, cx
        mov     cx, 60
        sub     cx, ax
        xor     ax, ax
        rep     stosb
        pop     ax
DMAFinished:
IssueTxForPkt:
        cli

        add     status.ms_total_sent.loword,1
        adc     status.ms_total_sent.hiword,0

        mov     cx,[bp].tmpcnt

        add     status.ms_total_sbytes.loword,cx
        adc     status.ms_total_sbytes.hiword,0



        ;VT3065A : Process 3065 TX
        ;-----------------------------------
        mov     pdescTxLastPtr, bx
        jmp     TxSetSTATUS
IF 0
Transmit3065Chip:

        ; Add by Ben (2003/04/12), if EMM386 is enable, just use 3043 way
        ; to tx. It's just a temparary way for fixing the slow tx rate
        ; when using :
        ;    DEVICE=EMM386.EXE
        ; in AOpen+VT82C686A(South Bridge)
        ; -----------------------------------------------------------------
        cmp     VDSActiveFlag, 1
        je      CopyToOneDesc3065Chip
        ; Get the fragment count to check if it is over 5 fragments
        ; if over, do one descriptor.
        ; else do multidescriptor.
        ;----------------------------------------------------------  
        push	ds
        push	si
        lds     si,[bp].tx_Bufdesc          ; restore the DS:SI
        mov     dx,[si].tx_data_count       ; DX = number of fragments
        ; ----------------------------------------------------
        ; reduce 5 -> 3
        ; because we modify "W_DEFAULT_TX_PACKET_COUNT" form 2 to 3
        ; ----------------------------------------------------
        
        cmp	    dx, 3
        jbe	    Under5Fragment3065Chip
        pop	    si
        pop	    ds
        jmp	    CopyToOneDesc3065Chip
         
Under5Fragment3065Chip:
        pop	    si
        pop     ds
	    ;----------------------------------------------------------  

IFDEF OS2
        jmp	    CopyToOneDesc3065Chip
ENDIF

        push    bx                              ; Save TX descriptor pointer
        push    ds                              ; Save original DS
        push    di                              ; Save packet size

        push    ds
        pop     es                              ; ES = DS

        lds     si,[bp].tx_Bufdesc              ; DS is changed.
        mov     cx,[si].tx_immed_bytes
    	cmp	    cx, 0
        je      TxDataBlockStart65

        sub     di, cx
        jns     NoPadding1 
        mov     di, 0
NoPadding1:

        ; ds:si => logical address
        ;-------------------------
        lds     si,[si].tx_immed_buff       ; DS is changed.
        mov     ax, ds                      ; Save the segment of fragment
        push    es                          ; restore the DS
        pop     ds                          ; Set DS = ES

IFDEF   OS2
        push    eax
        push    bx
        push    dx
        push    si
        push    ds
        push    es
        
        mov 	dl, DevHlp_VirtToPhys       ;DL - function ID
        mov     ds, ax
        
        call    DWORD PTR ES:[devHelper]
        jc      SHORT OS2VTP_Exit
        shl     eax, 16
        mov     ax, bx
        mov     ES:pdescTxBufferPhyAddr, eax
        clc

OS2VTP_Exit:
        pop     es
        pop	    ds
        pop	    si
        pop     dx
        pop     bx
        pop     eax
ENDIF	;OS2

IFDEF 	DOS
        push    di
        
        ; Fill TxEmmDescriotor with Segment:Offset and size of Tx Descriptor
        ;-------------------------------------------------------------------
        mov     TxEmmDescriptor.VSize, ecx
        and     esi, 0000ffffh			    ; For EMM386
        mov     TxEmmDescriptor.VOffset, esi
        mov     TxEmmDescriptor.VSegment, ax
        
        ; Lock the memory and get its Physical memory address space
        ;----------------------------------------------------------
        lea     di, TxEmmDescriptor

        push    es
        push    edx
        push    eax

        cmp     VDSActiveFlag, 0
        je      NoVDSAvailable1

        mov     ax, 08103h              ; Lock our region memory
        mov     dx, 0004h               ; do not allocate memory if region not
                                        ; continuous
        int     4Bh
        jc      VDSErrorExit1

        jmp     VDSExit1

NoVDSAvailable1:
        clc
        
        ; VDS does not exist, use segment:offset to calculate
        ; physicall address
        ;-----------------------------------------------------
        xor     eax, eax
        mov     ax, [di].VSegment
        shl     eax, 4
        add     eax, [di].VOffset
        mov     [di].VPhysical, eax         ; eax = the physical address

VDSExit1:

        mov     eax, [di].VPhysical      	; eax = the physical address
        mov     pdescTxBufferPhyAddr, eax   ; eax = the physical address

        pop     eax
        pop     edx
        pop     es
        pop     di
        jmp     VDSExit3065A1
VDSErrorExit1:

        pop     eax
        pop     edx
        pop     es
        pop     di
        ret
VDSExit3065A1:
ENDIF	;DOS

        clc
        ; Update the first TD : dwTdes1:
        ;-------------------------------
        mov     ax, 8000h                   ; Chain bit
        add     ax, cx                      ; CX:the length of header
        mov     [bx].STxDescStruc.wTxBufferSize, ax  ; Get total packet length (CX
                                            ; is the evenized and padded
                                            ; length calculated by the upper
                                            ; layer) and put in buffer size
                                            ; area.
        ; Reset the TCR value
        ;--------------------
        mov     [bx].STxDescStruc.wTCR, 0000h

        ; Update the first TD : dwTdes2:
        ;-------------------------------

        mov     eax, pdescTxBufferPhyAddr	; get the physical address
        
        mov     [bx].STxDescStruc.dwTxPhyBufAddr, eax
                                            ; store the physical addr. to TD
        ; save the previous pointer
        ;--------------------------
        mov     pdescTxPreviousPtr, bx		; save the previous pointer
        
        ; points to next descriptor
        ;--------------------------
        mov     bx, [bx].STxDescStruc.pdescTxNext 

TxDataBlockStart65:
        lds     si,[bp].tx_Bufdesc	        ; restore the DS:SI
        mov     dx,[si].tx_data_count       ; DX = number of fragments

        cmp     dx, 0
        je      AllBlockDataDone65

        add     si, 8                       ; move pointer to frag pointers
                                            ; DS:SI -> FragStruc.pointers
        ;===============================================================\
        ; Transmit Loop Begin
        ; Within this loop, address with [bp]
        ;===============================================================/
SearchBlock65:

        push    si                          ; save the base of FragStruc.pointers
        push    ds                          ; save the segment of FragStruc

        mov     cx,[si].cd_data_len
        or      ecx, ecx
        jnz     OS2_1_65
        jmp     BlockDataDone65
OS2_1_65:

        sub     di, cx
        jns     NoPadding2 
        mov     di, 0
NoPadding2:

IFDEF OS2
        cmp     ds:[si].cd_ptr_type,CT_GDT
        jne     @F
        lds     si,ds:[si].cd_data_buff
        jmp     short xmit_go65
@@:
    IFDEF FASTGDT
        mov     al,ds:[si].cd_data_buff.hiword.lobyte
        mov     bx,ds:[si].cd_data_buff.loword
        mov     ds,cs:cs_ds
        lds     si,dword ptr segTX
        mov     ds:[si].segd_base15_0,bx
        mov     ds:[si].segd_base23_16,al
        mov     ds:[si].segd_lim15_0,cx ; CX-1 really, but screw it
        mov     ds,si
        xor     si,si
    ELSE
        push    bp
        push    di
        push    dx
        push    cx
        push    bx
        push    ax
        mov     ax,ds:[si].cd_data_buff.hiword
        mov     bx,ds:[si].cd_data_buff.loword
        mov     ds,cs:cs_ds
        mov     si,segTX
        mov     dl,DevHlp_PhysToGDTSelector
        call    devHelper
        mov     ds,si
        xor     si,si
        pop     ax
        pop     bx
        pop     cx
        pop     dx
        pop     di
        pop     bp
    ENDIF
xmit_go65:
ELSE

		; SI : Point to chain data buffer.
		;---------------------------------
        lds     si,ds:[si].cd_data_buff
ENDIF


        mov     ax, ds                          ; Save the segment of fragment
        push    es                              ; restore the DS
        pop     ds                              ; Set DS = ES

IFDEF   OS2
        push    eax
        push    bx
        push    dx
        push    si
        push	ds
        push    es

        mov     dl, DevHlp_VirtToPhys           ;DL - function ID
        mov     ds, ax
        
        call    DWORD PTR ES:[devHelper]
        jc      SHORT OS2VirToPhy_Exit
        shl     eax, 16
        mov     ax, bx
        mov     ES:pdescTxBufferPhyAddr, eax
        clc

OS2VirToPhy_Exit:
        pop     es
        pop	    ds
        pop	    si
        pop     dx
        pop     bx
        pop	    eax
ENDIF	;OS2

IFDEF	DOS
        push    di
        ; Fill TxEmmDescriotor with Segment:Offset and size of Tx Descriptor
        ;-------------------------------------------------------------------
        mov     TxEmmDescriptor.VSize, ecx
        and     esi, 0000ffffh			            ; For EMM386
        mov     TxEmmDescriptor.VOffset, esi
        mov     TxEmmDescriptor.VSegment, ax
        
        ; Lock the memory and get its Physical memory address space
        ;----------------------------------------------------------
        lea     di, TxEmmDescriptor

        push    es
        push    edx
        push    eax
        
        cmp     VDSActiveFlag, 0
        je      NoVDSAvailable2

        mov     ax, 08103h              ; Lock our region memory
        mov     dx, 0004h               ; do not allocate memory if region not
                                        ; continuous
        int     4Bh
        jc      VDSErrorExit2
        jmp     VDSExit2

NoVDSAvailable2:
        clc
        ; VDS does not exist, use segment:offset to calculate
        ; physicall address
        ;-----------------------------------------------------
        xor     eax, eax
        mov     ax, [di].VSegment
        shl     eax, 4
        add     eax, [di].VOffset
        mov     [di].VPhysical, eax         ; eax = the physical address

VDSExit2:

        mov     eax, [di].VPhysical      	; eax = the physical address
        mov     pdescTxBufferPhyAddr, eax   ; eax = the physical address

        pop     eax
        pop     edx
        pop     es
        pop     di
        jmp     VDSExit3065A2
VDSErrorExit2:

        pop     eax
        pop     edx
        pop     es
        pop     di
        ret
VDSExit3065A2:
ENDIF	;DOS

        clc

        ; Update the other TD : dwTdes1:
        ;-------------------------------
        mov     ax, 8000h                  ; Chain bit
        add     ax, cx
        mov     [bx].STxDescStruc.wTxBufferSize, ax  ; Get total packet length (CX
                                            ; is the evenized and padded
                                            ; length calculated by the upper
                                            ; layer) and put in buffer size
                                            ; area.
                                            ; Reset the TCR value
	                                        ;--------------------
        mov     [bx].STxDescStruc.wTCR, 0000h

        ; Update the other TD : dwTdes2:
        ;-------------------------------
        mov     eax, pdescTxBufferPhyAddr	; get the physical address
        
        mov     [bx].STxDescStruc.dwTxPhyBufAddr, eax
                                            ; store the physical addr. to TD
        ; save the previous pointer
        ;--------------------------
        mov     pdescTxPreviousPtr, bx
        
        ; points to next descriptor
        ;--------------------------
        mov     bx, [bx].STxDescStruc.pdescTxNext 

BlockDataDone65:
        ; data pointer has assigned to the field of the desc.
        ;----------------------------------------------------
        pop     ds                          ; Restore the segment of FragStruc
        pop     si                          ; Restore the base of FragStruc
        add     si, 8		                ; DS:SI points to Next
                                            ; FragStruc.pointers
        dec     dx
        jnz     SearchBlock65

        ;===============================================================\
        ; Transmit Loop END
        ;===============================================================/
AllBlockDataDone65:

        push    es
        pop     ds                              ; Set DS = ES
        
        ; Restore the previous pointer
        ;-----------------------------
        
        mov     bx, pdescTxPreviousPtr
        
        ; Check the total frame length whether < cx or not
        ;-------------------------------------------------
        cmp     di, 0
        jbe     PaddingOK
        add     [bx].STxDescStruc.wTxBufferSize, di ; Directly update the length 
                                            ; field of the TD
PaddingOK:

        ; Update the last TD : dwTdes1:
        ;------------------------------
        or      [bx].STxDescStruc.wTCR, W_TX_TCR_EDP
                                            ; set the EDP flag
        ; Save the last descriptor pointer for this packet.
        ;--------------------------------------------------		
        mov     pdescTxLastPtr, bx          ; Save the last descriptor
                                            ; for this packet.
                                            ; Copy fragments done
                                            ;---------------------
        pop     cx
        pop     ds
        pop     bx

        ; Update the first TD : TDES1
        ;----------------------------
        or      [bx].STxDescStruc.wTCR, W_TX_TCR_STP
                                            ; set the STP flag
        ; Update the first TD : TDES3
        ;----------------------------
        and     [bx].STxDescStruc.dwTxPhyNextDesc, not 00000001h
                                            ; The first descriptor must
                                            ; set the TDCTL{0] = 0 to
                                            ; issue interrupt for 
                                            ; this packet
        cli

        add     status.ms_total_sent.loword,1

        adc     status.ms_total_sent.hiword,0

        mov     cx,[bp].tmpcnt

        add     status.ms_total_sbytes.loword,cx
        adc     status.ms_total_sbytes.hiword,0
ENDIF
TxSetSTATUS:
        ;VT3065A : Process 3065 TX
        ;-----------------------------------
        ; Set ownership bit in this descriptor, so NIC will be able to
        ; process it.
        ;--------------------------------------------------------------
        mov     [bx].STxDescStruc.wTxOwn, W_TX_OWN_BIT
        
        ; by Ben (2003/01/18)
        ; For later used to check the OWN BIT
        ; --------------------------------------
        push    ebx
        
        ; add by Ben (2001/08/10), set INSTAG off (Bit1) in TD's TCR field
        ; if under VT3106
        ; ----------------------------------------------------------------\
        cmp     pciRevisionId, RevisionID3106J
        jb      NoSetINSTAG
        
        ; Set INSTAG off under VT3106
        ; ----------------------------
        mov     dx, W_TX_TCR_INSTAG
        not     dx
        and     [bx].STxDescStruc.wTCR, dx
NoSetINSTAG:
        ; ----------------------------------------------------------------/
                out 89h, al
        ; Kick NIC to transmit by issuing TX poll demand.
        ;---------------------------------------------------
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.CommandReg
        in      ax, dx
        or      ax, W_CR_TDMD1 or W_CR_RXON
        out     dx, ax                         ; TX poll demand
                                               ;issue transmit command

        ; by Ben (2003/01/18), pop up the first descriptor
        ; to check the OWN Bit
        ; ------------------------------------------------
        pop     ebx     
        mov     cx, 7fffh
        
Wait1:
        test    [bx].STxDescStruc.wTxOwn, W_TX_OWN_BIT
        jz      Done
        ;in      al, 61h
        ;in      al, 61h
        loop    Wait1
Done:
        inc     wTxNumPosted
        
        ;VT3065A : Restore last desciptor
        ;-----------------------------------
        ; Restore the last desciptor position.
        ; In order to point to next TD.
        ;-------------------------------------
        mov     bx, pdescTxLastPtr              ; Restore the last pointer
        
        ; Point at next transmit descriptor (and save it)
        ;-------------------------------------------------
        mov     ax, [bx].STxDescStruc.pdescTxNext
        mov     pdescTxWrite, ax                ; save the incremented TX
        
DontStartThisOne:
        ;mov     bx, Ioport
        ;lea     dx, [bx].SCsrRegStruc.IMR0
        ;mov     ax, wImrShadow
        ;out     dx, ax

        pop     eax
        xor     ax,ax
        
        public  xmit_exit
xmit_exit:

        ; Restore the interrupt flag
        ;-----------------------------------
        
        popf
        POPR    esi,edi,ebp,ebx,ecx,edx,ds,es
        leave
        ret     TXRET

Out_Resource_Exit:
        pop     eax
        ;mov     ax, wImrShadow
        ;mov     bx, Ioport
        ;lea     dx, [bx].SCsrRegStruc.IMR0
        ;out     dx, ax
        mov     ax, Out_Resource
        jmp     xmit_exit

TransmitChain   endp

        END_CODE
        end