;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: util.asm
; 
;  Purpose: This file contains utility functions used internally by the MAC as 
;           well as the timer tick handler for DOS.                            
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       ResetAdapter
;       UpdateMulticast
;       DriverMulticastChange
;       SetupMCHashBit
;       ResetNIC
;       vSoftwareResetNIC
;       InitializeTheReceiveRing
;       InitializeTheTransmitRing
;       vUpdateTallyCounter
;       vKickNicToWork
;       vMACSoftwareReset
;       vMACSafeRxOff
;       vMACSetLoopbackMode
;       vSetFlowCTL
;       vGetMappedLFCTL
;       vSetLFCTL
;       vReadFCTL
;       vAddCAMEntry
;       vReadCAMEntry
;       vSetCAMCtlRegs
;       vSetPhyModeCfg
;       vPhyModeStatus
;       vMapPhyModeFlag
;       vSetAUTO_REAUTO
;       vSetMIIANAR
;       vSetMIIBMCR
;       MACminiDelay2
;       MACmicroDelay2
;       vChkLTSAPOK
;       vIsOurInterrupt
;       SetIRQ
;       FindAddressInMCTable
;       TickHandler
;       print_char
;       _dis
;       dis_ax
;       CLockMemoryAndGetPhysical
;       CheckVDSAvailale
;       List all the functions this module provides.
;       (This section is omitted in the header of "include" files)
; 
;  Revision History:
;       01-15-2003 GuardKuo: add this copyright message
;
;                page    88,122
               title   UTIL - Internal utility functions (2.0.1 Spec)



.xlist
IFDEF OS2
include devhlp.inc
ENDIF
include includes.mac
.list
.lfcond
.sall

.386

;------ Exported Interfaces -------------------------------------------------;
                public          ResetAdapter
                public          ResetNIC
                public          SetIRQ
                public          UpdateMulticast
                public          vMACSetLoopbackMode 
                public          vMACSafeRxOff      
                public          vMACSoftwareReset  
                public          vSetFlowCTL        
                public          vPhyModeStatus     
                public          vSetAUTO_REAUTO    
                public          vSetMIIANAR        
                public          vSetMIIBMCR        
                public          MACmicroDelay2     
                public          MACminiDelay2      
                public          SetPacketFilter    

IFDEF ANYSTATS
                DOSPUBL         TickHandler
ENDIF

IFDEF   DYNAALLOC
                public          MEMReSize
                public          MEMDynaAlloc
ENDIF
;-------Imported Interfaces -------------------------------------------------;

                OS2XTRN         devHelper:DWORD
                extrn           IMRport:WORD
                extrn           enableMask:BYTE
                extrn           multilist:BYTE
                extrn           specific:BYTE
                extrn           status:BYTE

IFDEF ANYSTATS
                DOSXTRN         timerCount:DWORD
                DOSXTRN         timerChain:DWORD
ENDIF

                extrn           state:byte
                extrn           cs_ds:word
                extrn           Ioport:word
                extrn           IntLevel:byte
                extrn           RamSize:byte
                extrn           adapterBits:word
                extrn           ReceiveConfig:byte

                extrn           MCAddress: byte
                extrn           ERFlag:byte
                extrn           ETFlag:byte
                extrn           FDXFlag:byte
                extrn           byLineSpeed:byte

                extrn           InISR:byte
                extrn           byMIIIndex:byte
                extrn           wMIIValue:word
                extrn           DriverCustomTallyMPA:dword
                extrn           DriverCustomTallyCRC:dword
                extrn           byRcrValue:byte
                extrn           byTcrValue:byte
                extrn           byDMALength:byte
                extrn           TxThreshSpecify:byte
                extrn           RxThreshSpecify:byte
                extrn           DMALengthSpecify:byte
                extrn           pdescRxListHead:word
                extrn           wRxNumBuffers:word
                extrn           pdescRxRead:word
                extrn           pdescTxListHead:word
                extrn           wTxNumBuffers:word
                extrn           pdescTxRead:word
                extrn           pdescTxWrite:word
                extrn           wTxNumPosted:word
                extrn           wImrShadow:word
                extrn           RDStart:byte
                extrn           TDStart:byte

                extrn           LineSpeed10Msg:byte
                extrn           LineSpeed100Msg:byte
                extrn           FullDuplexMsg:byte
                extrn           HalfDuplexMsg:byte
                extrn           EthernetID:byte
                extrn           pciRevisionId:byte   
                extrn           W_MAX_TIMEOUT:word   
                extrn           AutoFlag:byte        
                extrn           byCurrCAMIndex:byte  
                extrn           wVIDDefault:word     
                extrn           dbCurrPhyMode:byte   
                extrn           OKMsg:BYTE           
                extrn           ReAutoMsg:BYTE       
                extrn           msg_crlf:byte        
                extrn           dbUpdatRBRDU:byte    
                extrn           wFLOWCTLFlag:word    
                extrn           wOriPHYANARValue:word
                      
                extrn           MIIRead:near
                extrn           MIITurnOnBits:near
                extrn           MIITurnOffBits:near
                extrn           MIIWrite:near
                extrn           MIIDelay:near          ; Added by Ben (2001/09/24)
                extrn           PutString:near          ; Added by Ben (2001/08/17)
                extrn           intr_Delay1Second:near  ; Added by Ben (2001/08/17)
                
                
                extrn           VDSActiveFlag:byte

                IFDEF   DOS
                extrn           VEmmDesp:byte
                IFDEF  SHOW_KEY
                extrn           _dis:near
                ENDIF
                ENDIF
                extrn           dbLegacyForcedMode:byte      ; added by guard(2003/07/05)
        IFDEF   DYNAALLOC
        extrn   RXBufferSegment:word
        extrn   RXPhysicallAddr:word
        extrn   CurSEGmentCount:word
        ENDIF

                BEGIN_CODE

NEWPAGE <ResetAdapter - Reset Adapter>
;------ ResetAdapter --------------------------------------------------------;
;                                                                            ;
;       void ResetAdapter()                                                  ;
;                                                                            ;
;       Registers AX,BX,CX,DX,SI,DI,ES are destroyed.                        ;
;       Returns with interrupts disabled.                                    ;
;                                                                            ;
;       This function resets and initializes the adapter.  It is used to     ;
;       get the adapter back into a known good state after a catastrophic    ;
;       error.  The adapter will be closed and any outstanding requests      ;
;       will be forgotten.                                                   ;
;                                                                            ;
;       We ignore the state of the SRBinuse flag, and just stomp on          ;
;       anything that is in progress.  We unmask the IMR for our interrupt   ;
;       level regardless of the indication offDepth.                         ;
;                                                                            ;
;       If used at any time other than initialization, we should ensure      ;
;       that all of the queues are emptied and all of the state variables    ;
;       reset to their initial states.                                       ;
;                                                                            ;
;       The IBM Token Ring adapter is reset by first writing to the reset    ;
;       port, waiting at least 50ms and then writing to the release port.    ;
;       The card goes through its diagnostics and then generates an SRB      ;
;       acknowledgement interrupt to the PC (even though we didn't issue     ;
;       an SRB, but the IBM hardware engineers pretend we did).              ;
;                                                                            ;
;       This routine uses a loop to delay the 50ms required.  Not the best   ;
;       programming practice, but I needed something simple that worked      ;
;       under both OS/2 and DOS.  The loop is made up of XCHG AX,AX          ;
;       instructions which have the nice characteristic that they take the   ;
;       same number of cycles on all of the Intel processors 8088 thru       ;
;       80486.  The loop is currently coded to take about 50ms on a 40MHz    ;
;       486, with the longest time being about half a second on a 4.77MHz    ;
;       PC.                                                                  ;
;                                                                            ;
;       It appears to be perfectly acceptable to hold the reset state on     ;
;       longer than necessary.  In all my testing it was also acceptable to  ;
;       hold it much shorter than necessary.                                 ;
;                                                                            ;
;----------------------------------------------------------------------------;

ResetAdapter    proc    near

        push    bp
        cli
        and     status.ms_flags.loword, NOT ST_MAC_IS_OPEN
                                        ;MAC is not open
        mov     state,RESETTING

        mov     ds,cs:cs_ds
        mov     es,cs:cs_ds
        
        mov     dx, Ioport
        mov     di,offset specific.mc_paddr
        mov     cx,6h
        cld

@@:
        in      al,dx                   ; get node address
        stosb
        inc     dx
        loop    @B

InitcurrAddr:
        test    adapterBits, ADDRESSED
        jnz     @F
        mov     si,offset DGROUP:specific.mc_paddr
        mov     di,offset DGROUP:specific.mc_caddr
        mov     cx,3
        rep     movsw
        
@@:
        call    ResetNIC
        

        mov     status.ms_filter,3      ;set current packet filter
        mov     state,CLOSED

        call    SetIRQ
        mov     state, OPENNED
        or      status.ms_flags.loword, ST_MAC_IS_OPEN

        pop     bp
        retn

ResetAdapter    endp



;----------------------------------------------------------------------
;       UpdateMulticast
;
;
;       assumes:        ds      set to DGroup
;                       CLD has been executed
;                       Interrupts are disabled
;
;       returns:        Everything destroyed
;------------------------------------------------------------------------

UpdateMulticast      proc    near

        mov     si, offset DGroup:multilist.ma_mbuff[0]
        mov     cx, multilist.ma_cur
        call    DriverMulticastChange           ;Tell the driver about the update

MSMMediaShutdown:
MSMMediaReset:
        ret

UpdateMulticast      endp

;----------------------------------------------------------------------
;       DriverMulticastChange
;
;       Called by the envelope when changes have occurred to our
;       multicast address list.
;
;       assumes:        ds      is set to DGroup
;                       si      -> Multicast Table
;                       cx      number of entries in table
;                       CLD has been executed
;                       Interrupts are disabled
;
;       returns:        Nothing need be preserved
;----------------------------------------------------------------------

DriverMulticastChange   proc    near
        cli

        push    ebx
        push    esi

        ;---------------------------------------------- 
        ; First reset Multicast Address Registers.
        ;---------------------------------------------- 
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.MAR0
        mov     bx, 8                           ;There are 8 registers to setup
        xor     al, al                          ;Set all bits to 0.

DisableAllBitsLoop:
        out     dx, al
        inc     dx
        dec     bx
        jnz     DisableAllBitsLoop

        jcxz    @F                              ; Leave if table is empty.

        ;***************************************************************\
        ; Now Loop thru each table entry and set multicast addresses    *
        ; that use used.                                                *
        ;***************************************************************/
ScanMCTableForAddressLoop:
        ;***************************************************************\
        ; Get value to put into controllers multicast hash table.       *
        ;***************************************************************/
          
        ;***************************************************************\
        ; 2003 5 15, guard
        ; There are CAM memory in VT3106S only
        ;***************************************************************/
        cmp     pciRevisionID, RevisionID3106S
        jae     AddToCAMEntry               ; 3106S

NoCAMMemory:                                ; 3043,3065,3206,3106J
        
        ; ----------------------------------------------------------
        ;                   VT3065
        ; ----------------------------------------------------------        
        call    SetupMCHashBit                  ;Setup the address on the NIC
        jmp     EntryAddDone                    ; add by Ben (2001/08/10)
        
        ; ----------------------------------------------------------
        ;                   VT3106
        ; ----------------------------------------------------------
        ; add by Ben (2001/08/10), add multicast address into CAM
        ;   1. CAM is the first place to add entry
        ;   2. If CAM entry is not enough, then add to HASH table
        ;   3. 
        ; ----------------------------------------------------------\
AddToCAMEntry:
        cmp     byCurrCAMIndex, 32
        jae     AddToHASHTable
        
        ; ---------------------------------
        ; byCurrCAMIndex < 32, add to CAM
        ; ---------------------------------
        push    cx
        xor     cx, cx                          ; Set CH=0 for MCAM
        mov     cl, byCurrCAMIndex              ; CL=next entry to write
        call    vAddCAMEntry                    ; Entry:
                                                ;   CH : 0 for MCAM
                                                ;   CL : 0 ~ 31, entry index
                                                ;   SI : Pointer to data for write
                                                ; Ret :
                                                ;   Carry Flag : Set if success
                                                ;   All registers preserved
        pop     cx
        jc      CAMAccessOK
        
        ; Access CAM failed, just return
        ; ---------------------------------
CAMAccessFailed:        
        pop     esi
        pop     ebx
        pop     ds
        ret                                     ;All done

CAMAccessOK:                
        ; Access CAM ok, keep going on next entry
        ; ----------------------------------------
        
        inc     byCurrCAMIndex
        jmp     EntryAddDone
        
        ; ---------------------------------------
        ; byCurrCAMIndex > 32, add to HASH table
        ; ---------------------------------------
AddToHASHTable:
        ; Set CAMEN off for MAR0~7
        ; ---------------------------------------
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.CAMCR     ; [92h]
        in      ax, dx
        and     ax, not BY_CAMC_CAMEN           ; disable CAMEN bit
        out     dx, ax
        
        call    SetupMCHashBit                  ;Setup the address on the NIC
        
EntryAddDone:                                   ; add by Ben (2001/08/10)
        ; ----------------------------------------------------------/
MCEntryNotUsed:
        add     si, 10h                         ;Goto next entry
        loop    ScanMCTableForAddressLoop

@@:
        ; add by Ben (2001/08/10), everytime upper layer wants driver to add
        ; multicast address, the index for CAM is starting from zero.
        ; -------------------------------------------------------------------
        mov     byCurrCAMIndex, 0               ; add by Ben (2001/08/10)
        
        pop     esi
        pop     ebx

        ret                                     ;All done

DriverMulticastChange   endp




;----------------------------------------------------------------------
;       SetupMCHashBit
;
;       This routine will take the specified 6-byte address and calculate
;       which bit should be set in the 8390 multicast hash table to enable
;       reception of that address.  It will then set the appropriate bit
;       in the 8390 hash table.
;
;       assumes:        ds      is set to DGroup.
;                       si      -> buffer holding the 6-byte address to use.
;                       Interrupts unspecified.
;
;       returns:        ds,si,bx,cx preserved.
;                       Interrupt start preserved.
;----------------------------------------------------------------------

SetupMCHashBit  proc    near

        push    si
        push    cx

        ;----------------------------------------------------------------------
        ;       First select the page 1 registers.
        ;----------------------------------------------------------------------
        push    ds
        pop     es

        lea     edi, DGroup:MCAddress
        movsw
        movsw
        movsw

        mov     bp, 0FFFFh                      ;BP = crcl
        mov     di, bp                          ;DI = crch

        ;----------------------------------------------------------------------
        ;       for (index=0; index < 6; ++index)
        ;----------------------------------------------------------------------
        mov     cx, 6                           ;Do 6 bytes of address
        lea     esi, DGroup:MCAddress

FilterOuterLoop:
        push    cx                              ;Save outer loop counter

        ;       for (j=0; j<8; ++j)
        ;-----------------------------------

        mov     cl, 8                           ;Set innerloop count

        ;       carry = ((crc&0x80000000)?1:0)^(multaddress[i]&01)
        ;----------------------------------------------------------------------

FilterInnerLoop:
        mov     ax, 8000h
        and     ax, di

        rcl     ax, 1
        rcl     ax, 1

        mov     dx, 1
        and     dx, [si]                        ;multiaddress[i]&01

        xor     ax, dx

        ;       crc <<= 1
        ;-----------------------------------

        shl     bp, 1
        rcl     di, 1

        ;       multaddress[i] >>= 1
        ;-----------------------------------

        shr     byte ptr [si], 1

        ;       if (carry)
        ;        crc = ((crc^PLYNOMIAL) | carry)
        ;----------------------------------------------------------------------

        or      ax, ax                          ;AX has carry in it
        jz      FinishInnerFilterPass
        cwd                                     ;DX:AX = sign extended car y value

        ;       crc^POLYNOMIAL
        ;-----------------------------------
        xor     bp, 1DB6h                       ;High end of polynomial.
        xor     di, 04C1h                       ;Low end of polynomial.

        ;       crc^Polynomial | carry
        ;-----------------------------------
        or      bp, ax                          ;Low end of carry
        or      di, dx                          ;High end

FinishInnerFilterPass:
        loop    FilterInnerLoop

        inc     si                              ;-> next byte of address
        pop     cx                              ;Restore outer counter
        loop    FilterOuterLoop

        ;       crc = crc & 0x0ff00 0000h
        ;-----------------------------------
        and     di, 0ff00h

        ;       crc = crc >> 26
        ;-----------------------------------
        mov     cl, 26
        xor     ax, ax
        mov     dx, di

MultiShiftForFilter:
        shr     dx, 1
        rcr     ax, 1
        loop    MultiShiftForFilter

        ;----------------------------------------------------------------------
        ;       AX has the filter bit index.
        ;       Calculate the register and bit offset for this bit position.
        ;----------------------------------------------------------------------
        mov     dx, ax
        mov     cx, ax
        and     cl, 07h                         ;Mask off all except last 3 bits
        mov     al, 1
        shl     al, cl                          ;Setup variable

        shr     dx, 1                           ;Figure register to use (/8)
        shr     dx, 1
        shr     dx, 1

        push    ax
        mov     si, Ioport
        lea     ax, [si].SCsrRegStruc.MAR0
        add     dx, ax
        pop     ax

        ;----------------------------------------------------------------------
        ;       Write the value to the NIC.
        ;----------------------------------------------------------------------
        mov     ah, al                          ;Save AL
        in      al, dx                          ;Get current bit setting

        or      al, ah                          ;Mask in our bit
        out     dx, al

        pop     cx
        pop     si

        ret
SetupMCHashBit  endp



;----------------------------------------------------------------------
;       ResetNIC
;
;       Routine to totally reinitialize the NIC.
;
;       assumes:        ds      is set to CGroup
;                       Interrupt state is undefined
;
;       returns:        bx,ds,ints preserved.
;----------------------------------------------------------------------
ResetNIC        proc    near
        push    bx
        xor     al, al

        push    eax

        
        ; add by Ben (2001/08/17), check VT3106's phy, then set Bit0 of PHYMDCFG
        ; -----------------------------------------------------------------------\
        call    vSetPhyModeCfg
        ; -----------------------------------------------------------------------/
        
        call    vSoftwareResetNIC       ; high word of EAX is cleared

        mov     al, 20h                 ; commands to issue
        cmp     IntLevel, 08h
        jb      ClearPICMaster
        out     INT_1EOIR,al            ; command to slave
        push    ax
        in      al, 61h
        in      al, 61h
        in      al, 61h
        pop     ax
        
ClearPICMaster:
        out     INT_2EOIR,al            ; command to master
        push    ax
        in      al, 61h
        in      al, 61h
        in      al, 61h
        pop     ax

        ; Initialize driver's state variables so state machines will go to
        ; known states.
        ;--------------------------------------------------------------------
        ; Update Tx Hang check counters
        ;--------------------------------
        mov     wTxNumPosted, 0         ; Mark That no packets are
                                        ; posted

                                         
        ; Initialize transmit and receive descriptors list and buffers.
        ;---------------------------------------------------------------
        call    InitializeTheReceiveRing
        call    InitializeTheTransmitRing

        ;VT3065A : EMM386
        ;-----------------------------------
        push    es
        mov     ax, 40h
        mov     es, ax
        test    byte ptr es:[7bh], 20h
        pop     es
        jz      VT3065ANoEMM386
        
        ;EMM386 is the same as the real mode addressing.
        ;----------------------------------------------------------------------
        jmp     ExitNoEMM386
        
VT3065ANoEMM386:
        mov     VDSActiveFlag, 0
        
ExitNoEMM386:
        ;VT3065A : EMM386
        ;-----------------------------------
        IFDEF   SHOW_KEY
        push    eax                      ;      number 0-7>.
        push    edi
        mov     di,5
        call    _dis
        shr     eax, 16
        mov     di,6
        call    _dis
        pop     edi
        pop     eax
        ENDIF

        ; Init IMR, get Interrupt Mask
        ;--------------------------------
        mov     bx, Ioport
        mov     ax, wImrShadow
        lea     dx, [bx].SCsrRegStruc.IMR0
        out     dx, ax

        ; add by Ben (2001/08/10), add VID=0 to VCAM (under VT3106S, Mode1)
        ;   When disabling tagging, we will tx untagged packet, and rx untag/tag 
        ;   priority packet (extract tag from tagged packets). So the setting should
        ;   be :
        ;       1. [PQEN:RTGOPT]=[1:0]
        ;       2. Instag(Bit1)=0 in TD's TCR
        ;       3. VCAM[0]=0
        ;       4. VCAM MASK=1
        ;       5. VIDFR=1 in BCR1
        ; ---------------------------------------------------------------------------
        ; add by Ben (2001/12/31), (under VT3106J, Mode0)
        ;       1. [PQEN:RTGOPT]=[0:0]
        ;       2. Instag(Bit1)=0 in TD's TCR
        ;       3. VCAM[0]=0
        ;       4. VCAM MASK=0
        ;       5. VIDFR=0 in BCR1
        ; ---------------------------------------------------------------------------\
        cmp     pciRevisionId, RevisionID3106S
        jb      NoSetVCAM      

        push    cx
        push    si
        mov     ch, 1                           ; CH=1, accecc VCAM
        mov     cl, 0                           ; CL=0, the 1st entry
        lea     si, wVIDDefault
        call    vAddCAMEntry                    ; Entry: 
                                                ;   CH : Set for VCAM, otherwise for MCAM
                                                ;   CL : 0 ~ 32, total 32 entries
                                                ;   SI : Pointer to data to write
                                                ; Retrun:
                                                ;   Carry flag : set if success
        
        
        pop     si
        pop     cx
        
        ; Set VIDFR
        ;-----------
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.BCR1
        in      ax, dx
        or      ax, BY_BCR1_VIDFR               ; Set Bit8 VIDFR on
        out     dx, ax                          ; write back to BCR1
        
NoSetVCAM:        
        ; ---------------------------------------------------------------------------/
        
        ; Init Command registers (and start the Tx and RX processes)
        ;------------------------------------------------------------

IFDEF   OS2
        ; ----------------------------------------------------------------------------
        ; [4.37] Patch IBM TCP/IP suite 2.0 for OS2
        ; If loading multiple NICs, driver will let system to halt.
        ; We patch this issue by disabling RX engine at driver initial stage and
        ; enable RX engine after transmitting the first packet (OS will automatically
        ; sends a packet to itself after starting to work).
        ; ----------------------------------------------------------------------------

        push    dx

        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.CommandReg
        in      ax, dx
        and     ax, not (W_CR_STOP OR W_CR_RXON)             ; clear STOP bit
        or      ax, W_CR_START OR W_CR_TXON OR W_CR_DPOLL
        out     dx, ax

        pop     dx

ELSE
        call    vKickNicToWork

ENDIF

        pop     eax
        pop     bx
        clc                             ; Successful end.
        ret

ResetTimeout:
        stc                             ; Mark failure.

RT_ErrorExit:
        pop     eax
        pop     bx
        ret

ResetNIC        endp

; ---------------------------------------------------
;
;
; ---------------------------------------------------
        align   4
vSoftwareResetNIC      proc    near

        push    ax
        push    bx
        
        

        mov     bx, Ioport
        ; Set RCR and TCR registers
        ;-------------------------------------------------------------
        lea     dx, [bx].SCsrRegStruc.RXCR
        in      ax, dx                      ; AH=TCR, AL=RCR
        and     ah, not 0E0h                ; clear first (mask off TCR threshold)
        or      ah, byTcrValue              ; set user specified value
        

        cmp     pciRevisionId, RevisionID3106S
        jb      NoUserTcr
        
        ; Set {PQEN:RTGOPT}={1,0} under VT3106S
        ; --------------------------------------
        or      ah, TX_NOTAG
                
NoUserTcr:
        and     al, not 0E0h                ; clear first (mask off RCR threshold)
        or      al, byRcrValue              ; set user specified value
        
NoUserRcr:
        or      al, BY_RCR_AM OR BY_RCR_AB  ; default Multicast Broadcast ON
        out     dx, ax

        pop     bx
        pop     ax
        clc
        ret

vSoftwareResetNIC       endp

;/*****
;
;       InitializeTheReceiveRing
;
;  Description:
;       Routine reinitialize the receive ring and receive buffers.
;
;*/
        align   4
InitializeTheReceiveRing        proc

        push    eax
        push    ebx
        push    ebp
        push    si

        xor     ebx, ebx
        xor     eax, eax
        xor     edx, edx

IFDEF   OS2
        xor     ebx, ebx
        lea     bx, RDStart
        add     bx, 1Fh
        and     ebx, not 1Fh
        push    ebx
        push    edx
        mov     si, bx                  ; ds:si => logical address
        mov     dl,DevHlp_VirtToPhys    ; get AX:BX = physical address
        call    devHelper
        shl     eax,16
        mov     ax,bx
        pop     edx
        pop     ebx
ENDIF

IFDEF   DOS
        mov     VEmmDesp.VSize, W_DEFAULT_RX_DESC_COUNT*W_RX_BUFFER_SIZE+32
        xor     ebx, ebx
        mov     bx, offset RDStart
        add     bx, 1Fh
        and     ebx, not 1Fh
        push    ebx
        mov     VEmmDesp.VOffset, ebx
        mov     VEmmDesp.VSegment, ds
        lea     di, VEmmDesp    
        call    CLockMemoryAndGetPhysical
        pop     ebx
        jc      errexit
        mov     eax, VEmmDesp.VPhysical

GetPaddrOK:
        ;**************************************************
        ;  Here ebx ==> logical address of RD
        ;       eax ==> physical address of RD
        ;**************************************************


ENDIF

        ; Eax to hold aligned physical address
        ;------------------------------------
        push    eax                     ; Save Start of list

        ; Update run time receive descriptors pointer to point at start of list.
        ;-----------------------------------------------------------------------
        mov     pdescRxListHead,  bx    ; save pointer for run time
        mov     pdescRxRead, bx         ; save pointer for run time
                                        ; from now and on, BX points
                                        ; to the next descriptor to
                                        ; be initialized.

        ; Update CurrRxDescAddr to point at first RX descriptor
        ; (physical address)
        ;----------------------------------------------------------------------
        mov     si, Ioport
        lea     dx, [si].SCsrRegStruc.CurrRxDescAddr
        out     dx, eax
        mov     cx, wRxNumBuffers               ; get number of RX buffers
IFDEF   DYNAALLOC
        lea     si, RXPhysicallAddr
        lea     di, RXBufferSegment
        xor     edx, edx
        mov     dx, 0
        mov     CurSEGmentCount, 0
ENDIF
SetRxDescriptorsLoop:
        ; Set RDES0:
        ;----------
        ; Status part of RDES0 does not have to be initialized.
        ; Set ownership bit to denote descriptor is ownde by nic.
        ;----------------------------------------------------------------------
        mov     [bx].SRxDescStruc.wRxLength, W_RX_LENGTH_OWN

        ; Set RDES1:
        ;------------
        ; Set buffer size to be W_RX_BUFFER_SIZE.
        ;----------------------------------------------------------------------
        mov     [bx].SRxDescStruc.wRxBufferSize, W_RX_BUFFER_SIZE

        ; Set RDES2:
        ;------------
        ; Point with RDES2 to the buffer located immediately after this
        ; descriptor. Point to buffer's physical address.
        ;----------------------------------------------------------------------
        xor     ebp,ebp
        
IFDEF   DYNAALLOC
        mov     [bx].SRxDescStruc.pRxBuffer, dx
        mov     ebp, [si]
        mov     [bx].SRxDescStruc.pRxBufferSeg, ebp
        mov     bp, [di]
        mov     [bx].SRxDescStruc.pRxLogicSeg, bp
        mov     ebp, [bx].SRxDescStruc.pRxBufferSeg
        add     ebp, edx
        add     dx, W_RX_BUFFER_SIZE
        push    ax
        mov     ax, wRxNumBuffers
        sub     ax, cx
        inc     ax
        shr     ax, 5
        cmp     ax, CurSEGmentCount
        jbe     OnSameSegment
        add     si, 4
        add     di, 2
        mov     CurSegmentCount, ax
        mov     dx, 0
OnSameSegment:
        pop     ax
ELSE          
        lea     bp, [bp].SRxDescStruc.abyRxBuffer
        add     ebp, eax
ENDIF
        mov     [bx].SRxDescStruc.dwRxPhyBufAddr, ebp
        ; Set RDES3:
        ;------------
        ; Point with RDES3 to the descriptor located immediately after this
        ; descriptor's buffer. Point to next descriptor's physical address.
        ;----------------------------------------------------------------------
        add     eax, size SRxDescStruc
        
        IFDEF   SHOW_KEY
        push    eax                      ;      number 0-7>.
        push    edi
        mov     di,5
        call    _dis
        shr     eax, 16
        mov     di,6
        call    _dis
        pop     edi
        pop     eax
        ENDIF

        mov     [bx].SRxDescStruc.dwRxPhyNextDesc, eax

        ; Set pdescRxNext:
        ;------------------
        mov     bp, bx
        add     bp, size SRxDescStruc
        mov     [bx].SRxDescStruc.pdescRxNext, bp

        ; Point at next receive pool
        ;-----------------------------
        ; Notice that EAX is already holding the physical address
        ; of the next descriptor
        ;----------------------------------------------------------------------
        mov     bx, bp

        loop    SetRxDescriptorsLoop


        ; Update the end of receive list pointer.
        ; Update last descrioptor's pointers
        ; Set rnext of the last descriptor to point to the first descriptor
        ; Set phys address of next descriptor to be the first desc. address
        ;---------------------------------------------------------------------
        sub     bx, size SRxDescStruc
        mov     bp, pdescRxListHead             ; Let the pdescRxNext of the
                                                ; last descriptor
        mov     [bx].SRxDescStruc.pdescRxNext, bp
                                                ; point to the first one.
        pop     ebp                             ; Restore Start of List
        mov     [bx].SRxDescStruc.dwRxPhyNextDesc, ebp
                                                ; first descriptor
        clc
        
RD_Exit:
        pop     si
        pop     ebp
        pop     eax
        pop     eax
        ret
        
errexit:
        stc
        jmp     RD_Exit

InitializeTheReceiveRing        endp

;/*****
;
;       InitializeTheTransmitRing
;
;  Description:
;       Routine reinitialize the transmit ring and transmit buffers.
;
;  Prameters:
;     In:
;       ds - CGroup
;       CLD has been executed
;       Interrupts are disabled
;       NIC is in reset state
;       Global variables:
;               TxDmaDescriptor.dwPhysicalAddress
;               pTxResourcePtr
;               wCurrTxDescAddrAddress
;               wTxNumBuffers
;
;     Out:
;       ds - CGroup
;       dx - error message if fail
;       Nothing need be preserved
;       Global variable:
;               pdescTxListHead
;               pdescTxRead
;
;  Return Value:   None
;
;  Call:
;
;
;*/
        align   4
InitializeTheTransmitRing       proc    near

        push    eax
        push    ebx
        push    ebp
        push    si

        xor     ebx, ebx
        xor     eax, eax


IFDEF   OS2
        lea     bx, TDStart
        add     bx, 1Fh
        and     ebx, not 1Fh
        push    ebx
        push    edx
        mov     si, bx                  ; ds:si => logical address
        mov     dl,DevHlp_VirtToPhys    ; get AX:BX = physical cs_ds
        call    devHelper
        shl     eax,16
        mov     ax,bx
        pop     edx
        pop     ebx
ENDIF
IFDEF   DOS
        mov     VEmmDesp.VSize, W_DEFAULT_TX_DESC_COUNT*W_TX_BUFFER_SIZE+32
        xor     ebx, ebx
        mov     bx, offset TDStart
        add     bx, 1Fh
        and     ebx, not 1Fh
        push    ebx
        mov     VEmmDesp.VOffset, ebx
        mov     VEmmDesp.VSegment, ds
        lea     di, VEmmDesp    
        call    CLockMemoryAndGetPhysical
        pop     ebx
        jc      errexit
        mov     eax, VEmmDesp.VPhysical
GetPaddrOK1:
        ;**************************************************
        ;  Here ebx ==> logical address of RD
        ;       eax ==> physical address of RD
        ;**************************************************
ENDIF

        ; Eax to hold aligned physical address
        ;------------------------------------
        push    eax                     ; Save Start of list

        ;Update run time transmit descriptors pointer to point at start of list.
        ;----------------------------------------------------------------------
        mov     pdescTxListHead,  bx            ; save pointer for run time
        mov     pdescTxWrite, bx                ; save pointer for run time
        mov     pdescTxRead, bx                 ; save pointer for run time
                                                ; from now and on, BX points
                                                ; to the next descriptor to
                                                ; be initialized.

        ; Update CurrTxDescAddr to point at first TX descriptor.
        ; (physical address)
        ;----------------------------------------------------------------------
        mov     si, Ioport
        lea     dx, [si].SCsrRegStruc.CurrTxDescAddr
        out     dx, eax
        mov     cx, wTxNumBuffers               ; get number of TX buffers.

SetTxDescriptorsLoop:
        ; Set TDES0:
        ;-------------
        ; Reset ownership bit to denote descriptor is ownde by host.
        ;----------------------------------------------------------------------
        mov     [bx].STxDescStruc.wTxOwn, 0000h

        ; Set TDES1:
        ;------------
        ; TDES1 will be updated while creating Tx packets.
        ;----------------------------------------------------------------------
        ; Set TDES2:
        ;-------------
        ; Point with TDES2 to the buffer located immediately after this
        ; descriptor. Point to buffer's physical address.
        ;----------------------------------------------------------------------
        xor     ebp,ebp
        lea     bp, [bp].STxDescStruc.abyTxBuffer
        add     ebp, eax
        mov     [bx].STxDescStruc.dwTxPhyBufAddr, ebp

        ; Set TDES3:
        ;-------------
        ; Point with TDES3 to the descriptor located immediately after this
        ; descriptor's buffer. Point to next descriptor's physical address.
        ;----------------------------------------------------------------------
        mov     [bx].STxDescStruc.pdescTxCurrPhy, eax   ; Tx Error Re-Send
        add     eax, size STxDescStruc
        mov     [bx].STxDescStruc.dwTxPhyNextDesc, eax

        ; Set pdescTxNext:
        ;------------------
        mov     bp, bx
        add     bp, size STxDescStruc
        mov     [bx].STxDescStruc.pdescTxNext, bp

        ; Point at next receive pool
        ;-----------------------------
        ; Notice that EAX is already holding the physical address
        ; of the next descriptor
        ;----------------------------------------------------------------------
        mov     bx, bp
        loop    SetTxDescriptorsLoop

        ; Update the end of transmit list pointer..
        ; Update last descrioptor's pointers.
        ; Set pdescTxNext of the last descriptor to point to the 1st descriptor.
        ; Set phys address of next descriptor to be the first desc. address.
        ;-----------------------------------------------------------------------
        sub     bx, size STxDescStruc
        mov     bp, pdescTxListHead             ; Let the pdescTxNext of the
                                                ; last descriptor
        mov     [bx].STxDescStruc.pdescTxNext, bp
                                                ; point to the first one.
        pop     ebp                             ; Restore Start of List
        mov     [bx].STxDescStruc.dwTxPhyNextDesc, ebp
                                                ; first descriptor
        clc
        
TD_Exit:
        pop     si
        pop     ebp
        pop     ebx
        pop     eax
        ret

errexit1:
        stc
        jmp     TD_Exit
InitializeTheTransmitRing       endp

; ------------------------------------------------------
;
;
; ------------------------------------------------------
        public  vUpdateTallyCounter
        align   4
vUpdateTallyCounter        proc

        push    dx
        push    eax
        push    ebx

        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.TallyCounter_MPA
        in      eax, dx                         ; get NIC's tally counter value
        xor     ebx, ebx
        mov     bx, ax
        add     DriverCustomTallyMPA, ebx       ; add it's value to statistics
        shr     eax, 16
        add     DriverCustomTallyCRC, eax       ; add it's value to statistics

        pop     ebx
        pop     eax
        pop     dx
        ret

vUpdateTallyCounter     endp

; ------------------------------------------------------
;
;
; ------------------------------------------------------
        public  vKickNicToWork
vKickNicToWork  proc    near

        push    ax
        push    bx
        push    dx

        mov     bx, Ioport
        
        lea     dx, [bx].SCsrRegStruc.CommandReg
        in      ax, dx
        and     ax, not (W_CR_STOP)             ; clear STOP bit
        or      ax, W_CR_START OR W_CR_TXON OR W_CR_RXON OR W_CR_DPOLL
        out     dx, ax

        pop     dx
        pop     bx
        pop     ax
        ret

vKickNicToWork  endp

;---------------------------------------------------S
;   Added by Ben (07/11/2000)
;   ------------------------

;/*****
;
;       vMACSoftwareReset
;
;  Description:  Safely software reset.
;
;  Parameters:
;     In:
;       Global variables:
;               wCrAddress      wMISCCRAddress
;               
;       
;     Out:
;       All other registers are preserved.
;       
;     Return Value: c flag clear if succeeded;
;                           set if failed.
;
;*/
        public      vMACSoftwareReset
vMACSoftwareReset   proc    near
    
        push    ax
        push    bx
        push    cx
        push    dx
                
        mov     bx, Ioport
        ; Perform software reset to NIC:
        ;---------------------------------
        mov     ax, W_CR_SFRST          
        lea     dx, [bx].SCsrRegStruc.CommandReg
        out     dx, ax
        
        cmp     pciRevisionId, 40h
        jae     short WAIT_RESET_OK
        
WAIT_RESET_OK:                              ;3065

        mov     cx, W_MAX_TIMEOUT

WAIT_STILL:
        in      ax, dx
        test    ax, W_CR_SFRST
        jz      IF_RESET_OK
        loop    WAIT_STILL
IF_RESET_OK:
        cmp     cx, 0
        jne     RESET_OK
        
        ; Reset fail. Use Force Reset
        ;-----------------------------
        cmp     pciRevisionId, 40h
        jb      RESET_FAIL_43
        
        lea     dx, [bx].SCsrRegStruc.MISCCR
        in      ax, dx
        or      ax, 04000h                  ; FORSRST bit on
        out     dx, ax
        
RESET_FAIL_43:        
RESET_OK:  
        pop     dx
        pop     cx
        pop     bx
        pop     ax      
        ret
vMACSoftwareReset   endp

;/*****
;
;       vMACSafeRxOff
;
;  Description:  Set MAC RXOFF safely.
;
;  Parameters:
;     In:
;       Global variables:
;               wCrAddress      wNextTdesc0Address
;               
;       
;     Out:
;       All other registers are preserved.
;       
;     Return Value: c flag clear if succeeded;
;                           set if failed.
;
;*/

        public  vMACSafeRxOff
vMACSafeRxOff   proc    near
        
        push    edx
        push    eax
        push    ebx
        push    ecx
        
        mov     bl, 01h                     ; Internal LoopBack
        call    vMACSetLoopbackMode
        
        xor     ax, ax
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.CommandReg
        in      ax, dx
        and     ax, not W_CR_RXON           ; Trun off RXON
        out     dx, ax   
        
        
        mov     cx, W_MAX_TIMEOUT
WAIT_RXON_OFF:        
        in      ax, dx
        
        test    ax, W_CR_RXON
        jz      WAIT_END
        loop    WAIT_RXON_OFF
        
WAIT_END:
        cmp     cx, 0
        jne     RXON_OFF_OK
        
        
        cmp     pciRevisionId, 40h
        jb      short RXON_OFF_FAIL_43
        
        ; Enter FIFO test mode to issue RX reject
        ;-----------------------------------------
        lea     dx, [bx].SCsrRegStruc.NextTdesc1
        in      ax, dx                      ; Get GFTEST
        or      ax, 0001h                   ; FIFOTEST ON
        out     dx, ax

        in      ax, dx                      ; Get GFTEST
        or      ax, 0800h                   ; XREJT ON
        out     dx, ax
        
        in      ax, dx                      ; Get GFTEST
        and     ax, not 0001h               ; FIFOTEST OFF
        out     dx, ax
        clc
        jmp     RXON_OFF_OK
        
RXON_OFF_FAIL_43 :
        stc        
RXON_OFF_OK :
        xor     bx, bx                      ; Normal
        call    vMACSetLoopbackMode
        
        pop     ecx
        pop     ebx
        pop     eax
        pop     edx
        ret
        
vMACSafeRxOff   endp


;/*****
;
;       vMACSetLoopbackMode
;
;  Description:  Set NIC turn to loopback or normal mode.
;
;  Parameters:
;     In:
;       Global variables:
;               wTcrAddress
;       bx :    00 -> Normal                10 -> ENDEC loopback for 10baseT
;               01 -> Internal loopback     11 -> 223 loopback
;
;     Out:
;       All other registers are preserved.
;       
;     
;
;*/
vMACSetLoopbackMode    proc    near

        push    dx
        push    ax
        push    si
        pushf
        
        mov     si, Ioport
        lea     dx, [si].SCsrRegStruc.TXCR
        cmp     bl, 01h
        je      INTERNAL_LB
        cmp     bl, 10h
        je      ENDEC_LB
        cmp     bl, 11h
        je      _223_LB
        
NORMAL_LB:        
        in      al, dx
        and     al, 0f9h
        out     dx, al
        jmp     SET_OK
        
INTERNAL_LB :
        in      al, dx
        or      al, BY_TCR_LB0
        out     dx, al
        jmp     SET_OK
ENDEC_LB :
        in      al, dx
        or      al, BY_TCR_LB1
        out     dx, al
        jmp     SET_OK                
_223_LB :
        in      al, dx
        or      al, (BY_TCR_LB0 or BY_TCR_LB1)
        out     dx, al
        
SET_OK :
        popf      
        pop     si  
        pop     ax
        pop     dx
        ret

vMACSetLoopbackMode    endp
;---------------------------------------------------E

;---------------------------------------------------S
;   Added by Ben (08/06/2001)
;   ------------------------
;/*******************************************************************
;
;       vSetFlowCTL
;
;  Description:  
;
;       Flow control registers setting for VT3106 only
;       Must be called before RXON
; -------------------------------------------------------------------
;  Parameters:
;   IN:
;       dbUpdatRBRDU : 1->update RBRDU
;                      0->no update RBRDU
;       wFLOWCTLFlag : 1->Enable PAUSET bit in ANAR of PHY
;                      0->Disable PAUSET bit in ANAR of PHY
;                      2->Hardware Default
;/*******************************************************************
vSetFlowCTL     proc    near
        push    ax
        push    bx
        push    cx
        push    dx

        ; -----------------------------------------------------------------
        ;
        ; Set PHY's ANAR's PAUSE bit according user setting.
        ;
        ; -----------------------------------------------------------------
        ; add by Ben (2001/09/13), for support FLOW_CONTROL keyword action.
        ; Set PAUSET bit in ANAR (PHY) on or off. (VT3065 or VT3106)
        ; ------------------------------------------------------------------\        
        mov     byMIIIndex, MII_REG_ANAR
        mov     wMIIValue, W_ANAR_ASMFLC

        cmp     wFLOWCTLFlag, 2             ; FLOW_CONTROL=HARDWARE_DEFAULT
        je      FlowCtlHDefault

        mov     cx, wFLOWCTLFlag            ; CX=wFLOWCTLFlag=0 or 1
        cmp     cx, 0
        jne     @@TurnOnIt
        call    MIITurnOffBits
        jmp     @SetFlowOptOver
@@TurnOnIt:
        call    MIITurnOnBits

@SetFlowOptOver:
        mov     ax, cx
        shl     ax, 1
        jmp     SetLocalFLOWCTL
FlowCtlHDefault:
        ; ------------------------------------------------------------------/
        cmp     pciRevisionId, 40h          ; VT3043 doesn't support flow control
        jb      FlowCTLSetDone 

        ; ---------------------------------------------------
        ;
        ;       Set Full(HALF)-Duplex flow control
        ;
        ; ---------------------------------------------------
FDUPLEX_FLOWCTL:     
        mov     ax, 0                       ; AX=0->read local flow control ability   
        call    vReadFCTL                   ; AX=PHYANAR (95h) or PHY's ANAR-(VT3106)
                                            ; AX=PHY's ANAR-(VT3065)
        push    ax
        mov     ax, 1                       ; AX=1->read remote flow control ability
        call    vReadFCTL                   ; AX=MIISR (6dh)-(VT3106)
                                            ; AX=ANLPAR-(VT3065)
        mov     cx, ax                      ; CX=Remote flow control ability
        pop     ax                          ; AX=local control ability
        
        call    vGetMappedLFCTL             ; AX=0 -> Disable PAUSE TX, Disable PAUSE RX
                                            ;    1 -> Enable PAUSE TX, Disable PAUSE RX
                                            ;    2 -> Enable PAUSE TX, Enable PAUSE RX
                                            ;    3 -> Disable PAUSE TX, Enable PAUSE RX

;-------------------------------
; added by guard(2003/11/26)
;------------------------------
SetLocalFLOWCTL:
        call    vSetLFCTL                   ; set local flow control ability
                
        ; ---------------------------------------------------
        ;
        ;       Enable XON/OFF (AX=FlowCR0+FlowCR1)
        ;                   VT3106 only
        ;               Initial state only
        ; ---------------------------------------------------
        cmp     dbUpdatRBRDU, 1             ; 1-> from initial state
        jne     FlowCTLSetDone
        
        cmp     pciRevisionId, 80h
        jb      FlowCTLSetDone
        
        ; add by Ben (2001/08/14), coz we only have small rx buffers,
        ; so we use another way to set up flow control :
        ;   1. [XLTH1,XLTH0]=[0,0]
        ;   2. XONEN is off
        ;   3. TxPauseT = 0xff
        ; -------------------------------------------------------------
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.FLOWCR0
        in      ax, dx
        and     ax, not W_FLOWCR1_XONEN     ; disable XON/OFF
        mov     al, BYTE PTR wRxNumBuffers  ; Set Rx Residue Buffers
        or      ax, W_TXPF_LTH_4            ; Set Tx pause frame threshold
        out     dx, ax                      ; Write FlowCR0 FlowCR1
        
        ; Set TX pause timer to 0xffff in XONEN=1
        ; ----------------------------------------
        lea     dx, [bx].SCsrRegStruc.TXPAUSET
        mov     ax, W_TXPAUSET_DEFAULT
        out     dx, ax                      ; default tx pause timer = 0xff
        
FlowCTLSetDone:
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
vSetFlowCTL     endp

; ---------------------------------------------------------------- 
; Function to get the mapped local flow control ability.
; Called after calling vReadLFCTL() & vReadRFCTL(), and then to get
; the local flow control ability.
; IN:
;   AX=Local flow control ability
;       In VT3065 : PHY's ANAR (needs to shift right 5 bits for PHYANAR)
;       In VT3106 : PHY's ANAR (needs to shift right 5 bits) or
;                   MAC's PHYANAR(95h) if ANAREN bit is on
;   CX=Remote flow control ability
;       In VT3065 : PHY's ANLPAR (needs to shift 5 bits for MIISR)
;       In VT3106 : MAC's MIISR(6dh)
; OUT:
;   AX=0 -> Disable PAUSE TX, Disable PAUSE RX
;      1 -> Enable PAUSE TX, Disable PAUSE RX
;      2 -> Enable PAUSE TX, Enable PAUSE RX
;      3 -> Disable PAUSE TX, Enable PAUSE RX
; ----------------------------------------------------------------
vGetMappedLFCTL proc    near
        cmp     AutoFlag, 1
        je      AUTOModeSetting
        
        ; ---------------------------------------------------\
        ;       FORCE Mode settings for flow control 
        ;       (disable full-duplex flow control)
        ; ---------------------------------------------------/
        jmp     DisTX_RX1
        
        ; ---------------------------------------------------\
        ;       AUTO Mode settings for flow control
        ; ---------------------------------------------------/
AUTOModeSetting:
        and     ax, cx              ; ax=[ASM:FLOWC]=[Bit6:Bit5]=00, 01, 10 or 11
        
        test    ax, 0040h           ; if ax=[ASM:FLOWC]=[Bit6:Bit5]=[1:x]?
        jnz     aaaa
        
        test    ax, 0020h           ; if ax=[ASM:FLOWC]=[Bit6:Bit5]=[0:1]?
        jz      DisTX_RX1           ; ax=[ASM:FLOWC]=[Bit6:Bit5]=[0:0]
        
        test    cx, 0020h           ; if cx=[ASM:FLOWC]=[Bit6:Bit5]=[1:x]?
                                    ; when ax=[ASM:FLOWC]=[Bit6:Bit5]=[0:1]
        jz      EnRX_DisTX1         ; cx=[ASM:FLOWC]=[Bit6:Bit5]=[0:x]
        jmp     EnTX_RX1            ; cx=[ASM:FLOWC]=[Bit6:Bit5]=[1:x]
        
aaaa:                               ; ax=[ASM:FLOWC]=[Bit6:Bit5]=[1:x]
        test    ax, 0020h           ; if ax=[ASM:FLOWC]=[Bit6:Bit5]=[1:1]?
        jnz     EnTX_RX1            ; ax=[ASM:FLOWC]=[Bit6:Bit5]=[1:1]
        
        test    cx, 0020h           ; if cx=[ASM:FLOWC]=[Bit6:Bit5]=[x:1]?
                                    ; when ax=[ASM:FLOWC]=[Bit6:Bit5]=[1:0]
        jz      DisTX_RX1           ; cx=[ASM:FLOWC]=[Bit6:Bit5]=[x:0]
        jmp     EnTX_DisRX1         ; cx=[ASM:FLOWC]=[Bit6:Bit5]=[x:1]
        
        ;   AX=0 -> Disable PAUSE TX, Disable PAUSE RX
        ;      1 -> Enable PAUSE TX, Disable PAUSE RX
        ;      2 -> Enable PAUSE TX, Enable PAUSE RX
        ;      3 -> Disable PAUSE TX, Enable PAUSE RX
        ; ---------------------------------------------
EnTX_DisRX1:
        mov     ax, 1
        jmp     GetMappedLFCTLDone
        
EnTX_RX1:
        mov     ax, 2
        jmp     GetMappedLFCTLDone
        
DisTX_RX1:
        mov     ax, 0
        jmp     GetMappedLFCTLDone
        
EnRX_DisTX1:
        mov     ax, 3
GetMappedLFCTLDone:
        ret        
vGetMappedLFCTL endp

; ---------------------------------------------------------------- 
; Function to set Local Flow control ability
; -- > PHYANAR(MAC's 95h) or PHY's ANAR (VT3065)
; IN:
;   AX=0 -> Disable PAUSE TX, Disable PAUSE RX
;      1 -> Enable PAUSE TX, Disable PAUSE RX
;      2 -> Enable PAUSE TX, Enable PAUSE RX
;      3 -> Disable PAUSE TX, Enable PAUSE RX
;   -----------------------------------------
;       In VT3065 : set MAC's MISCCR(80h)
;       In VT3106 : set MAC's FLOWCR1(99h)
; OUT:
;   NONE
; ----------------------------------------------------------------
vSetLFCTL       proc    near
        push    dx
        push    cx
        push    bx
        push    si
        
        mov     bx, ax                      ; bX=AX=parameter
        
        mov     si, Ioport
        
        cmp     pciRevisionId, 80h
        jae     PrePare_FLOWCR1
        
        lea     dx, [si].SCsrRegStruc.MISCCR 
        in      ax, dx                      ; AX=MISCCR
        jmp     aaaa1
        
PrePare_FLOWCR1:
        lea     dx, [si].SCsrRegStruc.FLOWCR0
        in      ax, dx                      ; AX=FLOWCR0+FLOWCR1
        
aaaa1:  
        xor     cx, cx
        cmp     bx, 0
        je      Dis_TX_RX
        
        cmp     bx, 1
        je      EnTX_DisRX
        
        cmp     bx, 2
        je      EnTX_RX
        
        cmp     bx, 3
        je      EnRX_DisTX
        jmp     Dis_TX_RX                   ; default
        
        ; -------------------------
Dis_TX_RX:
        ;mov     cx, W_FLOWCR1_HDXFCEN
        mov     cx, 0
        jmp     aaaa2
        
        ; -------------------------
EnTX_DisRX:
        ;mov     cx, W_FLOWCR1_FDXTFCEN OR W_FLOWCR1_HDXFCEN
        mov     cx, W_FLOWCR1_FDXTFCEN
        jmp     aaaa2
        
        ; ------------------------
EnRX_DisTX:
        ;mov     cx, W_FLOWCR1_FDXRFCEN OR W_FLOWCR1_HDXFCEN
        mov     cx, W_FLOWCR1_FDXRFCEN
        jmp     aaaa2

        ; ------------------------
EnTX_RX:
        ;mov     cx, W_FLOWCR1_FDXRFCEN OR W_FLOWCR1_FDXTFCEN OR W_FLOWCR1_HDXFCEN
        mov     cx, W_FLOWCR1_FDXRFCEN OR W_FLOWCR1_FDXTFCEN
        
aaaa2:
        cmp     pciRevisionId, 80h
        jae     aaaa3
        
        shr     cx, 6
        and     cx, 0ffefh
        and     ax, 0fff3h                  ; mask off [FDXREN:HDXFEN]=[3:2]=[0:0]
        or      ax, cx                      ; mask on [FDXREN:HDXFEN]
        out     dx, ax
        jmp     SetLFCTLDone
        
aaaa3:
        and     ax, 0f8ffh                  ; mask off [FDXTEN:FDXREN:HDXFEN]
                                            ;          [Bit2:Bit1:Bit0] in FLOWCR1
        or      ax, cx                      ; mask on [FDXTEN:FDXREN:HDXFEN]
        
        ; by Ben (2003/02/01), Only set FlowCR1 with AL
        ; -----------------------------------------------
        inc     dx                          
        mov     al, ah
        out     dx, al
        
SetLFCTLDone:
        pop     si
        pop     bx
        pop     cx
        pop     dx        
        ret
vSetLFCTL       endp

; ---------------------------------------------------------------- 
; Function to read Local Flow control ability
; -- > PHYANAR(MAC's 95h) or PHY's ANAR (VT3065)
; IN:
;   AX=0 -> read local flow control ability
;     =1 -> read remote flow control ability
; OUT:
;   AX=PHYANAR or PHY's ANAR
;       -------------------------------------
;   AX= | Bit7 | Bit6 | Bit5 | ....
;       -------------------------------------
;        ANREN  ASMFLC  FLOWC  ...
; ----------------------------------------------------------------
vReadFCTL      proc    near
        push    bx
        push    dx
        
        cmp     pciRevisionId, 80h
        jb      VT3065_READFCTL

        mov     bx, Ioport
        
        ;       VT3106 - read flow control ability
        ; --------------------------------------------------
        cmp     ax, 0
        je      read_localfctl1
        
        ;       read remote flow control ability
        ; --------------------------------------------------
        lea     dx, [bx].SCsrRegStruc.MIISR
        in      ax, dx                  ; AX=MIISR
        jmp     ReadFCTLDone
        
        ;       read local flow control ability
        ; --------------------------------------------------
read_localfctl1:
        ; Test if ANAREN is on in PHYANAR (95h) (for VT3106)
        ; --------------------------------------------------
        lea     dx, [bx].SCsrRegStruc.PHYANAR
        in      ax, dx                  ; AX=PHY's ANAR
        test    ax, W_ANAR_ANAREN       ; Bit7
        jz      READ_ANAR
        jmp     ReadFCTLDone
        
        
        ;       VT3065 - read flow control ability
        ; --------------------------------------------------
VT3065_READFCTL:        
        cmp     ax, 0
        je      read_localfctl
        
        ;       read remote flow control ability
        ; --------------------------------------------------
        mov     byMIIIndex, MII_REG_ANLPAR  ; offset 05 (ANLPAR)
        call    MIIRead                     ; AX=ANLPAR's value
        shr     ax, 5                       ; map to MIISR bit arrangements
        jmp     ReadFCTLDone
                
        ;       read local flow control ability
        ; --------------------------------------------------
read_localfctl:
READ_ANAR:
        mov     byMIIIndex, MII_REG_ANAR    ; offset 04 (ANAR)
        call    MIIRead                     ; AX=ANAR's value
        shr     ax, 5                       ; map to PHYANAR(95h) bit arrangements
        
ReadFCTLDone:
        pop     dx
        pop     bx
        ret
vReadFCTL      endp

; ---------------------------------------------------------------- 
; Function to add CAM entry                                         */
; Entry:                                                            */
;   CH : Set for VID, otherwise for multicast address               */
;   CL : 1 ~ 32, total 32 entries, no matter VID or MUL             */
;   SI : Pointer to entry data                                      */
;     |                VID : Bit0~Bit12                             */
;     |                      _______________________                */
;     |--------------------->| [7:0] | [11:8] | ....                */
;     |                      -----------------------                */
;     |                        MAR6     MAR7                        */
;     |                                                             */
;     |                MAR : Bit0~Bit47                             */
;     |                      _______________________________        */
;     |--------------------->| [7:0] | [15:8] |...| [47:40] |       */
;                            -------------------------------        */
;                              MAR0     MAR1   ...    MAR5          */
; Return:                                                           */
;   Carry Flag : Set if success, otherwise failed                   */
; ---------------------------------------------------------------- 
vAddCAMEntry    proc    near
        push    bx
        push    cx
        push    dx
        push    si
        push    ax

        ; set CAM related bits
        ; ------------------------
        call    vSetCAMCtlRegs              ; Entry:
                                            ;   CH : 0
                                            ;   CL : 0 ~ 31, entry index
                                            ; Ret:
                                            ;   No
        
        mov     bx, Ioport                                            
        ; write byte value into CAM via data port                                    
        ; If write to VCAM, then access MAR6~7
        ; If write to MCAM, then access MAR0~5
        ; ----------------------------------------
        lea     dx, [bx].SCsrRegStruc.MAR0
        
        cmp     ch, 1
        je      WriteVCAM
        
        ; Write to MCAM
        ; ----------------------------------------
        mov     cx, 6                       ; MCAM has max 6 data ports
        jmp     WriteDataPortLoop
        
        ; Write to VCAM
        ; ----------------------------------------
WriteVCAM:
        mov     cx, 2                       ; VCAM has max 2 data ports
        add     dx, 6                       ; DX=MAR6
        jmp     WriteDataPortLoop
        
WriteDataPortLoop: 
        mov     al, byte ptr [si]       
        out     dx, al                      ; write to data port
        inc     si                          ; next data to write
        inc     dx                          ; next data port
        loop    WriteDataPortLoop


        ; Set write command
        ; ------------------------------
        lea     dx, [bx].SCsrRegStruc.CAMCR
        in      al, dx
        or      al, BY_CAMC_CAMWR
        out     dx, al

        ; CAM access will be slow in 10Mbps mode
        ; delayed 2 micro-seconds to guarantee 
        ; correct CAM access 
        ; ---------------------------------------
        mov     ax, 2
        call    MACmicroDelay2              ; Delay 2 us
                
        stc                                 ; notify write success
        jmp     AddCAMEntryDone
        
AddCAMEntryErr:
        clc                                 ; notify write failed
        jmp     AddCAMEntryDone
        
AddCAMEntryDone:  
        pop     ax      
        pop     si
        pop     dx
        pop     cx
        pop     bx
        ret        
vAddCAMEntry    endp
if 0
; ---------------------------------------------------------------- 
; Function to read CAM entry                                        */
; Entry:                                                            */
;   CH : Set for VID, otherwise for multicast address               */
;   CL : 1 ~ 32, total 32 entries, no matter VID or MUL             */
;   SI : Pointer to entry data                                      */
;     |                VID : Bit0~Bit12                             */
;     |                      _______________________                */
;     |--------------------->| [7:0] | [11:8] | ....                */
;     |                      -----------------------                */
;     |                        MAR6     MAR7                        */
;     |                                                             */
;     |                MAR : Bit0~Bit47                             */
;     |                      _______________________________        */
;     |--------------------->| [7:0] | [15:8] |...| [47:40] |       */
;                            -------------------------------        */
;                              MAR0     MAR1   ...    MAR5          */
; Return:                                                           */
;   Carry Flag : Set if success, otherwise failed                   */
; ---------------------------------------------------------------- 
vReadCAMEntry   proc    near
        push    cx
        push    dx
        push    si
        push    ax
        
        ; max entry size is 32
        ; ----------------------------
        cmp     cl, BY_MAX_CAM_ENTRY
        jge     ReadCAMEntryErr
        
        ; set CAM related bits
        ; ------------------------
        call    vSetCAMCtlRegs              ; Entry:
                                            ;   CH : 0
                                            ;   CL : 0 ~ 31, entry index
                                            ; Ret:
                                            ;   No
        
        ; Set read command
        ; ------------------------------
        mov     dx, wCAMCAddress            ; [92h]
        in      ax, dx
        or      ax, BY_CAMC_CAMRD
        out     dx, ax
                                 
        ; CAM access will be slow in 10Mbps mode
        ; delayed 2 micro-seconds to guarantee 
        ; correct CAM access 
        ; ---------------------------------------
        mov     ax, 2
        call    MACmicroDelay2              ; Delay 2 us
        
        ; read byte value from CAM via data port
        ; ----------------------------------------
        mov     dx, wMar0Address            ; DX=data port address
        
        cmp     ch, 1
        je      ReadVCAM
        
        ; Read from MCAM
        ; ----------------------------------------
        mov     cx, 6                       ; MCAM has max 6 data ports
        jmp     ReadDataPortLoop
        
        ; Read from VCAM
        ; ----------------------------------------
ReadVCAM:
        mov     cx, 2                       ; VCAM has max 2 data ports
        add     dx, 6                       ; DX=MAR6
        
ReadDataPortLoop:        
        in      al, dx                      ; read from data port
        mov     byte ptr [si], al
        inc     si                          ; next data addr to save
        inc     dx                          ; next data port
        loop    ReadDataPortLoop
        
        stc                                 ; notify write success
        jmp     ReadCAMEntryDone
        
ReadCAMEntryErr:
        clc                                 ; notify write failed
        jmp     ReadCAMEntryDone
        
ReadCAMEntryDone: 
        pop     ax       
        pop     si
        pop     dx
        pop     cx
        ret        
vReadCAMEntry   endp
endif
; ----------------------------------------------------------------  */
; Function to set CAM control registers                             */
;   CH : Set for VID, otherwise for multicast address               */
;   CL : 0 ~ 31, total 32 entries, no matter VID or MUL             */
; ----------------------------------------------------------------  */
vSetCAMCtlRegs  proc    near
        push    bx
        push    cx
        push    dx
        push    ax

        mov     bx, Ioport        
        ; ---------------------------
        ; test if set VID or MAR CAM 
        ; ---------------------------
        lea     dx, [bx].SCsrRegStruc.CAMCR
        in      ax, dx
        
        cmp     ch, 1
        je      UseVCAM
        
        ; Use MCAM
        ; ----------
        and     ax, BY_CAMC_SEL_MCAM_A
        jmp     SetCAMEN
        
        ; Use VCAM
        ; ----------
UseVCAM:        
        or      ax, BY_CAMC_SEL_VCAM_O

SetCAMEN:        
        or      ax, BY_CAMC_CAMEN
        out     dx, ax
        
        ; -----------------------
        ; Set CAM entry address
        ; -----------------------
        lea     dx, [bx].SCsrRegStruc.CAMADD
        mov     al, cl                      ; AL=CL=entry
        out     dx, al

        ; -----------------------
        ; Set CAM MASK (active)
        ; -----------------------
        lea     dx, [bx].SCsrRegStruc.CAMMASK
        in      eax, dx                     ; EAX=CAM MASK
        mov     ebx, 1
        and     ecx, 001fh
        shl     ebx, cl                     ; EBX=mask bit of CAM MASK
        or      eax, ebx                    ; EAX=new CAM MASK
        and     eax, 0ffffffffh
        out     dx, eax    
        
        pop     ax
        pop     dx
        pop     cx
        pop     bx
        ret
vSetCAMCtlRegs  endp        

; ----------------------------------------------------------------  */
; Function to idetify VT3106's PHY, and set Bit0 of PHY MODE CONFIG.*/
; VT3106 or VT3072F :                                               */
;   MII Register 0x10, Bit0 should be turned on if it's in NWay     */
;   forced mode, turned off if it's in other mode.                  */
; VT3043, VT3065, VT3072E :                                         */
;   Ignore it.                                                      */
;----------------------------------------------------------         */
; PHY Register 0x03 :                                               */
;   VT3106  = 0x8F40                                                */
;   VT3072E = 0x8F20                                                */
;   VT3072F = 0x8F25                                                */
;----------------------------------------------------------         */
; It's only called in INIT/RESET procedure.                         */
; CResetNIC()->vSetPhyModeCfg()                                     */
; IN :                                                              */
;   AutoFlag                                                        */
; OUT :                                                             */
;   wOriPHYANARValue                                                */
; ----------------------------------------------------------------  */
vSetPhyModeCfg  proc    near
        push    ax
        

        ; --------------------------
        ;       VT3106 & VT3072F
        ; Set seeSd1 in PHYMODECFG
        ; --------------------------
        
        ; Read PHYIDR2 (offset 03h)
        ; Currently, if ID is not [9:4]=[110100], then don't set bit0 in PHYMDCFG
        ; ------------------------------------------------------------------------
        mov     byMIIIndex, MII_REG_PHYIDR2     ; PHYIDR2
        call    MIIRead
        
        cmp     ax, 08f40h                      ; VT3106 PHYID range : 0x8f40~4f
        jb      IfVT3072FPHY
        
        cmp     ax, 08f4fh
        ja      IfVT3072FPHY
        
        jmp     Set_seeSd1                      ; It's VT3106
      
IfVT3072FPHY:
        cmp     ax, 08f25h                      ; VT3072F PHYID range : 0x8f25~2f
        jb      vSetPhyModeCfgDone
        
        cmp     ax, 08f2fh
        ja      vSetPhyModeCfgDone              ; It's VT3072F
      
Set_seeSd1:      
        mov     al, AutoFlag
        not     al
        and     al, 01h
        
        ; Get MII reg 0x10, and set Bit0 on (VT3106 only)
        ; ------------------------------------------------------------------------
        mov     byMIIIndex, 10h
        mov     wMIIValue, 0001h
        cmp     al, 0
        jne     @TurnOnIt
        call    MIITurnOffBits
        jmp     vSetPhyModeCfgDone
@TurnOnIt:
        call    MIITurnOnBits        
vSetPhyModeCfgDone:
        pop     ax
        ret
vSetPhyModeCfg  endp

; ----------------------------------------------------------------  */
; Function to decide the PHY mode changed or not.                   */
; It's called no matter AUTO or FORCED mode.                        */
; According parameters setting and ANAR value to decide.            */
; IN:                                                               */
;   byLineSpeed, FDXFlag                                            */
; OUT:                                                              */
;   Carry Flag : Set if mode changed, otherwise, not changed        */
;   dbCurrPhyMode                                                   */
; ----------------------------------------------------------------  */
vPhyModeStatus  proc    near
        push    cx
        push    ax
     
        ; ----------------------------------------------------------
        ;   dbCurrPhyMode                                         
        ;       ------------------------------------------------- 
        ;       | PAUSE |  T4   | TX_FD |  TX   | 10_FD |  10   | 
        ;       ------------------------------------------------- 
        ;           5       4       3       2       1       0 ->Bit
        ; ----------------------------------------------------------
        call    vMapPhyModeFlag                 ; get dbCurrPhyMode

        mov     ax, wOriPHYANARValue            ; AX=original ANAR
        shr     ax, 5                           ; ANAR[8:5]=[TX_FD:TX:10_FD:10]
        and     al, 3fh                         ; 
                
        cmp     al, dbCurrPhyMode
        jne     MODEC_TRUE
        
        clc                                     ; notify the mode is the same
        jmp     PhyModeStsDone
        
MODEC_TRUE:
        stc                                     ; notify the mode is changed
                                                 
PhyModeStsDone:        
        pop     ax
        pop     cx
        
        ret        
vPhyModeStatus  endp

; ----------------------------------------------------------------  */
; Function to map current (duplex/speed) parameters to mode flag    */
; IN:                                                               */
;   AutoFlag, byLineSpeed, FDXFlag                                  */
; OUT:                                                              */
;   dbCurrPhyMode                                                   */
;       -------------------------------------------------           */
;       | PAUSE |  T4   | TX_FD |  TX   | 10_FD |  10   |           */
;       -------------------------------------------------           */
;           5       4       3       2       1       0 ->Bit         */
;           10      9       8       7       6       5 ->MII's ANAR  */
; ----------------------------------------------------------------  */
vMapPhyModeFlag proc    near
        
        ; Set Bit0~Bit3, there is only 2 conditions,
        ; all bits on or one of the 4 bits on.
        ; --------------------------------------------------------
        ; AUTO parameter setting, just map dbCurrPhyMode to be 0fh
        ; --------------------------------------------------------
        cmp     AutoFlag, 1
        je      ALL4BitsOn
        
        ; FORCE parameter setting, map dbCurrPhyMode according by byLineSpeed
        ; and FDXFlag.
        ; -------------------------------------------------------------------
        cmp     byLineSpeed, 100
        jne     LineSpeed10
        
        ; Speed=100
        ; -------------
        cmp     FDXFlag, 1
        jne     Line100_HalfDuplex
        
        ; Speed=100, Fullduplex
        ; -----------------------
        mov     dbCurrPhyMode, 08h
        jmp     SetPAUSEBit
        
        ; Speed=100, Halfduplex
        ; -----------------------
Line100_HalfDuplex:
        mov     dbCurrPhyMode, 04h
        jmp     SetPAUSEBit
        
        ; Speed=10, Halfduplex
        ; ---------------------        
Line10_HalfDuplex:
        mov     dbCurrPhyMode, 01h
        jmp     SetPAUSEBit

        ; Speed=10
        ; ---------------------        
LineSpeed10:
        cmp     FDXFlag, 1
        jne     Line10_HalfDuplex
        
        ; Speed=10, Fullduplex
        ; ----------------------
        mov     dbCurrPhyMode, 02h
        jmp     SetPAUSEBit
        
ALL4BitsOn:
        mov      dbCurrPhyMode, 0fh
        
        ; Set PAUSE bit
        ; -------------------
SetPAUSEBit:
        ; In VT3043, no matter FLOW_CONTROL keywords value is setting,
        ; we treat it as 2, hardware default
        ; ------------------------------------------------------------
        cmp     pciRevisionId, 40h
        jb      GoGetPAUSEBit
        
        cmp     wFLOWCTLFlag, 2                 ; FLOW_CONTROL=HARDWARE_DEFAULT
        je      GoGetPAUSEBit

        mov     ax, wFLOWCTLFlag                ; CX=wFLOWCTLFlag=0 or 1
        shl     ax, 5
        or      dbCurrPhyMode, al               ; Set Bit5
        jmp     MapPhyModeFlagDone
        
        ; if keyword FLOW_CONTROL=hardware_default, then
        ; we first get ANAR's PAUSE bit value, then set to 
        ; dbCurrPhyMode bit5.
        ; ---------------------------------------------------
GoGetPAUSEBit:
        mov     byMIIIndex, MII_REG_ANAR        ; ANAR
        call    MIIRead                         ; AX=ANAR's value
        and     ax, 0400h                       ; mask other bit, except Bit10
        shr     ax, 5
        or      dbCurrPhyMode, al               ; Set Bit5
                
MapPhyModeFlagDone:
        ret               
vMapPhyModeFlag endp
; ----------------------------------------------------------------  */
; Function to decide set BMCR's AUTO or REAUTO bit.                 */
; It's called no matter AUTO or FORCED mode.                        */
; And can only be called when PHY MODE is changed                   */
; IN:                                                               */
;   NONE                                                            */
; OUT:                                                              */
;   NONE                                                            */
; ----------------------------------------------------------------  */
vSetAUTO_REAUTO proc    near
        push    ax
        push    dx
        ; VT3043 : alway issue AUTO or REAUTO
        ; VT3065 or VT3106 : if ANAR is changed, then issue AUTO or REAUTO
        ; ----------------------------------------------------------------
        cmp     pciRevisionId, 40h
        jb      AlwaysSetAUTO
        
        ; read current ANAR 
        ; ---------------------------------------
        mov     byMIIIndex, MII_REG_ANAR        ; ANAR
        call    MIIRead                         ; AX=ANAR's value
        
        cmp     ax, wOriPHYANARValue            ; wOriPHYANARValue was get when called
                                                ; vSetPhyModeCfg()
        mov     wOriPHYANARValue, ax            ; update to new ANAR value
        je      ISSUE_NOTHING

        ; Issue AUTO or REAUTO
        ; If AUTO is off, just set REAUTO is invalid action.
        ; --------------------------------------------------
AlwaysSetAUTO:    

        mov     wMIIValue, BMCR_AUTO or BMCR_REAUTO        
SetMIIBMCR:        
        mov     byMIIIndex, MII_REG_BMCR
        call    MIITurnOnBits

        mov     di,offset DGROUP:ReAutoMsg
        call    PutString
        
        mov     ecx, 06h
Wait5:
        push    ecx
        mov     byMIIIndex, MII_REG_BMSR        ; Basic Mode Status Register
        call    MIIRead
        pop     ecx
        test    ax, 0020h                       ; Bit5 == Auto-Negotiatio complete
        jnz     Wait5OK
        call    intr_Delay1Second
        loop    Wait5
        
Wait5OK:
        mov     di,offset DGROUP:OKmsg
        call    PutString
        mov     di,offset DGROUP:msg_crlf
        call    PutString
        jmp     BMCRSetDone                     ; by Ben (2003/01/25)
        
        ; by Ben (2003/01/28)
        ; check if AUTO bit is on or off for making
        ; sure it's in auto mode (N-way forced)
        ; -------------------------------------------
ISSUE_NOTHING:
        mov     byMIIIndex, 00
        call    MIIRead                        ; AX=BMCR
        
        test    ax, 1000h                       ; Bit12 (AUTO)
        jnz     BMCRSetDone                     ; AUTO bit is on already
        
        mov     wMIIValue, BMCR_AUTO
        jmp     SetMIIBMCR
        
BMCRSetDone:                                    ; by Ben (2003/01/25)

        pop     dx
        pop     ax
        ret
vSetAUTO_REAUTO endp

; ----------------------------------------------------------------  */
; Function to set MII's ANAR [8:5], should be called when ANAR's    */
; value is changed.                                                 */
; IN:                                                               */
;   dbCurrPhyMode                                                   */
; OUT:                                                              */
;   NONE                                                            */
; ----------------------------------------------------------------  */
vSetMIIANAR     proc    near
        push    ax
        push    cx
        
        ; phy mode is changed, Update ANAR with new value
        ; ---------------------------------------
        ; Read ANAR
        ; ----------------
        mov     byMIIIndex, MII_REG_ANAR        ; ANAR
        call    MIIRead                         ; AX=ANAR value
        movzx   cx, dbCurrPhyMode
        shl     cx, 5
        and     ax, 0fe1fh                      ; set AX[8:5]=[0:0]
        or      ax, cx                          ; AX=new ANAR value
        
        ; Write ANAR
        ; -----------------------
        mov     byMIIIndex, MII_REG_ANAR
        mov     wMIIValue, ax
        call    MIIWrite
        
        pop     cx
        pop     ax
        ret
vSetMIIANAR     endp

; ----------------------------------------------------------------  */
; Function to set MII's BMCR Bit13(SPEED) & Bit8(FDX).              */
; This function will turn off AUTO bit                              */
; IN:                                                               */
;   FDXFlag, byLineSpeed                                          */
; OUT:                                                              */
;   NONE                                                            */
; ----------------------------------------------------------------  */
vSetMIIBMCR     proc    near
        ;----------------------------------------------------
        ; Speed mode set begin
        ;----------------------------------------------------
        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_LBK
        call    MIITurnOnBits
        call    MIIDelay
        
        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_AUTO
        call    MIITurnOffBits

        cmp     byLineSpeed, 10     ; default == 100
        jnz     LineIs100M1

        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_SPEED
        call    MIITurnOffBits
        jmp     NoUserSpeed

LineIs100M1:
        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_SPEED
        call    MIITurnOnBits

        ;----------------------------------------------------
        ; Duplex mode set begin
        ;----------------------------------------------------
NoUserSpeed:
        cmp     FDXFlag, 1
        jz      FullDuplex22        ; default HalfDuplex

        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_FDX
        call    MIITurnOffBits
        jmp     DuplexEnd
        
FullDuplex22:
        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_FDX
        call    MIITurnOnBits
        
DuplexEnd:
        ; ------------------------
        ; added by guard (2003/07/05)
        ; if the driver is be forced to legacy mode,
        ; it should be delay a minute (default 1s)
        ; ------------------------------
        cmp     dbLegacyForcedMode, 0
        je      TurnOffLookback
        mov     ax, 1000
        call    MACminiDelay2  

TurnOffLookback:
        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_LBK
        call    MIITurnOffBits
        ret
vSetMIIBMCR     endp


;---------------------------------------------------E

; ---------------------------------------------------------
; Function to set mini-sec delay. 
; IN :
;   AX : number of mini-sec to delay
; OUT:
;   NONE
; ---------------------------------------------------------
MACminiDelay2   proc
        cmp     pciRevisionId, RevisionID3065
        jb      VT3043_Timer
        
        ; -----------------------------
        ;   VT3065 or VT3106 timer set
        ; -----------------------------
        push    ax                              ; save DX
        push    bx                              ; save AX
        push    dx

        mov     bx, Ioport

        ; Set Timer0 value
        ; -----------------------------
        lea     dx, [bx].SCsrRegStruc.Timer0
        out     dx, ax

        ; Get MISCCR reg
        ; -----------------------------
        lea     dx, [bx].SCsrRegStruc.MISCCR
        in      ax, dx                          ; AX=MISCCR value
        
        cmp     pciRevisionId, RevisionID3106J
        jb      SetTM0USDone
        
        ; VT3106J & VT3106S need to set TM0US bit off
        ; ---------------------------------------------
        and     ax, 0ffdfh                      ; Bit5=TM0US
        
SetTM0USDone:        
        or      ax, 0001h                       ; Timer0En = 1
        and     ax, 0fffdh                      ; Timer0Suspend = 0
        out     dx, ax                          ; write MISCCR reg
        
        ; Wait TM0SUSP bit on 
        ; ------------------------
WaitingTimer02:
        in      ax, dx                          ; DX=MISCCR reg
        test    ax, 0002h
        jnz     Timer0Out2
        jmp     WaitingTimer02
        
Timer0Out2:
        pop     dx                              ; restore AX
        pop     bx                              ; restore DX
        pop     ax
        jmp     MiniDelayDone
        
        ; ---------------------
        ;   VT3043 timer set
        ; ---------------------
VT3043_Timer:
        call    MIIDelay
        call    MIIDelay
        call    MIIDelay
        
MiniDelayDone:
        ret
MACminiDelay2   endp

; ---------------------------------------------------------
; Function to set micro-sec delay. 
; IN :
;   AX : number of micro-sec to delay
; OUT:
;   NONE
; ---------------------------------------------------------
MACmicroDelay2  proc
        cmp     pciRevisionId, RevisionID3106J
        jb      VT3065_43_Timer
        
        ; -----------------------------
        ;   VT3106 timer set
        ; -----------------------------
        push    ax                              ; save DX
        push    bx                              ; save AX
        push    dx

        mov     bx, Ioport
        ; Set Timer0 value
        ; -----------------------------
        lea     dx, [bx].SCsrRegStruc.Timer0
        out     dx, ax

        ; Get MISCCR reg
        ; -----------------------------
        lea     dx, [bx].SCsrRegStruc.MISCCR
        in      ax, dx                          ; AX=MISCCR value
        or      ax, 0020h                       ; Bit5=TM0US=1
        or      ax, 0001h                       ; Timer0En = 1
        and     ax, 0fffdh                      ; Timer0Suspend = 0
        out     dx, ax                          ; write MISCCR reg
        
        ; Wait TM0SUSP bit on 
        ; ------------------------
WaitingTimer01:
        in      ax, dx                          ; DX=MISCCR reg
        test    ax, 0002h
        jnz     Timer0Out1
        jmp     WaitingTimer01
        
Timer0Out1:
        pop     dx                              ; restore AX
        pop     bx                              ; restore DX
        pop     ax
        jmp     MicroDelayDone
        
        ; ---------------------
        ;   VT3043 or VT3065 timer set
        ; ---------------------
VT3065_43_Timer:
MicroDelayDone:
        ret
MACmicroDelay2  endp

;---------------------------------------------------S
;   Added by Ben (01/18/2001)
;   ------------------------

;/*******************************************************************
;
;       vChkLTSAPOK
;
;  Description:  
;
;       The MAC accepts IEEE 802.3 frames/IEEE 802.3 SNAP frmaes
;   with incorrect packet length value in L/T field. This is not
;   conforming to IEEE 802.3 spec.
; -------------------------------------------------------------------
;  Parameters:
;   [In]:
;       ds - DGroup
;       es - ds
;       bx - current RX descriptor (pdescRxRead) &  owned by host
;       bp - frame length field in RX descriptor
;               
;   [Out]:
;       All other registers are preserved.
;       
;   [Return Value]:
;       C flag clear if drop; Set if save this packet.
;
;   [Call]:
;       vPacketReceived
;
; -------------------------------------------------------------------
; Algorithm :
;
;   //Variable FrameSize is from Rx length in RDES0
;   wActualLen = FrameSize - Header_Len - CRC_LEN
;   pwTmp = the address of receive buffer of current descriptor
;   wLen = *(pwTmp + 6)         ; L/T field in the incoming packet
;   wSAP = *(pwTmp + 7)         ; the next word of L/T field
;
;   //if the frame length >= 46 & <= 1500
;   //and this is IEEE/802.3/IEEE 802.3 SNAP frame (exclude Novell's
;   //Ethernet 802.3 frame), but frame length field is inconsistent
;   //with actual frame length, then drop it!!!
;
;   ---------------------------------------------------
;   | Preamble |   DA   |   SA   |L/T|     Data     | ....
;   ---------------------------------------------------
;       8           6        6     2                (byte)
;
;/*******************************************************************
vChkLTSAPOK     proc    near

        ; ---------------------------------------\
        ; !!!! This part is done in INTR.ASM
        ; ---------------------------------------/
IF 0
        ;pusha
        ;pushf
        PUSHR   eax,ebx,ecx,edx,esi,edi,es,ds,ebp

        mov     ax, bp                  ; AX = Incoming Frame Size
        sub     ax, 14                  ; AX = Actual Frame Size (CRC had been cut)
                                        ;   (without :
                                        ;       DA = SA = 6 bytes
                                        ;       CRC = 4 bytes,
                                        ;       TYPE = 2 bytes)

        ;mov     es, [bx].pRxResourceSeg ; save Rx segment to es                                             
        lea     si, [bx].SRxDescStruc.abyRxBuffer
        mov     ch, es:[si + 12]        ; get L/T field of incoming pkt
        mov     cl, es:[si + 13]
        mov     dh, es:[si + 14]        ; get next word of L/T field
        mov     dl, es:[si + 15]
  
        ; if frame length is >= 46 and <= 1500
        ; -----------------------------------
        cmp     cx, 46                  ; CX=L/T field
        jb      NoDropThisPKT           ; <46, no drop
        
        cmp     cx, 1500                ; CX = L/T field
        ja      NoDropThisPKT           ; >1500, no drop
        
        ; and this is IEEE 802.3/IEEE 802.3 SNAP frame (exclude
        ; Novell's Ethernet 802.3 frame), but frame length field is 
        ; inconsistent with actual frame length, then drop it!
        ; -----------------------------------------------------
        cmp     dx, 0FFFFh              ; DX=next word of L/T field
        je      NoDropThisPKT           ; if exclude Novell's Ethernet
                                        ; 802.3 frame, continue check.
                                        
        cmp     cx, ax                  ; CX=L/T, AX=actual frame size
        je      NoDropThisPKT           ; Not Novell's header, but
                                        ; frame length field (L/T)
                                        ; <> actual frame length. Drop.
        ; Drop this packet
        ; --------------------------
        clc                             ; notify "DROP"
        jmp     CheckDoneWithLT                                        
        
NoDropThisPKT:
        stc                             ; notify "NO DROP"        
        
CheckDoneWithLT:
        POPR    eax,ebx,ecx,edx,esi,edi,es,ds,ebp
ENDIF        
        ret        
vChkLTSAPOK     endp        
;---------------------------------------------------S

;/**************************************************
;
;       vIsOurInterrupt
;
;  Description:  Test our MAC to see if it's our interrupt.
;
;  Parameters:
;     In:
;       Global variables:
;               wIsrAddress wImrShadow
;       
;     Out:
;       All other registers are preserved.
;       AX : 0  -> Not our interrupt
;            1  -> Our interrupt
;***************************************************/
if 0
public          vIsOurInterrupt
vIsOurInterrupt    proc    near

        push    dx
        
        mov     dx, es:wIsrAddress          ; Get Interrupt Status word
        in      ax, dx
        test    ax, es:wImrShadow           ; Check if we want this
        jz      Not_Our_ISR
        mov     ax, 1                       ; return OUR Interrupt flag
        ret
Not_Our_ISR:
        mov     ax, 0                       ; return Not Our Interrupt flag
        ret
vIsOurInterrupt     endp
endif

SetIRQ          proc    near

        mov     dx,IMRPort
        in      al,dx

        slow
        slow
        slow

        and     al,enableMask
        out     dx,al

        slow

        cmp     dx, INT_2IMR
        jne     @F

        mov     dx, INT_1IMR
        in      al,dx

        slow

        test    al, 04h
        jz      @F

        and     al, not 4
        out     dx,al

@@:


       mov     dx,IMRPort
       in      al,dx
       slow
       slow
       slow
       and     al,enableMask
       out     dx,al

       cmp     dx, 21h
       je      @F

       mov     dx, 21h
       in      al,dx

       test    al, 4
       jz      @F

       xor     al, 4
       slow
       out     dx,al
@@:

        push    bx
        mov     bx, Ioport
        mov     ax, wImrShadow
        lea     dx, [bx].SCsrRegStruc.IMR0
        out     dx, ax
        pop     bx


        ret
SetIRQ          endp


; ** FindAddressInMCTabel
;
;  Input :   ax, bx, di the destination multicast address
;
;
;
;  output: Z flag       1  has found the multicast
;
;                       SI = is the offset which match the destination in
;                            the multicast list
;
;                       0  can not find
;
;  resgiter: cx, dx, si has been destroied
;
;
;
                        public  FindAddressInMCTable
FindAddressInMCTable    proc    near

        mov     cx,multilist.ma_cur
        jcxz    NotExistInMCTable

        xor     si,si

FindAddLoop:
        cmp     ax,word ptr multilist.ma_mbuff[si]
        jne     @F

        cmp     bx,word ptr multilist.ma_mbuff[si+2]
        jne     @F

        cmp     di,word ptr multilist.ma_mbuff[si+4]
        je      FoundTheAddressInMC
@@:
        add     si,10h
        loop    FindAddLoop

NotExistInMCTable:
        or      dl, 1
        ret

FoundTheAddressInMC:
        xor     dl, dl
        ret

FindAddressInMCTable    endp





IFDEF   NE2000
        public  ERTInit
ERTInit         proc    near

        mov     bp,Ioport
        lea     dx, [bp].NICCommand
        mov     al, 21h   ;0120          ;
        out     dx, al
        push    dx                              ;SAve IO Base
        cli
        add     dx, NICRemoteByteCountLow       ; configuration register A
        in      al, dx                          ; set diagnostic bit
        push    ax
        push    dx
        or      al, 80h
        out     dx, al
        in      al, dx

        add     dx, 19h - 0ah                   ; diagnostic register
        in      al, dx                          ; set early interrupt bit
   IFDEF  def16bit
        and     al, not 02h    ; not dword mode
   ELSE
        or      al, 02h        ; dword mode
   ENDIF

        cmp     ERFlag, 1
        jne     er1
        or      al, 08h
        jmp     er2
 er1:
        and     al, 0f7h
 er2:
        cmp     ETFlag, 1
        jne     et1
        or      al, 01h
        jmp     et2
 et1:
        and     al, 0feh
 et2:

        cmp     FDXFlag, 1
        jne     fdx1
        or      al, 40h
        jmp     fdx2
 fdx1:
        and     al, 0bfh
 fdx2:

        out     dx, al
        pop     dx
        pop     ax
        out     dx, al
        in      al, dx

        pop     dx

        ret

ERTInit         endp
ENDIF


;------ TickHandler ---------------------------------------------------------;
;                                                                            ;
;       Timer Tick Handler for DOS                                           ;
;                                                                            ;
;       Just increments a global counter of ticks, used by RqClearStats.     ;
;                                                                            ;
;----------------------------------------------------------------------------;

IFDEF ANYSTATS
IFDEF DOS
TickHandler     proc    far
                add     cs:timerCount.loword,1
                adc     cs:timerCount.hiword,0
                jmp     cs:timerChain
TickHandler     endp
ENDIF
ENDIF

                public  print_char

;       bh = row, bl = col
;       al = char

print_char      proc    near
        pushf
        push    dx
        push    es
        mov     dx, 0b000h
        mov     es, dx
        push    ax
        mov     al, 160
        mul     bh
        shl     bl, 1
        add     al, bl
        adc     ah, 0
        mov     bx, ax
        pop     ax
        mov     byte ptr es:[bx], al
        mov     byte ptr es:[bx+1], 07h

        pop     es
        pop     dx
        popf
        ret
print_char      endp

_dis     proc    near
        pushf
        cli
        push    es
        push    ds
        push    si
        push    bx
        push    cx

        push    ax
        lea     si,line
        add     si,di
        mov     al,byte ptr cs:[si]
        mov     ah,al
        inc     al
        and     al,0fh
        mov     byte ptr cs:[si],al
        mov     al,ah
        xor     ah,ah
        add     ax,4
        mul     byte ptr cs:chars

        lea     si, position
        add     si,di
        add     si,di
        mov     si,cs:[si]
        add     si,ax

        inc     word ptr cs:seq_num
        mov     ax,word ptr cs:seq_num
        call    dis_ax
        pop     ax

        mov     byte ptr es:[si],20h
        inc     si
        inc     si
        call    dis_ax

        pop     cx
        pop     bx
        pop     si
        pop     ds
        pop     es
        popf
        ret
_dis     endp

chars           db      80*2

seq_num         dw      0

position        dw      0
                dw      20
                dw      40
                dw      60
                dw      80
                dw      100
                dw      120
                dw      140

line            db      8       dup(?)


dis_ax  proc    near
        mov     bx,ax
        mov     ax,0b000h
        mov     ds,ax
        mov     ax,0b800h
        mov     es,ax
        mov     ax,bx
        mov     cl,4
        shr     ah,cl
        add     ah,30h
        cmp     ah,3ah
        jc      number_1
        add     ah,7
number_1:
        ;mov     [si],ah
        mov     es:[si],ah
        inc     si
        inc     si

        mov     ah,bh
        and     ah,0fh
        add     ah,30h
        cmp     ah,3ah
        jc      number_2
        add     ah,7
number_2:
        ;mov     [si],ah
        mov     es:[si],ah
        inc     si
        inc     si

        mov     cl,4
        shr     al,cl
        add     al,30h
        cmp     al,3ah
        jc      number_3
        add     al,7
number_3:
        mov     es:[si],al
        inc     si
        inc     si

        mov     al,bl
        and     al,0fh
        add     al,30h
        cmp     al,3ah
        jc      number_4
        add     al,7
number_4:
        mov     es:[si],al
        inc     si
        inc     si
        mov     ax,bx
        ret
dis_ax  endp

IFDEF   DYNAALLOC
; ---------------------------------
; Description: modified memory size
;       INPUT: MSMImageEnd : code size + data size
;              es = the segment that want to modified
;       OUTPUT: if successful, cflag is clear, 
;               if fail, cflag is set, 
;                   ax is error code
;                   bx is maximum paragraphs available for specified memory block
; ----------------------------------------------------
MEMReSize   proc    near
    push cs
    pop  es
    mov bx, 1000h       ; 64 K
    mov ah, 4Ah
    int 21h
    ret
MEMReSize   endp

; ---------------------------------
; Description: dynamic allocate memory
;       INPUT: 
;           [bp+4] = buffer size (byte)
;           [bp+6] = the num of buffer
;           [bp+8] = the pointer of logic address array ( word * 8 )
;           [bp+10] = the pointer of physical address array ( dword * 8 )
;       OUTPUT: if successful, cflag is clear
;                   ax is new segment
;               if fail, cflag is set, 
;                   ax is error code
;                   bx is maximum paragraphs available for specified memory block
; ----------------------------------------------------
MEMDynaAlloc   proc    near
MAXBuffNum  equ     32
LocalBufferSize     equ     16
TheSizeofBuffer     equ     [bp+LocalBufferSize+4]
TheNumofBuffer      equ     [bp+LocalBufferSize+6]
pLocalAddr          equ     [bp+LocalBufferSize+8]
pPhysicalAddr       equ     [bp+LocalBufferSize++10]
numSeg              equ     [bp+4]
RequireBuffer       equ     [bp+8]
    push    bp
    sub     sp, LocalBufferSize
    mov     bp, sp

    push cx
    push dx
    push es
    push di


    ; ---------------------
    ; initialize
    ; ---------------------
    cld
    
    push ds
    pop es

    mov ax, TheSizeofBuffer
    mov bx, TheNumofBuffer
    mov di, pLocalAddr
    mov si, pPhysicalAddr
    
    mul bx
    mov numSeg, dx              ; if result more then FFFFh(64K),
                                ; the part of over 64K is store dx
    mov RequireBuffer, ax       ; the part of less 64K
    ; ------------------------------------
    ; calc we need how much buffer segment
    ; ------------------------------------
    mov bx, TheNumofBuffer      ; the number of buffer
    shr bx, 5                   ; the number of buffer / 32
    jz  SINGLEBUFFERSEGMENT     ; one segemnt can store 32 buffer
                                ; each buffer size is 2K

    ; --------------------------
    ; Multi Buffer Segment
    ; --------------------------
    mov cx, bx                  ; how much buffer segment we need
MULTIBUFFER:                    ; allocate memory
    mov bx, 1000h               ; 4096 paragraphs = 64 K
    mov ah, 48h
    int 21h
    jc MEMDynaAllocError        ; error occur, maybe insufficient memory
    stosw                       ; allocate successful, store segment to local variable
                                ; ax -> RxBufferSegment[CurSEGmentCount]
                                
    mov bx, ax                  ; bx = the segment physical address                                
    mov eax, 10000h             ; 64K
    call calcPhyAddessForEMM386 ; get physical address
    jc MEMDynaAllocError
    mov [si], eax
    add si, 4
    loop MULTIBUFFER

SINGLEBUFFERSEGMENT:
    mov bx, RequireBuffer
    or  bx, bx
    jz  MEMDynaAllocSuccess
    shr bx, 4           ; 1 para = 16 byte
    inc bx              
    mov ah, 48h
    int 21h
    jc  MEMDynaAllocError
    stosw
    
    mov bx, ax                  ; bx = the segment physical address                                
    mov eax, RequireBuffer      ; buffer size
    call calcPhyAddessForEMM386
    jc MEMDynaAllocError
    mov [si], eax

MEMDynaAllocSuccess:
    pop di
    pop es
    pop dx
    pop cx
    add sp, LocalBufferSize
    clc
    jmp MEMDynaAllocOver
MEMDynaAllocError:
    pop di
    pop es
    pop dx
    pop cx    
    add sp, 16
    stc
MEMDynaAllocOver:    
    pop bp
    ret 8
MEMDynaAlloc   endp

; ------------------------------------------------
; Description: get physical address for EMM386
;              if EMM386 is not exist, it return 
;              ssss0+oooo
;       Input: eax -> resource size
;              bx -> segment vaule
;       Output: if successful, cflag is clear, eax -> physical
;               if fail, cflag is set
; -------------------------------------------------
calcPhyAddessForEMM386  proc    near

    push    ax
    push    bx
    push    es
    call    MEMSearchProtMAN

    dec     bx          ; bx --> MCB header
    mov     es, bx
    mov     es:[1], ax

    pop     es
    pop     bx
    pop     ax
    push    di
    mov     VEmmDesp.VSize, eax
    mov     VEmmDesp.VOffset, 0
    mov     VEmmDesp.VSegment, bx

    ; Call VDS Service routine to Lock the memory and get its
    ; Physical address
    ;---------------------------------------------------------
    lea     di, VEmmDesp
    call    CLockMemoryAndGetPhysical
    jc      calcPhyAddressForEMM386Fail
    mov     eax, VEmmDesp.VPhysical
calcPhyAddressForEMM386Fail:    
    pop     di
    ret
calcPhyAddessForEMM386  endp
; ------------------------------------------------------------------
; description: release the buffer that allocate in initialize
;           INPUT:
;           [bp+4] = the pointer of the array of buffer
;                    that allocated in initialize time
;           [bp+6] = the data segment of packet driver
;                    in memory space
;           OUTPUT: none
; -------------------------------------------------------------------
public  MSMFreeMEM
MSMFreeMEM  proc    near
TheSegmentofBuffer      equ     [bp+4]
TheDataSegment          equ     [bp+6]

    push    bp
    mov     bp, sp
    
    push    ax
    push    bx
    push    ds
    push    es
    
    mov     ax, TheDataSegment
    mov     ds, ax
    mov     bx, TheSegmentofBuffer
ReleaseLoop:    
    mov     es, ds:[bx]
    mov     ah, 49h
    int     21h
    jc      MSMFreeMEMOver
    add     bx, 2
    jmp     ReleaseLoop

MSMFreeMEMOver:
    
    pop     es
    pop     ds
    pop     bx
    pop     ax
    pop     bp
    ret     4
MSMFreeMEM   endp

; ------------------------------------------------------------------
; description: 
;           INPUT: none
;           OUTPUT: AX-> the segment of Protman
; -------------------------------------------------------------------
signature   db  'PROTMAN',0
signature_len   equ $-signature
MEMSearchProtMAN    proc    near

    push    bx
    push    cx
    push    es
    push    si
    push    di
    ;------------------
    ; GET LIST OF LISTS
    ;------------------
    mov     ah, 52h
    int     21h
    
    ;--------------------------------------
    ; now, es:bx point to LIST of LISTS
    ;--------------------------------------
    mov     ax, es:[bx-2]               ; ax = the segmemt of the first MCB
    mov     es, ax

CHECKSIGNATURE:
    lea     si, signature
    lea     di, es:[8]
    mov     cx,signature_len
    repe    cmpsb   
    je      signature_ok
    mov     ah, es:[0]
    cmp     ah, 5Ah
    je      error                   ; can not find the MCB of PROTMAM
    mov     ax, es:[3]              ; the size of this MCB
    mov     bx, es
    add     ax, bx
    inc     ax                      ; ax point to next MCB
    mov     es, ax
    jmp     CHECKSIGNATURE
error:
    xor     ax, ax
    jmp     MEMSearchProtMANOver
signature_ok:
    mov     ax, es:[1]
MEMSearchProtMANOver:
    pop     di
    pop     si
    pop     es
    pop     cx
    pop     bx

    ret

MEMSearchProtMAN    endp

ENDIF
;------------------------------------------------------------------------------
;
;       CLockMemoryAndGetPhysical
;
;       1. Check if VDS available.
;       2. If yes, call VDS routine to get physical address.
;       3. If no, translate seg:off to physical address.
;       4. Put physical address at VDS structure(input) and return.
;
;
;       Input:
;               di ==>  VDS_Structure of the information about memory to be
;                       processed.
;       returns:
;               Physical address put at the VDS_Structure
;
;------------------------------------------------------------------------------
        align   4
CLockMemoryAndGetPhysical PROC near

        push    es
        push    edx
        push    eax

        call    CheckVDSAvailale
        jc      NoVDSAvailable
VDSAvailable:
        push    ds
        pop     es                      ; ES:DI -> VDS Descriptor
        mov     ax, 08103h              ; Lock our region memory
        mov     dx, 0004h               ; do not allocate memory if region not
                                        ; continuous
        int     4Bh
        jc      VDSErrorExit
        jmp     VDSExit

NoVDSAvailable:
        clc
        ; VDS does not exist, use segment:offset to calculate
        ; physicall address
        ;-----------------------------------------------------
        xor     eax, eax
        mov     ax, [di].VSegment
        shl     eax, 4
        add     eax, [di].VOffset
        mov     [di].VPhysical, eax           ; put in VDS descriptor

VDSExit:
VDSErrorExit:
        pop     eax
        pop     edx
        pop     es
        ret

CLockMemoryAndGetPhysical  ENDP

;------------------------------------------------------------------------------
;
;   CheckVDSAvailale
;
;   Checks if VDS services are available.
;   If 40:7Bh -> bit5 == 1
;      VDS available
;   else
;      VDS un-available
;
;       returns:
;          Carry   SET    If VDS are un-available
;                  RESET  If VDS are available
;
;------------------------------------------------------------------------------
        align   4
CheckVDSAvailale        PROC near
        push    ax
        push    es

        mov     ax, 40h                 ;test byte at 40:7b
        mov     es, ax                  ;to see if VDS is supported
        clc
        test    BYTE PTR es:[7Bh], 20h
        jnz     SHORT VDSExist

        stc
VDSExist:
        pop     es
        pop     ax
        ret
CheckVDSAvailale        ENDP

;------------------------------------------
; Update packet filter status
;   IN:
;       ReceiveConfig: current packet filter status
;   OUT:
;       none
;-------------------------------------------
SetPacketFilter     proc    near
        pusha
        
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.RXCR
        in      al, dx
        and     al, not (BY_RCR_PROM or BY_RCR_AB or BY_RCR_AM)
        mov     ah, ReceiveConfig
        or      al, ah
        out     dx, al

        test    ah, BY_RCR_PROM
        jz      @F

        cmp     pciRevisionId, RevisionID3106S
        jb      NOCAM
        lea     dx, [bx].SCsrRegStruc.CAMCR     ; [92h]
        in      al, dx
        and     al, not BY_CAMC_CAMEN           ; disable CAMEN bit
        out     dx, al

NOCAM:

        lea     dx, [bx].SCsrRegStruc.MAR0
        mov     ax, 0ffffh
        mov     cx, 4
TurnOnMAR:
        out     dx, ax
        add     dx, 2
        loop    TurnOnMAR
@@:
        popa
        ret
SetPacketFilter     endp
                END_CODE
                end
