;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: req.asm
; 
;  Purpose: Describe what this file is going to do.
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       Request
;       RqSetAddress
;       RqRstMAC
;       RqSetFilter
;       RqAddMulticast
;       RqDelMulticast
;       RqUpdateStats
;       RqClearStats
;       RqCloseAdapter
;       RqSetLookAhead
; 
;  Revision History:
;       01-15-2003 GuardKuo: add this copyright message
;
;                 page    88,122
                title   REQ - Request entry and subfunctions (2.0.1 Spec)

;------ REQ.ASM -------------------------------------------------------------;
;                                                                            ;
;       This file contains the Request entry point and its subfunctions.     ;
;                                                                            ;
;----------------------------------------------------------------------------;

.xlist
include includes.mac
.list
.lfcond
.sall

.386
;------ Exported Interfaces -------------------------------------------------;

                public  Request
                public  RqAddMulticast
                public  RqCloseAdapter
                public  RqDelMulticast
                public  RqSetAddress
                public  RqSetFilter
IFDEF ANYSTATS
                public  RqClearStats
ENDIF

                public  request_table

;------ Imported Interfaces -------------------------------------------------;


IFDEF ANYSTATS
                DOSXTRN timerCount:DWORD
                OS2XTRN infoSeg:WORD
ENDIF
                extrn   common:BYTE
                extrn   cs_ds:WORD
                extrn   multilist:BYTE
                extrn   oldstate:BYTE
                extrn   pdispatch:BYTE
                extrn   protDS:WORD
                extrn   specific:BYTE
                extrn   state:BYTE
                extrn   status:BYTE

;/** 920618
                extrn   StatusIndicate:near
                extrn   UpdateMulticast: near
                extrn   FindAddressInMCTable: near
                extrn   SetPacketFilter: near
                IFDEF   DYNAALLOC
                extrn   MSMFreeMEM:near
                ENDIF
                extrn   Ioport:word
                extrn   LastMCByteAddr:word
                extrn   ReceiveConfig:byte
                extrn   OffDepth:byte
                extrn   ICPending:byte
                extrn   media_specific:word
                extrn   LookAheadSize:word

                extrn   vMACSafeRxOff:near  ; Added by Ben (07/11/2000)
                extrn   ResetNIC:near
                extrn   SetIRQ: near
	            IFDEF   DYNAALLOC
	            extrn   RXBufferSegment:word
	            ENDIF
;**/

NEWPAGE <Dispatch Table>
;------ Dispatch Table ------------------------------------------------------;
;
; 0 offsets indicate unsupported functions.  Request Interrupt has a 0 offset
; but IS supported, it is just handled directly by the Request function
; to streamline things a bit.  Ditto ResetMAC, though for other reasons.
;

                BEGIN_DATA
                even
request_table   label   word


                dw      0                                 ; 0 = illegal function
                dw      0                                 ; 1 = diagnostics
                dw      0                                 ; 2 = read error log
                dw      offset CGROUP:RqSetAddress        ; 3 = set address
                dw      0                                 ; 4 = open adapter
                dw      offset CGROUP:RqCloseAdapter      ; 5 = close adapter
                dw      offset CGROUP:RqRstMAC            ; 6 = reset mac
                dw      offset CGROUP:RqSetFilter         ; 7 = set packet filter
                dw      offset CGROUP:RqAddMulticast      ; 8 = add multicast
                dw      offset CGROUP:RqDelMulticast      ; 9 = delete multicast
                dw      offset CGROUP:RqUpdateStats    ; 10 = update statistics

IFDEF ANYSTATS
                dw      offset CGROUP:RqclearStats    ; 11 = clear statistics
ELSE
                dw      0
ENDIF
                dw      0                                ; 12 = interrupt
                dw      0                                ; 13 = set functional
                dw      offset CGROUP:RqSetLookAhead       ; 14 = set lookahead


                END_DATA


                BEGIN_CODE

NEWPAGE <Request Entry>
;------ Request -------------------------------------------------------------;
;                                                                            ;
;       int far pascal Request(                                              ;
;                               WORD ProtID,                                 ;
;                               WORD Handle,                                 ;
;                               WORD Word,                                   ;
;                               DWORD Bufp,                                  ;
;                               WORD Opcode,                                 ;
;                               WORD MACDS      );                           ;
;                                                                            ;
;       This is the generic request entry into the MAC.  Various control     ;
;       functions can be requested by appropriate setting of Opcode.         ;
;                                                                            ;
;       This function must be completely reentrant and can be called at any  ;
;       time.  None of the functions are remotely performance critical,      ;
;       with the single exception of Interrupt.                              ;
;                                                                            ;
;       This function merely enqueues the request on the request todo queue  ;
;       and then calls NextRequest to start the next request if the          ;
;       SRBinuse flag indicates that the adapter is not busy.  If the        ;
;       adapter is busy, then NextRequest will be called out of the          ;
;       interrupt handler when the current request completes.                ;
;                                                                            ;
;       The Request Interrupt function is given special priority handling    ;
;       because of its performance critical nature.  Interrupt Request is    ;
;       handled without any queueing or dequeueing and always returns        ;
;       SUCCESS without any confirmation.  If possible, we generate an       ;
;       interrupt SRB to the adapter, which will generate an SRB ack         ;
;       interrupt eventually.  However, if the SRB is in use we just set     ;
;       the Intpending flag, which is checked when ANY SRB completes.  This  ;
;       way we can piggyback on top of another SRB if necessary.             ;
;                                                                            ;
;----------------------------------------------------------------------------;

Request         proc    far
        push    bp
        mov     bp,sp
        PUSHR   si,di,ds

        ; set up DS.
        ;------------------------------------
        mov     ds,cs:cs_ds

        mov     di,[bp].rq_opcode
        cmp     di,MAX_REQUEST_OPCODE    ; MAX_REQUEST_CODE = 0eh
        ja      rq_notsupported
        
        
        shl     di,1
        cmp     request_table[di], 0
        jz      rq_notsupported
        call    word ptr request_table[di]



        ;------ rq_exit ---------------------------------------------------------
        ;
        ; done.  return code in AX
        ;------------------------------------------------------------------------
        public  rq_exit
rq_exit:
        sti
        POPR    si,di,ds
        pop     bp
        ret     RQRET

        ; function not supported
        ;------------------------------------
        public  rq_notsupported
rq_notsupported:

        mov     ax,NOT_SUPPORTED
        jmp     rq_exit

Request         endp



NEWPAGE <RqSetAddress - Request SetStationAddress Subfunction>
;------ RqSetAddress --------------------------------------------------------;
;                                                                            ;
;       int RqSetAddress()                                                   ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;           bufp        = address of buffer containing new station address   ;
;           word        = not used                                           ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request SetStationAddress.  For an 802.5       ;
;       style adapter which requires an OpenAdapter call to function, this   ;
;       request is legal only if the adapter is in a closed state and the    ;
;       actual setting of the address will not take place until the          ;
;       OpenAdapter is done.  This function is performed synchronously.      ;
;                                                                            ;
;----------------------------------------------------------------------------;

RqSetAddress    proc    near




        ; copy the address to the mac specific characteristics table for later use
        ;------------------------------------------------------------------------
        ;/** 920616
        les     si,[bp].rq_bufp
        mov     ax,word ptr es:[si][0]

        test    ax,1                    ; is multicate address?
        jnz     rqadr_bad

        mov     word ptr specific.mc_caddr[0],ax
        mov     ax,word ptr es:[si][2]
        mov     word ptr specific.mc_caddr[2],ax
        mov     ax,word ptr es:[si][4]
        mov     word ptr specific.mc_caddr[4],ax

        mov     bp, Ioport
        lea     dx, [bp].PAR0
        mov     cx,6

@@:
        mov     al, byte ptr es:[si]
        out     dx,al
        inc     dx
        inc     si
        loop    @B

        xor     ax,ax
        ret

        ; invalid address
        ;------------------------------------
rqadr_bad:
        mov     ax,INVALID_PARAMETER    ; INVALID_PARAMETER = 7
        ret
        ;**/
RqSetAddress    endp



        ;/** 920616

                public  RqRstMAC

RqRstMAC        proc    near

        pushf
        cli

        mov     al,state
        cmp     al,DECEASED             ;DECEASED = 0FFh
        je      @F

        cmp     al,CLOSED               ; CLOSED = 2
        je      @F

        cmp     al,OPENNED              ; OPENNED = 3
        je      @F
                                        
        mov     ax,INVALID_FUNCTION     ; INVALID_FUNCTION = 8
        retn
@@:
        mov     Oldstate,al
        mov     state,RESETTING

        mov     dx,START_RESET
        xor     ax,ax                   ;must be zero
        call    StatusIndicate
        cli

        mov     ds, cs:cs_ds
        call    ResetNIC
        mov     OffDepth,0
        call    SetIRQ


        mov     dx,END_RESET                ;end reset
        call    StatusIndicate

        mov     ICPending,NO
        sti
        push    common.cc_ID
        push    protDS
        call    pdispatch.pd_indcomplete

        cli

        mov     ds, cs:cs_ds
        mov     al,Oldstate
        mov     state,al
        xor     ax,ax
        popf
        ret
RqRstMAC        endp



NEWPAGE <RqSetFilter - Request SetPacketFilter Subfunction>
;------ RqSetFilter ---------------------------------------------------------;
;                                                                            ;
;       int RqSetFilter()                                                    ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;           bufp        = not used                                           ;
;           word        = new packet filter                                  ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request SetPacketFilter.  The IBM Token Ring   ;
;       adapters have no packet filter per se, so the only thing this        ;
;       function really does is to enable or disable the generation of       ;
;       receive indications.  If a zero packet filter is specified, any      ;
;       packets received will be discarded.  A non-zero packet filter        ;
;       allows normal reception once again.                                  ;
;                                                                            ;
;       When the driver is initially started, the packet filter defaults to  ;
;       zero.  ReceiveLookahead indications may occur once both OpenAdapter  ;
;       and SetPacketFilter (non-zero filter) have been done.  The           ;
;       SetPacketFilter can be done before or after OpenAdapter.             ;
;                                                                            ;
;       This function is performed synchronously.                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

RqSetFilter     proc    near



        ; check if any bits were specified which are not supported by this driver
        ;------------------------------------------------------------------------
rqflt_able:

        mov     dl, ReceiveConfig
        and     dl, not (BY_RCR_PROM or BY_RCR_AB or BY_RCR_AM)

        mov     ax, [bp].rq_word
        cmp     ax, 0
        jne     @F
        jmp     SetPhyFilter

@@:
        test    ax, FM_DIRECTED or FM_BROADCAST or FM_PROMISCUOUS
        jz      rqflt_fail

        ; save the new packet filter in the mac specific status table
        ;------------------------------------------------------------------------
        test    al, FM_DIRECTED or FM_MULTICAST
        jz      @F
        or      dl, BY_RCR_AM
@@:

        test    al, FM_BROADCAST
        jz      @F
        or      dl, BY_RCR_AB

@@:
        test    ax,FM_PROMISCUOUS       ;accept promiscuous packet?
        jz      SetPhyFilter
        or      dl, BY_RCR_PROM or BY_RCR_AB or BY_RCR_AM
        or      ax, FM_BROADCAST or FM_DIRECTED or FM_MULTICAST
SetPhyFilter:

        mov     status.ms_filter, ax
        mov     ReceiveConfig, dl

        call    SetPacketFilter

IFDEF  NE2000
        mov     bp, Ioport
        mov     al, dl
        lea     dx, [bp].NICRxConfiguration
        out     dx,al
ENDIF

        ; done.  return SUCCESS.
        ;------------------------------------
        xor     ax,ax
        ret

        ; general failure
        ;------------------------------------
rqflt_fail:

        mov     ax,INVALID_PARAMETER
        ret
RqSetFilter     endp


NEWPAGE <RqAddMulticast - Request RqAddMulticast Subfunction>
;------ RqAddMulticast ------------------------------------------------------;
;                                                                            ;
;       int RqAddMulticast()                                                 ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;               bufp = address of buffer containing group address            ;
;               word = not used                                              ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request AddMulticastAddress.  The only         ;
;       'multicast' address which is supported by the IBM Token Ring         ;
;       adapters is the single group address, so things are somewhat         ;
;       simpler than they might seem.  If a group address has already been   ;
;       set, then the request is refused.  It will have to be deleted        ;
;       before a new group address can be set.  The group address set on     ;
;       the adapter is only the last 4 bytes of the 6 byte address.  The     ;
;       first two bytes are assumed to be 80 00 hex.                         ;
;                                                                            ;
;       This function is performed asynchronously except for errors.         ;
;                                                                            ;
;----------------------------------------------------------------------------;

RqAddMulticast  proc    near

        ;Lantastic      cmp     multilist.ma_cur, 8
        cmp     multilist.ma_cur, 16
        jae     rqadd_invalid


        ; ensure that the first two bytes of the address are correct
        ;------------------------------------------------------------------------
        les     si,[bp].rq_bufp


        test    word ptr es:[si],1
        jz      rqadd_bad



        mov     ax, word ptr es:[si]
        mov     bx, word ptr es:[si+2]
        mov     di, word ptr es:[si+4]

        call    FindAddressInMCTable
;;;;;;;;
        ; Zero flag=0  Not found

        jz      rqadd_bad


SetPhyMulticast:
        inc     multilist.ma_cur
        mov     si,LastMCByteAddr
        add     LastMCByteAddr,10h
;;;;;;;;;
        mov     word ptr multilist.ma_mbuff[si],ax
        mov     word ptr multilist.ma_mbuff[si+2],bx
        mov     word ptr multilist.ma_mbuff[si+4],di
;;;;;;;;;
;;;;;;;;;
        call    UpdateMulticast
;;;;;;;;;

        xor     ax,ax
        ret

        ; invalid state
        ;------------------------------------
rqadd_invalid:
        mov     ax,INVALID_FUNCTION
        ret

        ; bad parameter
        ;------------------------------------
rqadd_bad:
        mov     ax,INVALID_PARAMETER
        ret
RqAddMulticast  endp

NEWPAGE <RqDelMulticast - Request DeleteMulticastAddress Subfunction>
;------ RqDelMulticast ------------------------------------------------------;
;                                                                            ;
;       int RqDelMulticast()                                                 ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;               bufp = address of buffer containing group address            ;
;               word = not used                                              ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request DeleteMulticastAddress.  The only      ;
;       'multicast' address which is supported by the IBM Token Ring         ;
;       adapters is the single group address, so things are somewhat         ;
;       simpler than they might seem.  The address must match the one in     ;
;       the multicast list table or it will be refused.  A zero group        ;
;       address will then be set.                                            ;
;                                                                            ;
;       This function is performed asynchronously except for errors.         ;
;                                                                            ;
;----------------------------------------------------------------------------;

RqDelMulticast  proc    near


        les     si, [bp].rq_bufp
        test    word ptr es:[si], 1
        jcxz    rqdel_bad

        mov     ax, word ptr es:[si]
        mov     bx, word ptr es:[si+2]
        mov     di, word ptr es:[si+4]



        call    FindAddressInMCTable
        jcxz    rqdel_bad


RqDel_FoundAddr:

        lea     di,multilist.ma_mbuff[si]

        mov     bx, LastMCByteAddr
        sub     bx, 10h
        mov     LastMCByteAddr, bx
        lea     si,multilist.ma_mbuff[bx]

        push    ds
        pop     es

        mov     cx,3
@@:

        xor     ax, ax
        xchg    ax, word ptr [si]

        stosw
        add     si, 2

        loop    @B

        dec     multilist.ma_cur
        jmp     rqdel_exit

rqdel_invalid:
        mov     ax,INVALID_FUNCTION
        retn

rqdel_bad:
        mov     ax,INVALID_PARAMETER
        retn


rqdel_physet:

rqdel_exit:
;;;;;;;
        call    UpdateMulticast
;;;;;;;
        xor     ax,ax
        ret
RqDelMulticast  endp


                public  RqUpdateStats
RqUpdateStats   proc    near

        ;/** spec
        mov     bp, Ioport
        lea     dx, [bp].TallyCounter_CRC
        in      ax, dx
        xor     dx, dx
        add     media_specific[4].loword,ax
        adc     media_specific[4].hiword,dx

        lea     dx, [bp].TallyCounter_CRC
        in      ax, dx
        xor     dx, dx
        add     status.ms_crc_rerr.loword,ax
        adc     status.ms_crc_rerr.hiword,dx


        lea     dx, [bp].TallyCounter_MPA
        in      ax, dx
        xor     dx, dx
        add     status.ms_nobuf_rerr.loword,ax
        adc     status.ms_nobuf_rerr.hiword,dx
        ;**/
        
        xor     ax,ax
        retn
RqUpdateStats   endp



NEWPAGE <RqClearStats - Request RqclearStats Subfunction>
;------ RqClearStats --------------------------------------------------------;
;                                                                            ;
;       int RqClearStats()                                                   ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request Clearstatistics.  It updates the       ;
;       date/time statistics were last cleared and clears out the stats      ;
;       which are being maintained.                                          ;
;                                                                            ;
;       This function is performed synchronously.                            ;
;                                                                            ;
;----------------------------------------------------------------------------;

IFDEF ANYSTATS

RqClearStats    proc    near

        ;/** 920704
        pushr   si,di

        ; under OS/2 we can get the current date/time in the format we want from the
        ; global infoSeg.
        ;------------------------------------------------------------------------
IFDEF OS2
        mov     es,infoSeg
        mov     ax,es:[is_elapsed].loword
        mov     dx,es:[is_elapsed].hiword
        mov     status.ms_cdate.loword,ax
        mov     status.ms_cdate.hiword,dx

ENDIF
        ;**/


        ; under DOS we've been accumulating timer ticks since the last time clear
        ; was issued, so we can adjust the time after converting to seconds
        ;
        ; the timer tick handler is invoked 18.20651 times per second.  we use this
        ; as 36413/2000 = 18.2065.  probably good enough and it keeps the arithmetic
        ; halfway reasonable.
        ;-----------------------------------------------------------------------
IFDEF DOS

        xor     ax,ax

        xchg    ax,timerCount.loword

        mov     cx,2000
        mul     cx
        mov     si,ax
        mov     di,dx
        xor     ax,ax

        xchg    ax,timerCount.hiword

        mul     cx
        add     ax,di
        adc     dx,0
        mov     cx,36413
        div     cx
        mov     di,ax
        mov     ax,si
        div     cx                      ; DI:AX is seconds since last clear
        add     status.ms_cdate.loword,ax
        adc     status.ms_cdate.hiword,di
ENDIF


        ; set AX to zero, both for the zeroing and to return success
        ;----------------------------------------------------------------------
        xor     ax,ax

        ; and clear the various statistics we maintain, without disturbing the
        ; others...
        ;----------------------------------------------------------------------
        mov     status.ms_total_recv.loword,ax
        mov     status.ms_total_recv.hiword,ax
        mov     status.ms_total_rbytes.loword,ax
        mov     status.ms_total_rbytes.hiword,ax
        mov     status.ms_total_sent.loword,ax
        mov     status.ms_total_sent.hiword,ax
        mov     status.ms_total_sbytes.loword,ax
        mov     status.ms_total_sbytes.hiword,ax
        ;/** 920618

        ;               mov     status.ms_hard_serr.loword,ax
        ;               mov     status.ms_hard_serr.hiword,ax

        mov     media_specific[4].loword,ax
        mov     media_specific[4].hiword,ax
        mov     status.ms_crc_rerr.loword,ax
        mov     status.ms_crc_rerr.hiword,ax
        mov     status.ms_nobuf_rerr.loword,ax
        mov     status.ms_nobuf_rerr.hiword,ax


IFDEF  NE2000
        mov     bp, Ioport
        lea     dx, [bp].TallyCNTR0
        in      al, dx

        lea     dx, [bp].TallyCNTR1
        in      al,dx

        lea     dx, [bp].TallyCNTR2
        in      al,dx
ENDIF
        popr    si,di

        xor     ax,ax
        ;**/
        ret
RqClearStats    endp
ENDIF

COMMENT %

NEWPAGE <RqSetFunctional - Request SetFunctionalAddress Subfunction>
;------ RqSetFunctional -----------------------------------------------------;
;                                                                            ;
;       int RqSetFunctional()                                                ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;           bufp        = address of buffer containing functional address    ;
;           word        = not used                                           ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request SetFunctionalAddress.  This function   ;
;       is performed asynchronously except for errors.                       ;
;                                                                            ;
;----------------------------------------------------------------------------;

;;;;;;;;;;;;;;;;RqSetFunctional proc    near
;
; ensure that the adapter is openned
;
;;;;;;;;;;;;;;;;                cmp     state,OPENNED
;;;;;;;;;;;;;;;;                jne     rqfnc_invalid
;
; ensure that the first bit isn't set
;
;;;;;;;;;;;;;;;;                les     bx,[si].qr_bufp
;;;;;;;;;;;;;;;;                test    byte ptr es:[bx][0],80h
;;;;;;;;;;;;;;;;                jnz     rqfnc_bad
;
; copy the address to the mac specific characteristics table (save in AX|DX)
;
;;;;;;;;;;;;;;;;                mov     ax,word ptr es:[bx][0]
;;;;;;;;;;;;;;;;                mov     dx,word ptr es:[bx][2]
;;;;;;;;;;;;;;;;                mov     word ptr specific.mc_faddr[0],ax
;;;;;;;;;;;;;;;;                mov     word ptr specific.mc_faddr[2],dx
;
; set up an SRB for DIR.SET.FUNCT.ADDRESS (from AX|DX)
;
;;;;;;;;;;;;;;;;                mov     es,segSM
;;;;;;;;;;;;;;;;                mov     bx,oSRB
;;;;;;;;;;;;;;;;                mov     es:[bx].srb_command,DIR_SETFUNCTIONAL
;;;;;;;;;;;;;;;;                mov     word ptr es:[bx].funct_address[0],ax
;;;;;;;;;;;;;;;;                mov     word ptr es:[bx].funct_address[2],dx
;
; hit the command ready bit
;
;;;;;;;;;;;;;;;;                mov     es,segMMIO
;;;;;;;;;;;;;;;;                mov     byte ptr es:ISRAL+ACASET,ISRALSRBRDY+ISRALFREESRB
;
; done.  return.
;
;;;;;;;;;;;;;;;;                mov     ax,REQUEST_QUEUED
;;;;;;;;;;;;;;;;                ret
;
; invalid state
;
;;;;;;;;;;;;;;;;rqfnc_invalid:
;;;;;;;;;;;;;;;;                mov     ax,INVALID_FUNCTION
;;;;;;;;;;;;;;;;                ret
;
; invalid functional address
;
;;;;;;;;;;;;;;;;rqfnc_bad:
;;;;;;;;;;;;;;;;                mov     ax,INVALID_PARAMETER
;;;;;;;;;;;;;;;;                ret
;;;;;;;;;;;;;;;;RqSetFunctional endp


NEWPAGE <RqReadLog - Request ReadErrorLog Subfunction>
;------ RqReadLog -----------------------------------------------------------;
;                                                                            ;
;       int RqReadLog()                                                      ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;           bufp        = address of buffer to hold error log                ;
;           word        = length of buffer                                   ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request ReadErrorLog.  This function is        ;
;       performed asynchronously except for errors.                          ;
;                                                                            ;
;----------------------------------------------------------------------------;

;;;;;;;;;;;;;;;;RqReadLog       proc    near
;
; ensure that the adapter is openned
;
;;;;;;;;;;;;;;;;                cmp     state,OPENNED
;;;;;;;;;;;;;;;;                jne     rqlog_invalid
;
; ensure that there is sufficient space for the error log
;
;;;;;;;;;;;;;;;;                cmp     [si].qr_word,LOGSIZE
;;;;;;;;;;;;;;;;                jb      rqlog_fail
;
; set up an SRB for DIR.READ.LOG
;
;;;;;;;;;;;;;;;;                mov     es,segSM
;;;;;;;;;;;;;;;;                mov     bx,oSRB
;;;;;;;;;;;;;;;;                mov     es:[bx].srb_command,DIR_READLOG
;
; hit the command ready bit
;
;;;;;;;;;;;;;;;;                mov     es,segMMIO
;;;;;;;;;;;;;;;;                mov     byte ptr es:ISRAL+ACASET,ISRALSRBRDY+ISRALFREESRB
;
; done.  return.
;
;;;;;;;;;;;;;;;;                mov     ax,REQUEST_QUEUED
;;;;;;;;;;;;;;;;                ret
;
; invalid state
;
;;;;;;;;;;;;;;;;rqlog_invalid:
;;;;;;;;;;;;;;;;                mov     ax,INVALID_FUNCTION
;;;;;;;;;;;;;;;;                ret
;
; general failure
;
;;;;;;;;;;;;;;;;rqlog_fail:
;;;;;;;;;;;;;;;;                mov     ax,GENERAL_FAILURE
;;;;;;;;;;;;;;;;                ret
;;;;;;;;;;;;;;;;RqReadLog       endp

NEWPAGE <RqOpenAdapter - Request OpenAdapter Subfunction>
;------ RqOpenAdapter -------------------------------------------------------;
;                                                                            ;
;       int RqOpenAdapter()                                                  ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;           bufp        = not used                                           ;
;           word        = open options                                       ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request OpenAdapter.  It causes the adapter    ;
;       to be physically inserted into the ring, and allows other commands   ;
;       to the adapter to be issued.                                         ;
;                                                                            ;
;       This function must be called after Bind, but before most other       ;
;       functions (only Request Interrupt, SetStationAddress and             ;
;       IndicationOn/Off are legal before the adapter is open).  A           ;
;       CloseAdapter will return the adapter to the same state as before     ;
;       the open.  SetPacketFilter is still required to enable incoming      ;
;       packets to generate indications to the protocol.                     ;
;                                                                            ;
;----------------------------------------------------------------------------;

;;;;;;;;;;;;;;;;RqOpenAdapter   proc    near
;;;;;;;;;;;;;;;;                PUSHR   si,di
;
; ensure that the adapter is closed (change state to open when the open
; adapter command completes)
;
;;;;;;;;;;;;;;;;                cmp     state,CLOSED
;;;;;;;;;;;;;;;;                jne     rqopn_invalid
;
; save the open options supplied on the call
;
;;;;;;;;;;;;;;;;                mov     ax,[si].rq_word
;;;;;;;;;;;;;;;;                mov     openSoft,ax
;
; open the adapter
;
;;;;;;;;;;;;;;;;                call    OpenAdapter
;
; done.  return.
;
;;;;;;;;;;;;;;;;                mov     ax,REQUEST_QUEUED
;;;;;;;;;;;;;;;;rqopn_exit:
;;;;;;;;;;;;;;;;                POPR    si,di
;;;;;;;;;;;;;;;;                ret
;
; invalid state
;
;;;;;;;;;;;;;;;;rqopn_invalid:
;;;;;;;;;;;;;;;;                mov     ax,INVALID_FUNCTION
;;;;;;;;;;;;;;;;                jmp     rqopn_exit
;;;;;;;;;;;;;;;;RqOpenAdapter   endp

NEWPAGE <RqCloseAdapter - Request CloseAdapter Subfunction>
;------ RqCloseAdapter ------------------------------------------------------;
;                                                                            ;
;       int RqCloseAdapter()                                                 ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;           bufp        = not used                                           ;
;           word        = not used                                           ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request CloseAdapter.  This function is        ;
;       performed asynchronously except for errors.                          ;
;                                                                            ;
;       Note that CloseAdapter zeroes out the functional and group           ;
;       addresses just like TOKREUI.                                         ;
;                                                                            ;
;----------------------------------------------------------------------------;

RqCloseAdapter  proc    near
;
; ensure that the adapter is openned then change state to closed and clear the
; openned bit in the status flags
;
;;;;;;;;;;;;;;;;                cmp     state,OPENNED
;;;;;;;;;;;;;;;;                jne     rqcls_invalid
;;;;;;;;;;;;;;;;                mov     state,CLOSED
;;;;;;;;;;;;;;;;                and     status.ms_flags.loword,NOT ST_MAC_IS_OPEN
;
; zero out the functional and group addresses
;
;;;;;;;;;;;;;;;;                mov     word ptr specific.mc_faddr[0],0
;;;;;;;;;;;;;;;;                mov     word ptr specific.mc_faddr[2],0
;;;;;;;;;;;;;;;;                mov     multilist.ma_cur,0
;
; set the number of transmits needed to 0 (we'll get access errors from the
; adapter if these are processed after the adapter closes)
;
;;;;;;;;;;;;;;;;                mov     txNeeded,0
;
; set up an SRB for DIR.CLOSE.ADAPTER
;
;;;;;;;;;;;;;;;;                mov     es,segSM
;;;;;;;;;;;;;;;;                mov     bx,oSRB
;;;;;;;;;;;;;;;;                mov     es:[bx].srb_command,DIR_CLOSEADAPTER
;
; hit the command ready bit
;
;;;;;;;;;;;;;;;;                mov     es,segMMIO
;;;;;;;;;;;;;;;;                mov     byte ptr es:ISRAL+ACASET,ISRALSRBRDY+ISRALFREESRB
;
; done.  return.
;
;;;;;;;;;;;;;;;;                mov     ax,REQUEST_QUEUED
;;;;;;;;;;;;;;;;                ret
;
; invalid state
;
;;;;;;;;;;;;;;;;rqcls_invalid:
;;;;;;;;;;;;;;;;                mov     ax,INVALID_FUNCTION
                ret
RqCloseAdapter  endp

%


NEWPAGE <RqCloseAdapter - Request CloseAdapter Subfunction>
;------ RqCloseAdapter ------------------------------------------------------;
;                                                                            ;
;       int RqCloseAdapter()                                                 ;
;                                                                            ;
;       SI = queue entry for this request                                    ;
;                                                                            ;
;       where the queue entry fields are as follows:                         ;
;                                                                            ;
;           bufp        = not used                                           ;
;           word        = not used                                           ;
;                                                                            ;
;       returns:                                                             ;
;                                                                            ;
;       AX = return code                                                     ;
;                                                                            ;
;       Registers AX,BX,CX,DX,ES may be destroyed by this function.          ;
;                                                                            ;
;       This function handles Request CloseAdapter.  This function is        ;
;       performed asynchronously except for errors.                          ;
;                                                                            ;
;       Note that CloseAdapter zeroes out the functional and group           ;
;       addresses just like TOKREUI.                                         ;
;                                                                            ;
;----------------------------------------------------------------------------;

RqCloseAdapter  proc    near

        ; ensure that the adapter is openned then change state to closed and clear the
        ; openned bit in the status flags
        ;----------------------------------------------------------------------
        cmp     state,OPENNED
        jne     rqcls_invalid
;;;;;;;;;;;;;;;;                mov     state,CLOSED

        ;---------------------------------------------------S
        ;   Added by Ben (07/11/2000)
        ;   ------------------------

        call    vMACSafeRxOff
        jc      SET_RXON_OFF_FAIL 

        ;----------------------------------------------------
        ; Added by guard (08/06/2003)
        ;----------------------------------------------------
        IFDEF   DYNAALLOC
        push    ds
        lea     dx, RXBufferSegment
        push    dx
        call    MSMFreeMEM
        ENDIF
        
        mov     bx, Ioport
        
        lea     dx, [bx].SCsrRegStruc.CommandReg                                                  
        in      ax, dx
        and     ax, not W_CR_TXON           ; Trun off TXON
        out     dx, ax 
        
        ;Set STOP & DPOLL off
        ;---------------------------
        xor     ax, ax
        or      ax, W_CR_STOP OR W_CR_DPOLL
        out     dx, ax
        ;---------------------------------------------------E

        ;---------------------------------------------------E
SET_RXON_OFF_FAIL:                  ; Added by Ben (07/11/2000)
rqcls_invalid:

        mov     ax,INVALID_FUNCTION

        
        ret
RqCloseAdapter  endp

                public  RqSetLookAhead
RqSetLookAhead  proc    near
        mov     bx,[bp].rq_word
        cmp     bx, 64
        jb      @F

        cmp     LookAheadSize, bx
        jae     @F

        cmp     bx,256
        ja      RqsetL_bad

        mov     LookAheadSize,bx
@@:
        xor     ax,ax
        retn

RqsetL_bad:
        mov     ax,INVALID_PARAMETER
        retn
RqSetLookAhead  endp



        END_CODE
        end
        
