;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: recv.asm
; 
;  Purpose: This file is mainly for reception for packet larger than header part.
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       TransferData
;       IndicationOn
;       IndicationOff
;       ReceiveRelease
; 
;  Revision History:
;       01-15-2003 GuardKuo: add this copyright message
;
                title   RECV - Receive Functions (2.0.1 Spec)
.xlist
IFDEF OS2
include devhlp.inc
ENDIF
include includes.mac
.list
.lfcond
.sall

.386
;------ Exported Interfaces -------------------------------------------------;
                
                public  IndicationOff
                public  IndicationOn
                public  ReceiveRelease
                public  TransferData

;------ Imported Interfaces -------------------------------------------------;

                extrn   IMRport:WORD
                extrn   cs_ds:WORD
                extrn   disableMask:BYTE
                extrn   enableMask:BYTE
                extrn   offDepth:BYTE
IFDEF SNAP
                DEXTRN  rxsnapix:WORD
                DEXTRN  rxsnaparea:BYTE
ENDIF


                extrn   TotalRxCnt:word
                IFNDEF DYNAALLOC
                extrn   LookAheadBuf: byte
                ENDIF
                extrn   Ioport:word
                extrn   ERCurrPtr: word
                extrn           wImrShadow:word
                IFDEF   DYNAALLOC
                extrn           CurRXDescPtr:word
                ENDIF


                BEGIN_CODE

NEWPAGE <TransferData - Copy Received Packet Into Protocol Buffers>
;------ TransferData --------------------------------------------------------;
;                                                                            ;
;       int far pascal TransferData(                                         ;
;                                       LPWORD Copied,                       ;
;                                       WORD Offset,                         ;
;                                       LPBUF Bufdesc,                       ;
;                                       WORD MACDS      );                   ;
;                                                                            ;
;       Called by the protocol to copy the current receive packet into the   ;
;       protocol buffers described by Bufdesc.  The copy operation starts    ;
;       at byte Offset and the number of bytes copied is returned in         ;
;       Copied.  This function should only be called from ReceiveLookahead,  ;
;       though it need not be called at all.                                 ;
;                                                                            ;
;       Bufdesc points to a transfer buffer descriptor describing a series   ;
;       of frame data blocks to be used for the transfer.  The packet will   ;
;       be copied in such a way as to fill in each block to capacity before  ;
;       proceeding to the next.  The buffer descriptor itself will not be    ;
;       modified by this operation.                                          ;
;                                                                            ;
;       Note: Failure to align data buffers on (physical) word boundaries    ;
;       may have significant performance consequences.                       ;
;                                                                            ;
;       Because of wait states on the memory, the 8MHz bus, waits on the     ;
;       adapter memory and the 8 bit data path to the Adapters I & II the    ;
;       time it takes to copy a packet to or from the adapter into system    ;
;       memory is substantially different from what might be theoretically   ;
;       predicted based solely on processor clock cycles.  Tests show that   ;
;       a single REP MOVSW takes about:                                      ;
;                                                                            ;
;               2.0 usec on a 386/20 (vs. 0.2 predicted)                     ;
;               2.0 usec on a 286/8 (vs. 0.5 predicted)                      ;
;               1.1 usec on a PS/2 Model 50 (vs. 0.4 predicted)              ;
;                                                                            ;
;       The Adapter/A has a 16 bit data path, which accounts for most of     ;
;       the improvement over the 8 bit adapters.  However, some of the       ;
;       improvement comes from the fact that the PS/2 Model 50 runs the bus  ;
;       at 10MHz instead of 8MHz, since it has about a 15% head start even   ;
;       using REP MOVSB.  Timing tests show no significant advantage to      ;
;       using the REP MOVSD form on 386 processors, and taking advantage of  ;
;       it significantly complicates things.                                 ;
;                                                                            ;
;       Although the IBM Token Ring Adapters do not seem to be capable of    ;
;       transmitting at anywhere near the 4Mbps rated capacity of the        ;
;       network, it is possible with multiple transmitters to fill the       ;
;       network to very close to that capacity and the adapters appear to    ;
;       be capable of receiving at the full bandwidth.  An Adapter II        ;
;       installed in a 386/20 easily received at 4.0E6 bits per second.      ;
;                                                                            ;
;----------------------------------------------------------------------------;

                DLOCAL  db_remaining
                DLOCAL  db_current,4
                DLOCAL  rx_head

;------ TransferData --------------------------------------------------------;
;
CXsave  dw  0
ESsave  dw  0
DISave  dw  0

                align   4
TransferData    proc    far
        LOCALS
        PUSHR   si,di,ds
        pushf
        cli

        mov     ds,cs:cs_ds


        ; initialize all of the receive buffer variables adjusting for the specified
        ; start offset.
        ; --------------------------------------------------------------------
        mov     bx,TotalRxCnt
        mov     cx,[bp].td_offset         ;starting offset in frame for

                                          ;transfer
        sub     bx,cx
        mov     TotalRxCnt,bx             ; the byte counts will be
                                          ; moved

        mov     [bp].rx_head,cx           ; the head of xfer Desc. will
                                          ; be dumped
        xor     si,si


        ; set db_remaining to the number of frame blocks in the buffer descriptor
        ; and db_current (and ES:DI) to the address of the first chain entry
        ;------------------------------------------------------------------------
        les     di,[bp].td_bufdesc
        mov     ax,es:[di].td_data_count
        mov     [bp].db_remaining,ax
        add     di,td_chain
        mov     [bp].db_current.segm,es

        mov     ax,[bp].rx_head               ;
        mov     ERCurrPtr, ax

xfer_dbloop:
        mov     [bp].db_current.off,di
        mov     cx,es:[di].cd_data_len


        ; get the virtual address of the frame data block in ES:DI.  Under OS/2 we
        ; may be given a physical address which we will have to virtualize using the
        ; receive GDT selector reserved at INIT time.  if FASTGDT is defined do this
        ; ourselves in-line (the devhelp calls are just too many instructions).
        ;------------------------------------------------------------------------

        les     di,es:[di].cd_data_buff
        cld
        sub     bx,cx
        jnc     @F
        add     cx,bx
        xor     bx,bx
@@:
        jmp     RealXfer

        
RealXfer:
        cli

        mov     si, ERCurrPtr               ;
IFDEF   DYNAALLOC 
        push    ax
        push    bx
        push    ds
        mov     bx, CurRXDescPtr
        add     si, [bx].SRxDescStruc.pRxBuffer
        add     ERCurrptr,cx
        mov     ax, [bx].SRxDescStruc.pRxLogicSeg
        mov     ds, ax     
ELSE
        add     si, offset LookAheadBuf
        add     ERCurrptr,cx
ENDIF        

        
        shr     cx,1
        rep     movsw
        PRIV_CPU
        jnc     NotOdd
        movsb

NotOdd:
IFDEF   DYNAALLOC
        pop     ds
        pop     bx
        pop     ax
ENDIF      
EROver:


NextChains:
IFDEF   RxDebug
        call    dbgsave2  ;int3
ENDIF
        or      bx,bx
        jz      xferHasDone
        dec     word ptr [bp].db_remaining
        jz      xferHasDone
        mov     es,[bp].db_current.segm
        mov     di,[bp].db_current.off
        add     di,8
        jmp     xfer_dbloop
xferHasDone:

        
        mov     ax, TotalRxCnt
        sub     ax,bx
        les     di,dword ptr [bp].td_copied
        mov     es:[di],ax



        ; done.  return SUCCESS.
        ;------------------------------------
xfer_copied:
        xor     ax,ax
        popf

        ; done.  return code in AX
        ;------------------------------------
        POPR    si,di,ds
        leave
        
       
        ret     TDRET
TransferData    endp


NEWPAGE <IndicationOn Entry>
;------ IndicationOn --------------------------------------------------------;
;                                                                            ;
;       int far pascal IndicationOn(WORD MACDS);                             ;
;                                                                            ;
;       This routine enables indications after they have been disabled by    ;
;       IndicationOff.  Since IndicationOn/Off can be nested, a counter      ;
;       is used to keep track of when indications should be enabled again.   ;
;       Therefore the protocol should not rely on indications being          ;
;       immediately enabled on return from this routine.                     ;
;                                                                            ;
;       This function disables interrupts.  It is the protocol's             ;
;       responsibility to enable them on return.  Note that this guarantees  ;
;       that indications will not be generated before this function          ;
;       returns.                                                             ;
;                                                                            ;
;       This function is critical path for DLC.                              ;
;                                                                            ;
;----------------------------------------------------------------------------;

                align   4
IndicationOn    proc    far
        cli

        ;/** 920616
        PUSHR   es, dx, bx
        ;**/


        ; set ES to our data segment
        ;------------------------------------
        mov     es,cs:cs_ds

        ; sanity checks for development.  ensure that indications aren't already
        ; on and then make sure they really were off.
        ;------------------------------------------------------------------------
IFDEF DEV

        cmp     es:offDepth,0
        jnz     @F
        BPOINT  on_already
@@:
        mov     dx,es:IMRport
        in      al,dx
        test    al,es:disableMask
        jnz     @F
        BPOINT  on_notoff
@@:
ENDIF

        ; decrement the nest level.  if non-zero just return.
        ;------------------------------------------------------------------------

        cmp     es:offDepth, 0
        je      @F
        dec     es:offDepth
        jnz     on_exit

        ; enable interrupts through the the PIC IMR (clear the bit for our int level)
        ;------------------------------------------------------------------------
@@:
        mov     dx,es:IMRport
        in      al,dx
        slow
        slow
        and     al,es:enableMask
        out     dx,al

        ;mov     bx, es:Ioport

        ;lea     dx, [bx].SCsrRegStruc.IMR0
        ;MOV     AX, ES:wImrShadow
        ;OUT     DX, AX

        ; done.  return SUCCESS.
        ;------------------------------------
on_exit:

        POPR    es,dx, bx
        xor     ax,ax
        ret     STDRET
IndicationOn    endp

NEWPAGE <IndicationOff Entry>
;------ IndicationOff -------------------------------------------------------;
;                                                                            ;
;       int far pascal IndicationOff(WORD MACDS);                            ;
;                                                                            ;
;       This routine disables indications.  They can be reenabled by a call  ;
;       to IndicationOn.  Since IndicationOn/Off can be nested, a counter    ;
;       is used to keep track of when indications should be enabled again.   ;
;                                                                            ;
;       This function disables interrupts.  It is the protocol's             ;
;       responsibility to enable them on return.                             ;
;                                                                            ;
;       This function is critical path for DLC.                              ;
;                                                                            ;
;----------------------------------------------------------------------------;

                align   4
IndicationOff   proc    far
        cli
        ;/** 920616
        PUSHR   es,dx,bx
        ;**/

        ; set ES to our data segment
        ;------------------------------------
        mov     es,cs:cs_ds

        ; sanity checks for development.  make sure that indications are really
        ; in the state we think they are.
        ;------------------------------------------------------------------------
IFDEF DEV
        mov     dx,es:IMRport
        in      al,dx
        cmp     es:offDepth,0
        jnz     @F
        test    al,es:disableMask
        jz      off_sane
        BPOINT  off_noton
@@:     test    al,es:disableMask
        jnz     off_sane
        BPOINT  off_notoff
off_sane:
ENDIF

        ; increment the nest level
        ;------------------------------------
        inc     es:offDepth

        ; disable interrupts through the PIC IMR (set the bit for our int level)
        ;------------------------------------------------------------------------
        mov     dx,es:IMRport
        in      al,dx
        slow
        slow
        or      al,es:disableMask
        out     dx,al
        ;mov     bx, es:Ioport
        ;lea     dx, [bx].SCsrRegStruc.IMR0

        ;XOR     AX, AX
        ;OUT     DX, AX

        POPR    es,dx,bx
        ;**/

        ; done.  return SUCCESS.
        ;------------------------------------

        xor     ax,ax
        ret     STDRET
IndicationOff   endp

NEWPAGE <ReceiveRelease Dummy Entry>
;------ ReceiveRelease ------------------------------------------------------;
;                                                                            ;
;       This entry is provided to conform to the spec requirement that no    ;
;       entry point be NULL.  Since this driver never generates              ;
;       ReceiveChain indications to the protocol, this function should       ;
;       never be invoked.                                                    ;
;                                                                            ;
;----------------------------------------------------------------------------;

                align  4
ReceiveRelease  proc    far
        mov     ax,GENERAL_FAILURE
        ret     RRRET
ReceiveRelease  endp

                END_CODE
                end
