;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: msg.asm
; 
;  Purpose: include all message that used in NDIS2 driver.
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       upcase
;       hexchar
;       charhex
; 
;  Revision History:
;       01-15-2003 GuardKuo: add this copyright message
;
; 
                page    88,122
                title   MSG - Messages and Banners (2.0.1 Spec)

.xlist
IFDEF OS2
include devsym.inc
include devhlp.inc
ENDIF
include includes.mac
.list
.lfcond
.sall

.386
;------ Exported Interfaces -------------------------------------------------;
                public  msg_signon              ; INIT time only
                public  msg_generalfailure      ; "
                public  msg_nosuchkeyword       ; "
                public  msg_invalidrhs          ; "
                public  msg_badconfigure        ; "
                public  msg_crcerror
                public  msg_nohardware          ; "
                public  msg_pressakey           ; "
                public  msg_crlf                ; "
                public  msg_equals              ; "
                public  msg_quote               ; "
                public  msg_openparen           ; "
                public  msg_closeparen          ; "
                public  msg_preamble            ; "
                public  msg_moretocome          ; "


                public  keyn_drivername
                public  keyn_ioaddress
                public  keyn_interrupt
                public  keyn_netaddr
                public  keyn_earlyreceive
                public  keyn_earlytransmit
                public  keyn_fullduplex
                public  keyn_linespeed
                public  keyn_auto
                public  keyn_connectiontype     ; added by Ben (2001/03/07)
                public  keyn_flowctl            ; added by Ben (2001/09/13)
                public  keyn_valpktlen          ; added by guard (2003/06/21)
                public  keyn_busno
                public  keyn_deviceno

;**/
                public  hexchar                 ; "
                public  charhex                 ; "

NEWPAGE <Banner>
; *************************************************************
;
                BEGIN_INIT_DATA
;
; *************************************************************

        msg_signon      db      'VIA Rhine Family Fast Ethernet Adapter Driver               ', 0ah, 0dh
IFDEF OS2
                        db      'NDIS2 OS2 Driver'
ELSE
                        db      'NDIS2 DOS Driver'
ENDIF
                        db      ' v4.38(03-22-2007)', 0ah, 0dh, 0 ; (MM/DD/YY)


IFDEF OS2
public  error_msg1
public  error_msg2
public  error_msg3
public  error_msg4
public  error_msg5
public  error_msg6
public  error_msg7
public  error_msg8
public  error_msg9
public  error_msg0

error_msg1      db      'error 1',0ah,0dh,0
error_msg2      db      'error 2',0ah,0dh,0
error_msg3      db      'error 3',0ah,0dh,0
error_msg4      db      'error 4',0ah,0dh,0
error_msg5      db      'error 5',0ah,0dh,0
error_msg6      db      'error 6',0ah,0dh,0
error_msg7      db      'error 7',0ah,0dh,0
error_msg8      db      'error 8',0ah,0dh,0
error_msg9      db      'error 9',0ah,0dh,0
error_msg0      db      'error 0',0ah,0dh,0
ENDIF
        public  msg_LineSpeed
msg_LineSpeed   db      'Line Speed = ',0
        public  msg_10M
msg_10M         db      '10Mbps',0
        public  msg_100M
msg_100M        db      '100Mbps',0
        public  msg_FullDuplex
msg_FullDuplex  db      'FullDuplex',0
        public  msg_HullDuplex
msg_HullDuplex  db      'HalfDuplex',0
        public  EtherIDMsg
EtherIDMsg      db      ' Ethernet address: ',0
        public  EthernetID
EthernetID      db      12 dup('0'),0

; Product Name strings
; --------------------------------------------------------------------------
        public  VT3043CardName
VT3043CardName          db      'VIA VT86C100A Rhine Fast Ethernet Adapter                   ', 0dh, 0ah, 0
        public  VT3065CardName
VT3065CardName          db      'VIA Rhine II Fast Ethernet Adapter                          ', 0dh, 0ah, 0
        public  VT3106JCardName
VT3106JCardName         db      'VIA Rhine III Fast Ethernet Adapter                         ', 0dh, 0ah, 0
        public  VT3106SCardName
VT3106SCardName         db      'VIA Rhine III Management Adapter                            ', 0dh, 0ah, 0
;        public  VT3206CardName
;VT3206CardName         db       'VIA Rhine III Fast Ethernet Adapter                         ', 0dh, 0ah, 0


        
; modify by Ben (10/09/00), ' Slot: ' -> ' Slot(HEX): "                
; ------------------------------------------------------
        public  PCISlotMsg
PCISlotMsg              db      ' Device(HEX): ',0        
        public  PCISlotValue
PCISlotValue            db      '    ',0
        public  FullDuplexMsg
FullDuplexMsg           db      'Full-Duplex,',0
        public  HalfDuplexMsg
HalfDuplexMsg           db      'Half-Duplex,',0
        public  LineSpeed10Msg
LineSpeed10Msg          db      'LineSpeed=10',0
        public  LineSpeed100Msg
LineSpeed100Msg         db      'LineSpeed=100',0
        public  CableUnLink
CableUnLink             db      'Cable Disconnection',0
        public  first_name
        

first_name      db      'FETND$', 4 dup(0)

; add by Ben (2001/09/13), FLOW_CONTROL & CONNECTIONTYPE keywords messages
; -------------------------------------------------------------------------\
        public  msg_FLOWCTL_enable
msg_FLOWCTL_enable      db      'FLOW CONTROL enabled.', 0dh, 0ah, 0
        public  msg_FLOWCTL_disable
msg_FLOWCTL_disable     db      'FLOW CONTROL disable.', 0dh, 0ah, 0
        public  msg_FLOWCTL_HD
msg_FLOWCTL_HD          db      'FLOW CONTROL is hardware default.', 0dh, 0ah, 0
        public  msg_FLOWCTL_Err
msg_FLOWCTL_Err         db      'FLOW_CONTROL keyword value is wrong, use hardware default.', 0dh, 0ah, 0
        public  msg_CONTT_Err
msg_CONTT_Err           db      'CONNECTIONTYPE keyword value is wrong, use AUTO mode as default.', 0dh, 0ah, 0



; -------------------------------------------------------------------------/

NEWPAGE <Messages>
;-------------------------------------------------------------------
; initialization error messages.
;-------------------------------------------------------------------
msg_generalfailure  db  'MAC0001: Initialization failure',CR,LF,0
msg_invalidrhs      db  'MAC0004: Syntax error in PROTOCOL.INI - '
                    db  'Invalid Parameter Value',CR,LF,0
msg_nosuchkeyword   db  'MAC0005: Syntax error in PROTOCOL.INI - '
                    db  'Unrecognized Keyword',CR,LF,0
msg_nohardware      db  'MAC0006: Network Interface Hardware Not Found or Not Responding',CR,LF,0
msg_badconfigure    db  'MAC0007: Configuration error in PROTOCOL.INI',CR,LF,0
msg_crcerror        db  'MAC0008: Unexcepted Error happened in initialize',CR,LF,0
msg_pressakey       db  'Press any key to continue...',CR,LF,0
msg_crlf            db  0Dh, 0ah, 00
msg_equals          db  ' = ',0
msg_quote           db  '"', 0
msg_openparen       db  ' (0x', 0
msg_closeparen      db  ')', 0
msg_preamble        db  '-->      ', 0
msg_moretocome      db  ', ...', 0

;/** ethernetspec
keyn_drivername     db  'DRIVERNAME', 0
keyn_ioaddress      db  'IOBASE', 0
keyn_interrupt      db  'INTERRUPT', 0
keyn_netaddr        db  'NetworkAddress',0
keyn_earlyreceive   db  'EARLYRECEIVE',0
keyn_earlytransmit  db  'EARLYTRANSMIT',0
keyn_fullduplex     db  'FULLDUPLEX',0
keyn_linespeed      db  'SPEED',0
keyn_auto           db  'AUTO',0
;keyn_slot           db  'SLOT',0
keyn_connectiontype db  'CONNECTIONTYPE', 0         ; added by Ben (2001/03/07)
;keyn_flowctl        db  'FLOW_CONTROL', 0           ; added by Ben (2001/09/13)
keyn_flowctl        db  'FLOWCTRL',0
keyn_valpktlen      db  'VALPKTLEN', 0              ; added by guard (2002/06/21)
keyn_busno          db  'BUSNO',0                   ; added by guard (2003/05/07)
keyn_deviceno       db  'DEVICENO',0                ; added by guard (2003/05/07)
;***************************************************************\
; PlugNPlay address port assignments                            *
;***************************************************************/
public  DSSave,ESSave
public  NumberOfNIC,PCiIOBase
public  PCIINT,PCIID,PCIEtherID
public  PCIAdapterNotFoundMsg,PCISLOTNoMatchMsg
public  InterruptMsg,IoportMsg,Ioport1
public  PCIEntry,PCIBDFNumber
public  Mechanism,Bus_Info
public  pciIOBase1
Mechanism               db      0
Bus_Info                dw      0
PCIEntry                dd      0
PCIBDFNumber            dw      0
DSSave                  dw      0
ESSave                  dw      0
NumberOfNIC             db      0
pciIOBase               dw      4    dup(0)
pciIOBase1              dw      4    dup(0)
        public  BusNo
        public  DeviceNo
        public  pciINT
        public  DeviceNo1
        public  BusNo1
        public  pciINT1
        public  IntLevel1
BusNo                   dw      4    dup(0)
DeviceNo                dw      4    dup(0)
pciINT                  db      4    dup(0)
BusNo1                  dw      4    dup(0)
DeviceNo1               dw      4    dup(0)
pciINT1                 db      4    dup(0)

pciID                   db      6     dup (0)
pciEtherID              db      6 * 4 dup (0)
pciAdapterNotFoundMsg   db      'PCIID keyword specified but PCI Adapter Not Found.',0dh,0ah,0
PCISLOTNoMatchMsg       db      'PCI Slot value Not match any Adapter.',0dh,0ah,0
InterruptMsg            db      '      Interrupt = 0x'
IntLevel1               db      0,0dh,0ah,0
IoportMsg               db      '      Iobase    = 0x'
Ioport1                 db      4 dup(0),0dh,0ah,0

public BusNoPrompt
public DeviceNoPrompt
public IOBasePrompt
public AddrPrompt
public CRLFMsg
public ChoicePrompt
public ClosePrompt
BusNoPrompt             db      '. Bus ',0
DeviceNoPrompt          db      ' Device ',0
IOBasePrompt            db      ' IOBase=',0
AddrPrompt              db      ' Node Address: 0x',0
CRLFMsg                 db      0dh,0ah,0
ChoicePrompt    db      'Please chose a card (1-',0
ClosePrompt     db      '):',0
;**/
                END_INIT_DATA
                BEGIN_INIT_CODE

NEWPAGE <upcase/hexchar/charhex>
;------ upcase --------------------------------------------------------------;
;                                                                            ;
;       Converts a character in AL from lowercase to uppercase.              ;
;                                                                            ;
;       This implementation is for U.S. ASCII.                               ;
;                                                                            ;
;       Assumes:                                                             ;
;       AL = character to convert, or not                                    ;
;                                                                            ;
;       Returns:                                                             ;
;       AL = uppercase character                                             ;
;                                                                            ;
;       Preserves all other registers.                                       ;
;                                                                            ;
;----------------------------------------------------------------------------;

                public  upcase                  ; "
upcase          proc    near
                cmp     al, 'a'
                jb      @F
                cmp     al, 'z'
                ja      @F
                sub     al, 'a'-'A'
@@:             ret
upcase          endp

;------ hexchar -------------------------------------------------------------;
;                                                                            ;
;       Converts a binary digit in AL to a hex character.                    ;
;                                                                            ;
;       This implementation is for U.S. ASCII.                               ;
;                                                                            ;
;       Assumes:                                                             ;
;       AL = binary digit to convert                                         ;
;                                                                            ;
;       Returns:                                                             ;
;       AL = hex character, '0' thru 'F'                                     ;
;                                                                            ;
;       Preserves all other registers.                                       ;
;                                                                            ;
;----------------------------------------------------------------------------;

hexchar         proc    near
                add     al, '0'                 ; convert to ASCII
                cmp     al, '9'                 ; greater than 9?
                jbe     @F                      ; no, not in A-F range
                add     al, 'A'-'9'-1           ; map to uppercase letter
@@:             ret
hexchar         endp

;------ charhex -------------------------------------------------------------;
;                                                                            ;
;       Converts a hex character in AL to a binary digit.                    ;
;                                                                            ;
;       This implementation is for U.S. ASCII.                               ;
;                                                                            ;
;       Assumes:                                                             ;
;       AL = hex character, '0' thru 'F'                                     ;
;                                                                            ;
;       Returns:                                                             ;
;       AL = binary digit                                                    ;
;       carry set if an invalid character                                    ;
;                                                                            ;
;       Preserves all other registers.                                       ;
;                                                                            ;
;----------------------------------------------------------------------------;

charhex         proc    near
                cmp     al,'0'
                jb      ch_fail
                cmp     al,'9'
                ja      @F
                sub     al,'0'
                ret
@@:             call    upcase
                cmp     al,'A'
                jb      ch_fail
                cmp     al,'F'
                ja      ch_fail
                sub     al,'A' - 0Ah
                ret
ch_fail:        stc
                ret
charhex         endp

                END_INIT_CODE
                end
