;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: init.asm
; 
;  Purpose: This file contains the device strategy routine (where the INIT
;           packet is received), and any initialization routines.  Aside from
;           the strategy routine, most of the functions here should not be    
;           called except at INIT time as they are discarded.                    
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       devStrategy
;       devInterrupt
;       GetSysConfig
;       devInit
;       AdapterExists
;       Delay1Second
;       MiniSec
;       read_tick_counter
;       vCalculateRegistersAddresses
;       StringEquals
;       PutS
;       PutString
;       LongToASCII
;       PutKeyword
;       ParseKeyword
;       ParseNetAddr
;       ParseConfig
;       DoFLOWCTLKeyword
;       DoCONTTKeyword
;       MatchCONTypeText
;       vCompareString
;       PCIHexToInt
;       PCIIDProc
;       MatchSlot
;       FindPCIDevice
;       GetSlot
;       ReadConfigWord
;       ReadConfigByte
;       WriteConfigByte
;       GetEtherID
;       DELAY
;       IOIRQMsg
;       ConvertEtherID
;       ConvertSlot
;       ProcessDuplex
;       ForceNotNway
;       SetDuplex
;       ReAuto
;       MACminiDelay
;       MACmicroDelay
;       SetToSenseLink
;       vSetPCIMode2Register
;       vTurnOnMode10
;       vTurnOffMode10
;       vPCIGeneralSet
;       cCheckPHYVendor
;
;  Revision History:
;       01-15-2003 GuardKuo: add this copyright message
;
; 
                page    88,122
                title   INIT - Strategy routine and initialization (2.0.1 Spec)

.xlist
IFDEF OS2
include devsym.inc
include devhlp.inc
ENDIF
include includes.mac

IFDEF DBG
include DBGInter.inc
ENDIF
.list
.lfcond
.sall

.386
;------ Exported Interfaces -------------------------------------------------;

        DOSPUBL devInterrupt
        ;public  AdapterExists
        ;public  ParseConfig
        ;public  ParseKeyword
        ;public  ParseNetAddr
        ;public  PutKeyword
        public  PutString
        ;public  PutS
        ;public  StringEquals
        ;public  devInit
        public  devStrategy
        ;public  DoFLOWCTLKeyword        ; added by Ben (2001/09/14)
        ;public  DoCONTTKeyword          ; added by Ben (2001/09/14)
        
        
;-------Imported Interfaces -------------------------------------------------;

        OS2XTRN DOSCLOSE:FAR            ; OS/2 API Function
        OS2XTRN DOSDEVIOCTL:FAR         ; OS/2 API Function
        OS2XTRN DOSOPEN:FAR             ; OS/2 API Function
        OS2XTRN DOSPUTMESSAGE:FAR       ; OS/2 API Function
        OS2XTRN KBDCHARIN:FAR           ; OS/2 API Function
        
        
        extrn   MIIRead:near
        ;extrn   MIIWrite:near
        extrn   MIITurnOnBits:near
        extrn   MIITurnOffBits:near
        extrn   SenseLinkUnLink:near
        extrn   MIIDelay:near
        extrn   SetToFullDPX:near
        extrn   SetTOHalfDPX:near
        extrn   QueryAuto:near
        extrn   vMACSoftwareReset:near  ; Added by Ben (07/11/2000)
        extrn   vPhyModeStatus:near     ; Added by Ben (08/17/2001)
        extrn   vSetAUTO_REAUTO:near    ; Added by Ben (08/17/2001)
        extrn   vSetFlowCTL:near        ; Added by Ben (09/24/2001)
        extrn   vSetMIIANAR:near        ; Added by Ben (09/24/2001)
        extrn   vSetMIIBMCR:near        ; Added by Ben (09/24/2001)

IFDEF PROTECTED
        extrn   VerifySromCRC32:near    ; Added by guard (05/24/2003)
ENDIF
IFDEF ANYSTATS
        OS2XTRN DOSGETINFOSEG:FAR       ; OS/2 API Function
ENDIF
        IFDEF   DYNAALLOC
        extrn   MEMReSize:near
        extrn   MEMDynaAlloc:near
        ENDIF
        DOSXTRN DDStkOff:WORD
        DOSXTRN DDStkSeg:WORD
        DOSXTRN DDTopStk:WORD
        DOSXTRN saved_bx:WORD
        DOSXTRN saved_es:WORD
        OS2XTRN CharData:BYTE
        OS2XTRN devHelper:DWORD
        OS2XTRN dummy:WORD
        OS2XTRN physDS:DWORD
        OS2XTRN segRX:WORD
        OS2XTRN segTX:WORD
        
IFDEF ANYSTATS
        OS2XTRN infoSeg:WORD
        DOSXTRN TickHandler:FAR
        DOSXTRN timerChain:DWORD
ENDIF

        extrn   EOIs:WORD
        extrn   IMRport:WORD
        extrn   IntLevel:BYTE
        OS2XTRN action_taken:WORD
        extrn   adapterBits:BYTE
        extrn   charhex:NEAR
        extrn   common:BYTE
        extrn   cs_ds:WORD
        extrn   days:WORD
        extrn   devHeader:WORD
        extrn   disableMask:BYTE
        extrn   enableMask:BYTE
        extrn   hexchar:NEAR
        extrn   keyword_table:WORD
        extrn   mdispatch:BYTE
        extrn   msg_badconfigure:BYTE
        extrn   msg_closeparen:BYTE
        extrn   msg_crlf:BYTE
        extrn   msg_equals:BYTE
        extrn   msg_generalfailure:BYTE
        extrn   msg_invalidrhs:BYTE
        extrn   msg_moretocome:BYTE
        extrn   msg_nohardware:BYTE
        extrn   msg_crcerror:BYTE          
        extrn   msg_nosuchkeyword:BYTE
        extrn   msg_openparen:BYTE
        extrn   msg_preamble:BYTE
        extrn   msg_pressakey:BYTE
        extrn   msg_quote:BYTE
        extrn   msg_signon:BYTE
        extrn   OKMsg:BYTE
        extrn   ReAutoMsg:BYTE
        extrn   msg_LineSpeed:BYTE
        extrn   msg_10M:BYTE
        extrn   msg_100M:BYTE
        extrn   msg_FullDuplex:BYTE
        extrn   msg_HullDuplex:BYTE
        extrn   number_buffer:BYTE
        extrn   our_name:WORD
        extrn   protmgr_handle:WORD
        extrn   protmgr_name:BYTE
        extrn   qtarray:BYTE
        extrn   ramSize:BYTE
        extrn   rqblock:WORD
        extrn   second_name:BYTE
        extrn   specific:BYTE
        extrn   state:BYTE
        extrn   status:BYTE
        extrn   upcase:near
        extrn   DSSave:word
        extrn   ESSave:word
        extrn   NumberOfNIC:byte
        extrn   PCIIOBase:word
        extrn   PCIINT:byte
        extrn   UsedSlotArray:byte              ; added by Ben (2001/03/07)
        extrn   PCIRevisionId:byte
        extrn   PCIID:byte
        extrn   PCIEtherID:byte
        extrn   PCIAdapterNotFoundMsg:byte
        extrn   PCISLOTNoMatchMsg:byte
        extrn   InterruptMsg:byte
        extrn   LineSpeed10Msg:byte
        extrn   CableUnLink:byte
        extrn   LineSpeed100Msg:byte
        extrn   FullDuplexMsg:byte
        extrn   EtherIDMsg:byte
        extrn   EthernetID:byte
        extrn   HalfDuplexMsg:byte
        extrn   IntLevel1:byte
        extrn   IoportMsg:byte
        extrn   Ioport1:byte
        extrn   PCIEntry:dword
        extrn   PCIBDFNumber:word
        extrn   Mechanism:byte
        extrn   Bus_Info:word
        extrn   SlotIndex:word

        extrn   len:word
        extrn   add1:dword
        extrn   buf:byte
        extrn   SlotValue:word
        extrn   PCISlotValue:byte
        extrn   PCISlotMsg:byte
        extrn   F000Save:word
        extrn   BusNo:word
        extrn   DeviceNo:word
        extrn   UserBusNo:word
        extrn   UserDeviceNo:word
        extrn   byMIIIndex:byte
        extrn   wMIIValue:word
        extrn   byUserOverride:byte
        extrn   LinkStatus:byte
        extrn   wStartTime:word
        extrn   dbCurrPhyMode:byte          ; Added by Ben (2001/08/17)
        extrn   SystemFlags:byte
        extrn   Ioport:word
        
        extrn   ERFlag:byte
        extrn   ETFlag:byte
        extrn   FDXFlag:byte
        extrn   AutoFlag:byte
        extrn   byLineSpeed:byte
        extrn   ConnectionType:byte         ; added by Ben (2001/03/07)
        extrn   wFLOWCTLFlag:word           ; added by Ben (2001/09/13)
        extrn   wOriPHYANARValue:word       ; added by Ben (2001/09/13)
        extrn   dbLegacyForcedMode:byte     ; added by Ben (2001/09/24)
        extrn   msg_FLOWCTL_Err:BYTE        ; added by Ben (2001/09/13)
        extrn   msg_CONTT_Err:BYTE          ; added by Ben (2001/09/13)
        extrn   SupportedFLOWCTL:WORD       ; added by Ben (2001/09/13)
        extrn   SupportedCONTYPE:WORD       ; added by Ben (2001/09/14)
        extrn   msg_FLOWCTL_enable:BYTE     ; Added by Ben (2001/09/13)
        extrn   msg_FLOWCTL_disable:BYTE    ; Added by Ben (2001/09/13)
        extrn   msg_FLOWCTL_HD:BYTE         ; Added by Ben (2001/09/13)
        extrn   dbUpdatRBRDU:byte           ; Added by Ben (2001/09/24)
        
        extrn   VT3043CardName:byte         ; Added by Ben (2003/01/04)
        extrn   VT3065CardName:byte         ; Added by Ben (2003/01/04)
        extrn   VT3106JCardName:byte        ; Added by Ben (2003/01/04)
        extrn   VT3106SCardName:byte        ; Added by Ben (2003/01/04)
        
        IFDEF   DYNAALLOC
        extrn   RXBufferSegment:word
        extrn   RXPhysicallAddr:word
        extrn   CurSEGmentCount:word
        extrn   wRxNumBuffers:word
        ENDIF
        IFDEF   OS2
        extrn   error_msg1:byte
        extrn   error_msg2:byte
        extrn   error_msg3:byte
        extrn   error_msg4:byte
        extrn   error_msg5:byte
        extrn   error_msg6:byte
        extrn   error_msg7:byte
        extrn   error_msg8:byte
        extrn   error_msg9:byte
        extrn   error_msg0:byte
        ENDIF        
        
        extrn   pciDeviceId:word
        extrn   pciRevisionID1:byte
        extrn   pciIOBase1:word
        extrn   BUSNo1:word
        extrn   PCIINT1:byte
        extrn   PCIDeviceID1:word
        extrn   pciRevisionId1:byte
        extrn   DeviceNo1:word
        
        extrn   sub_vendorid:word
CONFIG_ADDRESS          equ     0CF8h
CONFIG_DATA             equ     0CFCh
FLATBASE                equ     0
BSD_ENTRY_POINT         equ     4
BSD_LENGTH              equ     9
FET_VENDOR_ID           equ     1106h           ; changed for String Adjustment (2001/05/18) by Ben

;VT3065A : Device ID
;---------------------------------------\
FET_DEVICE_ID43         equ     3043h           ; changed for String Adjustment (2001/05/18) by Ben
FET_DEVICE_ID65         equ     3065h           ; changed for String Adjustment (2001/05/18) by Ben
FET_DEVICE_ID3106       equ     3106h           ; add by Ben for VT3106 (2001/08/06)
FET_DEVICE_ID3053       equ     3053h           ; add by Ben for VT3106 (2003/01/10)
;VT3065A : Device ID
;---------------------------------------/

REGISTER_IOBASE         equ     10h
REGISTER_IRQ            equ     3ch
REGISTER_REVISION_ID    equ     08h

NewIODelay MACRO
        out     0e1h, ax
        ENDM

NEWPAGE <devStrategy - device Strategy Routine>
;------ devStrategy ---------------------------------------------------------;
;                                                                            ;
;       This is the device driver's strategy routine, invoked by the         ;
;       operating system to initialize the driver and handle IOCTL requests. ;
;       In this driver the only request packet we expect to see is the INIT  ;
;       packet, since all other communication is done through direct         ;
;       procedure calls to macEntry from other ring 0 device drivers.        ;
;                                                                            ;
;       inputs:                                                              ;
;               es:bx = pointer to request packet                            ;
;                                                                            ;
;       All registers are saved and restored by OS/2.                        ;
;                                                                            ;
;----------------------------------------------------------------------------;
                BEGIN_CODE
devStrategy     proc    far
        ; -------------------------------------------------------------
        ; under DOS we merely save the packet for the interrupt routine
        ; -------------------------------------------------------------
IFDEF DOS
        mov     cs:saved_bx,bx          ; save bx
        mov     cs:saved_es,es          ; save es
        ret
devStrategy     endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
devInterrupt    proc    far
        PUSHR   ax,bx,cx,dx,si,di,ds,es,bp
        ; -------------------------------------------------------------
        ; since we only have about 20 bytes of stack space, switch stacks
        ; -------------------------------------------------------------
        cli
        mov     DDStkSeg,ss
        mov     DDStkOff,sp
        mov     ax,cs
        mov     ss,ax
        mov     sp, offset DGROUP:DDTopStk
        sti

        mov     ds,ax                   ; set DS = CS
        les     bx,dword ptr saved_bx   ; restore ES:BX
ENDIF
        ; ----------------------------------
        ; invoke periscope to load symbols
        ; ----------------------------------
        ;------ common DOS and OS/2 code --------------------------------------
        ; clear the direction flag to conform to Microsoft C calling conventions
        ;----------------------------------------------------------------------
        cld

        ; check the packet type
        ; ---------------------
        cmp     es:[bx].PktCmd,CMDInit  ; Init packet?
        je      strat_init

        ; bad packet
        ; ----------
        mov     es:[bx].PktStatus,STDON+STERR+3
        
        ; exit.  restore registers under DOS and return.
        ; ----------------------------------------------
strat_exit:
IFDEF DOS
        cli
        mov     ss,DDStkSeg             ; switch stacks back
        mov     sp,DDStkOff
        sti

        POPR    ax,bx,cx,dx,si,di,ds,es,bp
ENDIF
        ret

        ; device driver initialization.  under DOS we relocate this routine along
        ; the way so fake a far call.
        ; ----------------------------------------------------------------------
        public  strat_init
strat_init:
IFDEF DOS
        push    cs
ENDIF
        call    devInit
        jmp     short strat_exit

        ; under DOS we relocate the INIT code out of the way of the QSPACE in order
        ; to initialize it.  to do this it will branch here with everything set up
        ; for the copy and a return address on the stack.
        ; ---------------------------------------------------------------------
IFDEF DOS
        public  strat_copy
strat_copy:
        rep     movsb

        retf
ENDIF

        ; end of whichever procedure we're in.
        ; -------------------------------------
IFDEF DOS
devInterrupt    endp
ELSE
devStrategy     endp
ENDIF

        END_CODE


NEWPAGE <devInit - device driver initialization>
;------ devInit -------------------------------------------------------------;
;                                                                            ;
;       void devInit()                                                       ;
;                                                                            ;
;       ES:BX = pointer to init packet                                       ;
;                                                                            ;
;       Only the critical registers are saved.                               ;
;                                                                            ;
;       Device driver initialization routine.  Called from the device driver ;
;       Strategy Routine when an init packet is received from OS/2.          ;
;                                                                            ;
;       This routine retrieves the configuration pointer from the protocol   ;
;       manager and uses it to configure the driver.  If successful, it      ;
;       registers itself with the protocol manager.                          ;
;                                                                            ;
;       To allow two copies of the driver to be installed we first attempt   ;
;       to open our own device name.  If that is successful then we use an   ;
;       alternate name.                                                      ;
;                                                                            ;
;       This code is discarded at the end of initialization.                 ;
;                                                                            ;
;----------------------------------------------------------------------------;

        BEGIN_INIT_CODE

IFDEF DOS

GetSysConfig    proc    near

        mov     ah,0C0h
        int     15h
        jc      NotOnAPS2
        or      ah,ah
        jnz     NotOnAPS2
        test    byte ptr es:[bx+5],2        ;Micro channel bit set?
        jz      NotOnAPS2
        or      SystemFlags,PS2Flag
NotOnAPS2:
        push    sp
        pop     ax
        cmp     ax,sp
        jne     MustBeOnPCXT
        or      SystemFlags,ATFlag
MustBeOnPCXT:
        pushf
        pushf
        pop     ax
        or      ah,60h                  ; '`'
        push    ax
        popf
        pushf
        pop     ax
        test    ah,60h                  ; '`'

        jz      NotOn386

        or      SystemFlags, I386Flag

        ; Now see if this is a EISA machine.
        ; -------------------------------------
        mov     ax, 0f000h
        mov     es, ax
.386
        cmp     dword ptr es:[0ffdch], 'ASIE'   ;'EISA'?
        PRIV_CPU
        jne     NotEISABus

        or      SystemFlags, EISAFlag

NotEISABus:
NotOn386:
        popf
        ret

GetSysConfig          endp

ENDIF

        DLOCAL  device_packet
        DLOCAL  our_handle
IFDEF DOS
        DLOCAL  year
        DLOCAL  month
        DLOCAL  day
        DLOCAL  hour
        DLOCAL  minute
        DLOCAL  second
        DLOCAL  since,dword
ENDIF

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
devInit         proc    near
                LOCALS
        ; save packet address
        ; ---------------------
        mov     [bp].device_packet.off,bx
        mov     [bp].device_packet.segm,es

        ; display signon message
        ; -----------------------
        mov     di,offset DGROUP:msg_signon
        call    PutString

        mov     di,offset DGROUP:msg_crlf
        call    PutString

IFDEF DOS


        ; try and open our device name.  if not installed then just go on as normal
        ; ----------------------------------------------------------------------
        mov     dx,our_name
        mov     ax,3DC2h                ; open for private read
        int     21h                     ; call DOS to open
        jc      init_named
        mov     word ptr [bp].our_handle,ax
ELSE
        push    ds
        push    our_name
        push    ss
        lea     ax,[bp].our_handle
        push    ax
        push    ds
        lea     ax, DGROUP:action_taken
        push    ax
        push    0
        push    0                       ; file size (long)
        push    0                       ; file attribute
        push    1                       ; open flag: file must exist
        push    0C2h                    ; open mode (share R/W private)
        push    0
        push    0                       ; 0L reserved
        call    DOSOPEN
        test    ax,ax
        jnz     init_named
ENDIF

        ; close the other token ring driver
        ; ---------------------------------
IFDEF DOS
        mov     bx,word ptr [bp].our_handle
        mov     ah,3Eh
        int     21h
ELSE
        push    word ptr [bp].our_handle
        call    DOSCLOSE
ENDIF

        ; change the device name we'll use to allow a second copy to be installed
        ; -----------------------------------------------------------------------
        mov     our_name,offset DGROUP:second_name

        ; copy the name to be used to the device header
        ; ---------------------------------------------
init_named:
        mov     ax,ds                   ; compute strlen(our_name)
        mov     es,ax
        mov     di,our_name
        xor     ax,ax
        mov     cx,ax
        dec     cx                      ; set maximum to FFFFh
repne   scasb                           ; scan for null byte
        not     cx                      ; 1's complement remaining count
        dec     cx                      ; don't count null byte

        mov     si,our_name
        mov     di,offset DGROUP:devHeader.SDevName
rep     movsb                           ; copy it

        ; obtain address of DOS Device Helper routine and save in devHelper
        ; -----------------------------------------------------------------
IFDEF OS2
        les     bx,[bp].device_packet
        mov     ax,es:[bx].InitDevHlp.off
        mov     dx,es:[bx].InitDevHlp.segm
        mov     devHelper.off,ax
        mov     devHelper.segm,dx
ENDIF

        ; set up cs_ds to point at our data segment
        ; ------------------------------------------
IFDEF DOS
        mov     cs:cs_ds,ds
ELSE
        cli                             ; Protect PhysToVirt
        push    ds
        pop     es                      ; ES = DS
        push    cs
        pop     ds
        mov     si,offset CGROUP:cs_ds  ; DS:SI = address of cs_ds
        mov     dl,DevHlp_VirtToPhys    ; get AX:BX = physical cs_ds
        call    es:devHelper
        push    es
        pop     ds                      ; restore DS
        mov     cx,SIZE cs_ds           ; only one word writable
        mov     dh,1                    ; return in ES:DI
        mov     dl,DevHlp_PhysToVirt    ; writable selector please
        call    devHelper
        L0DS                            ; protect mode dataseg
        mov     es:[di].loword,ax       ; save it in CS:cs_ds
        mov     dl,DevHlp_UnPhysToVirt  ; release selector to OS/2
        call    devHelper
        sti                             ; UnProtect
ENDIF

        ; open the Protocol Manager
        ; -------------------------
IFDEF DOS
        mov     dx,offset CGROUP:protmgr_name
        mov     ax,3DC2h                ; open for private read
        int     21h                     ; call DOS to open
        SJC     init_fail
        mov     protmgr_handle,ax
ELSE
        push    ds
        lea     ax, DGROUP:protmgr_name
        push    ax
        push    ds
        lea     ax, DGROUP:protmgr_handle
        push    ax
        push    ds
        lea     ax, DGROUP:action_taken
        push    ax
        push    0
        push    0                       ; file size (long)
        push    0                       ; file attribute
        push    1                       ; open flag: file must exist
        push    0C2h                    ; open mode (share R/W private)
        push    0
        push    0                       ; 0L reserved
        call    DOSOPEN
        test    ax,ax
        SJNZ    init_fail
ENDIF

        ; invoke Protocol Manager with GET_PROTOCOL_MANAGER_INFO request block
        ; ---------------------------------------------------------------------
        mov     rqblock.rb_opcode,GET_PROTMAN_INFO
IFDEF DOS
        ;Format of NDIS request block for GetProtocolManagerInfo:
        ;Offset  Size    Description     (Table 01424)
        ;00h    WORD    01h
        ;02h    WORD    returned status (see #01434)
        ;04h    DWORD   returned pointer to structure representing parsed user config
        ;08h    DWORD   unused
        ;0Ch    WORD    returned BCD version of NDIS on which Protocol Manager is based
        ;-----------------------------------------------------------------------
        mov     bx,protmgr_handle       ; handle into bx
        mov     cx,SIZE ReqBlock        ; number of bytes to read
        mov     dx,offset CGROUP:rqblock ; buffer to read into
        mov     ax,4402h                ; IOCTL read call
        int     21h                     ; call DOS
        SJC     init_fail               ; did IOCTL fail?
ELSE
        push    0
        push    0                       ; data area address (none)
        push    ds
        lea     ax, DGROUP:rqblock      ; request block address
        push    ax
        push    IONC_PM                 ; device function (pr'cl mgmt)
        push    IOC_NC                  ; device category (net control)
        push    protmgr_handle          ; handle
        call    DOSDEVIOCTL
        test    ax,ax                   ; check OS return code
        SJNZ    init_fail
ENDIF
        mov     ax,rqblock.rb_status
        test    ax,ax                   ; check protmgr return code
        SJNZ    init_fail

        ; check the protocol manager version number against what we expect
        ; ----------------------------------------------------------------
        cmp     rqblock.rb_word1,PMGRVER_NEED
        SJB     init_fail

        ; parse the configuration image returned
        ; ----------------------------------------
        les     bx,rqblock.rb_pointer1

        call    ParseConfig
        test    ax,ax
        SJNZ    init_fail

        call    PCIIDProc     ;mmmmm
        test    ax,ax
        jnz     init_nohardware

        ; initialize the entries in the common module characteristics table that
        ; we couldn't initialize statically (such as pointers which need the ring
        ; 0 data selector rather than the current ring 3 selector).
        ; ---------------------------------------------------------------------
        L0DS
        mov     common.cc_DS,ax
        mov     common.cc_specific.segm,ax
        mov     common.cc_status.segm,ax
        mov     common.cc_udispatch.segm,ax

        L0CS
        mov     common.cc_system.segm,ax

        ; initialize entries in the MAC characteristics table (the permanent and
        ; current node addresses will have to wait until Bind time).  we'll fill
        ; in the transmit and receime space numbers after we get some info from
        ; the adapter itself.
        ; ----------------------------------------------------------------------
        L0DS
        mov     specific.mc_multicast.segm,ax
        mov     specific.mc_serial.segm,ax
        ;/** spec
        mov     status.ms_media_spec.segm,ax
        ;**/

        ; initialize entries in the MAC dispatch table
        ; --------------------------------------------
        L0DS
        mov     mdispatch.md_cctable.segm,ax

        L0CS
        mov     mdispatch.md_request.segm,ax
        mov     mdispatch.md_txchain.segm,ax
        mov     mdispatch.md_txferdata.segm,ax
        mov     mdispatch.md_rxrelease.segm,ax
        mov     mdispatch.md_indication_on.segm,ax
        mov     mdispatch.md_indication_off.segm,ax

        ; invoke Protocol Manager with REGISTER_MODULE for this adapter.
        ; when passing the pointer to the MAC's common module we have to supply the
        ; protected mode DS selector rather than the current ring 3 DS value.
        ;
        ; also note that the tables we are providing access to may not yet be
        ; completely filled in which is okay since the protocol manager doesn't
        ; look at it, and the protocol won't get it until binding with us.
        ; ----------------------------------------------------------------------
        mov     rqblock.rb_opcode,REGISTER_MODULE
        mov     rqblock.rb_pointer2.off,0
        mov     rqblock.rb_pointer2.segm,0
        mov     rqblock.rb_pointer1.off,offset DGROUP:common
        L0DS
        mov     rqblock.rb_pointer1.segm,ax
IFDEF DOS
        mov     bx,protmgr_handle        ; handle into bx
        mov     cx,SIZE ReqBlock         ; number of bytes to read
        mov     dx,offset CGROUP:rqblock ; buffer to read into
        mov     ax,4402h                 ; IOCTL read call
        int     21h                      ; call DOS
        SJC     init_fail                ; did IOCTL fail?
ELSE
        push    0
        push    0                       ; data area address (none)
        push    ds
        lea     ax, DGROUP:rqblock      ; request block address
        push    ax
        push    IONC_PM                 ; device function (pr'cl mgmt)
        push    IOC_NC                  ; device category (net control)
        push    protmgr_handle          ; handle
        call    DOSDEVIOCTL
        test    ax,ax                   ; check OS return code
        sjnz    init_fail
        mov     ax,rqblock.rb_status
        test    ax,ax                   ; check protmgr return code
        sjnz    init_fail
ENDIF

        ; reserve GDT selectors for Token Ring Adapter memory access: segMMIO for
        ; MMIO access, segSM for shared memory access and segTX and segRX for doing
        ; PhysToGDT for the transmit and receive sides.  Don't assume they're
        ; contiguous.
        ; -----------------------------------------------------------------------
IFDEF OS2
        mov     cx,1
        push    ds
        pop     es
        mov     di,offset DGROUP:segTX
        mov     dl,DevHlp_AllocGDTSelector
        call    devHelper
        SJC     init_fail
        mov     di,offset DGROUP:segRX
        call    devHelper

ENDIF

        ; if FASTGDT is defined, set physDS to the physical address of DS:0
        ; ------------------------------------------------------------------
IFDEF FASTGDT
        xor     si,si                   ; DS:SI is virtual address
        mov     dl,DevHlp_VirtToPhys
        call    devHelper
        SJC     init_fail
        mov     physDS.hiword,ax
        mov     physDS.loword,bx
ENDIF

        ; and point segTX and segRX at DS:0 to get all the fields initialized the way
        ; OS/2 wants them (so we can just fill in the offset and limit if we decide to
        ; do the PhysToGDT's ourselves, and not worry about the other fields).
        ;
        ; we could also fill in the limit field ahead of time, but filling it in
        ; correctly is just too useful as far as catching pointer errors.
        ; ----------------------------------------------------------------------
IFDEF FASTGDT
        mov     cx,1                    ; unusable for now
        mov     si,segTX
        mov     dl,DevHlp_PhysToGDTSelector
        call    devHelper
        SJC     init_fail

        mov     ax,physDS.hiword        ; reload just in case
        mov     si,segRX
        call    devHelper
        SJC     init_fail
ENDIF

        ; if the adapter type is known, just check if it exists.  if not known try
        ; PRIMARY first, then ALTERNATE if not found.
        ; ----------------------------------------------------------------------


        ;/** 920704
        ; -------------
IFDEF DOS
        call    GetSysConfig
ENDIF
        call    AdapterExists

        ;**/

init_found:
        test    ax,ax                   ; configuration error?
        SJNZ    init_problem



;       call    vCalculateRegistersAddresses

        ;-------------------------------------------------------------------
        ; [4.38] Stop MAC to prevent previous driver didn't release control
        ;-------------------------------------------------------------------
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.CommandReg
        xor     ax, ax
        or      ax, W_CR_STOP OR W_CR_DPOLL
        out     dx, ax

        mov     cx, 0fffh
INIT_WaitMacStop:
        in      al, dx
        test    al, W_CR_STOP
        jz      INIT_WaitMacStopFinish
        loop    INIT_WaitMacStop

INIT_WaitMacStopFinish:
        ;---------------------------------------------------S
        ;   Added by Ben (07/11/2000)
        ;   ------------------------
        ; Set MAC to D0 state 
        ; (Set STICKHW reg Bit0,1,2 off before accessing any regs)
        ;------------------------------------------------------------------
        cmp     pciRevisionId, 40h
        jb      short NoSetD0Mode43
      
        mov     bx, Ioport
        lea     dx, [bx].SCsrRegStruc.STICKHW           ;83h
        in      ax, dx
        and     al, 0fch
        out     dx, al
        
        lea     dx, [bx].SCsrRegStruc.WOLCGCLR          ;A7h
        mov     al, 80h
        out     dx, al
                
        lea     dx, [bx].SCsrRegStruc.WOLCRCLR          ;A4h
        mov     al, 0ffh
        out     dx, al
        
        lea     dx, [bx].SCsrRegStruc.PWRCSRCLR         ;ACh
        mov     al, 0ffh
        out     dx, al

        lea     dx, [bx].SCsrRegStruc.CommandReg
        in      al ,dx
        test    al, W_CR_STOP
        jz      init_problem


        ;---------------------------------
        ; (2003/09/19) Added by guard
        ; eeprom reload
        ;---------------------------------
        lea     dx, [bx].SCsrRegStruc.MIISR             ;6dh
        in      al, dx
        or      al, EECSR_AUTOLD
        out     dx, al

        mov     cx, 0fffh
WaitEEPROMAutoLoadFinish:
        in      al, dx
        test    al, EECSR_AUTOLD
        jz      EEPROMAutoLoadFinish
        loop    WaitEEPROMAutoLoadFinish
EEPROMAutoLoadFinish:

        ;-------------------------------------------------------------------------
        ; added by guard(2004/02/20)
        ; EEPROM reloaded will cause bit 0 in MAC_REG_CFGA turned on.
        ; it makes MAC receive magic packet automatically. So, driver turn it off
        ;-------------------------------------------------------------------------
        cmp     pciRevisionId, RevisionID3065
        jb      ClearPACPIOver
        lea     dx, [bx].SCsrRegStruc.CFGA
        in      al, dx
        and     al, 0feh
        out     dx, al
ClearPACPIOver:

NoSetD0Mode43:        

    	;-----------------------------------
    	; added by guard (05/23/2003)
    	; Driver protection for D-Link
    	; Only in VT6105 and VT6105M
    	;-----------------------------------
    	;IFDEF   PROTECTED
	    ;cmp     pciRevisionId,RevisionID3106J
	    ;jb      UnProtection
	    ;call    VerifySromCRC32
        ;jnz     init_eepromerror
        ;UnProtection:
	    ;ENDIF   ;DLINK

        ;------------------------------------------
        ; added by guard (2003/08/05)
        ; dynamic allocate RX buffer
        ; for VT3119 pre test
        ;------------------------------------------
        IFDEF   DYNAALLOC

        lea     ax, RXPhysicallAddr
        push    ax
        lea     ax, RXBufferSegment
        push    ax
        push    wRxNumBuffers
        mov     ax, W_RX_BUFFER_SIZE
        push    ax
        call    MEMDynaAlloc
        jc      init_problem

        ENDIF
        ; initialize the date/time statistics last cleared to the current time, in
        ; number of seconds since January 1, 1970.  under OS/2 we can just get this
        ; out of the InfoSeg.
        ; ----------------------------------------------------------------------
IFDEF ANYSTATS
IFDEF OS2
        push    ds
        lea     ax, DGROUP:infoSeg
        push    ax
        push    ds
        lea     ax, DGROUP:dummy
        push    ax
        call    DOSGETINFOSEG

        mov     es,infoSeg
        mov     ax,es:[is_elapsed].loword
        mov     dx,es:[is_elapsed].hiword
        mov     status.ms_cdate.loword,ax
        mov     status.ms_cdate.hiword,dx
ENDIF
ENDIF

        ; under DOS this is MUCH harder.  the only date/time we have is in the usual
        ; units, and we'll have to convert.  we'll use the same logic as the Microsoft
        ; C 5.1 time function, though we'll ignore such issues as time zone and
        ; daylight savings time.  and leap years are easy for the next century or
        ; so, since the every 4, but not every century, but every 400 years means that
        ; the every 4 rule works for the year 2000.
        ;
        ; note the check for date changed around getting time--otherwise we could be
        ; off by 24 hours.
        ; ----------------------------------------------------------------------
IFDEF ANYSTATS
IFDEF DOS
        mov     [bp].year.loword,0
        mov     [bp].month.loword,0
        mov     [bp].day.loword,0
        mov     [bp].hour.loword,0
        mov     [bp].minute.loword,0
        mov     [bp].second.loword,0

@@:     mov     ah,2Ah                  ; get date
        int     21h                     ; CX=year DH=month DL=day
        mov     [bp].year.loword,cx
        mov     [bp].month.lobyte,dh
        mov     [bp].day.lobyte,dl

        mov     ah,2Ch                  ; get time
        int     21h                     ; CH=hour CL=min DH=sec
        mov     [bp].hour.lobyte,ch
        mov     [bp].minute.lobyte,cl
        mov     [bp].second.lobyte,dh

        mov     ah,2Ah                  ; get date again
        int     21h
        cmp     cx,[bp].year.loword     ; still the same?
        jne     @B                      ; nope, try again
        cmp     dh,[bp].month.lobyte
        jne     @B
        cmp     dl,[bp].day.lobyte
        jne     @B

        sub     [bp].year.loword,1980   ; offset year from 1980

        mov     cx,[bp].year.loword     ; CX=(year+3)/4
        add     cx,3
        shr     cx,1
        shr     cx,1

        mov     bx,0001h                ; BX:AX = 00015180h
        mov     ax,5180h                ;       = 24 * 60 * 60
                                        ;       = seconds/day

        mul     cx                      ; since = (year+3)/4 * secs/day
        mov     [bp].since.hiword,dx
        mov     [bp].since.loword,ax
        mov     ax,bx
        mul     cx
        add     [bp].since.hiword,ax

        mov     bx,[bp].month.loword    ; BX=month
        dec     bx
        shl     bx,1
        mov     ax,days[bx]             ; AX=days[month-1]
        cmp     [bp].month.loword,2     ; if month > february
        jbe     @F
        test    [bp].year.loword,3      ; and year is leap
        jnz     @F
        inc     ax                      ; then add one more day
@@:     mov     cx,ax                   ; monthdays in CX for now

        mov     ax,[bp].year.loword     ; AX=year
        mov     bx,365
        mul     bx                      ; AX=year*365
        add     ax,[bp].day.loword      ; AX=year*365+day
        add     ax,cx                   ; AX=year*365+day+monthdays
        mov     cx,ax                   ; daysince in CX for now

        mov     bx,0001h                ; BX:AX = 00015180h
        mov     ax,5180h                ;       = 24 * 60 * 60
                                        ;       = seconds/day
        mul     cx                      ; since += daysince * secs/day
        add     [bp].since.loword,ax
        adc     [bp].since.hiword,dx
        mov     ax,bx
        mul     cx
        add     [bp].since.hiword,ax

        mov     ax,[bp].hour.loword     ; AX = hour
        mov     cx,3600
        mul     cx                      ; DX:AX = hour*3600
        add     [bp].since.loword,ax    ; update since
        adc     [bp].since.hiword,dx

        mov     ax,[bp].minute.loword   ; AX = minute
        mov     cx,60
        mul     cx                      ; AX = minute*60
        add     [bp].since.loword,ax    ; update since
        adc     [bp].since.hiword,dx

        mov     ax,[bp].second.loword   ; AX = second
        add     [bp].since.loword,ax    ; update since
        adc     [bp].since.hiword,0

        add     [bp].since.loword,0A600h; 12CEA600 = seconds in 1970-79
        adc     [bp].since.hiword,012CEh; update since

        mov     ax,[bp].since.loword    ; update status table clear time
        mov     dx,[bp].since.hiword
        mov     status.ms_cdate.loword,ax
        mov     status.ms_cdate.hiword,dx
ENDIF
ENDIF

        ;/** 920704
        ; since DOS is not reentrant, we'll just accumulate ticks to add to this time
        ; every time ClearStatistics is issued.  install our own tick handler in the
        ; chain for INT 08h
        ; ----------------------------------------------------------------------
IFDEF ANYSTATS
IFDEF DOS
        mov     ax,3508h                ; get interrupt vector 08h
        int     21h                     ; returns ES:BX
        mov     timerChain.segm,es      ; and save it
        mov     timerChain.off,bx

        mov     ax,2508h                ; install a interrupt handler
        mov     dx,offset CGROUP:TickHandler
        int     21h                     ; takes DS:DX
ENDIF
ENDIF
        ; change state to initialized
        ; -----------------------------
        mov     state,INITIALIZED

        ; successful initialization.  close the protocol manager.
        ; ----------------------------------------------------------------------
IFDEF DOS
        mov     bx,protmgr_handle
        mov     ah,3Eh
        int     21h
ELSE
        push    protmgr_handle
        call    DOSCLOSE
ENDIF

        ; return terminating addresses of code and data under OS/2 or the end of
        ; driver under DOS (assumes that LASTCODE precedes LASTDATA in CGROUP).  to
        ; determine this we need to retain exactly the right number of transmit
        ; queue entries that will be needed.
        ; ----------------------------------------------------------------------
        ;/** 920612
        mov     ax,offset DGROUP:qtarray
        ;**/

        les     bx,[bp].device_packet
IFDEF DOS
        mov     es:[bx].InitpEnd.off,ax
        mov     es:[bx].InitpEnd.segm,cs
ELSE
        mov     es:[bx].InitEcode,offset LASTCODE:0
        mov     es:[bx].InitEdata,ax
ENDIF

        ; we now want to fill in the QSPACE.  but since its going to be allocated
        ; over top of the initialization code/data under DOS, we have to move ourselves
        ; out of the way first.  CS:AX is the end of QSPACE.  since the copy operation
        ; may overlap, we do it out of the code that isn't moved, keeping as much here
        ; as possible to keep the code size down.  since there are no transmit queue
        ; entries allocated statically under DOS, it is guaranteed that the new location
        ; for the INIT code will be greater than its current location so we can safely
        ; do the copy backwards in case of overlap.  once relocated we should reference
        ; init data through cs: and avoid making calls to procedures not in init code.
        ; ----------------------------------------------------------------------
IFDEF DOS
        mov     dx,cs                   ; CS:AX is end of QSPACE
        mov     cl,4                    ; offset >> 4
        shr     ax,cl
        add     ax,dx                   ; adjusted by CS
        inc     ax                      ; plus one is next segment
        mov     es,ax                   ; point at it with ES:DI
        xor     di,di
        mov     si,offset DGROUP:BEFORELAST ; DS:SI points at init code/data
        mov     cx,offset DGROUP:AFTERLAST
        sub     cx,offset DGROUP:BEFORELAST ; CX is size of init code/data
        add     si,cx                   ; set up for reverse direction
        dec     si
        add     di,cx
        dec     di
IF  0
        std
        push    es                      ; set up return address
        mov     ax,offset LASTCODE:init_relocated
        push    ax

        ; Use masm 5.1a compile, masm 6.0 will jump to error location
        ; cause program hang.    MASM51A
        ; ----------------------------------------------------------------------
        jmp     strat_copy

        ;rep     movsb
        ;retf

        public  init_relocated
init_relocated:
ENDIF
        cld
ENDIF

        ; exit, indicate packet has been processed.  under DOS, return far in case
        ; we've been relocated along the way.
        ; ----------------------------------------------------------------------
init_exit1:
        ;---------------------------------------------------
        ; 2003 5 27 marked by guard
        ; move to before registing protocol managment
        ; because checked EEPROM needing some MAC registers.
        ; if we check EEPROM after registed protocol managment,
        ; when the check fail, the system will be reboot
        

        ;---------------------------------------------------E

        ; EEPROM maybe force speed duplex mode
        ;--------------------------------------------------------------
        push    ax
        push    dx
        
        mov     bx, Ioport
        
        ; add by Ben (2001/08/06), in VT3106, there will be no
        ; EEPROM Force mode. The bits definitons had been changed
        ; to other functions. 
        ; ------------------------------------------
        ; VT3106 :
        ;   No EEPROM forced mode. So dbLegacyForcedMode is always 0
        ; VT3065 :
        ;   If EEPROM force enable, then set dbLegacyForcedMode=1,
        ;   else, set to 0.
        ; VT3043 :
        ;   No matter EEPROM force enable or not, always set
        ;   dbLegacyForcedMode=1
        ; --------------------------------------------------------        
        cmp     pciRevisionId, 80h
        jae     NoEEPROMforce               ; dbLegacyForcedMode is always 0 in VT3106
        
        ; ------------------------
        ;       VT3043 or VT3065
        ; ------------------------
        lea     dx, [bx].SCsrRegStruc.CFGC
        in      al, dx
        test    al, 80H                     ;if eeprom force enable
        jz      NoEEPROMforce
        
        lea     dx, [bx].SCsrRegStruc.BCR0
        in      al, dx
        test    al, 80H                     ;if med2=0
        jz      MED1equal0

MED1equal1:
        lea     dx, [bx].SCsrRegStruc.BCR1
        in      al, dx
        and     al, 0C0H
        cmp     al, 00H
        je      AutoMode

AutoMode:
        mov     AutoFlag, 1
        jmp     NoEEPROMforce
        
MED1equal0:
        lea     dx, [bx].SCsrRegStruc.BCR1
        in      al, dx
        and     al, 0C0H
        cmp     al, 0C0H
        je      Full100Mode
        cmp     al, 80H
        je      Full10Mode
        cmp     al, 40H
        je      Half100Mode
        cmp     al, 00H
        je      Half10Mode

Full100Mode:
        mov     FDXFlag, 1
        mov     byLineSpeed, 100
        jmp     SetdbLegacyForcedMode           ; modified by Ben (2001/09/24)
                                                ; NoEEPROMforce->SetdbLegacyForcedMode

Full10Mode:
        mov     FDXFlag, 1
        mov     byLineSpeed, 10
        jmp     SetdbLegacyForcedMode           ; modified by Ben (2001/09/24)
                                                ; NoEEPROMforce->SetdbLegacyForcedMode

Half100Mode:
        mov     FDXFlag, 0
        mov     byLineSpeed, 100
        jmp     SetdbLegacyForcedMode           ; modified by Ben (2001/09/24)
                                                ; NoEEPROMforce->SetdbLegacyForcedMode

Half10Mode:
        mov     FDXFlag, 0
        mov     byLineSpeed, 10
        jmp     SetdbLegacyForcedMode           ; modified by Ben (2001/09/24)
                                                ; NoEEPROMforce->SetdbLegacyForcedMode
        ; add by Ben (2001/09/22), set dbLegacyForcedMode=1.
        ; -------------------------------------------------
SetdbLegacyForcedMode:
        mov     AutoFlag, 0                     ; the default value is 1
        mov     dbLegacyForcedMode, 1           ; for distinguish to use Nway forced
                                                ; mode or legacy forced mode in
                                                ; ForceNotNway(). The default value
                                                ; of dbLegacyForcedMode=0.
        
NoEEPROMforce:
        ; add by Ben (2001/09/22), even no EEPROM forced, 
        ; in VT3043, we still need to use legacy forced mode if
        ; user set up forced mode.
        ; If in VT3065 or VT3106, just use
        ; ---------------------------------------------------\
        IFDEF   NONWAYFORCEMODE
        ;---------------------------------------------------------
        ; add by guard (2003/05/21), compare Dlink's requirement,
        ; disable NWay Forced Mode
        ; use legacy forced mode in all driver
        ;---------------------------------------------------------
        
        mov     dbLegacyForcedMode, 1
        ELSE
        cmp     pciRevisionId, 40h
        jnb     NOTVT3043Legacy
        mov     dbLegacyForcedMode, 1           ; No EEPROM Forced, but in VT3043
        ENDIF
NOTVT3043Legacy:
        ; ---------------------------------------------------/
        pop     dx
        pop     ax

        
        ;---------------------------------------------------S
        ;   Added by Ben (07/11/2000)
        ;   ------------------------                
        call    vMACSoftwareReset
        ;---------------------------------------------------E        
       

        ;Vt3065A : LongDelay
        ; ----------------------
        mov     ax, 0002h               ; about 0.983 * 2 ms
        call    MACminiDelay


        mov     bx, Ioport

        ;Set CAP , CFGD[2] = 1(Dont' set CAP for conforming 802.3 spec.)
        ; ---------------------------------------------------------------
        lea     dx, [bx].SCsrRegStruc.CFGD
        in      al, dx
        
       
        ; added by Ben (10/20/00), for conforming 802.3 spec.
        ; -----------------------------------------------------------
        and     al, 0f0h
        out     dx, al
        
        ;Added by Charles Yu 3/02/99
        ;Disable Transmit frame queuing
        ; --------------------------------
        lea     dx, [bx].SCsrRegStruc.CFGB
        in      al, dx

        ; Check chip whether 3065 or not
        ;-------------------------------
        cmp     pciRevisionId, 40h
        jae     QPacketChip3065
        or      al, 80h                 ; QPacketDis is set to 1
        jmp     ExitQPacketChip3065
        
QPacketChip3065:
        and     al, 7Fh                 ; QPacketDis is set to 0
        
ExitQPacketChip3065:
        out     dx, al

        ; ----------------------------------------------------------------------/

        ; add by Ben (2001/09/14), read PHY ANAR value, no 
        ; matter in VT3065 or VT3106
        ; ----------------------------------------------------
        ; It's different from DOS ODI or OS2 ODI (this block is
        ; executed in vSetPhyModeCfg() directly. It's because
        ; vSetPhyModeCfg() is called before calling ProcessDuplex()).
        ; That means CResetNIC()->vSetPhyModeCfg() is before ProcessDuplex().
        ;
        ; In NDIS2 ODI, ProcessDuplex() is calling before vSetPhyModeCfg().
        ; (ResetNIC()->vSetPhyModeCfg(), it's not in initial state).
        ; ----------------------------------------------------\
        mov     byMIIIndex, MII_REG_ANAR                  ; ANAR
        call    MIIRead                         ; AX=ANAR value
        mov     wOriPHYANARValue, ax
        ; ----------------------------------------------------/
        
        ; add by Ben (2001/09/24), for settiing flow control registers
        ; The function must be called before ProcessDuplex(), because
        ; we will reauto when calling ProcessDuplex() if ANAR's value
        ; is different from original, which is saved in wOriPHYANARValue.
        ; -------------------------------------------------------------\
        mov     dbUpdatRBRDU, 1
        call    vSetFlowCTL
        mov     dbUpdatRBRDU, 0
        ; -------------------------------------------------------------/
        
        call    ProcessDuplex

        ;//////////////////////////////
        ;Modified by Charles Yu 1/07/99
        ;3043 --> Bit[1]=1 LED4_MODE (10M Full LED bit)
        ;3071 --> Bit[7]=1 Activity_LED_On
        ;//////////////////////////////
        mov     al, pciRevisionId
        cmp     al, 40h
        jae     DEV_JumpOut
        cmp     al, 20h
        jge     DEV_3071
        
        ;The chip is 3043
        ; ------------------------
        mov     byMIIIndex, 17h
        mov     wMIIValue, 0001h
        call    MIITurnOnBits
        jmp     DEV_JumpOut
        
DEV_3071:
        ;The Chip is 3071
        ; -----------------------------
        mov     byMIIIndex, 17h
        mov     wMIIValue, 0080h
        call    MIITurnOnBits
DEV_JumpOut:
        ;/////////////////////////////

        IFDEF   LinkChange
        call    SetToSenseLink
        call    SenseLinkUnLink
        ENDIF

        
UserSpeedOver:
        call    IoIRQmsg

init_exit:
        les     bx,[bp].device_packet
        mov     es:[bx].InitcUnit,0             ; character device
        
IFDEF OS2
        mov     es:[bx].InitpBPB.off,0
        mov     es:[bx].InitpBPB.segm,0
ENDIF
        mov     es:[bx].PktStatus,STDON
        leave
IFDEF DOS
        retf
ELSE
        ret
ENDIF

        ; PHY Vendor check error, message to user
        ;-----------------------------------------
init_isnotviaphy:

        ; EEPROM check error. message to user.
        ;-------------------------------------
init_eepromerror:
        mov     di, offset DGROUP:msg_crcerror
        mov     state,NOT_MAINTAINED
        mov     ax, CONFIGURATION_FAILURE
        jmp     short init_msgfail   


        ; configuration problem.  message to user.
        ; -----------------------------------------
init_problem:
        mov     di,offset DGROUP:msg_badconfigure
        jmp     short init_msgfail

        ; hardware not found.  message to user.
        ; -----------------------------------
init_nohardware:
        mov     di,offset DGROUP:msg_nohardware

        ; message to user in DI.
        ; -----------------------
init_msgfail:
        call    PutString

        ; failure to initialize driver.  message to user.
        ; ------------------------------------------------
init_fail:
        mov     di,offset DGROUP:msg_generalfailure
        call    PutString

        mov     di,offset DGROUP:msg_pressakey
        call    PutString

        ; wait for a keystroke before continuing...
        ; ------------------------------------------
IFDEF OS2
        push    ds
        ;push    offset DGROUP:CharData
        lea     ax, DGROUP:CharData
        push    ax
        push    0                       ; wait until one is available
        push    0                       ; keyboard handle
        call    KBDCHARIN
ELSE
        xor     ax,ax
        int     16h
ENDIF

        ; don't install anything, return zero size(s)
        ; =------------------------------------------
        les     bx,[bp].device_packet
IFDEF DOS

        ; don't formally install. For DOS 3.2 the device header must be installed
        ; but nothing else. Thus, we set the first character in the device name to
        ; a blank so the header cannot be used later in applications.
        ; =-------------------------------------------------------------------
        mov     byte ptr cs:10,' '

        ; set the failed driver size to install just the header
        ; =----------------------------------------------------
        mov     es:[bx].InitpEnd.off,20
        mov     es:[bx].InitpEnd.segm,cs
ELSE
        mov     es:[bx].InitEcode,0
        mov     es:[bx].InitEdata,0
ENDIF

        jmp     init_exit
devInit         endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
AdapterExists   proc    near

        PUSHR   bx,cx,dx,si,di,bp,es
        mov     state,DECEASED ; DECEASED = 0FFh
        mov     al,IntLevel

        ; on an AT class machine interrupt level 2 can be trapped as either level 2
        ; or level 9 since the hardware treats it as level 9 and the BIOS contains
        ; a stub handler for level 9 which invokes level 2.  however, the IBM 3270
        ; Program requires level 2 so we use level 2.  under OS/2 they have given up
        ; hiding the fact that level 2 is really level 9 and we must treat it as
        ; level 9.  so we do an operating system sensitive translation here.  since
        ; OS/2 only runs on AT class machines we do not need any CPU sensing logic.
        ; =--------------------------------------------------------------------
IFDEF OS2
        cmp     al,2
        jne     @F
        mov     al,9
@@:
ENDIF

        ; save it in the MAC specific characteristics table.
        ; =--------------------------------------------------------------------
        xor     ah,ah
        mov     specific.mc_interrupt,ax
        
        ; set up IMRport and EOIs based on the interrupt level.  if the interrupt
        ; level is less than 8 then we use the master PIC, otherwise the slave.  EOIs
        ; is set up with the command to issue to the slave in the low byte and the
        ; command to issue to the master in the high byte.  if the interrupt level is
        ; less than 8 the command to the slave will be a NOP.
        ; =--------------------------------------------------------------------
        mov     IMRport,INT_1IMR
IFDEF DOS
        mov     EOIs,EOI_NOP+(EOI_NONSPEC*256)
ELSE
        xchg    al,ah                           ; int level in ah
        add     ax,EOI_NOP+(EOI_SPECIFIC*256)   ; specific EOI in ah
        mov     EOIs,ax
ENDIF
        cmp     specific.mc_interrupt,8
        jb      @F
        mov     IMRport,INT_2IMR
IFDEF DOS
        mov     EOIs,EOI_NONSPEC+(EOI_NONSPEC*256)
ELSE
        mov     EOIs,EOI_NONSPEC+((EOI_SPECIFIC+2)*256)
ENDIF
@@:

        ; compute interrupt enable/disable masks to use with the IMR (to enable
        ; interrupts for the adapter, AND enableMask with IMR, to disable interrupts
        ; for the adapter, OR disableMask with IMR)
        ; --------------------------------------------------------------------
        mov     cl,specific.mc_interrupt.lobyte
        and     cl,07
        mov     ah,1
        shl     ah,cl
        mov     disableMask,ah
        not     ah
        mov     enableMask,ah
        

        ; save the real-mode segment for use in ResetAdapter, then convert it to an
        ; OS/2 physical address in AX:BX
        ; =--------------------------------------------------------------------
aex_phys:

        mov     status.ms_flags.loword,ST_OK
        
        ; return with carry flag clear and AX set to zero (no error)
        ; =--------------------------------------------------------------------
        xor     ax,ax                   ; clears carry

        ; done.  carry flag indicates success.  release PhysToVirt selector.
        ; =--------------------------------------------------------------------
aex_exit:

        POPR    bx,cx,dx,si,di,bp,es
        ret

        ; configuration problem.  message to user.  return with carry flag clear.
        ; =--------------------------------------------------------------------
aex_problem:

        mov     ax,CONFIGURATION_FAILURE
        jmp     short aex_exit

AdapterExists   endp
if 0
; ----------------------------------
; This routine delays for 1 second.
; ----------------------------------
Delay1Second    proc    near

        push    ecx
        mov     ecx, 100
wait1second:
        call    MiniSec
        loop    wait1second
        pop     ecx
        ret
Delay1Second    endp

; ----------------------------------------
; This routine delays for 10 mini seconds.
; ----------------------------------------
MiniSec proc    near
        push    ax
        call    read_tick_counter
        mov     wStartTime, ax
wait1:
        call    read_tick_counter
        neg     ax
        add     ax, wStartTime
        cmp     ax, 23866
        jbe     wait1
        pop     ax
        ret
MiniSec endp

; ----------------------------------
; This routine read 8254 time tick
; ----------------------------------
read_tick_counter proc  near
        xor     ax, ax                  ; Clear accumulator.
        mov     al, 06h
        out     43h, al                 ; Command 8254 to latch T0's count
        in      al, 40h                 ; Read LSB first
        mov     ah, al
        in      al, 40h                 ; Read MSB
        xchg    al, ah                  ; Get in proper order
        ret
read_tick_counter endp
endif
NEWPAGE <StringEquals - Compare Two Strings>
;------ StringEquals --------------------------------------------------------;
;                                                                            ;
;       int StringEquals()                                                   ;
;                                                                            ;
;       SI = string A                                                        ;
;       ES:DI = string B                                                     ;
;                                                                            ;
;       Returns:                                                             ;
;                                                                            ;
;       Flags set for JE/JNE.                                                ;
;                                                                            ;
;       All other registers preserved.                                       ;
;                                                                            ;
;       Compares two ASCIIZ strings for equality, ignoring case.  Both       ;
;       strings must be terminated by a null byte.                           ;
;                                                                            ;
;----------------------------------------------------------------------------;

StringEquals    proc    near
                PUSHR   ax,si,di
;
; convert characters from each to uppercase and then compare.  stop on NULL.
;
streq_loop:
        mov     al,[si]
        mov     ah,es:[di]
        test    ax,ax
        jz      streq_exit
        call    upcase                  ; convert AL to uppercase
        xchg    ah,al                   ; swap characters
        call    upcase                  ; convert old AH to uppercase
        cmp     al,ah
        jne     streq_exit

        inc     si
        inc     di
        jmp     short streq_loop
streq_exit:
        POPR    ax,si,di
        ret
StringEquals    endp

NEWPAGE <PutString/PutString - display message to screen>
;------ PutString -----------------------------------------------------------;
;                                                                            ;
;       void PutString()                                                     ;
;                                                                            ;
;       ES:DI = pointer to null terminated string                            ;
;                                                                            ;
;       Registers AX,CX,DX and flags are destroyed.  All others preserved.   ;
;                                                                            ;
;       outputs a null-terminated string to the screen.  under OS/2 this     ;
;       function uses the DOSPUTMESSAGE function, so can only be used at     ;
;       initialization time.                                                 ;
;                                                                            ;
;----------------------------------------------------------------------------;

PutS            proc    near
        ; set CX to the number of bytes in the string not including the null
        ; -------------------------------------------------------------------
        push    di
        xor     ax,ax
        mov     cx,ax
        dec     cx              ; set maximum to FFFFh
repne   scasb                   ; scan for null byte
        not     cx              ; 1's complement the remaining count
        dec     cx              ; don't include the null in count
        pop     di

        ; put the string in ES:DI for CX bytes to stdout
        ; -------------------------------------------------------------------
IFDEF OS2
        push    1               ; standard output handle
        push    cx
        push    es
        push    di
        call    DOSPUTMESSAGE
ELSE
        push    ds
        push    bx
        mov     ax,es
        mov     ds,ax
        mov     dx,di
        mov     ah,40h          ; put string DS:DX for CX bytes
        mov     bx,1            ; standard output handle
        int     21h
        pop     bx
        pop     ds
ENDIF
        ret
PutS            endp

;------ PutString -----------------------------------------------------------;
;                                                                            ;
;       void PutString()                                                     ;
;                                                                            ;
;       DI = offset of null terminated string in data segment                ;
;                                                                            ;
;       Calls PutString after setting up ES.  The original value of ES       ;
;       is preserved across the call.                                        ;
;                                                                            ;
;----------------------------------------------------------------------------;

PutString       proc    near
        push    es
        mov     ax,ds
        mov     es,ax
        call    PutS
        pop     es
        ret
PutString       endp

NEWPAGE <LongToASCII>
;------ LongToASCII ---------------------------------------------------------;
;                                                                            ;
;       DX:AX = long to convert                                              ;
;       SI = base to use (2 to 31)                                           ;
;       ES:DI = where to put it                                              ;
;                                                                            ;
;       Converts the double word in DX:AX (unsigned) to an ASCII string      ;
;       in ES:DI using the base in SI.  The string will be null terminated.  ;
;                                                                            ;
;       Since it uses DIV this is not an optimal routine.                    ;
;                                                                            ;
;       Registers AX, CX, DX and flags are destroyed.  All others            ;
;       preserved.                                                           ;
;                                                                            ;
;----------------------------------------------------------------------------;

LongToASCII     proc    near
        PUSHR   bx,si,di
        push    di                      ; save start of buffer

        ; move DX:AX into BX:CX
        ; ---------------------
        mov     bx,dx                   ; now in BX:CX
        mov     cx,ax

        ; if BX:CX is zero,skip the divide and jump right in
        ; ----------------------------------------------------
        mov     ax,bx                   ; BX:CX is zero?
        or      ax,cx
        jz      ltoa_digit              ; just use zero, skip divide

        ; loop
        ;
        ; divide BX:CX by SI.  result in BX:CX, remainder in AX.
        ; -------------------------------------------------------
ltoa_loop:
        xor     dx,dx                  ; BX:CX / SI -> BX:CX, AX
        mov     ax,bx
        div     si
        mov     bx,ax
        mov     ax,cx
        div     si
        mov     cx,ax
        mov     ax,dx
        
        ; single digit in AL.  convert to ASCII and store at ES:DI.
        ; -------------------------------------------------------------------
ltoa_digit:

        call    hexchar                 ; convert to ASCII
        stosb                           ; store at ES:DI, advance

        ; loop around again if still non-zero
        ; ------------------------------------
        mov     ax,bx                   ; BX:CX is zero?
        or      ax,cx
        jnz     ltoa_loop               ; nope, loop around

        ; done processing.  put a null terminator on the end.
        ; ---------------------------------------------------
        mov     byte ptr es:[di],0

        ; the string is stored backwards.  reverse it by swapping bytes.
        ; -------------------------------------------------------------------
        pop     si                      ; restore start of buffer
ltoa_swaploop:

        dec     di                      ; back up one
        cmp     si,di                   ; check if done swapping
        jae     ltoa_exit               ; finished
        mov     ah,byte ptr es:[si]     ; swap characters
        mov     al,byte ptr es:[di]
        mov     byte ptr es:[di],ah
        mov     byte ptr es:[si],al
        inc     si                      ; forward one
        jmp     short ltoa_swaploop     ; back around

        ; done.
        ; ----------
ltoa_exit:
        POPR    bx,si,di
        ret
LongToASCII     endp

NEWPAGE <PutKeyword>
;------ PutKeyword ----------------------------------------------------------;
;                                                                            ;
;       void PutKeyword()                                                    ;
;                                                                            ;
;       ES:BX = pointer to keyword entry                                     ;
;                                                                            ;
;       Displays an error message string to the screen in the approximate    ;
;       form of the original input line for this keyword entry.              ;
;                                                                            ;
;       Registers AX, CX, DX and flags are destroyed.  All others            ;
;       preserved.                                                           ;
;                                                                            ;
;----------------------------------------------------------------------------;

PutKeyword      proc    near
        push    di

        ; First display the preamble
        ; -------------------------------
        mov     di,offset DGROUP:msg_preamble
        call    PutString

        ; Then display the keyword itself
        ; -------------------------------
        
        lea     di,[bx].kw_keyword
        call    PutS

        ; If no parameters stop here
        ; ------------------------------
        cmp     es:[bx].kw_param_num, 0
        je      key_crlf

        ; Then an equals sign (' = ').
        ; -----------------------------
        mov     di,offset DGROUP:msg_equals
        call    PutString

        ; If the rhs is a string then display it in quotes.
        ; --------------------------------------------------
        cmp     es:[bx].kw_param_type, KW_PARAM_STRING
        jne     key_long

        mov     di,offset DGROUP:msg_quote
        call    PutString

        lea     di,[bx].kw_param_value
        call    PutS

        mov     di,offset DGROUP:msg_quote
        call    PutString

        jmp     short key_more?

        ; The rhs is a long.  Display it in decimal.
        ; -------------------------------------------
key_long:

        push    es
        mov     dx,es:[bx].kw_param_value.hiword
        mov     ax,es:[bx].kw_param_value.loword
        mov     si,10                   ; decimal
        mov     cx,ds
        mov     es,cx
        mov     di,offset DGROUP:number_buffer
        call    LongToASCII             ; now string at ES:DI
        call    PutS                    ; display it
        pop     es

        ; Then an open parenthesis and hex prefix (' (0x').
        ; --------------------------------------------------
        mov     di,offset DGROUP:msg_openparen
        call    PutString

        ; Then the number in hex.
        ; ------------------------
        push    es
        mov     dx,es:[bx].kw_param_value.hiword
        mov     ax,es:[bx].kw_param_value.loword
        mov     si,16                   ; hexadecimal
        mov     cx,ds
        mov     es,cx
        mov     di,offset DGROUP:number_buffer
        call    LongToASCII             ; now string at ES:DI
        call    PutS                    ; display it
        pop     es

        ; Then an close parenthesis (')').
        ; ----------------------------------
        mov     di,offset DGROUP:msg_closeparen
        call    PutString

        ; If there are any more parameter, indicate that
        ; ----------------------------------------------
key_more?:

        cmp     es:[bx].kw_param_num, 1
        jbe     key_crlf

        mov     di,offset DGROUP:msg_moretocome
        call    PutString

        ; And finally a new line
        ; -----------------------
key_crlf:
        mov     di,offset DGROUP:msg_crlf
        call    PutString

        pop     di
        ret
PutKeyword      endp

NEWPAGE <ParseKeyword - Identify Keyword>
;------ ParseKeyword --------------------------------------------------------;
;                                                                            ;
;       int ParseKeyword()                                                   ;
;                                                                            ;
;       ES:BX = pointer to keyword image in configuration                    ;
;                                                                            ;
;       Returns:                                                             ;
;                                                                            ;
;       AX = keyword id (0 if no match, FFFFh if bad rhs)                    ;
;                                                                            ;
;       All other registers except flags preserved.                          ;
;                                                                            ;
;       Given a keyword image, checks the keyword against those recognized   ;
;       by this driver and if a match, returns an integer non-zero keyword   ;
;       id from the keyword_table.  Also checks to ensure that the right     ;
;       hand side has the right number of entries of the right type and      ;
;       does a simple range check.                                           ;
;                                                                            ;
;       If a right hand side is required and none has been supplied (but     ;
;       we have a valid keyword) then return KEY_NOP.  This should be        ;
;       treated as a NOP, with no change from the default.                   ;
;                                                                            ;
;----------------------------------------------------------------------------;

ParseKeyword    proc    near
        PUSHR   bx,dx,si,di,es
        ; set SI to the first keyword in table
        ; ------------------------------------
        mov     si,offset DGROUP:keyword_table

        ; loop until no more keywords in table
        ; ------------------------------------
parsek_loop:

        cmp     [si].key_name,0
        SJE     parsek_badkey

        ; try for a match
        ; ---------------
        push    si
        mov     si,[si].key_name
        lea     di,es:[bx].kw_keyword
        call    StringEquals
        pop     si
        je      parsek_match

        ; next keyword
        ; -------------
        add     si,SIZE key_entry
        jmp     parsek_loop

        ; matched keyword at SI.  if no rhs expected, confirm it.
        ; --------------------------------------------------------
parsek_match:

        cmp     [si].key_rhs,RHS_NONE
        jne     @F
        cmp     es:[bx].kw_param_num,0
        SJNE    parsek_syntax
        jmp     parsek_success

        ; must be a single rhs value.  if none then return KEY_NOP.
        ; ---------------------------------------------------------
@@:     cmp     es:[bx].kw_param_num,0
        jne     @F
        mov     ax,KEY_NOP
        jmp     parsek_exit

@@:     cmp     es:[bx].kw_param_num,1
        jne     parsek_syntax

        ; if anything allowed, it can be either a string or an integer.  
        ; if an integer, then range check it.
        ; -------------------------------------------------------------
        cmp     [si].key_rhs,RHS_ANYTHING
        jne     parsek_integer
        cmp     es:[bx].kw_param_type,KW_PARAM_LONG
        jne     parsek_any_string
        cmp     es:[bx].kw_param_value.hiword,0
        jne     parsek_syntax
        mov     ax,es:[bx].kw_param_value.loword
        cmp     ax,[si].key_min
        jb      parsek_syntax
        cmp     ax,[si].key_max
        ja      parsek_syntax
        jmp     short parsek_success
parsek_any_string:

        cmp     es:[bx].kw_param_type,KW_PARAM_STRING
        jne     parsek_syntax
        jmp     short parsek_success

        ; if an integer expected, confirm it and range check
        ; ---------------------------------------------------
parsek_integer:

        cmp     [si].key_rhs,RHS_INTEGER
        jne     parsek_string
        cmp     es:[bx].kw_param_type,KW_PARAM_LONG
        jne     parsek_syntax
        cmp     es:[bx].kw_param_value.hiword,0
        jne     parsek_syntax
        mov     ax,es:[bx].kw_param_value.loword
        cmp     ax,[si].key_min
        jb      parsek_syntax
        cmp     ax,[si].key_max
        ja      parsek_syntax
        jmp     short parsek_success

        ; if a string expected, confirm it and range check the length (note 
        ; that the rhs length stored in the image includes the null terminator)
        ; ----------------------------------------------------------------------
parsek_string:
        cmp     [si].key_rhs,RHS_STRING
        jne     parsek_syntax
        cmp     es:[bx].kw_param_type,KW_PARAM_STRING
        jne     parsek_syntax
        mov     ax,es:[bx].kw_param_len
        dec     ax
        cmp     ax,[si].key_min
        jb      parsek_syntax
        cmp     ax,[si].key_max
        ja      parsek_syntax

        ; successful match against keyword at SI, return key id in AX.
        ; ------------------------------------------------------------
parsek_success:
        mov     ax,[si].key_id
parsek_exit:
        POPR    bx,dx,si,di,es
        ret

        ; no match on keyword.  return 0.
        ; ------------------------------------
parsek_badkey:
        xor     ax,ax
        jmp     parsek_exit

        ; bad right hand side.  return FFFFh
        ; ------------------------------------
parsek_syntax:
        mov     ax,0FFFFh
        jmp     parsek_exit
ParseKeyword    endp




NEWPAGE <ParseNetAddr - Parse NETADDRESS keyword>
;------ ParseNetAddr --------------------------------------------------------;
;                                                                            ;
;       void ParseNetAddr()                                                  ;
;                                                                            ;
;       ES:BX = pointer to keyword image in configuration                    ;
;                                                                            ;
;       Returns:                                                             ;
;                                                                            ;
;       carry flag set if error.                                             ;
;                                                                            ;
;       All registers except flags preserved.                                ;
;                                                                            ;
;       sets the current address from the NETADDRESS keyword in the          ;
;       PROTOCOL.INI file.  The string on the right hand side is parsed,     ;
;       with two hex characters converted to a byte.  The string is          ;
;       guaranteed to be exactly 12 bytes in length.                         ;
;                                                                            ;
;----------------------------------------------------------------------------;

ParseNetAddr    proc    near
        PUSHR   ax,si,di

        ; set ES:DI to the start of the rhs string and SI to the start 
        ; of the current address
        ; ------------------------------------------------------------
        mov     si,offset DGROUP:specific.mc_caddr
        lea     di,es:[bx].kw_param_value
        mov     cx,6

        ; convert the two ascii hex characters at ES:DI to a byte in AL and 
        ; store it at SI, incrementing both DI and SI for the next repetition
        ; -----------------------------------------------------------
parsena_loop:
        mov     al,es:[di]
        inc     di
        call    charhex
        jc      parsena_fail
        mov     ah,al

        mov     al,es:[di]
        inc     di
        call    charhex
        jc      parsena_fail

        shl     ah,1
        shl     ah,1
        shl     ah,1
        shl     ah,1
        or      al,ah

        mov     [si],al
        inc     si
        loop    parsena_loop

        ; success.
        ; -------------
        clc
parsena_exit:
        POPR    ax,si,di
        ret

        ; failure
        ; ----------
parsena_fail:
        stc
        jmp     parsena_exit
ParseNetAddr    endp

NEWPAGE <ParseConfig - Parse PROTOCOL.INI image>
;------ ParseConfig ---------------------------------------------------------;
;                                                                            ;
;       int ParseConfig()                                                    ;
;                                                                            ;
;       ES:BX = pointer to an array of configuration memory images.          ;
;                                                                            ;
;       Returns:                                                             ;
;                                                                            ;
;       AX = return code, zero for success                                   ;
;                                                                            ;
;       All other registers except flags preserved.  This routine is called  ;
;       in device driver INIT context.                                       ;
;                                                                            ;
;       This routine takes the memory image of the PROTOCOL.INI file passed  ;
;       to us by the Protocol Manager and parses it, initializing various    ;
;       parameters in the process.  Note that ES:BX may be a NULL pointer,   ;
;       indicating that no PROTOCOL.INI file was found.  In this case we     ;
;       will initialize exactly one adapter with all default values.         ;
;                                                                            ;
;       See the NDIS Spec for the format of the configuration memory         ;
;       images.  The following keywords are recognized (defaults and any     ;
;       range in parentheses):                                               ;
;                                                                            ;
;               PRIMARY                         (see below)                  ;
;               ALTERNATE                                                    ;
;               EARLYRELEASE                    (see below)                  ;
;               RECVBUFS = integer              (2, 2 to 60)                 ;
;               RECVBUFSIZE = integer           (256, 256 to 17952)          ;
;               XMITBUFS = integer              (1, 1 to 2)                  ;
;               XMITBUFSIZE = integer           (see below, 256 to 17952)    ;
;               RAM = hex integer/"3Com"/IBM    (see below)                  ;
;               MAXTRANSMITS = integer          (6, 6 to MAX_TX_PENDING)     ;
;               PRODUCTID = "hex-string"        (see below)                  ;
;               NETADDRESS = "hex-string"       (see below)                  ;
;               DRIVERNAME = "string"                                        ;
;                                                                            ;
;       PRIMARY and ALTERNATE are opposites.  Use only one.  They            ;
;       specify which adapter to look for (there is a PRIMARY/ALTERNATE      ;
;       jumper on the adapter which determines which of two sets of          ;
;       ports the adapter will use).  If not specified the driver will       ;
;       try PRIMARY first and if no adapter is found, try ALTERNATE.         ;
;       Therefore these are normally not necessary.  However, if two         ;
;       adapters are installed in the same machine, PRIMARY should be        ;
;       specified for one and ALTERNATE for the other to be specific         ;
;       about which network adapter you mean.                                ;
;                                                                            ;
;       EARLYRELEASE specifies that the early token release option should    ;
;       be enabled if supported at the jumpered rate.  To make I&S easier    ;
;       the keyword is ignored if not supported.                             ;
;                                                                            ;
;       XMITBUFS, XMITBUFSIZE, RECVBUFS and RECVBUFSIZE determine the        ;
;       number and size of the transmit and receive buffers.                 ;
;                                                                            ;
;       XMITBUFS is the number of transmit buffers (DHBs) to configure.      ;
;       Although the configuration works just fine, none of the adapters     ;
;       tested to date support overlapped transmits (a major performance     ;
;       failing) so it is pointless to change this.                          ;
;                                                                            ;
;       XMITBUFSIZE is the size of a transmit buffer (DHB).  This sets the   ;
;       maximum packet size that can be handled by the adapter since         ;
;       transmit packets cannot span buffers.  If not specified this will    ;
;       default depending on the amount of SRAM available and the maximum    ;
;       packet size supported by this adapter.  For the original adapters    ;
;       (I, II and /A) a packet size of 2040 will always be used.  For the   ;
;       16/4 adapters the defaults depend upon the SRAM size and the data    ;
;       rate.  Most support a maximum packet size of 4456 bytes at 4Mbps     ;
;       and 17952 bytes at 16Mbps.  The default will be min(SRAM/4,maximum   ;
;       legal packet size).  These particular maximums are not guaranteed    ;
;       however and others are possible.  Up to about 4K performance         ;
;       improvements incur by increasing the packet size.  Beyond that       ;
;       there seems little point other than reducing the number of receive   ;
;       interrupts.  If specified, this will be checked at INIT time         ;
;       against the maximum packet sizes allowed for all of the data rates   ;
;       supported by this adapter.  It is possible that the packet size      ;
;       specified will slip through because it is supported but not at the   ;
;       data rate configured on the adapter.  If this happens a              ;
;       CONFIGURATION_FAILURE error will be returned from Open Adapter and   ;
;       (hopefully) reported to the user by NETBIND.                         ;
;                                                                            ;
;       RECVBUFS and RECVBUFSIZE determine the number and size of the        ;
;       receive buffers to use.  Although the default number of receive      ;
;       buffers requested defaults to 2 if not specified, the adapter        ;
;       automatically configures any remaining RAM as receive buffers, so    ;
;       the default is actually as many receive buffers as will fit, based   ;
;       on the buffer size.  Received packets can span multiple receive      ;
;       buffers so the default of 256 bytes allows you to receive a lot of   ;
;       small packets or fewer large packets.  The overhead in TransferData  ;
;       of using smaller receive buffers is minimal from measurements of     ;
;       thruput.  There is therefore little reason to change these.          ;
;                                                                            ;
;       See additional comments on Request OpenAdapter regarding reasonable  ;
;       values for RECVBUFS, RECVBUFSIZE, XMITBUFS and XMITBUFSIZE.          ;
;                                                                            ;
;       The RAM keyword determines where the shared RAM will be located.     ;
;       If not specified, the shared RAM is located immediately following    ;
;       the RAM on the next acceptable boundary (this is the same method     ;
;       the 3+ Token Ring driver used).  An acceptable boundary is defined   ;
;       as being aligned based on its own RAM size.  Thus the Adapter I      ;
;       with 8K of RAM aligns the RAM on the next 8K boundary following the  ;
;       ROM--ie.  immediately following the ROM (at CE00h if the default     ;
;       CC00h ROM location is used).  For a 16/4 adapter jumpered for 64K    ;
;       the RAM must be on a 64K boundary (at D000h if if the CC00h ROM      ;
;       location is used).  Since this driver does not use SRAM paging the   ;
;       size of the RAM is directly indicated by the switch settings (ie.    ;
;       16K is 16K not 64K using 16K pages).  If a hex value is specified    ;
;       it is the upper four bytes of the five byte physical address where   ;
;       the shared RAM should be located.  It must be between A000h and      ;
;       EC00h, and be located on a proper boundary.  The right hand side     ;
;       can also be "3Com" to specify the 3Com RAM location method (the      ;
;       default outlined above) or "IBM" to specify the IBM RAM location     ;
;       method (0xD800 for PRIMARY, 0xD400 for alternate).                   ;
;                                                                            ;
;       Normally RAM need not be specified.  No checks are made to           ;
;       guarantee it does not conflict with any other memory ranges.  If     ;
;       two adapters are installed, either let the RAM location default or   ;
;       exercise care to ensure that the two locations do not conflict.      ;
;                                                                            ;
;       Note that on the PS/2 adapters the shared RAM location is set up by  ;
;       POS and the RAM keyword is ignored.                                  ;
;                                                                            ;
;       MAXTRANSMITS determines the number of transmits which can be         ;
;       queued up.  Most protocols will handle running out of resources      ;
;       with little performance degredation.  However, DLC will drop         ;
;       significantly in performance if OUT_OF_RESOURCES is returned too     ;
;       often.  The default is 6, which should be sufficient for most        ;
;       cases, is adequate for window sizes up to about 6 or so.  On a       ;
;       heavily loaded server with a lot of active connections, you may      ;
;       want to increase this number since this driver is transmit limited,  ;
;       and with large windows on multiple active connections you may need   ;
;       a bigger transmit queue to handle them all.  Since each takes about  ;
;       128 bytes of memory this number can affect the resident size of the  ;
;       driver significantly.                                                ;
;                                                                            ;
;       The PRODUCTID keyword is entirely optional.  It is used to fill in   ;
;       the product id supplied to the adapter on open, which can be         ;
;       queried by network administration.  The right hand side consists of  ;
;       a string of hex characters which are used to fill in the 18 byte     ;
;       productid.  If the user does not specify this value then it          ;
;       defaults to "0110F0...F0".  See the IBM Token Ring Architecture      ;
;       Reference for details on what the product id should look like.  The  ;
;       logic here merely converts the 2-36 byte string into leading bytes   ;
;       (padded with zeroes) and does not enforce any particular values.     ;
;       Normally this is unnecessary unless the installation is using        ;
;       IBM Network Administration, in which case somebody familiar with     ;
;       the rules will have to go around setting PRODUCTIDs up.              ;
;                                                                            ;
;       NETADDRESS allows the user to configure the network address of       ;
;       the adapter, rather than using the one in ROM.  If not specified     ;
;       the address on the adapter will be used.  If specified, the rhs      ;
;       must be exactly 12 hex ascii characters which will be converted      ;
;       to the network address.  Like IBM we require that the address set    ;
;       be in the range 4000 0000 0000 to 4000 7FFF FFFF.  IBM suggests      ;
;       limiting yourself to decimal digits, but does not enforce this so    ;
;       we don't either (though apparently it is required for certain host   ;
;       connectivity).                                                       ;
;                                                                            ;
;----------------------------------------------------------------------------;

        DLOCAL  pdriver,4

ParseConfig     proc    near
        LOCALS
        PUSHR   bx,cx,dx,si,di,es

        jmp     short parse_driverloop

        ;------ parse_driverloop -----------------------
        ;
        ; loop through all driver configuration entries
        ; ----------------------------------------------
parse_nextdriver:
        les     bx,[bp].pdriver
        les     bx,es:[bx].dr_next

parse_driverloop:
        mov     ax,es
        or      ax,bx
        SJZ     parse_done

        mov     [bp].pdriver.off,bx
        mov     [bp].pdriver.segm,es

        ; determine if this driver configuration is for us.  to do this we loop
        ; through all of the keyword assignments for this driver looking for
        ; "DRIVERNAME" with the correct right hand side.
        ; --------------------------------------------------------------------
        add     bx,dr_keyword
parse_nameloop:
        mov     ax,es                           ; any keyword?
        or      ax,bx
        SJZ     parse_nextdriver

        ; check if its "DRIVERNAME"
        ; ------------------------------------
        call    ParseKeyword
        cmp     ax,KEY_DRIVERNAME
        jne     parse_notname

        ; check the rhs against our_name
        ; ------------------------------------
        lea     di,es:[bx].kw_param_value
        mov     si,our_name
        call    StringEquals
        je      parse_ours
        jmp     parse_nextdriver

        ; keyword is not DRIVERNAME, next keyword
        ; ------------------------------------
parse_notname:
        les     bx,es:[bx].kw_next
        jmp     parse_nameloop

        ; this configuration is ours, set ES:BX to the 
        ; driver configuration again
        ; ------------------------------------
parse_ours:
        les     bx,[bp].pdriver

        ; copy the logical driver name out of the driver configuration into the
        ; common module characteristics table
        ; ---------------------------------------------------------------------
        mov     di,offset DGROUP:common.cc_name
        lea     si,es:[bx].dr_logical_name
        push    es                              ; swap ES & DS
        push    ds
        pop     es
        pop     ds
        mov     cx,16
rep     movsb
        push    ds                              ; swap ES & DS back
        push    es
        pop     ds
        pop     es

        ; scan the keyword list of the current config entry
        ; --------------------------------------------------
        add     bx,dr_keyword
parse_keyloop:
        mov     ax,es
        or      ax,bx                   ; any more keywords?
        SJZ     parse_done              ; if not, we're done

        ; check against the keywords recognized by this driver.
        ; ------------------------------------
        call    ParseKeyword
        cmp     ax, KEY_NOP
        sje     parse_nextkey
        cmp     ax, KEY_DRIVERNAME
        sje     parse_nextkey
        cmp     ax, KEY_IOADDRESS
        sje     parse_ioaddr
        cmp     ax, KEY_INTERRUPT
        sje     parse_interrupt
        cmp     ax, KEY_NETADDR
        sje     parse_netaddr
   ;mmmmm
        cmp     ax, KEY_FLOWCTL                 ; add by Ben (2001/09/13)
        sje     parse_FLOWCTL
        cmp     ax, KEY_CONNECTIONTYPE
        sje     parse_CONNECTIONTYPE
        ; remove keyword SLOT (2003/05/26)
        ;cmp     ax, KEY_SLOT
        ;sje     parse_SLOT
        cmp     ax, KEY_EARLYRECEIVE
        sje     parse_erflag
        cmp     ax, KEY_LINESPEED
        sje     parse_LineSpeed
        cmp     ax, KEY_FULLDUPLEX
        sje     parse_fdxflag
        cmp     ax, KEY_AUTO
        sje     parse_autoflag

        ;------------------------------
        ; added by guard(2003/05/07)
        ; new keyword, BUSNO and DEVICENO
        ;----------------------------------
        cmp     ax, KEY_BUSNO
        sje     parse_busno
        cmp     ax, KEY_DEVICENO
        sje     parse_deviceno
   ;mmmmm
        test    ax,ax
        sjz     parse_badkey
        jmp     parse_badrhs


parse_ioaddr:
        cmp     word ptr es:[bx].kw_param_type, KW_PARAM_LONG
        jne     @F
        mov     cx, word ptr es:[bx].kw_param_value
        cmp     cx, 300h
        jne     @F
        jmp     parse_ioaddr_end
@@:
        cmp     cx, 320h
        jne     @F
        jmp     parse_ioaddr_end
@@:
        cmp     cx, 340h
        jne     @F
        jmp     parse_ioaddr_end
@@:
        cmp     cx, 360h
        je      parse_ioaddr_end
        jmp     parse_ioaddr_end
        jmp     parse_badrhs

parse_ioaddr_end:
        mov     Ioport,cx
        jmp     parse_nextkey

parse_interrupt:
        mov     ax,word ptr es:[bx].kw_param_value
        cmp     al,2
        jne     @F
        test    SystemFlags,ATFlag      ; check is AT?
        jz      @F
        mov     al,9                    ;
@@:
        mov     IntLevel,al             ;
        jmp     parse_nextkey           ;
;mmmmm
parse_erflag:
        mov     ax,word ptr es:[bx].kw_param_value
        cmp     al,1
        jne     @F
        mov     erflag,1                ;
        jmp     parse_erflag_end
@@:
        mov     erflag,0                ;
parse_erflag_end:
        jmp     parse_nextkey           ;

parse_etflag:
        mov     ax,word ptr es:[bx].kw_param_value
        cmp     al,1
        jne     @F
        mov     etflag,1                ;
        jmp     parse_etflag_end
@@:
        mov     etflag,0                ;
parse_etflag_end:
        jmp     parse_nextkey           ;

parse_fdxflag:
        mov     ax,word ptr es:[bx].kw_param_value
        cmp     al,1
        jne     @F
        mov     fdxflag,1               ;
        mov     Autoflag,0              ;
        jmp     parse_fdxflag_end
@@:
        mov     Autoflag,0              ;
        mov     fdxflag,0               ;
parse_fdxflag_end:
        jmp     parse_nextkey           ;

parse_autoflag:
        mov     ax,word ptr es:[bx].kw_param_value
        cmp     al,1
        jne     @F
        mov     Autoflag,1              ;
        jmp     parse_Autoflag_end
@@:
        mov     Autoflag,0              ;
parse_autoflag_end:
        jmp     parse_nextkey           ;

parse_linespeed:
        mov     ax,word ptr es:[bx].kw_param_value
        cmp     al,10
        jne     @F
        mov     byLineSpeed,10          ;
        jmp     parse_speedflag_end
@@:
        cmp     al,100
        jne     parse_speedflag_end
        mov     byLineSpeed,100         ;
parse_speedflag_end:
        jmp     short parse_nextkey     ;

        ; remove keyword SLOT (2003/05/26)
;parse_SLOT:
;        mov     ax,word ptr es:[bx].kw_param_value
;        mov     UserSlot,ax             ;
;        jmp     short parse_nextkey     ;

        ; added by Ben (2001/09/13), get FLOWCTL value
        ; ------------------------------------------------------\
parse_FLOWCTL:
        call    DoFLOWCTLKeyword
        jmp     short parse_nextkey     ;
        ; ------------------------------------------------------/
        
        ; added by Ben (2001/03/07), get CONNECTIONTYPE value
        ; marked by Ben (2001/09/14), we changed CONNECTIONTYPE keyword
        ; value from INTEGER to STRING type.
        ; ------------------------------------------------------\
parse_CONNECTIONTYPE:
        IF 0
        mov     ax, word ptr es:[bx].kw_param_value
        cmp     ax, 5                   ; this keywork only has 0~4
        jae     short   parse_nextkey
        mov     ConnectionType, al      ;
        jmp     short parse_nextkey     ;
        ELSE
        call    DoCONTTKeyword
        jmp     short parse_nextkey
        ENDIF
        ; ------------------------------------------------------/
        
parse_netaddr:
        ;/** 920704
        call    ParseNetAddr            ;
        jc      parse_badrhs
        ;cmp     byte ptr specific.mc_caddr[0], 0ffh
        ;je      parse_badrhs
        or      adapterBits,ADDRESSED
        jmp     parse_nextkey
        ;**/
parse_busno:
        mov     ax,word ptr es:[bx].kw_param_value
        mov     UserBusNo,ax             ;
        jmp     parse_nextkey
parse_deviceno:
        mov     ax,word ptr es:[bx].kw_param_value
        mov     UserDeviceNo,ax             ;
        jmp     parse_nextkey

        ; process next keyword if any
        ; ------------------------------------
parse_nextkey:
        les     bx,es:[bx].kw_next
        jmp     parse_keyloop

        ;------ parse_done -------------------
        ; return success.
        ; ------------------------------------
        
parse_done:
        ;call    PCIIDProc     ;mmmmm
        ;call    IoIRQmsg
        xor     ax,ax
parse_exit:
        POPR    bx,cx,dx,si,di,es
        leave
        ret

        ;------ error handling ---------------------------------
        ; unrecognized keyword.  es:[bx] is the keyword entry.
        ; ------------------------------------------------------
parse_badkey:
        mov     di,offset DGROUP:msg_nosuchkeyword
        jmp     short parse_errline

        ; invalid right hand side.  es:[bx] is the keyword entry.
        ; ------------------------------------------------------
parse_badrhs:
        mov     di,offset DGROUP:msg_invalidrhs

        ; output error message in DI to user, followed by the 
        ; failure line for es:[bx]
        ; ------------------------------------------------------
parse_errline:
        call    PutString
        call    PutKeyword

        mov     ax,INVALID_PARAMETER
        jmp     short parse_exit

        ; configuration error.
        ; ---------------------
parse_cfgerr:
        mov     di,offset DGROUP:msg_badconfigure

        ; output error message in DI to user.
        ; -------------------------------------
parse_errmsg:
        call    PutString

        mov     ax,INVALID_PARAMETER
        jmp     parse_exit

        ; general init failure (no adapters configured, too many 
        ; adapters configured, unable to allocate GDT entry)
        ; ------------------------------------------------------
parse_fail:
        mov     ax,GENERAL_FAILURE
        jmp     parse_exit
ParseConfig     endp

; -------------------------------------------------------------------
; Added by Ben (2001/09/13)
; Add new keyword handle routine for handling 'FLOW_CONTROL' for 
; handling 'HARDWARE_DEFAULT', 'ENABLE', 'DISABLE'. 
; IN:
;   ES:BX = pointer to keyword image in configuration
;
; -------------------------------------------------------------------
DoFLOWCTLKeyword  proc    near

        PUSHR   dx, ax, si, di
        mov     dx, 2                   ; DX=2, process flow_control keywords
        
        ; set ES:DI to the start of the rhs string and SI to the start 
        ; of the current address
        ; ------------------------------------------------------------
        lea     di, es:[bx].kw_param_value        
        call    MatchCONTypeText
        jnc     ParmERRORFLOWCTL

        mov     wFLOWCTLFlag, dx
        jmp     FLOWCTLRet
        
ParmERRORFLOWCTL:
        mov     di, offset DGROUP:msg_FLOWCTL_Err
        call    PutString
        mov     wFLOWCTLFlag, 0         ; use the hardware default setting
        
FLOWCTLRet:
        POPR    dx, ax, si, di
        ret
DoFLOWCTLKeyword  endp

; -------------------------------------------------------------------
; Added by Ben (2001/09/14)
; Add new keyword handle routine for handling 'FLOW_CONTROL' for 
; handling 'HARDWARE_DEFAULT', 'ENABLE', 'DISABLE'. 
; IN:
;   ES:BX = pointer to keyword image in configuration
;
; -------------------------------------------------------------------
DoCONTTKeyword  proc    near
        PUSHR   dx, ax, si, di
        mov     dx, 1                   ; DX=1, process connectiontype keywords

        ; set ES:DI to the start of the rhs string and SI to the start 
        ; of the current address
        ; ------------------------------------------------------------
        lea     di, es:[bx].kw_param_value        
        call    MatchCONTypeText
        jnc     ParmERRORCONTT

        mov     ConnectionType, dl
        
        cmp     dl, 0
        je      AUTOSENSE
        cmp     dl, 3
        je      M10BASET
        cmp     dl, 4
        je      M10BASETFD
        cmp     dl, 1
        je      M100BASETX
        cmp     dl, 2
        je      M100BASETXFD
        
        mov     ConnectionType, 0
        jmp     AUTOSENSE
        
ParmERRORCONTT:
        mov     di, offset DGROUP:msg_CONTT_Err
        call    PutString
        mov     ConnectionType, 0               ; AutoFlag will be the default value 1
        
AUTOSENSE:
        mov     AutoFlag, 1
        jmp     CONTYPERet

M10BASET:
        mov     FDXFlag, 0
        mov     byLineSpeed, 10
        jmp     SetAutoFlagZero
                
M10BASETFD:
        mov     FDXFlag, 1
        mov     byLineSpeed, 10
        jmp     SetAutoFlagZero
        
M100BASETX:
        mov     FDXFlag, 0
        mov     byLineSpeed, 100
        jmp     SetAutoFlagZero
        
M100BASETXFD:
        mov     FDXFlag, 1
        mov     byLineSpeed, 100
        jmp     SetAutoFlagZero
                  
SetAutoFlagZero:        
        mov     AutoFlag, 0
        
CONTYPERet:
        POPR    dx, ax, si, di
        ret
DoCONTTKeyword  endp

; -----------------------------------------------------------------------------
; Founction to translate CONNECTIONTYPE & FLOW_CONTROL keywords's value :
;   CONNECTIONTYPE  AUTOSENSE       --> return DX=0
;                   10BaseT         --> return DX=3
;                   10BaseTFD       --> return DX=4
;                   100BasetTX      --> return DX=1
;                   100BasetTXFD    --> return DX=2
; ---------------------------------------------------------
;   FLOW_CONTROL    HARDWARE_DEFAULT--> return DX=2
;                   HD              --> return DX=2
;                   ENABLE          --> return DX=1
;                   DISABLE         --> return DX=0
;
; IN:
;   DX      -   1 -> CONNECTIONTYPE, 2 -> FLOW_CONTROL
;   ES:DI   -   pointer to keywrod's value from PROTOCOL.INI
; OUT:
;   DX      -   translated ID
;   Carry   -   Set if matched.
; -----------------------------------------------------------------------------
MatchCONTypeText    proc    near
        PUSHR   si, di, ax, bx, cx
        
        cmp     dx, 1
        je      TranslateCONTYPEKeyword
        
        cmp     dx, 2
        je      TranslateFLOWCTLKeyword
        jmp     ParmERRORCONTYPE
        
        ; -----------------------------------------------
        ; Get CONNECTIONTYPE keyword value table
        ; -----------------------------------------------
TranslateCONTYPEKeyword:        
        mov     dx, SupportedCONTYPE                    ; DX = Num value Supported.
        mov     bx, offset DGROUP:SupportedCONTYPE + 2  ; BX -> 1st CONNECTIONTYPE value
        jmp     FindKeywordTextLoop
        
        ; -----------------------------------------------
        ; Get FLOW_CONTROL keyword value table
        ; -----------------------------------------------
TranslateFLOWCTLKeyword:
        mov     dx, SupportedFLOWCTL                    ; DX = Num value Supported.
        mov     bx, offset DGROUP:SupportedFLOWCTL + 2  ; BX -> 1st CONNECTIONTYPE value

FindKeywordTextLoop:
        push    di                      ; DI=string from NET.CFG
        mov     si, word ptr [bx]       ; SI=CONNECTIONTYPE table value
        mov     cl, byte ptr [si]       ; CL=the strings length
        inc     si                      ; Advance past the length byte
        call    vCompareString          ; Check if we have a match.
        pop     di                      ; DI -> Current Frame Type String
        jz      FoundCONTYPEText        ; z => Found a Match.

        ;-------------------------------
        ;       Not yet Found
        ;-------------------------------
        add     bx, 4                   ; BX -> next media name/ID entry
        dec     dx                      ; Check each of the Supported Frame types.
        jnz     FindKeywordTextLoop
        
        ; ---------------------------------------------
        ;       Test if use integer as keyword value
        ; ---------------------------------------------
        IF 0
        xor     ax, ax
        mov     al, byte ptr es:[di]
        call    charhex                 ; DX=integer # from char
        jc      ParmERRORCONTYPE
        mov     dx, ax
        stc                             ; notify it's ok
        jmp     DoneAndGetOut
        ELSE
        xor     dx, dx
        mov     dl, byte ptr es:[di]
        cmp     dl, 0
        jb      ParmERRORCONTYPE
        cmp     dl, 4
        ja      ParmERRORCONTYPE
        stc
        jmp     DoneAndGetOut
        ENDIF
        
        ;-------------------------------------------
        ;       Matched the CONNECTIONTYPE or FLOW_CONTROL value
        ;-------------------------------------------
FoundCONTYPEText:
        add     bx, 2
        mov     dx, word ptr [bx]       ; Get the ID
        stc                             ; notify it's ok
        jmp     DoneAndGetOut
        
        ;-------------------------------------------
        ;       CONNECTIONTYPE value wrong!
        ;-------------------------------------------
ParmERRORCONTYPE:
        clc                             ; notify failed
        
DoneAndGetOut:        
        POPR    si, di, ax, bx, cx
        ret        
MatchCONTypeText    endp

;-------------------------------------------------------------------------------
; Function to compare 2 string. (case sensitive)
; IN:
;   ES:DI : pointer to keywrod's value from PROTOCOL.INI
;   DS:SI : pointer to compared string keyword's table
;           (MUST BE TERMINATED WITH A ZERO,SPACE,or TAB)
;   CX    : Number of chars to compare this must be the
;           length of the str at DS:SI
; OUT:
;   ES:DI : points to end of compared string
;   DS:SI : points to end of comparing string
;   Carry : Set if string the same, otherwise, failed.
;-------------------------------------------------------------------------------
vCompareString  proc

CompareLoop:
        mov     al, byte ptr es:[di]
        call    upcase
        cmp     byte ptr ds:[si], al
        jne     CompareStrExit
        inc     si
        inc     di
        loop    CompareLoop
        
        ;repe    cmpsb                   ; compare ds:si, es:di
        ;jne     CompareStrExit          ; ne => not equal (z=0)

        ;       Check the length
        ;--------------------------------
        mov     cl, byte ptr es:[di]    ; Make sure 2nd str is not longer
        or      cl, cl                  ; Null is what we expect
        jz      CompareStrExit          ; Z=1

        cmp     cl, ' '                 ; Ignore trailing spaces
        je      CompareStrExit          ; Z=1

        cmp     cl, 09h                 ; Ignore trailing tabs
        
CompareStrExit:                         ; e (z) => Strings Match
        ret
vCompareString  endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
PCIHexToInt     proc  near
        mov     cx, 12
        
HextoIntlop:
        lodsb
        cmp     al,0       ;PCIID=0
        je      exitt
        sub     al,30h
        cmp     al,9
        jbe     NumHex
        and     al,not 20h
        sub     al,7
        
NumHex:
        cmp     al,0fh
        ja      errexit
        shl     al,4
        xchg    ah,al
        lodsb
        cmp     al,0
        je      exitt      ;PCIID=0
        sub     al,30h
        cmp     al,9
        jbe     NumHex1
        and     al,not 20h
        sub     al,7
        
NumHex1:
        cmp     al,0fh
        ja      errexit
        or      al,ah
        stosb
        sub     cx,2
        jnz     HexToIntLop
        
exitt:
        xor     ax,ax       ; set flag
        ret
        
errexit:
        or      ax,1        ; set flag
        ret
PCIHexToInt     endp

; --------------------------------------------------------------------
;   This routine is finding PCI devices (VT3043, VT3065, VT3106, VT3053)
; --------------------------------------------------------------------
        public  PCIIDProc
PCIIDProc       proc    near
        push    bp
        mov     bp, sp
        lea     si, PCIID       ; pointer of input ID

        mov     ESSave,es
        push    ds
        pop     es

        call    FindPCIDevice
        jnz     ErrorPCINotFound


        ;--------------------
        ; adapter filter
        ;-----------------
        call    PreCheckAdapter
        or      ax, ax
        jz      ErrorPCINotFound

        call    GetEtherID
        ;call    vPCIGeneralSet

        call    MatchSlot
        jz      NoMisMatch
        push    di
        push    cx
        push    dx
        mov     di, offset DGroup:PCISLOTNoMatchMsg
        call    PutString
        pop     dx
        pop     cx
        pop     di
        
NoMisMatch:
        jmp     COMMON_ENTRY

ErrorPCINotFound:               ; no adapter found
        mov     es,ESSave
        mov     ax,1
        jmp     rettt

COMMON_ENTRY:
        mov     IntLevel, cl
        mov     Ioport, dx
        mov     SlotValue, di
        
        mov     es,ESSave
        ;mov     bx,cs:PCIIntPtr
        ;mov     byte ptr [bx],cl
        ;mov     bx,cs:PCIIOPtr
        ;mov     word ptr [bx],dx

        xor     ax,ax
   rettt:
        pop     bp
        ret

PCIIDProc       endp

;***********************************************************************\
; On Entry:     CX     Bus Type
; On Return:    AX     Return Code
;***********************************************************************/
MatchSlot       proc
        push    bx
        mov     bx, 0
        cmp     NumberOfNIC, 1
        je      MatchSlotExit
        cmp     UserDeviceNo, 0ffffh
       
        jne     MatchNextSlot
        call    ChoseSlot
        jmp     MatchSlotExit           ; User do not give SLOT keyword

        ; ---------------------------------
        ; Slot had been assigned
        ; ---------------------------------
MatchNextSlot:

        call    CheckUserSpecify
        jnc     MatchSlotExit
        call    ChoseSlot

MatchSlotExit:
        mov     UsedSlotArray, 1
        mov     al, UsedSlotArray
        
        
        mov     cl, pciRevisionId [bx]
        mov     pciRevisionId, cl
        mov     cl, PCIINT [bx]
        shl     bx, 1
        mov     dx, PCIIOBase [bx]
        mov     di, DeviceNo [bx]
        mov     ax, pciDeviceId[bx]
        mov     pciDeviceId, ax


        pop     bx
        xor     ax, ax
        ret
MatchSlot       endp


; ***********************************************
;           Find PCI Devices (OS2)
; ***********************************************
IFDEF OS2
.386
FindPCIDevice   proc
        push  es
        xor   edi, edi
        mov   ax, 0fh                    ; from f000:0000
        mov   bx, 0h
        mov   cx, 0h                     ; 0 : Default 64k
        mov   dh,  1                     ; Result 1 : in ES:DI
        
        mov   DL, DevHlp_PhysToUVirt
        
        call  devHelper
        mov   di, bx
        mov   F000Save, es
        mov   ecx, 4000h                 ; Search From e000:0 to ffff:f
        mov   eax, '_23_'
        repne scasd
  
        je      @F
        mov     di, offset DGROUP:error_msg1
        call    PutString
        jmp     BoardNotFound
@@:
        sub   edi, 4
        
        cmp   byte ptr es:[edi].BSD_LENGTH, 1
        je      @F
        mov     al, es:[edi].BSD_LENGTH
        out     80h, al
        mov     di, offset DGROUP:error_msg2
        call    PutString
        jmp     BoardNotFound
@@:
        xor   al, al
        mov   ecx, 16
        mov   ebx, edi
        
@@:                                     ;Check checksum
        add   al, es:[edi]
        inc   edi
        loop  @B
        or    al, al
        ;jne   BoardNotFound
        je      @F
        mov     di, offset DGROUP:error_msg3
        call    PutString
        jmp     BoardNotFound
@@:

        push es
        push bx
        mov  ax, (0FFE6Eh SHR 16)       ; high-order part of physical addr.
        mov  bx, 0                      ; start of that segment
        mov  cx, 0                      ; map full 64KB
        mov  dh, 0                      ; make it executable-readable
        mov  dl, DevHlp_PhysToUVirt     ; function to get virtual address
        call devHelper
        add  bx, (0FFE6Eh AND 0FFFFh)   ; low-order part of phys addr
        mov  word ptr PCIEntry, bx      ; save entry point offset
        mov  word ptr PCIEntry+2, es    ; save entry point segment
        pop  bx
        pop  es

        call    GetRoutingTable
        jc      BoardNotFound

        ; Decide Mechanism #1 or #2
        ; ---------------------------
        mov     byte ptr mechanism, 1   ;Default Mechanism #1
        mov     dx, CONFIG_ADDRESS
        mov     al, 5ah
        out     dx, al
        NEWIODELAY
        in      al, dx
        NEWIODELAY
        cmp     al, 5ah
        jnz     short Mech_2
        mov     al, 0a5h
        out     dx, al
        NEWIODELAY
        in      al, dx
        NEWIODELAY
        cmp     al, 0a5h
        jnz     short Mech_2
        mov     byte ptr mechanism, 2
        
Mech_2:
        mov     ax, 0
        jmp     short found
        
found:
        xor     esi, esi                ;ESI is index of IRQ&IOBase table
        mov     Bus_Info, si
        
        ; ---------------------
        ;   Find VT3043
        ; ---------------------
        ;VT3065A : OS/2 Support Device ID 3043&3065
FindDeviceLoop43:
        ; modified by Ben (2001/08/06)
        ; Input:SI -- Index
        ;       CL -- Specified Devices :
        ;               0 : VT3043
        ;               1 : VT3065
        ;               2 : VT3106
        ;               3 : VT3053
        ; ---------------------------------\
        push    cx
        mov     cl, 0
        call    Find_PCI_Devices
        pop     cx
        ; ---------------------------------/
        jc      EndLoop43
        mov     Bus_Info, bx
        mov     PCIBDFNumber, bx

DeviceFound43:
        ; Check I/O bit and BusM bit in the PCI Command register
        ;-------------------------------------------------------
        mov     di, 04h
        call    ReadConfigByte     
        test    cl, 01h
        jz      BoardNotFound
        test    cl, 04h
        jnz     ExitOpenBusMBit43
        or      cl, 04h
        call    WriteConfigByte         ; bx : write value
        
ExitOpenBusMBit43:
        mov     di, REGISTER_IOBASE     ;10h
        ;call    ReadConfigWord
        call    Read_Config_Word
        and     ax, 0fffeh
        mov     cx, ax
        movzx   ebp,ax

CheckPCIorISAMode43:
PCIMode43:
        push    esi
        movzx   esi, NumberOfNIC
        shl     esi, 1

        mov     PCIIOBase1 [esi], cx

        mov     cx, 3043h
        mov     pciDeviceId1[si], cx


        mov     bx, PCIBDFNumber
        call    GetSlot
        mov     DeviceNo1 [si], cx

        mov     di, REGISTER_IRQ        ;3ch
        call    Read_Config_Byte
        mov     cl, al
        shr     esi, 1
        mov     PCIINT1 [esi], cl

        mov     di, REGISTER_REVISION_ID    ;08h
        call    Read_Config_Byte
        mov     cl, al
        mov     pciRevisionId1 [esi], cl

        pop     esi

        inc     NumberOfNIC

FindNextCard43:
        inc     esi
        cmp     esi, 4
        jb      FindDeviceLoop43

EndLoop43:
        xor	esi, esi
        mov     Bus_Info, si

        ; ---------------------
        ;   Find VT3065
        ; ---------------------
FindDeviceLoop65:
        ; modified by Ben (2001/08/06)
        ; Input:SI -- Index
        ;       CL -- Specified Devices :
        ;               0 : VT3043
        ;               1 : VT3065
        ;               2 : VT3106
        ;               3 : VT3053
        ; ---------------------------------\
        push    cx
        mov     cl, 1
        ;call    Find_PCI_Device65
        call    Find_PCI_Devices
        pop     cx
        ; ---------------------------------/
        jc      EndLoop65
        mov     Bus_Info, bx

        mov     PCIBDFNumber, bx

DeviceFound65:
        ; Check I/O bit and BusM bit in the PCI Command register
        ;-------------------------------------------------------
        mov     di, 04h
        call    ReadConfigByte     
        test    cl, 01h
        jz      BoardNotFound
        test    cl, 04h
        jnz     ExitOpenBusMBit65
        or      cl, 04h
        call    WriteConfigByte         ; bx : write value
        
ExitOpenBusMBit65:
        mov     di, REGISTER_IOBASE     ;10h
        ;call    ReadConfigWord
        call    Read_Config_Word
        and     ax, 0fffeh
        mov     cx, ax
        movzx   ebp,ax

CheckPCIorISAMode65:
PCIMode65:
        push    esi
        movzx   esi, NumberOfNIC
        shl     esi, 1
        mov     PCIIOBase1 [esi], cx

        mov     cx, 3065h
        mov     pciDeviceId1[si], cx

        mov     bx, PCIBDFNumber
        call    GetSlot
        mov     DeviceNo1 [si], cx

        mov     di, REGISTER_IRQ        ;3ch
        call    Read_Config_Byte
        mov     cl, al
        shr     esi, 1
        mov     PCIINT1 [esi], cl

        mov     di, REGISTER_REVISION_ID        ;08h
        call    Read_Config_Byte
        mov     cl, al
        mov     pciRevisionId1 [esi], cl

        pop     esi

        inc     NumberOfNIC

FindNextCard65:
        inc     esi
        cmp     esi, 4
        jb      FindDeviceLoop65

EndLoop65:

        xor	esi, esi
        mov     Bus_Info, si

        ; ---------------------
        ;   Find VT3106
        ; ---------------------
FindDeviceLoop3106:
        ; modified by Ben (2001/08/06)
        ; Input:SI -- Index
        ;       CL -- Specified Devices :
        ;               0 : VT3043
        ;               1 : VT3065
        ;               2 : VT3106
        ;               3 : VT3053
        ; ---------------------------------\
        push    cx
        mov     cl, 2
        ;call    Find_PCI_Device65
        call    Find_PCI_Devices
        pop     cx
        ; ---------------------------------/
        jc      EndLoop3106
        mov     Bus_Info, bx
        mov     PCIBDFNumber, bx

DeviceFound3106:
        ; Check I/O bit and BusM bit in the PCI Command register
        ;-------------------------------------------------------
        mov     di, 04h
        call    ReadConfigByte     
        test    cl, 01h
        ;jz      BoardNotFound
        jnz     @F
        mov     di, offset DGROUP:error_msg4
        call    PutString
        jmp     BoardNotFound
@@:

        test    cl, 04h
        jnz     ExitOpenBusMBit3106
        or      cl, 04h
        call    WriteConfigByte         ; bx : write value
        
ExitOpenBusMBit3106:
        mov     di, REGISTER_IOBASE     ;10h
        ;call    ReadConfigWord
        call    Read_Config_Word
        and     ax, 0fffeh
        mov     cx, ax
        movzx   ebp,ax

CheckPCIorISAMode3106:
PCIMode3106:
        push    esi
        movzx   esi, NumberOfNIC
        shl     esi, 1
        mov     PCIIOBase1 [esi], cx

        mov     cx, 3106h
        mov     pciDeviceId1[si], cx

        mov     bx, PCIBDFNumber
        call    GetSlot
        mov     DeviceNo1 [si], cx

        mov     di, REGISTER_IRQ        ;3ch
        call    Read_Config_Byte
        mov     cl, al
        shr     esi, 1
        mov     PCIINT1 [esi], cl

        mov     di, REGISTER_REVISION_ID        ;08h
        call    Read_Config_Byte
        mov     cl, al
        mov     pciRevisionId1 [esi], cl
        pop     esi
        inc     NumberOfNIC

FindNextCard3106:
        inc     esi
        cmp     esi, 4
        jb      FindDeviceLoop3106

EndLoop3106:

        xor	esi, esi
        mov     Bus_Info, si
        ; ---------------------
        ;   Find VT3053
        ; ---------------------
FindDeviceLoop3053:
        ; modified by Ben (2003/01/10)
        ; Input:SI -- Index
        ;       CL -- Specified Devices :
        ;               0 : VT3043
        ;               1 : VT3065
        ;               2 : VT3106
        ;               3 : VT3053
        ; ---------------------------------\
        push    cx
        mov     cl, 3
        call    Find_PCI_Devices
        pop     cx
        ; ---------------------------------/
        jc      EndLoop3053
        mov     Bus_Info, bx
        mov     PCIBDFNumber, bx

DeviceFound3053:
        ; Check I/O bit and BusM bit in the PCI Command register
        ;-------------------------------------------------------
        mov     di, 04h
        call    ReadConfigByte     
        test    cl, 01h
        ;jz      BoardNotFound
        jnz     @F
        mov     di, offset DGROUP:error_msg5
        call    PutString
        jmp     BoardNotFound
@@:

        test    cl, 04h
        jnz     ExitOpenBusMBit3053
        or      cl, 04h
        call    WriteConfigByte         ; bx : write value
        
ExitOpenBusMBit3053:
        mov     di, REGISTER_IOBASE     ;10h
        ;call    ReadConfigWord
        call    Read_Config_Word
        and     ax, 0fffeh
        mov     cx, ax
        movzx   ebp,ax

CheckPCIorISAMode3053:
PCIMode3053:
        push    esi
        movzx   esi, NumberOfNIC
        shl     esi, 1
        mov     PCIIOBase1 [esi], cx

        mov     cx, 3053h
        mov     pciDeviceId1[si], cx


        mov     bx, PCIBDFNumber
        call    GetSlot
        mov     DeviceNo1 [si], cx

        mov     di, REGISTER_IRQ        ;3ch
        call    Read_Config_Byte
        mov     cl, al
        shr     esi, 1
        mov     PCIINT1 [esi], cl

        mov     di, REGISTER_REVISION_ID        ;08h
        call    Read_Config_Byte
        mov     cl, al
        mov     pciRevisionId1 [esi], cl
        pop     esi
        inc     NumberOfNIC

FindNextCard3053:
        inc     esi
        cmp     esi, 4
        jb      FindDeviceLoop3053

EndLoop3053:
        ; &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
        ;VT3065A : OS/2 Support Device ID 3043&3065      
        cmp     NumberOfNIC, 0
        ;je      BoardNotFound
        jne     @F
        mov     di, offset DGROUP:error_msg6
        call    PutString
        jmp     BoardNotFound
@@:

AllBoardFound:
        pop     es
        xor     eax, eax
        ret

BoardNotFound:
        pop     es
        lea     eax, PCIAdapterNotFoundMsg
        or      eax, eax
        ret
FindPCIDevice   endp

IF 1    

; ----------------------------------------------------------\

;*** Find_PCI_Device (43, 65, 3106) *****************
;Input: SI -- Index
;       CL -- Specified Devices :
;               0 : VT3043
;               1 : VT3065
;               2 : VT3106
;Output: CF
;        BX: BUS
;****************************************************
        public Find_PCI_Devices
Find_PCI_Devices    proc    near
        cmp     mechanism, 2
        jz      mech2
        push    edi
        push    esi
        push    cx
        push    si

        mov     dx, FET_VENDOR_ID       ; 1106h
       
        cmp     cl, 0
        je      FindVT3043
        
        cmp     cl, 1
        je      FindVT3065
        
        cmp     cl, 2
        je      FindVT3106           
        
        cmp     cl, 3
        je      FindVT3053              ; if not spcified which devices,
                                        ; VT3043 will be the default!
FindVT3043:
        mov     di, FET_DEVICE_ID43     ; 3043h
        jmp     StartToFind

FindVT3065:
        mov     di, FET_DEVICE_ID65     ; 3065h
        jmp     StartToFind
        
FindVT3106:
        mov     di, FET_DEVICE_ID3106   ; 3106h
        jmp     StartToFind
        
FindVT3053:
        mov     di, FET_DEVICE_ID3053   ; 3053h
        
StartToFind:   

        xor     esi, esi

        shl     edi, 16
        mov     di, dx                  ; save Vendor ID (edi-hi = deviceID)

        xor     bx, bx
        mov     cl, 0
Search_loop0:
        ; --------------------------
        ; Finding Devices (mechism 1)
        ; --------------------------
        xor     bx, bx
        mov     bx, BUS_Info
        add     bl, 8
        mov     cl, 0
Search_loop:
         call    Get_CfgSpace_Dword      ; read vendor & device ID
        cmp     eax, edi                ; vendor & device ID match?
        jz      short Device_found
        add     bl, 08                  ; R05, just increment device no.
        jnc     short Search_Loop       ; R06, last device is 31
        inc     bh
        cmp     bh, 0ffh
        ;jb      Search_loop0
        jb      Search_loop
        stc
        jmp     short FIND_PCI_DEVICE_Exit
Device_found:
        clc                             ;set successful return

FIND_PCI_DEVICE_Exit:
        pop     si
        pop     cx
        pop     esi
        pop     edi
        ret
        
        ; --------------------------
        ; Finding Devices (mechism 2)
        ; --------------------------
mech2:
        mov     dx, FET_VENDOR_ID       ; 1106h
        cmp     cl, 0
        je      FindVT3043_2
        
        cmp     cl, 1
        je      FindVT3065_2
        
        cmp     cl, 2
        je      FindVT3106_2                        ; if not spcified which devices,
                                                    ; VT3043 will be the default!

        cmp     cl, 3
        je      FindVT3053_2              ; if not spcified which devices,

FindVT3043_2:
        mov     cx, FET_DEVICE_ID43     ; 3043h
        jmp     StartToFind_2

FindVT3065_2:
        mov     cx, FET_DEVICE_ID65     ; 3065h
        jmp     StartToFind_2
        
FindVT3106_2:
        mov     cx, FET_DEVICE_ID3106   ; 3106h
        jmp     StartToFind_2

FindVT3053_2:
        mov     cx, FET_DEVICE_ID3053  ; 3106h
                        
StartToFind_2:
        push    si
        push    di
        push    cx
        push    dx
        mov     bx, -1
        mov     di, dx
        mov     dx, 0c000h                          ;index base
        
Search_loop2:
        in      ax, dx
        cmp     ax, di                              ;Vendor ID
        jne     short Next_slot2
        add     dx, 2
        in      ax, dx
        sub     dx, 2
        cmp     ax, cx
        jne     short Next_slot2
        inc     bx
        cmp     bx, si
        je      short Device_found2
        
Next_slot2:
        inc     dh
        cmp     dh, 0d0h
        jb      short Search_loop2

        stc
        jmp     short FIND_PCI_DEVICE_Exit2

Device_found2:
        mov     bx, dx
        clc                                         ;set successful return
        
FIND_PCI_DEVICE_Exit2:
        pop     dx
        pop     cx
        pop     di
        pop     si
        ret
Find_PCI_Devices    endp

ELSE 

ENDIF 

;[]-------------------------------------------------------------------------[]
; READ_CFG_BYTE:
;       This function allows reading individual bytes from the configuration
;   space of a specific device.
;
;Input: AX -- Bus Number | Device Number | Function Number
;       CX -- Register Number
;Output: AH: 0 -- Successful
;        CL: Byte Read
;[]-------------------------------------------------------------------------[]
READ_CONFIG_BYTE  PROC    near
        cmp     byte ptr mechanism, 2
        jz      rb2
        push    bp                          ;Dream
        mov     bp, sp                      ;Dream
        mov     cx, di                      ;Dream
        push    cx
        mov     bx, Bus_Info
        call    Get_CfgSpace_Word

        pop     cx                          ;Dream AL : Byte Read
        pop     bp
        ret
rb2:
        push    bp                          ;Dream
        mov     bp, sp                      ;Dream
        push    dx
        mov     dx, Bus_Info                ;Dream
        mov     cx, di                     ;Dream
        mov     dl, cl
        in      al, dx
        mov     cl, al
        pop     dx
        pop     bp
        clc
        ret

READ_CONFIG_BYTE  ENDP
;
;*** Read_Cfg_Word ****
;Input: AX -- Bus Number | Device Number | Function Number
;       CX -- Register Number
;Output: AH: 0 -- Successful
;        AX: Word Read
;***********************
READ_CONFIG_WORD  PROC    NEAR
        cmp     byte ptr mechanism, 2
        je      rw2
        push    bp                          ;Dream
        mov     bp, sp                      ;Dream
        mov     cx, di                      ;Dream
        push    cx
        mov     bx, Bus_Info
        call    Get_CfgSpace_Word           ;AX : Return Word

        pop     cx
        pop     bp
        ret
rw2:
        push    bp                          ;Dream
        mov     bp, sp                      ;Dream
        push    dx
        mov     dx, Bus_Info                ;Dream
        mov     cx, di                      ;Dream
        mov     dl, cl
        in      ax, dx
        mov     cx, ax
        pop     dx
        pop     bp
        clc
        ret

READ_CONFIG_WORD  ENDP

;[]-------------------------------------------------------------------------[]
; Get_CfgSpace_Word:
;
; ENTRY : CX = CONFIG_ADDRESS register value
;               CH = Device Number in upper 5 bits
;                    Function Number in lower 3 bits
;               CL = Register Number
; EXIT  : AX = value of CONFIG_DATA
;
;[]-------------------------------------------------------------------------[]
Get_CfgSpace_Word       PROC    NEAR

        call    Get_CfgSpace_Dword
        and     cl,03                   ;byte in dword to get
        shl     cl,3                    ;*8 : 8 bits/byte for shifting
        shr     eax,cl
        ret
Get_CfgSpace_Word       ENDP

;[]-------------------------------------------------------------------------[]
; Get_CfgSpace_Dword:
;
; ENTRY : CX  = CONFIG_ADDRESS register value
;               CH = Device Number in upper 5 bits
;                    Function Number in lower 3 bits
;               CL = Register Number
;               BX = BusID/DevID/FuncID
;               
;
; EXIT  : EAX = value of CONFIG_DATA
;
;[]-------------------------------------------------------------------------[]
Get_CfgSpace_Dword      PROC    NEAR
        push    dx
        xor     eax,eax
        mov     ax, bx
        shl     eax, 8
        or      eax,80000000h           ;enable config. cycle
        mov     al, cl
        and     al,0FCh                 ;must be dword read/write
        mov     dx,CONFIG_ADDRESS
        out     dx,eax
        mov     dx,CONFIG_DATA
        in      eax,dx
        pop     dx
        ret
Get_CfgSpace_Dword      ENDP

;-----------------------------------------------------------
; Procedure Name: Read PCI Configuration Register (DWord)
; Input:        di = PortID
; Output:       ecx = Contents of register
;-----------------------------------------------------------

ReadConfigDWord proc
        mov     ax, 0b10ah
        mov     bx, PCIBDFNumber
        pushf
        call    PCIEntry
        ret
ReadConfigDWord endp

;-----------------------------------------------------------
; Procedure Name: Read PCI Configuration Register (Word)
; Input:        di = PortID
; Output:       cx = Contents of register
;-----------------------------------------------------------

ReadConfigWord  proc
        mov     ax, 0b109h
        mov     bx, PCIBDFNumber
        pushf
        call    PCIEntry
        ret
ReadConfigWord  endp

;-----------------------------------------------------------
; Procedure Name: Read PCI Configuration Register (Byte)
; Input:        di = PortID
; Output:       cl = Contents of register
;-----------------------------------------------------------

ReadConfigByte  proc
        mov     ax, 0b108h
        mov     bx, PCIBDFNumber
        pushf
        call    PCIEntry
        ret
ReadConfigByte  endp

;-----------------------------------------------------------
; Procedure Name: Write PCI Configuration Register (Byte)
; Input:        di = PortID
; Output:       cl = Contents of register
;-----------------------------------------------------------

WriteConfigByte proc
        mov     ax, 0b10bh
        mov     bx, PCIBDFNumber
        pushf
        call    PCIEntry
        ret
WriteConfigByte endp

GetRoutingTable proc    near
        push    ebx
        push    ds
        push    esi
        push    es
        push    edi


        push    ds              ; Get ES:DI -> buffer to hold routing table
        pop     es
        mov     ax, ds
        mov     word ptr add1+2, ax
        lea     ax, buf
        mov     word ptr add1, ax
        lea     edi, len

        mov     ax, F000Save
        mov     ds, ax          ; set DS -> F000h segment (physical address)
        mov     bx, 0
        mov     ax, 0b10eh      ; get routing table
        pushf
        call    dword ptr es:PCIEntry


        pop     edi
        pop     es
        pop     esi
        pop     ds
        pop     ebx
        ret
GetRoutingTable endp
; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
GetSlot proc    near
        push    ebx
        push    ds
        push    esi
        push    es
        push    edi

IF 0
        push    ds
        push    ebx             ; BX = device number

        push    ds              ; Get ES:DI -> buffer to hold routing table
        pop     es
        mov     ax, ds
        mov     word ptr add1+2, ax
        lea     ax, buf
        mov     word ptr add1, ax
        lea     edi, len

        mov     ax, F000Save
        mov     ds, ax          ; set DS -> F000h segment (physical address)
        mov     bx, 0
        mov     ax, 0b10eh      ; get routing table
        pushf
        call    dword ptr es:PCIEntry

        pop     eax
        xchg    ah, al
        pop     ds
ENDIF
        mov     ax, bx
        xchg    ah, al
        lea     edi, len
        mov     cx, word ptr [edi]          ; get size of buffer
        add     edi, 6

HavePCIDeviceGetPCISlotLoop:
        cmp     ax, word ptr [edi]          ; also the Device Number
        jnz     HavePCIDeviceGetPCISlotGetNext

        ; have match of Bus Number and PCI Device Number, 
        ; uniquely identifies adapter
        ; -------------------------------------------------
        xor     ecx, ecx
        mov     cl, [edi+14]
        clc
        jmp     short HavePCIDeviceGetPCISlotFound

HavePCIDeviceGetPCISlotGetNext:
        add     edi, 10h                    ; ptr to next element
        sub     ecx, 10h
        jns     HavePCIDeviceGetPCISlotLoop ;Neg, never found it
        stc

HavePCIDeviceGetPCISlotFound:
        pop     edi
        pop     es
        pop     esi
        pop     ds
        pop     ebx
        ret
GetSlot endp

ELSE

; ***********************************************
;           Find PCI Devices (DOS)
; ***********************************************
bDeviceArray        dw      FET_DEVICE_ID43,FET_DEVICE_ID65,FET_DEVICE_ID3106,FET_DEVICE_ID3053
bDeviceArrayIndex   dw      0
FindPCIDevice   proc    near
MAXDEVICE           equ     4

    ;---------------------------------
    ; Check PCI BIOS present or not.
    ;---------------------------------
	mov     ax, 0b101h
	int     1ah
	jc      PCI_ErrorExit
	cmp     edx, dword ptr ' ICP'
	jnz     PCI_ErrorExit
	or      ah, ah
	jnz     PCI_ErrorExit

	xor     esi, esi                        ; Start with first Ethernet device.

    ;--------------------
    ; Find NIC
    ;--------------------
    mov     bDeviceArrayIndex, 0
FindNICLoop:
    mov     di, bDeviceArrayIndex
	mov     ax, 0b102h                      ; Find PCI device
	mov     dx, FET_VENDOR_ID                ; 1106h
	mov     cx, bDeviceArray [di]
	int     1ah
	jc      FindNextDevice
	or      ah, ah
	jnz     FindNextDevice
	
DeviceFound:
	mov     PCIBDFNumber, bx

    mov     ax, sub_vendorid
    cmp     ax, 0
    jz      SUBVENDORID_MATCH
    mov     di, 02ch        ; read sub-vendor id
    call    ReadConfigWord
    mov     ax, sub_vendorid
    cmp     ax, cx
    je      SUBVENDORID_MATCH
    inc     si     
    jmp     FindNICLoop
        
SUBVENDORID_MATCH:

	; Check I/O bit and BusM bit in the PCI Command register
	;-------------------------------------------------------
	mov     di, 04h
	call    ReadConfigByte     
	test    cl, 01h
	jz      PCI_ErrorExit
	test    cl, 04h
	jnz     ExitOpenBusMBit
	or      cl, 04h
	call    WriteConfigByte             
	
ExitOpenBusMBit:
	mov     di, 10h                  ; REGISTER_IOBASE == 10h
	call    ReadConfigWord           ;
	and     cx, 0fffeh
	mov     dx, cx

	push    si

	mov     bl, NumberOfNIC
	xor     bh, bh
	mov     si, bx
	shl     si, 1
	mov     pciIOBase1 [si], cx


    ;------------------------------
    ; added by guard(2003/12/24)
    ;------------------------------

    mov     di, bDeviceArrayIndex
    mov     cx, bDeviceArray[di]
    mov     pciDeviceId1[si], cx


	mov     bx, PCIBDFNumber
	and     bx, 0F8h
	shr     bx, 3
	
	;-------------------------------------
	; modified by guard (2003/05/07)
	; support two keyword BUSNO and DEVICENO
	;---------------------------------------
    mov     DeviceNo1[si], bx

    mov     bx, PCIBDFNumber
    xchg    bh, bl
    and     bx, 0FFh
    mov     BusNo1[si], bx
    
    ; remove keyword SLOT (2003/05/26)
    ;mov     bx, PCIBDFNumber
    ;and     bx, 07h
	;mov     PCISlot [si], bx


	mov     di, 3ch                  ; REGISTER_IRQ == 3ch
	call    ReadConfigByte
	shr     si, 1
	mov     PCIINT1 [si], cl

	mov     di, 08h                  ; REGISTER_REVISION == 08h
	call    ReadConfigByte
	mov     pciRevisionId1 [si], cl
	
	;----------------------------------------
	; 2003.5.6,guard
	; remove "WRITEMODE2" tag now
	; we compare its revision ID to finish 
	;  original work 
	;----------------------------------------
	call vSetPCIMode2Register

    ; ----------------------------------------------
    ;       Write Mode 0
    ; ----------------------------------------------
IFDEF   WriteMode0    ; QPacket closed
	; Write PCI Config Space to set MODE3 register
	;-----------------------------------------------
	mov     di, 50h
	mov     cl, 80h
	call    WriteConfigByte
ENDIF

	;Add by shing to turn on bit2 (MIION) 00/10/18
	;------------------------------------
	mov     di,53h
	call    ReadConfigByte
	or      cl,4
	mov     di,53h
	call    WriteConfigByte
	pop     si
	inc     NumberOfNIC

FindNextCard:
	inc     si
	cmp     si, 4
	jb      FindNICLoop
    jmp     EndLoopFindLoop
    
FindNextDevice:
    xor     esi,esi
    add     bDeviceArrayIndex, 2
    cmp     bDeviceArrayIndex, 8
    jb      FindNICLoop
    
EndLoopFindLoop:
	cmp     NumberOfNIC, 0
	je      BoardNotFound

AllBoardFound:
	xor     ax, ax
    clc
    jmp     cFindPCIDeviceOver


BoardNotFound:
PCI_ErrorExit:
	lea     edx, PCIAdapterNotFoundMsg
	mov     ax, 1
	or      ax, ax

	stc
cFindPCIDeviceOver:

	ret
	
FindPCIDevice   endp


; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
GetSlot proc    near
        push    bx
        push    ds
        push    si
        push    es
        push    di

        push    ds
        push    bx                          ; BX = device number

        push    ds                          ; Get ES:DI -> buffer to hold routing table
        pop     es
        mov     ax, ds
        mov     word ptr add1+2, ax
        lea     ax, buf
        mov     word ptr add1, ax
        lea     di, len

        mov     ax, 0F000h
        mov     ds, ax                      ; set DS -> F000h segment (physical address)
        mov     bx, 0
        mov     ax, 0b10eh                  ; get routing table
        int     1ah

        pop     ax
        xchg    ah, al
        pop     ds
        lea     di, len
        mov     cx, word ptr [di]           ; get size of buffer
        add     di, 6

HavePCIDeviceGetPCISlotLoop:
        cmp     ax, word ptr [di]           ; also the Device Number
        jnz     HavePCIDeviceGetPCISlotGetNext

        ; have match of Bus Number and PCI Device Number, 
        ; uniquely identifies adapter
        ; ------------------------------------------------
        xor     cx, cx
        mov     cl, [di+14]
        clc
        jmp     short HavePCIDeviceGetPCISlotFound

HavePCIDeviceGetPCISlotGetNext:
        add     di, 10h                     ; ptr to next element
        sub     cx, 10h
        jns     HavePCIDeviceGetPCISlotLoop ;Neg, never found it
        stc

HavePCIDeviceGetPCISlotFound:
        pop     di
        pop     es
        pop     si
        pop     ds
        pop     bx
        ret
GetSlot endp


;-----------------------------------------------------------
; Procedure Name: Read PCI Configuration Register (Word)
; Input:        di = PortID
; Output:       cx = Contents of register
;-----------------------------------------------------------

ReadConfigWord  proc
        mov     ax, 0b109h
        mov     bx, PCIBDFNumber
        int     1ah
        ret
ReadConfigWord  endp

;-----------------------------------------------------------
; Procedure Name: Read PCI Configuration Register (Byte)
; Input:        di = PortID
; Output:       cl = Contents of register
;-----------------------------------------------------------

ReadConfigByte  proc
        mov     ax, 0b108h
        mov     bx, PCIBDFNumber
        int     1ah
        ret
ReadConfigByte  endp

;-----------------------------------------------------------
; Procedure Name: Write PCI Configuration Register (Byte)
; Input:        di = register Number
;               cl = Contents of register
;-----------------------------------------------------------

WriteConfigByte proc
        mov     ax, 0b10bh
        mov     bx, PCIBDFNumber
        int     1ah
        ret
WriteConfigByte endp

ENDIF
;***********************************************************************\
; On Entry: None
; On Return: AX: return code
;***********************************************************************/
GetEtherID      proc

        mov     bx, 0

GetNextID:
        push    bx
        shl     bx, 1
        mov     dx, PCIIOBase [bx]
        mov     bp, dx
        pop     bx

        push    bx
        mov     ax, bx
        shl     ax, 1
        shl     bx, 1
        shl     bx, 1
        add     bx, ax
                
        lea     di, PCIEtherID [bx]         ; DI -> Node Address.
        pop     bx

        push    es
        push    ds
        pop     es
        push    cx
        mov     cx,6
  nn10:
        in      al, dx
        inc     dx
        stosb
        loop    nn10
        pop     cx
        pop     es

        inc     bx
        cmp     bl, NumberOfNIC
        jb      GetNextID

        xor     ax, ax

GetIDExit:
        or      ax, ax
        ret

GetEtherID      endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
DELAY proc near
        push    cx
        mov     cx,0fffh
  delay1ms:  loop    delay1ms
        pop     cx
        ret
DELAY  endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
IOIRQMsg        proc
        
        mov     al, IntLevel
        call    hexchar                     ; convert to ASCII
        mov     IntLevel1, al

        mov     ax, Ioport
        xchg    ah, al
        push    ax
        and     al, 0f0h
        shr     al, 4
        call    hexchar                     ; convert to ASCII
        mov     Ioport1, al
        pop     ax

        push    ax
        and     al, 0fh
        call    hexchar                     ; convert to ASCII
        mov     Ioport1+1, al
        pop     ax

        xchg    ah, al
        push    ax
        and     al, 0f0h
        shr     al, 4
        call    hexchar                     ; convert to ASCII
        mov     Ioport1+2, al
        pop     ax

        push    ax
        and     al, 0fh
        call    hexchar                     ; convert to ASCII
        mov     Ioport1+3, al
        pop     ax
if 0
        ; Show Card Name
        ; -----------------------------
        cmp     pciRevisionId, RevisionID3106S
        jae     VT3106SCard
        
        cmp     pciRevisionId, RevisionID3106J
        jae     VT3106JCard
        
        cmp     pciRevisionId, RevisionID3065
        jae     VT3065Card
endif
        cmp     pciDeviceId, FET_DEVICE_ID3053
        je      VT3106SCard
        
        cmp     pciDeviceId, FET_DEVICE_ID3106
        je      VT3106JCard
        
        cmp     pciDeviceId, FET_DEVICE_ID65
        je      VT3065Card
        ; It's VT3043
        ; -----------        
        mov     di, offset DGROUP:VT3043CardName
        jmp     ShowCardName
        
        ; It's VT3106S
        ; -----------        
VT3106SCard:
        mov     di, offset DGROUP:VT3106SCardName
        jmp     ShowCardName
        
        ; It's VT3106J
        ; -----------        
VT3106JCard:
        mov     di, offset DGROUP:VT3106JCardName
        jmp     ShowCardName
        
        ; It's VT3065
        ; -----------        
VT3065Card:
        mov     di, offset DGROUP:VT3065CardName
        
ShowCardName:
        call    PutString
        
        ; Show FLOW CONTROL ability
        ; -----------------------------
        cmp     wFLOWCTLFlag, 1             ; FLOW_CONTROL=Enable
        je      ShowFLOWCTLMsg1
        cmp     wFLOWCTLFlag, 0             ; FLOW_CONTROL=Disable
        je      ShowFLOWCTLMsg2
        
        mov     di, offset DGROUP:msg_FLOWCTL_HD    ; FLOW_CONTROL=HARDWARE_DEFAULT
        call    PutString
        jmp     ShowFLOWCTLMsgDone
        
ShowFLOWCTLMsg1:
        mov     di, offset DGROUP:msg_FLOWCTL_enable
        call    PutString
        jmp     ShowFLOWCTLMsgDone
                
ShowFLOWCTLMsg2:
        mov     di, offset DGROUP:msg_FLOWCTL_disable
        call    PutString

ShowFLOWCTLMsgDone:        
        lea     di, DGroup:Interruptmsg
        call    PutString
        lea     di, DGroup:Ioportmsg
        call    PutString

        cmp     LinkStatus, LinkOK          ; Toggle...
        jnz     UnLinkMsg

        cmp     FDXFlag, 1
        jnz     HDX
        lea     di, DGroup:FullDuplexMsg
        call    PutString
        jmp     DuplexOver
        
HDX:
        lea     di, DGroup:HalfDuplexMsg
        call    PutString
        
DuplexOver:
        cmp     byLineSpeed, 100
        jnz     Speed10
        lea     di, DGroup:LineSpeed100Msg
        call    PutString
        jmp     SpeedOver
        
Speed10:
        lea     di, DGroup:LineSpeed10Msg
        call    PutString
        jmp     SpeedOver
UnLinkMsg:
        lea     di, DGroup:CableUnLink
        call    PutString
        
SpeedOver:
        push    si                          ; Here show Ethernet ID
        push    di
        push    es

        ;------------------------------
        ; added by guard (2003/09/23)
        ; new keyword: networkaddress
        ;------------------------------
        test    adapterBits, ADDRESSED
        jz      @F                          ; address is not changed

        push    ds
        pop     es
        lea     di, specific.mc_caddr[0]
        call    CheckNodeAddrVaild
        jc      @F

        mov     cx, 6
        xor     si, si
        mov     dx, Ioport
UpdateMacAddressLoop:
        mov     al, specific.mc_caddr[si]
        out     dx, al
        inc     si
        inc     dx
        loop    UpdateMacAddressLoop
@@:

        push    ds
        pop     es
        mov     dx, Ioport
        mov     di,offset DGROUP:PCIID
        mov     cx,6h
        cld
@@:
        in      al,dx                       ; get node address
        stosb
        inc     dx
        loop    @B

        mov     si,offset DGROUP:PCIID
        mov     di,offset DGROUP:EthernetID
        call    ConvertEtherID

        mov     si,offset DGROUP:SlotValue
        mov     di,offset DGROUP:PCISlotValue
        call    ConvertSlot
        pop     es
        pop     di
        pop     si

        lea     di, DGroup:EtherIDMsg
        call    PutString
        lea     di, DGroup:EthernetID
        call    PutString
        lea     di, DGroup:PCISlotMsg
        call    PutString
        lea     di, DGroup:PCISlotValue
        call    PutString
        mov     di,offset DGROUP:msg_crlf
        call    PutString
        mov     di,offset DGROUP:msg_crlf
        call    PutString
        ret
IOIRQMsg        endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
ConvertEtherID  proc    near
        mov     cx, 6
Convert1:
        lodsb
        push    ax
        and     al, 0f0h
        shr     al, 4
        call    hexchar
        stosb
        pop     ax
        and     al, 0fh
        call    hexchar
        stosb
        loop    Convert1
        ret
ConvertEtherID  endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
ConvertSlot     proc    near
        cmp     word ptr [si], 9
        jbe     OneNibble
        mov     cx, 1                   ; modify by Ben (10/09/00), cx=2->cx=1
Convert11:
        lodsb
        push    ax
        and     al, 0f0h
        shr     al, 4
        call    hexchar
        stosb
        pop     ax
        and     al, 0fh
        call    hexchar
        stosb
        loop    Convert11
        ret
OneNibble:
        lodsb
        or      al, 30h
        stosb
        ret
ConvertSlot     endp


;============================================================================
; Processing Speed and Duplex keywords begin
;============================================================================
ProcessDuplex   proc    near            ;[Not SwitchHub]
        ; No matter in 3043 or 3065, we don't need to reset PHY.
        ; ------------------------------------------------------
        cmp     AutoFlag, 1             ; If AUTO keyword given, ignore all others
        jz      NokeywordsGiven
        cmp     FDXFlag, 0FFh           ; KingMax
        jnz     UserForce               ; User no input Duplex keyword
        cmp     byLineSpeed, 0FFh
        jnz     UserForce               ; User no input Speed keyword
        jmp     NokeywordsGiven
        
UserForce:
        ; ----------------------------------------------------------------------------
        ;                       Force Mode Process 
        ; (FDXFlag will be default to be 0 (helfduplex) if user didn't specify duplex mode!!!)
        ; (byLineSpeed will be default to be 10 if user didn't specify line speed!!!)
        ; ----------------------------------------------------------------------------
        cmp     FDXFlag, 0FFh           ; added by guard (05/24/02)
        jne     NoSpecifyDuplex         ; added by guard (05/24/02)
        mov     FDXFlag, 0              ; added by guard (05/24/02)
NoSpecifyDuplex:        
        cmp     byLineSpeed, 0FFh       ; added by Ben (10/04/00)
        jne     DontSetDeSpeed          ; added by Ben (10/04/00)
        mov     byLineSpeed, 10         ; added by Ben (10/04/00) 
                                        ; modified by guard (05/24/02)
        
DontSetDeSpeed:                         ; added by Ben (10/04/00)
        mov     byUserOverride, 1       ; user specify SPEED or Duplex keywork
        call    ForceNotNWay            ; can not link at NWAY mode

        ; add by Ben (2001/08/17), for VT3043, it's need longer delay
        ; for detecting link status, but for VT3065 or VT3106, it's not
        ; needed.
        ; Vt3043 : LongDelay
        ;--------------------------------\
        cmp     pciRevisionId, RevisionID3065
        jae     SpeedDuplexOver
        
        mov     ax, 3
        call    MACminiDelay
        
        jmp     SpeedDuplexOver         ; set to force mode.

        ; -------------------------------------------------------------------
        ;                       Auto Mode Process
        ; -------------------------------------------------------------------
NokeywordsGiven:
        mov     AutoFlag, 1
        
        ; 3043 and 3065 (3074) path to re-auto
        ;   3043        : set REAUTO bit
        ;   3065 & 3106 : just set AUTO bit only
        ; ----------------------------------------------------
        call    ReAuto                  ; re-auto now to let MII setting work
        call    QueryAuto               ; At Re-Auto, we have enable Auto-Negotiation
        
        ; For now, we had decide the duplex mode, no matter in FORCE or AUTO mode.
        ; -----------------------------------------------------------------------
        ; Now, set duplex mode to MAC only, if now is AUTO mode. 
        ; If it is in FORCE mode, we need to set MAC and MII both!!! 
        ; Here, we only set MAC, because MII had been set in ForceNotNWay() if
        ; it's in FORCE mode.(By Ben 10/04/00)
        ; -----------------------------------------------------------------------
SpeedDuplexOver:
        call    SetDuplex               ; set duplex to MAC only, not include MII
        
        ;=====================================================
        ; Processing Speed and Duplex keywords end
        ;=====================================================
        ;call    Delay1Second

    	; Set ISO bit to 0
    	;-----------------   
        mov     byMIIIndex, MII_REG_BMCR
        mov     wMIIValue, BMCR_ISO
        call    MIITurnOffBits

        ret
ProcessDuplex   endp                        ;[Not SwitchHub]

;----------------------------------------------------------------------------
; Modified by Ben (2001/08/17):
;   Changed to N-Way forced mode, not legacy forced mode. See Document.
; ---------------------------------
; Modified by Ben (2001/09/24):
;   In VT3065, adopt legacy forced mode if media type is loaded from EEPROM.
; In VT3106, media type selection is abandoned. So it will use N-Way forced mode.
; Here, we add a new variable, dbLegacyForcedMode, to judge if use N-Way forced
; mode or Legacy forced mode.
; ---------------------------------
; NWay keyword not given, disable Auto-Negotiation and set MII according to
; user speified parameters, or default 100-Half Duplex
; PS: Here must disable Auto-Negotiation...
;----------------------------------------------------------------------------
ForceNotNway    proc    near            ;[Not SwitchHub]
        call    vPhyModeStatus                  ; get dbCurrPhyMode
        jc      PhyModeIsChanged
        
        ; phy mode is the same, just get out!
        ; ---------------------------------------
        jmp     ForceNotNwayDone
        
PhyModeIsChanged:
        cmp     dbLegacyForcedMode, 1
        je      LegacyForcedMode
        
        ; -----------------------------------------------------
        ;
        ;       N-Way forced Mode 
        ;
        ; (VT3106 or VT3065 when EEPROM forced mode disable)
        ; (Set ANAR & BMCR, and set AUTO or REAUTO bit of BMCR)
        ; -----------------------------------------------------
        call    vSetMIIANAR                     ; set ANAR, based on dbCurrPhyMode
        call    vSetMIIBMCR                     ; set BMCR's SPEED & FDX
        call    vSetAUTO_REAUTO
        jmp     ForceNotNwayDone
        
        ; -----------------------------------------------------
        ;
        ;       Legacy Forced Mode
        ;
        ; (VT3043 or VT3056 when EEPROM forced mode is enable)
        ; (Just set BMCR's FDX & SPEED, and turn off AUTO)
        ; -----------------------------------------------------
LegacyForcedMode:        
        call    vSetMIIBMCR                     ; set BMCR's SPEED & FDX
        
ForceNotNwayDone:
        ret
ForceNotNway    endp            ;[Not SwitchHub]

; **********************************************************************
; Description :
;   According LbyFDXFlag to call "SetToFullDPX()" & " SetToHalfDPX()"
;   to set duplex mode.
; **********************************************************************
SetDuplex       proc    near    ;[Not SwitchHub]
        cmp     FDXFlag, 0
        je      SetHalf
        call    SetToFullDPX
        jmp     FDXOver
SetHalf:
        call    SetToHalfDPX
FDXOver:
                ret
SetDuplex       endp            ;[Not SwitchHub]

; **********************************************************************
; Description :
;       Reauto:
;           VT3065 & VT3106 : don't need to set REAUTO bit
;           VT3043          : need to set REAUTO bit
; **********************************************************************
ReAuto  proc    near                    ;[Not SwitchHub]

        ; --------------------------------------
        ;
        ;       VT3106 & VT3065 VT3043
        ;       -to update ANAR
        ; --------------------------------------
        ; add by Ben (2001/08/17), set ANAR[8:5] to be on in AUTO mode.
        ; ---------------------------------------------------------------\
        call    vPhyModeStatus                      ; get dbCurrPhyMode
        jnc     PhyModeIsTheSame
        
        call    vSetMIIANAR                         ; set ANAR, based on dbCurrPhyMode
        call    vSetAUTO_REAUTO
        jmp     MIIReAutoDone
        
        ; --------------------------------------
        ;
        ;           VT3043 only
        ;           -need to reauto
        ; --------------------------------------
PhyModeIsTheSame:        
        ; if under VT3043, still need to set AUTO and REAUTO
        ; ---------------------------------------------------
        ; by Ben (2003/01/25), if AUTO bit is off, just turn on it.
        ; It's used for prevent the AUTO bit is not turned on
        ; when loading NWay forced driver after
        ; Legacy forced driver is unloaded. 
        ; ------------------------------------------------------------
        ;cmp     pciRevisionId, 40h
        ;jnb     MIIReAutoDone
        
        call    vSetAUTO_REAUTO
        
MIIReAutoDone:
        ret
ReAuto  endp                        ;[Not SwitchHub]



; ---------------------------------------------------------
; Function to set mini-sec delay. 
; IN :
;   AX : number of mini-sec to delay
; OUT:
;   NONE
; ---------------------------------------------------------
public MACminiDelay
MACminiDelay    proc
        cmp     pciRevisionId, RevisionID3065
        jb      VT3043_Timer
        
        ; -----------------------------
        ;   VT3065 or VT3106 timer set
        ; -----------------------------
        push    dx                              ; save DX
        push    ax                              ; save AX
        push    bx
        
        mov     bx, Ioport
        
        ; Set Timer0 value
        ; -----------------------------
        lea     dx, [bx].SCsrRegStruc.Timer0
        out     dx, ax

        ; Get MISCCR reg
        ; -----------------------------
        lea     dx, [bx].SCsrRegStruc.MISCCR
        in      ax, dx                          ; AX=MISCCR value
        
        cmp     pciRevisionId, RevisionID3106J
        jb      SetTM0USDone
        
        ; VT3106J & VT3106S need to set TM0US bit off
        ; ---------------------------------------------
        and     ax, 0ffdfh                      ; Bit5=TM0US
        
SetTM0USDone:        
        or      ax, 0001h                       ; Timer0En = 1
        and     ax, 0fffdh                      ; Timer0Suspend = 0
        out     dx, ax                          ; write MISCCR reg
        
        ; Wait TM0SUSP bit on 
        ; ------------------------
WaitingTimer02:
        in      ax, dx                          ; DX=MISCCR reg
        test    ax, 0002h
        jnz     Timer0Out2
        jmp     WaitingTimer02
        
Timer0Out2:
        pop     bx
        pop     ax                              ; restore AX
        pop     dx                              ; restore DX
        jmp     MiniDelayDone
        
        ; ---------------------
        ;   VT3043 timer set
        ; ---------------------
VT3043_Timer:
        call    MIIDelay
        call    MIIDelay
        call    MIIDelay
        
MiniDelayDone:
        ret
MACminiDelay    endp

; -----------------------------------------------------
;
;
;
;
; -----------------------------------------------------
IFDEF   LinkChange
SetToSenseLink  proc    near

        push    bx
        mov     bx, Ioport

        lea     dx, [bx].SCsrRegStruc.MIICR
        in      al, dx
        and     al, not 80h                 ; turn off MAUTO
        out     dx, al
        call    MIIDelay
        call    MIIDelay
        call    MIIDelay
        
        lea     dx, [bx].SCsrRegStruc.MIIAdr
        mov     al, 41h                     ; turn on MSRCEN
        out     dx, al

        mov     ecx, 0ffffh
        
Waiting1:
        in      al, dx
        test    al, 20h
        jnz     MDone
        loop    Waiting1
        
MDone:
        call    MIIDelay
        lea     dx, [bx].SCsrRegStruc.MIICR
        in      al, dx
        or      al, 80h                     ; turn on MAUTO
        out     dx, al
        call    MIIDelay
        call    MIIDelay

NoLinkChange:
        pop     bx
        ret
SetToSenseLink  endp

; -----------------------------------------------------
;
;
;
;

ENDIF

;****************************************************************
; 2003/5/6, guard
; vTurnOnMode10 and vTurnOffMode10 is used to switch the bit 
; MODE10TEN on PCI-52. it it used to control tx threshold 
;
; In 3043,if MODE10TEN is on, the tx threshold is 128
; In others, if MODE10TEN is on, the tx threshold is 64
; In 3206, the tx FIFO and rx FIFO are only 1.6K ( others are 128),
; so we turn on MODE10TEN to make it
;****************************************************************
vSetPCIMode2Register	proc
	cmp	pciRevisionId,RevisionID3106S
	jae	TurnOffMode10Ten

	cmp	pciRevisionId,RevisionID3206
	jae	TurnOnMode10Ten

	cmp pciRevisionId,RevisionID3065
	jb  TurnOnMode10Ten
	
TurnOffMode10Ten:
	call	vTurnOffMode10
	ret

TurnOnMode10Ten:
	call	vTurnOnMode10
	ret	
vSetPCIMode2Register	endp

vTurnOnMode10 	proc
	mov	di, 52h
	mov	cl, 02h
	call    WriteConfigByte
	ret
vTurnOnMode10	endp

vTurnOffMode10	proc
	mov	di, 52h
	mov	cl, 00h
	call	WriteConfigByte
	ret
vTurnOffMode10	endp

vPCIGeneralSet  proc

    call    vSetPCIMode2Register
IFDEF   WriteMode0
    mov     di, 50h
    mov     cl, 80h
    call    WriteConfigByte
ENDIF
    ; added by Ben (10/20/00), for conforming 802.3 spec.
    ; ----------------------------------------------------S
    mov     di, 53h         ; wirtemode3
    call    ReadConfigByte
    or      cl, 04h         ; Turn on MIION, Bit2
    call    WriteConfigByte
    ; ----------------------------------------------------E
    ret
vPCIGeneralSet  endp

IF 0
;-----------------------------------------------------------------
; added by guard, 06/20/2003
; check phy vendor 
; if it is not via, set cflag
;    VIA PHY ID: PHY ID 1 (offset 02h in PHY reg) : 0101h
;                PHY ID 2 (offset 03h in PHY reg) : 8F20h~8F2Fh
;                         (3072 PHY: 8F20h~8F27h, 3207 PHY: 8F28h~8F2Fh)
;-----------------------------------------------------------------
RhinePHYID1     equ     0101h

RhinePHYID3072  equ     08F20h
RhinePHYID3207  equ     08F28h

cCheckPHYVendor   proc    near
    mov     byMIIIndex, MII_REG_PHYIDR1     ; PHYIDR1
    call    MIIRead
    cmp     ax, RhinePHYID1
    jne     IsNotVIAPHY
    mov     byMIIIndex, MII_REG_PHYIDR2     ; PYHIDR2
    call    MIIRead
    
    and     ax, 0fff0h
    cmp     ax, RhinePHYID3072
    jne     IsNotVIAPHY

    clc
    ret
IsNotVIAPHY:
    stc    
    ret
cCheckPHYVendor   endp
ENDIF

extrn BusNoPrompt:byte
extrn DeviceNoPrompt:byte
extrn IOBasePrompt:byte
extrn AddrPrompt:byte
extrn CRLFMsg:byte
extrn ChoicePrompt:byte
extrn ClosePrompt:byte

ChoseSlot       proc    near
IFDEF DOS
		push    cx
		
		xor     cx,cx
		mov     cl,NumberOfNIC
		xor     dx,dx
		mov     ax,1
		      
PrintSlotEntries:
		push    cx
		push    ax
		
		xor     dx, dx
		call    PutNum

        mov     di,offset DGROUP:BusNoPrompt
        call    PutString
		mov     si,SlotIndex
		mov     ax,BusNo [si]
		xor     dx,dx
		call    PutNum


        lea     di, DeviceNoPrompt
        call    PutString
		mov     si,SlotIndex
		mov     ax,DeviceNo [si]
		xor     dx,dx
        call    PutNum

		
		lea     di,IOBasePrompt
        call    PutString
		mov     si,SlotIndex
		mov     ax,pciIOBase [si]
		xor     dx,dx
		call    PutHex
		
		lea     di,AddrPrompt
        call    PutString

        mov     si,offset DGROUP:pciEtherID
        mov     di,offset DGROUP:EthernetID
        mov     ax, SlotIndex
        mov     dx, 3
        mul     dx
        add     si, ax
        call    ConvertEtherID
        lea     di,EthernetID
		call    PutString
				
	    lea     di, CRLFMsg
	    call    PutString
	    
		pop     ax     
		add     SlotIndex, 2                           
		inc     ax
		
		pop     cx
		dec     cx
		cmp     cx, 0
		jnz     PrintSlotEntries                
PromptAgain:                
		lea     di,ChoicePrompt
		call    PutString

		xor     dx,dx
		xor     ah,ah
		mov     al,NumberOfNIC
		call    PutNum

        lea     di, ClosePrompt
        call    PutString
	    lea     di, CRLFMsg
	    call    PutString

WaitKeyStrike:
		mov     ah, 1
		int     16h
        jz      WaitKeyStrike


		sub     al,'0'
		cmp     al,1
		jb      WaitKeyStrike
		cmp     al,NumberOfNIC
		ja      WaitKeyStrike


		xor     ebx,ebx
				
		dec     al
		mov     bl,al
		pop     cx
ELSE
        mov     bl, 0
ENDIF
		ret
ChoseSlot       endp


;------------------------------------
; check user specify keyword,
; DEVICEID > PCISLOT > BUSID
;   IN:
;       none
;   OUTPUT:
;       bx : the user specify.
;       cflag: if success, cflag is clear. otherwise cflag is set.
;------------------------------------------------------------------
CheckUserSpecify    proc    near
        push    ax
        push    cx
        push    dx
        push    si
        push    di
        xor     si, si
        xor     di, di              ; how many adapters are matched?
        xor     cx, cx
        mov     cl, NumberOfNIC

CheckUserSpecifyLoop:
        
        mov     dx, DeviceNo[si]
        cmp     dx, UserDeviceNo
        jne     CheckNextCard
        mov     bx, si
        inc     di
        ; remove keyword SLOT (2003/05/26)
        ;mov     dx, PCISlot[si]
        ;cmp     dx, UserSlot
        ;jne     CheckNextCard
        mov     dx, BusNo[si]
        cmp     dx, UserBusNo
        je      AllMatch
        
CheckNextCard:
        add     si, 2
        loop    CheckUserSpecifyLoop
        
        ;-------------------------------------------------
        ; no perfect matched
        ; check one matched, multi matched or no matched
        ;-------------------------------------------------
        cmp     di, 1
        jne     NoMatchorMultiMatched
        shr     bx, 1
        clc
        jmp     CheckUserSpecifyOver
        
NoMatchorMultiMatched:

        stc
        jmp     CheckUserSpecifyOver
AllMatch:
        shr     bx, 1
        clc
CheckUserSpecifyOver:
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     ax
        ret
CheckUserSpecify    endp

;---------------------------------------
; dx:ax is double word want to display
; all registers will be reserved
;-----------------------------------------
PutNum  proc    near
        pusha
        push    es

        push    ds
        pop     es

        mov     si, 10
        mov     di,offset DGROUP:number_buffer
        call    LongToASCII             ; now string at ES:DI
        call    PutS                    ; display it
        
        pop     es
        popa
        ret
PutNum  endp

;---------------------------------------
; dx:ax is double word want to display
; all registers will be reserved
;-----------------------------------------
PutHex proc    near
        pusha
        push    es

        push    ds
        pop     es

        mov     si, 16
        mov     di,offset DGROUP:number_buffer
        call    LongToASCII             ; now string at ES:DI
        call    PutS                    ; display it
        
        pop     es
        popa
        ret
PutHex  endp

;---------------------------------------------------------------------------
; check if NodeAddress is vaild. Boardcast, Multicast, and null address
; are all invaild.
;   IN:
;       es:di -> node address
;   OUT:
;       if node address is invalild, cflag is set.
;---------------------------------------------------------------------------
CheckNodeAddrVaild  proc    near

    push    ax
    push    cx
    push    di

    ; check if boardcast address
    mov     cx, 3
    mov     si, di
@@:
    mov     ax, word ptr es:[si] 
    cmp     ax, 0ffffh
    jne     @F
    add     si, 2
    loop    @B
    jmp     NodeAddressIsInVaild
@@:

    ; check if multicast address
    mov     al, byte ptr es:[di]
    test    al, 01h
    jnz     NodeAddressIsInVaild
    
    ; check if null address
    mov     cx, 3
    mov     si, di
@@:
    mov     ax, word ptr es:[si] 
    cmp     ax, 0h
    jne     @F
    add     si, 2
    loop    @B
    jmp     NodeAddressIsInVaild
@@:    

    clc
    jmp     CheckNodeAddrVaildOver

NodeAddressIsInVaild:
    stc
    
CheckNodeAddrVaildOver:

    pop     di
    pop     cx
    pop     ax
    ret
CheckNodeAddrVaild  endp

;---------------------------------------------------------------------
; If no adpter is found. zflag is set
;---------------------------------------------------------------------
PreCheckAdapter proc    near
wOrigIndex     equ     [bp-2]
wTargetIndex   equ     [bp-4]
        push    bp
        mov     bp, sp
        sub     sp, 4

        push    bx
        push    cx
        push    dx
        push    di
        push    si


        xor     si, si
        mov     wOrigIndex, si

        xor     di, di
        mov     wTargetIndex, di
        xor     cx, cx
        mov     cl, NumberOfNIC

CheckAdapterLoop:

IFDEF PROTECTED
        push    cx

        mov     si, wOrigIndex
        mov     al, pciRevisionId1[si]
        mov     pciRevisionId, al
        shl     si, 1
        mov     bx, pciIOBase1[si]
        mov     Ioport, bx


        lea     dx, [bx].SCsrRegStruc.STICKHW
        in      ax, dx
        and     al, 0fch
        out     dx, al

	    cmp     pciRevisionId,RevisionID3106J
	    jb      NoEEPROM_CRC_CHECK
	    call    VerifySromCRC32
        jz      NoEEPROM_CRC_CHECK
                
InitErrorExit11:
        pop     cx
     
        mov     si, wOrigIndex
        inc     si
        mov     wOrigIndex, si
        loop    CheckAdapterLoop
        jmp     PreCheckAdapterOver
NoEEPROM_CRC_CHECK:
        pop     cx
ENDIF

        mov     si, wOrigIndex
        mov     di, wTargetIndex

        call    CopyMatchAdapter
        
        inc     di
        mov     wTargetIndex, di
        inc     si
        mov     wOrigIndex, si

        loop    CheckAdapterLoop

PreCheckAdapterOver:
        mov     ax, wTargetIndex
        mov     NumberOfNIC, al


        pop     si
        pop     di
        pop     dx
        pop     cx
        pop     bx

        mov     sp, bp
        pop     bp
        ret

PreCheckAdapter endp

;---------------------------
; si--> source index
; di--> dest index
;---------------------------
CopyMatchAdapter    proc    near

        push    ax
        push    si
        push    di

        mov     al, PCIINT1[si]
        mov     PCIINT[di], al
        mov     al, pciRevisionId1[si]
        mov     pciRevisionId[di], al
        
        
        shl     si, 1
        shl     di, 1
        mov     ax, pciIOBase1[si]
        mov     pciIOBase[di], ax
       
       
        mov     ax, BusNo1[si]
        mov     BusNo[di], ax
        
        mov     ax, pciDeviceId1[si]
        mov     pciDeviceId[di], ax     
        
        mov     ax, DeviceNo1[si]
        mov     DeviceNo[di], ax

        pop     di
        pop     si
        pop     ax

        ret
CopyMatchAdapter    endp

        END_INIT_CODE
        end
        
