;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: data.asm
; 
;  Purpose: Describe what this file is going to do.
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       none
; 
;  Revision History:
;       01-15-2003 GuardKuo: add VIA Networking Copyright message
;       01-17-2003 GuardKuo: move CRC table to the end of DATA segment
;                            fixed the problem of system halt on RPL reboot environment
;
; 
                page    88,122
                title   DATA - Data Structures (2.0.1 Spec)

.xlist
IFDEF OS2
include devsym.inc
include devhlp.inc
ENDIF
include includes.mac
include srom.inc

.list
.lfcond
.sall

;----------------------------------------------------------------------------
;	Macro used for generating length preceded, 0 terminated strings.
;
;	Example:	Message	CustomString1	'TotalTxCount'
;
;----------------------------------------------------------------------------
Message     macro   name, stringg
    local   tail
    name    db      (tail-2)-name
            db      stringg, 0
    tail    equ     $
	endm
	
.386
;------ Imported Interfaces -------------------------------------------------;

extrn           system:far


extrn           keyn_drivername:BYTE    ; from msg
extrn           keyn_ioaddress:BYTE     ; from msg
extrn           keyn_netaddr:BYTE       ; from msg
extrn           keyn_interrupt:BYTE     ; from msg
extrn           keyn_earlyreceive:BYTE  ; from msg
extrn           keyn_earlytransmit:BYTE ; from msg
extrn           keyn_fullduplex:BYTE    ; from msg
extrn           keyn_linespeed:BYTE     ; from msg
extrn           keyn_auto:BYTE          ; from msg
extrn           keyn_connectiontype:BYTE; from msg added by Ben (2001/03/07)
extrn           keyn_flowctl:BYTE       ; from msg added by Ben (2001/09/13)
extrn           keyn_valpktlen:BYTE     ; form msg added by guard (2003/06/24)
extrn           keyn_busno:BYTE
extrn           keyn_deviceno:BYTE


extrn           Request:near
extrn           TransmitChain:near
extrn           TransferData:near
extrn           ReceiveRelease:near
extrn           IndicationOn:near
extrn           IndicationOff:near

extrn           devStrategy:near
DOSXTRN         devInterrupt:near


extrn           first_name:byte

; *********************************************************
;
                BEGIN_HEADER
;
; *********************************************************
                public  devHeader
IFDEF OS2
DEVATTR         EQU     DEV_CHAR_DEV+DEVLEV_1+DEV_GIOCTL
devHeader       SysDev  <-1,DEVATTR,offset CGROUP:devStrategy,0,'        '>
ELSE
devHeader       dd      -1
                dw      DEV_CHAR_DEV+DEV_IOCTL
                dw      offset CGROUP:devStrategy
                dw      offset CGROUP:devInterrupt
                db      '        '
ENDIF
                END_HEADER
                
;------ Data in Code Segment ------------------------------------------------;
;
; Address of data segment, retrievable from code segment
;----------------------------------------------------------------------------
; *********************************************************
;
                BEGIN_CODE
;
; *********************************************************

                public  cs_ip               ; added by Ben (10/12/00)
cs_ip           dw      4 dup(0)            ; added by Ben (10/12/00)

                public  cs_ds
cs_ds           dw      ?

IFNDEF  def16bit    ;---------------------\
                public  TxOddCount
TxOddCount      db      0
                public  TxOddValue
TxOddValue      dd      0
ENDIF               ;---------------------/
                END_CODE

;------ Data in Data Segment ------------------------------------------------;
;
; Address of data segment, retrievable from data segment
;----------------------------------------------------------------------------
; *********************************************************
;
                BEGIN_DATA
;
; *********************************************************
serialnumber    db      'VIA Rhine Family Fast Ethernet Adapter',0
                db      20 dup(0)

IFDEF OS2
                align   4
                public  devHelper
devHelper       dd      0
ENDIF

; Timer ticks since last clear
;---------------------------------------
IFDEF ANYSTATS  ;-------------------------------------------\
IFDEF DOS   ;-------------------------------------------\
                public  timerCount
timerCount      dd      0

; The next timer tick handler in the INT 08h chain
; --------------------------------------------------
                public  timerChain
timerChain      dd      0
ENDIF       ;-------------------------------------------/
ENDIF           ;;-------------------------------------------/

                public  Ioport
Ioport          dw      300h    ; IOPORT
                public  SlotValue
SlotValue       dw      0h      ; SLOT value
                public  IntLevel
IntLevel        db      5

                public  ERFlag
ERFlag          db      0           ; Early Receive
                public  ETFlag
ETFlag          db      0           ; Early Transmit
                public  FDXFlag
FDXFlag         db      0FFh        ; Full Duplex
                public  AutoFlag
AutoFlag        db      1           ; AUTO keyword given
                public  byUserOverride
byUserOverride  db      0           ; NWAY keyword given

                public  UserBusNo
                public  UserDeviceNo
                public  SlotIndex
UserBusNo       dw      0ffffh
UserDeviceNo    dw      0ffffh
SlotIndex       dw      0
; added by Ben (2001/03/07), var to save connection type when parsing config.
; 0=Auto, 1=100F, 2=100H, 3=10F, 4=10H
; -----------------------------------------------------------------------------\
                public  ConnectionType
ConnectionType  db      0ffh        ; user specify connection type      
                public  UsedSlotArray
UsedSlotArray   db      4   dup (0) ; had been used slot number                
; -----------------------------------------------------------------------------/

; added by Ben (2001/09/13), var to save flow control when parsing config.
; 0=DISABLE, 1=ENABLE, 2=HARDWARE_DEFAULT
; -----------------------------------------------------------------------------
                public  wFLOWCTLFlag
wFLOWCTLFlag    dw      0           ; user specify connection type      

; added by Ben (2001/09/13), var to save PHY's ANAR value
; -----------------------------------------------------------------------------
                public  wOriPHYANARValue
wOriPHYANARValue    dw  0           

                public  dbLegacyForcedMode
dbLegacyForcedMode  db  0           ; by Ben (2001/09/24), for distinguish
                                    ; to use legacy forced mode or 
                                    ; Nway forced mode. It's used in
                                    ; ForceNotNway().

; added by guard (2003/06/21),  var to save VARPKTLEN when parsing config.
; 0=DISABLE, 1=ENABLE
; -----------------------------------------------------------------------------------
                public  wVALPKTLENFlag
wVALPKTLENFlag      dw      0           ; default is disable
                public  byLineSpeed
byLineSpeed     db      0FFh        ; Line Speed
                public  ERCurrPtr
ERCurrPtr       dw      0



                public  wBak
wBak            dw      0

                public byNowRevID           ; added by Ben (10/04/00)
byNowRevID      db      0                   ; added by Ben (10/04/00)

                public  RDStart
RDStart label   byte                        ; initial.asm will use this
IFDEF   DYNAALLOC
                db      size SRxDescStruc * (W_DEFAULT_RX_DESC_COUNT+1) dup (0)
public  RXBufferSegment
public  RXPhysicallAddr
public  CurSEGmentCount
public  CurRXDescPtr
RXBufferSegment     dw      8 dup (0)
RXPhysicallAddr     dd      8 dup (0)
CurSEGmentCount     dw      0
CurRXDescPtr        dw      0
ELSE
                db      32 dup (0)          ; reserved to align to 32 byte alignment
                db      ((W_DEFAULT_RX_DESC_COUNT+1) * W_RX_BUFFER_SIZE)  dup  (0)
                db      32 dup (0)          ; reserved to align to 32 byte alignment
ENDIF
                public  TDStart
TDStart label   byte                        ; initial.asm will use this
                db      32 dup (0)          ; reserved to align to 32 byte alignment
                db      ((W_DEFAULT_TX_DESC_COUNT+1) * W_TX_BUFFER_SIZE) dup  (0)
                db      32 dup (0)          ; reserved to align to 32 byte alignment

IFDEF   DOS
                public      VEmmDesp
VEmmDesp        VDSStruc    <>
ENDIF

;VT3065A : Define TxEmmDescriptor & VDSActiveFlag
        public  TxEmmDescriptor
TxEmmDescriptor VDSStruc  <>
        public	VDSActiveFlag
VDSActiveFlag	db	1                       ; changed by Ben (2001/03/07), 0->1
;VT3065A : Define TxEmmDescriptor & VDSActiveFlag

IFDEF   OS2
                public  segTX
segTX           dw      0
                public  segRX
segRX           dw      0
ENDIF

;--------------------------------------------------------------
;/** NICReg
;--------------------------------------------------------------
        even
        public          wErrCurrTxDescAddr
wErrCurrTxDescAddr      dd      0                   ; Added by Ben (07/11/2000)

        public          InISR
InISR                   db      0

        public          byMIIIndex
byMIIIndex              db      0

        public          wMIIValue
wMIIValue       dw      0

        public          FDXFlagNow
FDXFlagNow              db      0

        public          wIMRShadow
wIMRShadow              dw      07BFFh

        public          wStartTime
wStartTime              dw      0


        public          LinkStatus
LinkStatus              db      0

        public          W_MAX_TIMEOUT               ; Added by Ben (07/11/2000)
W_MAX_TIMEOUT           dw      0fffh               ; Added by Ben (07/11/2000)

        
;/////////////////////////////////
;Change the threshold from 128 to Store&Forward
        public          byRcrValue
byRcrValue              db      BY_RCR_DEFAULT      ; added by Ben (01/19/2001)

;/////////////////////////////////
;Change the threshold from 1024 to Store&Forward
        public          byTcrValue
byTcrValue              db      BY_TCR_DEFAULT      ; added by Ben (01/19/2001)

;/////////////////////////////////
;Change the threshold from 8 to Store&Forward
        public          byDMALength
byDMALength             db      DMA_LENGTH_stf

;/////////////////////////////////
        public          TxThreshSpecify
TxThreshSpecify         db      0
        public          RxThreshSpecify
RxThreshSpecify         db      0
        public          DMALengthSpecify
DMALengthSpecify        db      0
        public          wISRImage
wISRImage               dw      0
        public          PktRaceContinue
PktRaceContinue         dw      0

;//////////////////////////////////////////
        public          pciDeviceId
pciDeviceId             dw      4    dup(0)
        public          pciDeviceId1
pciDeviceId1            dw      4    dup(0)

        public          pciRevisionId
pciRevisionId           db      4    dup(0)
        public          pciRevisionId1
pciRevisionId1          db      4    dup(0)


        public          pdescTxLastPtr
pdescTxLastPtr		    dw	0               ; For a packet, is saves the last
                                            ; descriptor position.
        public          pdescTxPreviousPtr
pdescTxPreviousPtr	    dw	0               ; Save the previous pointer
        public          pdescTxBufferPhyAddr
pdescTxBufferPhyAddr	dd	0               ; Save the buffer physical address.

;//////////////////////////////////////////
        public          len
len                     dw      100h
        public          add1
add1                    dd      0
        public          buf
buf                     db      100h     dup(0)
        public          F000Save
F000Save                dw      0

        align   4
        public          pdescRxListHead
pdescRxListHead         dw      0
        public          wRxNumBuffers
wRxNumBuffers           dw      W_DEFAULT_RX_DESC_COUNT
        public          pdescRxRead
pdescRxRead             dw      0       ; buffer to be processed
        public          pRxResourcePtr
pRxResourcePtr          dw      0       ; Pointer to the Rx list allocated
                                        ; memory.
        public          wRxDescFilterValue
wRxDescFilterValue      dw      W_RX_STATUS_NON_PROMISCUOUS_VALUE
                                        ; Error filter,
                                        ; default is in Non-promiscuous mode
        public          pdescTxListHead
pdescTxListHead         dw      0
        public          wTxNumBuffers
wTxNumBuffers           dw      W_DEFAULT_TX_DESC_COUNT
        public          pdescTxRead
pdescTxRead             dw      0       ; buffer to be removed from ring
        public          pdescTxWrite
pdescTxWrite            dw      0       ; free space to put data in
        public          wTxNumPosted
wTxNumPosted            dw      0
        public          DriverCustomTallyMPA
DriverCustomTallyMPA    dd      0
        public          DriverCustomTallyCRC
DriverCustomTallyCRC    dd      0
        public          ReceiveConfig
ReceiveConfig           db      0Ch
PCIKeyword              db      0

; added by Ben (2001/08/09), variables for CAM access
; ------------------------------------------------------------------\
        public          byCurrCAMIndex
byCurrCAMIndex          db      0
        public          wVIDDefault
wVIDDefault             dw      0               ; only [0:11] is valid
        public          dbUpdatRBRDU
dbUpdatRBRDU            db      0
        public          dbCurrPhyMode
dbCurrPhyMode           db      0               ; [3:0]=[TX_FD,TX,10_FD,10]

; ------------------------------------------------------------------/

                ;**/
                public  LookAheadSize
LookAheadSize   dw      64
                public  TotalRxCnt
TotalRxCnt      dw      0


                
                even

                public  ProductID
ProductID       dw      0c8h


                public  adapterBits
adapterBits     db      0

                public  MCAddress
MCAddress       db      6 dup (0)


; lookahead buffer include 256 bytes buffer and 4 bytes receive header
; ------------------------------------------------------------------------
IFNDEF DYNAALLOC
                public  LookAheadBuf
LookAheadBuf    db      2048 dup (0)
ENDIF
                public  saved_bx
saved_bx        dw      0

                public  saved_es
saved_es        dw      ?

                public  rqblock
rqblock         label    byte
                ReqBlock <>

IFDEF OS2
                public  infoSeg
infoSeg         dw      0
ENDIF


; added by guard (2005/01/28)
; Someone hope their driver don't be loaded by other vendor's NIC that also use Rhine series
; MAC chip. So we need check sub vendor id.
public sub_vendorid
align 16
vn_sign db  'SVID'
sub_vendorid    dw  0h       ; if this value is zero, we will skip to compare subvendor id

                END_DATA





NEWPAGE <Queues>
;--------------------------------------------------------------------------------
; transmit and request queue entries.  to allow the transmit queue size to be
; configurable the transmit queue entries are placed in a separate segment so
; they can be positioned just in front of the discardable stuff.  under OS/2
; we can't extend the size of our data segment so the space is pre-allocated.
; under DOS we only need a label here and we will allocate the actual qentries
; over the init code and data.
;
; note: the point is that allocating space for 50 x 128+ bytes here makes the
;       file rather larger than necessary on disk and we want to be able to
;       put a lot of MAC drivers on a single floppy.
;
; note2: if we split the OS/2 data segment in two, a device header segment
;        low and moved the data segment high, we wouldn't have this problem
;        and could shrink the size of the file on disk, as well as the
;        real mode footprint.
;--------------------------------------------------------------------------------
; *********************************************************
;
                BEGIN_QSPACE
;
; *********************************************************

                even
                public  qtarray
IFDEF OS2
qtarray         label   byte
ELSE
qtarray         label   byte
ENDIF
                END_QSPACE

; *********************************************************
;
                BEGIN_INIT_DATA
;
; *********************************************************                
; A dummy word location for OS/2 calls
; ----------------------------------------
IFDEF OS2
                public  dummy
dummy           dw      0
ENDIF
                public  days
days            dw      0FFFFh                  ; Data table (indexed access)
                db       1Eh, 00h, 3Ah, 00h, 59h, 00h
                db       77h, 00h, 96h, 00h,0B4h, 00h
                db      0D3h, 00h,0F2h, 00h, 10h, 01h
                db       2Fh, 01h, 4Dh, 01h, 6Ch, 01h

IFDEF OS2
                public  physDS
physDS          dd      0
ENDIF

                public  number_buffer
number_buffer   db      12 dup (0)

                public  protmgr_handle
protmgr_handle  dw      0

                public  protmgr_name

IFDEF DOS
protmgr_name    db      'PROTMAN$', 0
ELSE
protmgr_name    db      '/DEV/PROTMAN$', 0

                public  action_taken
action_taken    dw      0
ENDIF

                public  second_name
                ;/** ethernetspec
                ; ------------------------------
second_name     db      'FETND2$', 3 dup (0)
;**/
                even
                public  our_name
our_name        dw      offset DGROUP:first_name
keyn_off        db      'OFF',0
keyn_on         db      'ON', 0
                db       13h, 00h

IFDEF OS2
                public  chardata
chardata        db      10 dup(0)
ENDIF



NEWPAGE <Keyword Table>
;------ Keyword Table -------------------------------------------------------;
;
; The following table defines the keywords that are recognized by this driver
; as well as a few of their characteristics (right hand side required, range
; of legal values, etc) to allow general purpose validation/processing
;----------------------------------------------------------------------------
                public  keyword_table
keyword_table   label   word
        ;/** ethernetspec
        key_entry <offset DGROUP:keyn_drivername,KEY_DRIVERNAME,RHS_STRING,1,8>
        key_entry <offset DGROUP:keyn_ioaddress,KEY_IOADDRESS,RHS_ANYTHING,220H,0FE00H>
        key_entry <offset DGROUP:keyn_interrupt,KEY_INTERRUPT,RHS_INTEGER,02,0fH>
        key_entry <offset DGROUP:keyn_netaddr,KEY_NETADDR,RHS_STRING,0ch,0ch>
;mmmmm
        key_entry <offset DGROUP:keyn_earlyreceive,KEY_EARLYRECEIVE,RHS_INTEGER,0,1>
        key_entry <offset DGROUP:keyn_earlytransmit,KEY_EARLYTRANSMIT,RHS_INTEGER,0,1>
        key_entry <offset DGROUP:keyn_fullduplex,KEY_FULLDUPLEX,RHS_INTEGER,0,1>
        key_entry <offset DGROUP:keyn_auto,KEY_AUTO,RHS_INTEGER,0,1>
        key_entry <offset DGROUP:keyn_linespeed,KEY_LINESPEED,RHS_INTEGER,10,100>
        
        ; added by ben (2001/03/07), add one keyword table
        ; modified by Ben (2001/09/14), RHS_INTEGER->RHS_STRING
        ; -------------------------------------------------------
        key_entry <offset DGROUP:keyn_connectiontype,KEY_CONNECTIONTYPE,RHS_STRING + RHS_INTEGER,0,15>
        
        ; added by ben (2001/09/13), add one keyword table
        ; -------------------------------------------------------
        key_entry <offset DGROUP:keyn_flowctl,KEY_FLOWCTL,RHS_STRING + RHS_INTEGER,0,20>
        
        ; added by guard (2002/06/21), add one keyword table
        ; -------------------------------------------------------
        key_entry <offset DGROUP:keyn_valpktlen,KEY_VALPKTLEN,RHS_STRING + RHS_INTEGER,0,7>

        ; added by guard (2003/05/07), add two keyword to table
        key_entry <offset DGROUP:keyn_busno,KEY_BUSNO,RHS_INTEGER,0,255>
        key_entry <offset DGROUP:keyn_deviceno,KEY_DEVICENO,RHS_INTEGER,0,31>
        dw      0
        ;**/
        
        
; ----------------------------------------------------------------\
; Add by Ben (2001/09/13), CONNECTIONTYPE & FLOW_CONTROL keywords
; value (string or integer) handling block.
;
;   In NET.CFG, we can use the following ways to specify connection
;   type and flow control ability.
;   
;   CONNECTIONTYPE  AUTOSENSE       or  0  
;                   10BaseT         or  3
;                   10BaseTFD       or  4
;                   100BasetTX      or  1
;                   100BasetTXFD    or  2
; ---------------------------------------------------------
;   FLOW_CONTROL    HARDWARE_DEFAULT    or  2
;                   ENABLE          or  1
;                   DISABLE         or  0
;
; ----------------------------------------------------------------
; Add by guard (2003/06/21), VALPKTLEN keywords value 
; (string or integer) handling block.
;
;   VALPKTLEN       ENABLE          or  1
;                   DISABLE         or  0
;                   DEFAULT         or  0
;-----------------------------------------------------------------

Message                 MAUTO   'AUTOSENSE'
Message                 M10H    '_10BASET'
Message                 M10F    '_10BASETFD'
Message                 M100H   '_100BASETX'
Message                 M100F   '_100BASETXFD'

ConTypeID_AUTO          equ     0
ConTypeID_100H          equ     1
ConTypeID_100F          equ     2
ConTypeID_10H           equ     3
ConTypeID_10F           equ     4

Message                 FLOW_HD     'HARDWARE_DEFAULT'
Message                 FLOW_HD1    'HD'
Message                 FLOW_ENA    'ENABLE'
Message                 FLOW_DIS    'DISABLE'

FlowCtlID_HardDefault   equ     2
FlowCtlID_Enable        equ     1               ; follow DLINK
FlowCtlID_Disable       equ     0               ; follow DLINK

; Add by guard (2003/06/21), VALPKTLEN keywords value
VALPKTLEN_ENA           equ     FLOW_ENA
VALPKTLEN_DIS           equ     FLOW_DIS


ValPktLen_Enable           equ     1
ValPktLen_Disable          equ     0

;----------------------------------------------------------------------------
;       This table is required for use with the CONNECTIONTYPE value
;----------------------------------------------------------------------------
                        public  SupportedCONTYPE
SupportedCONTYPE        dw      5                   ;Num. CONNECTIONTYPE supported
                        ; AUTOSENSE
                        ; -------------------
                        dw      offset DGroup:MAUTO       
                        dw      ConTypeID_AUTO
                        
                        ; 10BaseT
                        ; ----------------
                        dw      offset DGroup:M10H
                        dw      ConTypeID_10H
                        
                        ; 10BaseTFD
                        ; -----------------
                        dw      offset DGroup:M10F
                        dw      ConTypeID_10F
                        
                        ; 100BasetTX
                        ; -----------------
                        dw      offset DGroup:M100H
                        dw      ConTypeID_100H
                        
                        ; 100BasetTXFD
                        ; -----------------
                        dw      offset DGroup:M100F
                        dw      ConTypeID_100F
                        
;----------------------------------------------------------------------------
;       This table is required for use with the FLOWCTL value
;----------------------------------------------------------------------------
                        public  SupportedFLOWCTL
SupportedFLOWCTL        dw      4                   ;Num. FLOWCTL supported
                        ; HardwareDefault
                        ; -------------------
                        dw      offset DGroup:FLOW_HD       
                        dw      FlowCtlID_HardDefault
                        
                        ; HardwareDefault1
                        ; -------------------
                        dw      offset DGroup:FLOW_HD1
                        dw      FlowCtlID_HardDefault
                        
                        ; Enable
                        ; ----------------
                        dw      offset DGroup:FLOW_ENA
                        dw      FlowCtlID_Enable

                        ; Disable
                        ; ----------------
                        dw      offset DGroup:FLOW_DIS
                        dw      FlowCtlID_Disable



; Add by guard (2003/06/21), VALPKTLEN keywords value
;----------------------------------------------------------------------------
;       This table is required for use with the VALPKTLEN value
;----------------------------------------------------------------------------
                    public  SupportedVALPKTLEN
SupportedVALPKTLEN      dw      2                   ;Num. VALPKTLEN supported
                        ; Enable
                        ; ----------------
                        dw      offset CGroup:VALPKTLEN_ENA
                        dw      ValPktLen_Enable

                        ; Disable
                        ; ----------------
                        dw      offset CGroup:VALPKTLEN_DIS
                        dw      ValPktLen_Disable
public  SSromReg
public  pbyRomRegs
public  pybWorkStream
public  Table256
public  Table256End

SSromReg    _SSromReg   <>      ; SROM Register
pbyRomRegs  db  ?               ; point to SROM Register

pybWorkStream   db  64  DUP(?)
	align 4
Table256    label   byte
	dd      000000000h
	dd      077073096h
	dd      0EE0E612Ch
	dd      0990951BAh
	dd      0076DC419h
	dd      0706AF48Fh
	dd      0E963A535h
	dd      09E6495A3h
	dd      00EDB8832h
	dd      079DCB8A4h
	dd      0E0D5E91Eh
	dd      097D2D988h
	dd      009B64C2Bh
	dd      07EB17CBDh
	dd      0E7B82D07h
	dd      090BF1D91h
	dd      01DB71064h
	dd      06AB020F2h
	dd      0F3B97148h
	dd      084BE41DEh
	dd      01ADAD47Dh
	dd      06DDDE4EBh
	dd      0F4D4B551h
	dd      083D385C7h
	dd      0136C9856h
	dd      0646BA8C0h
	dd      0FD62F97Ah
	dd      08A65C9ECh
	dd      014015C4Fh
	dd      063066CD9h
	dd      0FA0F3D63h
	dd      08D080DF5h
	dd      03B6E20C8h
	dd      04C69105Eh
	dd      0D56041E4h
	dd      0A2677172h
	dd      03C03E4D1h
	dd      04B04D447h
	dd      0D20D85FDh
	dd      0A50AB56Bh
	dd      035B5A8FAh
	dd      042B2986Ch
	dd      0DBBBC9D6h
	dd      0ACBCF940h
	dd      032D86CE3h
	dd      045DF5C75h
	dd      0DCD60DCFh
	dd      0ABD13D59h
	dd      026D930ACh
	dd      051DE003Ah
	dd      0C8D75180h
	dd      0BFD06116h
	dd      021B4F4B5h
	dd      056B3C423h
	dd      0CFBA9599h
	dd      0B8BDA50Fh
	dd      02802B89Eh
	dd      05F058808h
	dd      0C60CD9B2h
	dd      0B10BE924h
	dd      02F6F7C87h
	dd      058684C11h
	dd      0C1611DABh
	dd      0B6662D3Dh
	dd      076DC4190h
	dd      001DB7106h
	dd      098D220BCh
	dd      0EFD5102Ah
	dd      071B18589h
	dd      006B6B51Fh
	dd      09FBFE4A5h
	dd      0E8B8D433h
	dd      07807C9A2h
	dd      00F00F934h
	dd      09609A88Eh
	dd      0E10E9818h
	dd      07F6A0DBBh
	dd      0086D3D2Dh
	dd      091646C97h
	dd      0E6635C01h
	dd      06B6B51F4h
	dd      01C6C6162h
	dd      0856530D8h
	dd      0F262004Eh
	dd      06C0695EDh
	dd      01B01A57Bh
	dd      08208F4C1h
	dd      0F50FC457h
	dd      065B0D9C6h
	dd      012B7E950h
	dd      08BBEB8EAh
	dd      0FCB9887Ch
	dd      062DD1DDFh
	dd      015DA2D49h
	dd      08CD37CF3h
	dd      0FBD44C65h
	dd      04DB26158h
	dd      03AB551CEh
	dd      0A3BC0074h
	dd      0D4BB30E2h
	dd      04ADFA541h
	dd      03DD895D7h
	dd      0A4D1C46Dh
	dd      0D3D6F4FBh
	dd      04369E96Ah
	dd      0346ED9FCh
	dd      0AD678846h
	dd      0DA60B8D0h
	dd      044042D73h
	dd      033031DE5h
	dd      0AA0A4C5Fh
	dd      0DD0D7CC9h
	dd      05005713Ch
	dd      0270241AAh
	dd      0BE0B1010h
	dd      0C90C2086h
	dd      05768B525h
	dd      0206F85B3h
	dd      0B966D409h
	dd      0CE61E49Fh
	dd      05EDEF90Eh
	dd      029D9C998h
	dd      0B0D09822h
	dd      0C7D7A8B4h
	dd      059B33D17h
	dd      02EB40D81h
	dd      0B7BD5C3Bh
	dd      0C0BA6CADh
	dd      0EDB88320h
	dd      09ABFB3B6h
	dd      003B6E20Ch
	dd      074B1D29Ah
	dd      0EAD54739h
	dd      09DD277AFh
	dd      004DB2615h
	dd      073DC1683h
	dd      0E3630B12h
	dd      094643B84h
	dd      00D6D6A3Eh
	dd      07A6A5AA8h
	dd      0E40ECF0Bh
	dd      09309FF9Dh
	dd      00A00AE27h
	dd      07D079EB1h
	dd      0F00F9344h
	dd      08708A3D2h
	dd      01E01F268h
	dd      06906C2FEh
	dd      0F762575Dh
	dd      0806567CBh
	dd      0196C3671h
	dd      06E6B06E7h
	dd      0FED41B76h
	dd      089D32BE0h
	dd      010DA7A5Ah
	dd      067DD4ACCh
	dd      0F9B9DF6Fh
	dd      08EBEEFF9h
	dd      017B7BE43h
	dd      060B08ED5h
	dd      0D6D6A3E8h
	dd      0A1D1937Eh
	dd      038D8C2C4h
	dd      04FDFF252h
	dd      0D1BB67F1h
	dd      0A6BC5767h
	dd      03FB506DDh
	dd      048B2364Bh
	dd      0D80D2BDAh
	dd      0AF0A1B4Ch
	dd      036034AF6h
	dd      041047A60h
	dd      0DF60EFC3h
	dd      0A867DF55h
	dd      0316E8EEFh
	dd      04669BE79h
	dd      0CB61B38Ch
	dd      0BC66831Ah
	dd      0256FD2A0h
	dd      05268E236h
	dd      0CC0C7795h
	dd      0BB0B4703h
	dd      0220216B9h
	dd      05505262Fh
	dd      0C5BA3BBEh
	dd      0B2BD0B28h
	dd      02BB45A92h
	dd      05CB36A04h
	dd      0C2D7FFA7h
	dd      0B5D0CF31h
	dd      02CD99E8Bh
	dd      05BDEAE1Dh
	dd      09B64C2B0h
	dd      0EC63F226h
	dd      0756AA39Ch
	dd      0026D930Ah
	dd      09C0906A9h
	dd      0EB0E363Fh
	dd      072076785h
	dd      005005713h
	dd      095BF4A82h
	dd      0E2B87A14h
	dd      07BB12BAEh
	dd      00CB61B38h
	dd      092D28E9Bh
	dd      0E5D5BE0Dh
	dd      07CDCEFB7h
	dd      00BDBDF21h
	dd      086D3D2D4h
	dd      0F1D4E242h
	dd      068DDB3F8h
	dd      01FDA836Eh
	dd      081BE16CDh
	dd      0F6B9265Bh
	dd      06FB077E1h
	dd      018B74777h
	dd      088085AE6h
	dd      0FF0F6A70h
	dd      066063BCAh
	dd      011010B5Ch
	dd      08F659EFFh
	dd      0F862AE69h
	dd      0616BFFD3h
	dd      0166CCF45h
	dd      0A00AE278h
	dd      0D70DD2EEh
	dd      04E048354h
	dd      03903B3C2h
	dd      0A7672661h
	dd      0D06016F7h
	dd      04969474Dh
	dd      03E6E77DBh
	dd      0AED16A4Ah
	dd      0D9D65ADCh
	dd      040DF0B66h
	dd      037D83BF0h
	dd      0A9BCAE53h
	dd      0DEBB9EC5h
	dd      047B2CF7Fh
	dd      030B5FFE9h
	dd      0BDBDF21Ch
	dd      0CABAC28Ah
	dd      053B39330h
	dd      024B4A3A6h
	dd      0BAD03605h
	dd      0CDD70693h
	dd      054DE5729h
	dd      023D967BFh
	dd      0B3667A2Eh
	dd      0C4614AB8h
	dd      05D681B02h
	dd      02A6F2B94h
	dd      0B40BBE37h
	dd      0C30C8EA1h
	dd      05A05DF1Bh
	dd      02D02EF8Dh
Table256End label   byte
                END_INIT_DATA

; *********************************************************
;
                BEGIN_DATA
;
; *********************************************************
                public  nestLevel
nestLevel       db      0

                public  OffDepth
OffDepth        db      0

;                public overflowcnt
;overflowcnt     db      0

;                public OverFlowReXmitCnt
;OverFlowReXmitCnt      db      0

                public  RamSize
RamSize         db      10h    ;sRAM size in k

                public  indications
indications     db      0FFh

                public  disableMask
disableMask     db      0

                public  enableMask
enableMask      db      0

                public  ICPending
ICPending       db      0

                public  Intpending
Intpending      db      0

                public  IMRport
IMRPort         dw      0
                public  EOIs
EOIs            dw      0

                public  protDS
protDS          dw      0

                public  state
state           db      0

                public  oldstate
oldstate        db      0

;                public  RetryTxFlag
;RetryTxFlag     db      0

;                public  ResetTxConfigFlag
;ResetTxConfigFlag db    0

                public  SystemFlags
SystemFlags     db      0

                public  common
common          label   word
                dw      40h
                db      2          ; major NDIS version
                db      0          ; minor NDIS version
                dw      0
                db      2          ; major module version
                db      2          ; minor midule version
                dd      1          ; binding at lower boundary supported
                ;mmmmmdb      'ETHER16', 9 dup(0)  ; Module name
                ;db      'FETND', 11 dup(0)  ; Module name
                ; --------------
                ; modified guard (2003/07/08)
                db      'FETNDIS2', 8 dup(0)
                db      1          ; Protocol level at upper boundary of module
                db      1          ; Type of interface at upper boundary of
                                   ; module
                db      0          ; Protocol level at lower boundary of module
                db      0          ; Type of interface at lower boundary of
                                   ; module
                dw      ?          ; Module ID
                dw      ?          ; Module DS
                dw      offset CGROUP:System
                dw      ?
                dw      offset DGROUP:specific
                dw      ?
                dw      offset DGROUP:status
                dw      ?
                dw      offset DGROUP:mdispatch
                dw      ?
                dd      3 dup (0)

                public  specific
specific        label   word
                dw      60h        ; length of specific characteristics table
                db      'DIX+802.3', 7 dup (0) ;type name of MAC
                dw      6                      ;length of station address
                db      16 dup (0)             ;permanent station address
                db      16 dup (0)             ;current station address
                dd      0                      ;current functional address
                dw      offset DGROUP:multilist
                dw      ?                      ;
                dd      10000000               ;Link speed
                
; Bit#    DC21x4Setting     NDIS 2.01 Definition
; ------  -------------     --------------------
; bit<0>  yes               broadcast supported
; bit<1>  yes               multicast supported
; bit<2>  no                functional/group addressing
; bit<3>  yes               promiscuous mode is supported
; bit<4>  yes               software settable station address
; bit<5>  yes               statistics are always current
; bit<6>  no                initiateDiagnostics not supported
; bit<7>  no                loopback supported
; bit<8>  ReceiveLookahead  primary ReceiveLookahead
; bit<9>  no                IBM Source routing not supported (token ring)
; bit<10> no                reset MAC not supported
; bit<11> yes               open/close adapter supported
; bit<12> no                interrupt request supported
; bit<13> no                source routing bridge supported
; bit<14> yes               OS/2 GDT virtual addresses supported
; bit<15> yes               multiple TransferDatas permitted during a single indication
; bit<16> no                mac normally sets FrameSize = 0 in ReceiveLookahead
                ;dd      0000441Bh       ;0 0100 0100 0001 1011
                dd      0000C83Bh       ;0 1100 1000 0011 1011 b
                                        ;service flag
                                        ;support pbroadcast,multicast,
                                        ;promiscuous, software settable station
                                        ;address,resetMAC,GDT virtual address

                dw      5EAh            ;maximum frame size (both tx and rx)

                dd      0600h           ;total transmission buffer capacity
                                        ;in the driver(bytes)

                dw      600h            ;transmission buffer allocation block
                                        ;size(bytes)

                dd      3400h           ;total reception buffer capacity in the
                                        ;driver(bytes)

                dw      5EAh            ;reception buffer allocation block size
                                        ;(bytes)

                db       0FFH           ;IEEE vender code
                db       0FFH
                db       0FFH

                db       0              ;vender adapter code
                dw       offset DGROUP:serialnumber
                dw       ?
                dw      3               ;IRQ
                dw      1               ;transmit queue depth
                dw      8               ;Maxmum number of data blocks in buffer
                                        ;descriptors supported

                public  multilist
multilist       label   word
;Lantastic      dw      8               ;maximum number of multicast addresses
                dw      16              ;maximum number of multicast addresses
                dw      0               ;current number of multicast addresses
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)       ;Lantastic
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)
                db      16 dup(0)

                public  LastMCByteAddr
LastMCByteAddr  dw      0
;**/

;---------------------------------------
;
; MAC-specific status table
;
;---------------------------------------
                even
                public  status
status          label   word
                dw      MSTABLESIZE     ;length of status table
                dd      NOT_MAINTAINED  ;Date/Time when last run
                dd      0               ;MAC status
                dw      0               ;current packet filter

                dw      offset DGROUP:media_specific
                dw      ?
                ;dd      0
                dd      NOT_MAINTAINED
                                        ;Date/Time when last clearstats issued

                ;/** ethernetspec
                ; ------------------------------------------------
                dd      0               ;Total frames received OK

                dd      0               ;Total frames with CRC error
                ;dd      NOT_MAINTAINED  ;

                dd      0               ;Total byte received

                dd      0               ;no space error counts
                ;dd      NOT_MAINTAINED      ;4

                dd      NOT_MAINTAINED      ;total multicast frames received OK
                dd      NOT_MAINTAINED      ;total broadcast frames received OK
                dd      NOT_MAINTAINED      ;reserve
                dd      NOT_MAINTAINED      ;reserve
                dd      NOT_MAINTAINED      ;reserve
                dd      NOT_MAINTAINED      ;reserve
                dd      NOT_MAINTAINED      ;reserve
                dd      NOT_MAINTAINED      ;hardware error counts
                dd      0               ;Total frames transmitted OK
                dd      0               ;Total bytes transmitted OK
                dd      NOT_MAINTAINED      ;Total multicast frames transmitted
                dd      NOT_MAINTAINED      ;Total broadcast frames transmitted
                dd      NOT_MAINTAINED      ;reserve
                dd      NOT_MAINTAINED      ;reserve
                dd      NOT_MAINTAINED      ;Total frames not transmitted
                                            ;(time-out)
                dd      NOT_MAINTAINED      ;Total frames not transmitted
                                            ;(hardware error)
                ;**/

                public  media_specific
media_specific  dw      40h
                dw      0

                dd      0           ; 1
                dd      0FFFFFFFFh  ; 2
                dd      0FFFFFFFFh  ; 3
                dd      0FFFFFFFFh  ; 4
                dd      0FFFFFFFFh  ; 5
                dd      0FFFFFFFFh  ; 6
                dd      0FFFFFFFFh  ; 7
                dd      0FFFFFFFFh  ; 8
                dd      0FFFFFFFFh  ; 9
                dd      0FFFFFFFFh  ; 10
                dd      0FFFFFFFFh  ; 11
                dd      0FFFFFFFFh  ; 12
                dd      0FFFFFFFFh  ; 13
                dd      0FFFFFFFFh  ; 14
                dd      0FFFFFFFFh  ; 15
                ;*/

                Align   4
                public  mdispatch
mdispatch       label   byte
                dw      offset DGROUP:common
                dw      ?
                dw      offset CGROUP:Request
                dw      ?
                dw      offset CGROUP:TransmitChain
                dw      ?
                dw      offset CGROUP:TransferData
                dw      ?
                dw      offset CGROUP:ReceiveRelease
                dw      ?
                dW      offset CGROUP:IndicationOn
                dw      ?
                dw      offset CGROUP:IndicationOff
                dw      ?


                public  pdispatch
pdispatch       label   byte
                pdtable <>

IFDEF DOS

DDStk           db      128 dup ('$$$$')

                public  DDTopStk
DDTopStk        db      0AAh,0AAh

                public  DDStkSeg
DDStkSeg        dw      ?

                public  DDStkOff
DDStkOff        dw      0

ENDIF


                public  ReAutoMsg
ReAutoMsg       db      'Analyzing network Media type, please wait...',0
                public  OKMsg
OKMsg           db      'OK.',0

                END_DATA
                end
