;
;  Copyright (c) 2003 VIA Networking, Inc. All rights reserved.
; 
;  This software is copyrighted by and is the sole property of
;  VIA Networking, Inc. This software may only be used in accordance
;  with the corresponding license agreement. Any unauthorized use,
;  duplication, transmission, distribution, or disclosure of this
;  software is expressly forbidden.
; 
;  This software is provided by VIA Networking, Inc. "as is" and any
;  express or implied warranties, including, but not limited to, the
;  implied warranties of merchantability and fitness for a particular
;  purpose are disclaimed. In no event shall VIA Networking, Inc. be
;  liable for any direct, indirect, incidental, special, exemplary, or
;  consequential damages.
; 
; 
;  File: bind.asm
; 
;  Purpose: This file contains the System entry, and support procedures for the
;           Bind operation.
; 
;  Author: GuardKuo
; 
;  Date: Jan 15, 2003
; 
;  Functions:
;       System
; 
;  Revision History:
;       01-15-2003 GuardKuo : first release
;
; 
                page    88,122
                title   BIND - System entry and Bind routines (2.0.1 Spec)

.xlist
IFDEF OS2
include devhlp.inc
ENDIF
include includes.mac
.list
.lfcond
.sall

.386
;------ Exported Interfaces -------------------------------------------------;
        public          System

;------ Imported Interfaces -------------------------------------------------;
        OS2XTRN         devHelper:DWORD
        extrn           common:BYTE
        extrn           cs_ds:WORD
        extrn           pdispatch:BYTE
        extrn           protDS:WORD
        extrn           ramSize:BYTE
        extrn           specific:BYTE
        extrn           state:BYTE
        extrn           status:BYTE
        
        extrn           cs_ip:WORD              ; added by Ben (10/12/00)
        
        extrn           IntHandler:FAR          ; from intr
        extrn           ResetAdapter:NEAR       ; from util


                BEGIN_CODE
NEWPAGE <System Entry>
;------ System --------------------------------------------------------------;
;                                                                            ;
;       int far pascal System(                                               ;
;                               DWORD Param1,                                ;
;                               DWORD Param2,                                ;
;                               WORD Param3,                                 ;
;                               WORD Opcode,                                 ;
;                               WORD MACDS      );                           ;
;                                                                            ;
;       Used by the protocol manager or the upper protocol during the        ;
;       Binding process.  Only a Bind is expected by the MAC.  For Bind      ;
;       the parameters are:                                                  ;
;                                                                            ;
;               Param1  = far pointer to protocol's cctable                  ;
;               Param2  = far pointer to address to set to MAC's cctable     ;
;               Param3  = unused                                             ;
;                                                                            ;
;       After this function returns successfully, the MAC is ready for       ;
;       use, though the adapter still needs to be openned and a non-zero     ;
;       packet filter set to get transmission and reception going.           ;
;                                                                            ;
;----------------------------------------------------------------------------;

System          proc    far
        push    bp
        mov     bp,sp
        PUSHR   si,di,ds
        
        ; set up DS.
        ; --------------------------------
        mov     ds,cs:cs_ds

        ; fail anything other than a bind request
        ; ----------------------------------------------------------------
        cmp     [bp].sy_opcode,BIND
        je      @F
        
sy_fail:
        mov     ax,GENERAL_FAILURE
        jmp     sy_exit
        
@@:
        ; ensure the state is correct
        ; --------------------------------
        cmp     state,INITIALIZED
        je      @F
        mov     ax,DRIVER_NOT_INITIALIZED
        jmp     sy_exit
        
@@:
        ; if we're going to do PhysToGDT in-line, verify that our assumptions 
        ; are valid.  make sure OS2_GDT points to the GDT.
        ; ----------------------------------------------------------------
IFDEF FASTGDT
        push    bp
        sub     sp,6
        mov     bp,sp
        sgdt    fword ptr [bp]
        mov     cx,[bp].sgdt_limit
        inc     cx
        xor     ah,ah
        mov     al,[bp].sgdt_base23_16
        mov     bx,[bp].sgdt_base15_0
        add     sp,6
        pop     bp
        mov     si,segRX
        mov     dl,DevHlp_PhysToGDTSelector
        call    devHelper
        jc      sy_fail
        mov     es,si
        cmp     es:[OS2_GDT].segd_base15_0,bx
        jne     sy_incompatible
        cmp     es:[OS2_GDT].segd_base23_16,al
        je      @F
sy_incompatible:
        mov     ax,INCOMPATIBLE_OS_VERSION
        jmp     sy_exit
        
@@:
ENDIF
        ; set the bound bit in the status field
        ; --------------------------------
        ;/** 920704
        ;;;;;;;;;;;;;;;;mov     state, CLOSED
        ;**/

        or      status.ms_flags.loword,ST_MAC_IS_BOUND

        ; return common characteristics table address
        ; ----------------------------------------------------------------
        les     di,[bp].sy_param2
        mov     es:[di].segm,ds
        mov     es:[di].off,offset DGROUP:common

        ; save the protocol's module dataseg
        ; --------------------------------
        les     di,[bp].sy_param1
        mov     ax,es:[di].cc_DS
        mov     protDS,ax
        ; copy the protocol's lower dispatch table to pdispatch
        ; ----------------------------------------------------------------
        push    ds
        lds     si,es:[di].cc_ldispatch
        pop     es
        mov     di,offset DGROUP:pdispatch

        mov     cx,PDTABLESIZE
        rep     movsb
        push    es
        pop     ds

        ; install the hardware interrupt handler
        ; --------------------------------
IFDEF DOS
        mov     al,specific.mc_interrupt.lobyte
        mov     cl,08h                  ; IRQ 0 = INT 08h
        cmp     al,07h                  ; IRQ 0 to 7 ?
        jbe     @F
        mov     cl,70h - 08h            ; IRQ 8 = INT 70h
@@:     add     al,cl

        
        push    es
        xor     dx, dx
        mov     es, dx
        xor     ah, ah
        shl     ax, 1
        shl     ax, 1
        mov     di, ax
        
        ; added by Ben (10/12/00), to store 
        ; original Interrupt handler's IP
        ; -------------------------------------S
        xor     dx, dx 
        push    ds                      ; save DS                 
        mov     ds, dx                  ; ds = es
        mov     si, di                  ; si = di
        lodsw                           ; [ds:si] -> ax, IP
        pop     ds                      ; restore DS
        mov     cs_ip [0], ax           ; store the Old NIC's IP 
        ; -------------------------------------E
        
        mov     ax, offset CGROUP:IntHandler    ; Assume DS = CS
        stosw                                   ; ax -> [es:di], Hook IP
        
        ; added by Ben (10/12/00), to restore original
        ; Interrupt Handler's CS
        ; ---------------------------------------------S
        xor     dx, dx 
        push    ds                      ; save DS                 
        mov     ds, dx                  ; ds = es
        mov     si, di                  ; si = di
        lodsw                           ; [ds:si] -> ax
        pop     ds                      ; restore ds
        mov     cs_ip [2], ax           ; store the Old NIC's CS
        ; ----------------------------------------------E
        
        mov     ax, cs
        stosw
        pop     es
ELSE
        mov     bx,specific.mc_interrupt
        mov     ax,offset CGROUP:IntHandler
        mov     dx,(0*256)+DevHlp_SetIRQ    ; unshared interrupt
        call    devHelper
        jnc     @F                          ; interrupt in use?
        mov     ax,INTERRUPT_CONFLICT       ; return error
        jmp     sy_exit
@@:
ENDIF
        mov     al,RamSize
        xor     ah,ah
        mov     cl,0Ah
        shl     ax,cl
        mov     bx,0C00h
        sub     ax,bx
        mov     specific.mc_totalrxspc.loword,ax
        call    ResetAdapter

        ; return success.
        ; --------------------------------
        xor     ax,ax

        ; done.  return code in AX
        ; --------------------------------
;        public  sy_exit
        
sy_exit:
        POPR    si,di,ds
        pop     bp
        ret     SYRET
System          endp

        END_CODE
        end
        
